/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;

public class SubstrColumnTransform
implements ISingleNewAndOldValueColumnTransform,
IBuiltInExtensionPoint {
    public static final String NAME = "substr";

    public String getName() {
        return NAME;
    }

    @Override
    public boolean isExtractColumnTransform() {
        return true;
    }

    @Override
    public boolean isLoadColumnTransform() {
        return true;
    }

    @Override
    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String expression;
        if (StringUtils.isNotEmpty((CharSequence)newValue) && StringUtils.isNotBlank((CharSequence)(expression = column.getTransformExpression()))) {
            String[] tokens = expression.split(",");
            if (tokens.length == 1) {
                int index = Integer.parseInt(tokens[0]);
                newValue = newValue.length() > index ? newValue.substring(index) : "";
            } else if (tokens.length > 1) {
                int beginIndex = Integer.parseInt(tokens[0]);
                int endIndex = Integer.parseInt(tokens[1]);
                newValue = newValue.length() > endIndex && endIndex > beginIndex ? newValue.substring(beginIndex, endIndex) : (newValue.length() > beginIndex ? newValue.substring(beginIndex) : "");
            }
        }
        return new NewAndOldValue(column, data, newValue);
    }

    protected String[] prepend(String v, String[] array) {
        String[] dest = new String[array.length + 1];
        dest[0] = v;
        for (int i = 0; i < array.length; ++i) {
            dest[i + 1] = array[i];
        }
        return dest;
    }
}

