/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.reader.IExtractDataReaderSource;

public class TableExtractDataReaderSource
implements IExtractDataReaderSource {
    protected IDatabasePlatform platform;
    protected String whereClause;
    protected Batch batch;
    protected Table table;
    protected ISqlReadCursor<CsvData> cursor;
    protected boolean streamLobs;

    public TableExtractDataReaderSource(IDatabasePlatform platform, String catalogName, String schemaName, String tableName, String whereClause, boolean streamLobs, String sourceNodeId, String targetNodeId) {
        this.platform = platform;
        this.table = platform.getTableFromCache(catalogName, schemaName, tableName, true);
        if (this.table == null) {
            throw new IllegalStateException(String.format("Could not find table %s", Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName)));
        }
        this.whereClause = whereClause;
        this.streamLobs = streamLobs;
        this.batch = new Batch(Batch.BatchType.EXTRACT, -1L, "default", BinaryEncoding.BASE64, sourceNodeId, targetNodeId, false);
    }

    @Override
    public Batch getBatch() {
        return this.batch;
    }

    @Override
    public Table getTargetTable() {
        return this.table;
    }

    @Override
    public Table getSourceTable() {
        return this.table;
    }

    @Override
    public CsvData next() {
        CsvData data = null;
        if (this.cursor == null) {
            this.startNewCursor();
        }
        if (this.cursor != null && (data = (CsvData)this.cursor.next()) == null) {
            this.closeCursor();
        }
        return data;
    }

    protected void startNewCursor() {
        DatabaseInfo dbInfo = this.platform.getDatabaseInfo();
        String sql = String.format("select * from %s %s", this.table.getQualifiedTableName(dbInfo.getDelimiterToken(), dbInfo.getCatalogSeparator(), dbInfo.getSchemaSeparator()), StringUtils.isNotBlank((CharSequence)this.whereClause) ? " where " + this.whereClause : "");
        this.cursor = this.platform.getSqlTemplate().queryForCursor(sql, (ISqlRowMapper)new ISqlRowMapper<CsvData>(){

            public CsvData mapRow(Row row) {
                return new CsvData(DataEventType.INSERT, TableExtractDataReaderSource.this.toStringData(row, TableExtractDataReaderSource.this.table.getPrimaryKeyColumns()), TableExtractDataReaderSource.this.toStringData(row, TableExtractDataReaderSource.this.table.getColumns()));
            }
        });
    }

    protected String[] toStringData(Row row, Column[] columns) {
        String[] stringValues = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Object value = row.get((Object)columns[i].getName());
            if (value instanceof byte[]) {
                stringValues[i] = new String(Base64.encodeBase64((byte[])((byte[])value)), Charset.defaultCharset());
                continue;
            }
            if (value == null) continue;
            stringValues[i] = value.toString();
        }
        return stringValues;
    }

    @Override
    public boolean requiresLobsSelectedFromSource(CsvData data) {
        return this.streamLobs;
    }

    @Override
    public void close() {
        this.closeCursor();
    }

    protected void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }
}

