/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRequestResponseFilter
implements Filter {
    private boolean enabled = false;
    private static Logger LOG = LoggerFactory.getLogger(LogRequestResponseFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (Boolean.valueOf(filterConfig.getInitParameter("enabled")).booleanValue()) {
            this.enabled = true;
        }
    }

    public void doFilter(ServletRequest argRequest, ServletResponse argResponse, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(argRequest, argResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)argRequest;
        HttpServletResponse response = (HttpServletResponse)argResponse;
        StringBuilder buff = new StringBuilder(256);
        this.buildRequest(request, buff);
        long start = System.currentTimeMillis();
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        long elapsed = System.currentTimeMillis() - start;
        this.buildResponse(response, elapsed, buff);
        buff.setLength(buff.length() - 2);
        LOG.info(buff.toString());
    }

    private void buildRequest(HttpServletRequest request, StringBuilder buff) {
        buff.append(request.getMethod()).append(" REQUEST: ").append(this.getUrl(request)).append(" from ").append(request.getRemoteHost()).append("\r\n");
        for (String headerName : Collections.list(request.getHeaderNames())) {
            buff.append("\t").append(headerName).append("=").append(request.getHeader(headerName)).append("\r\n");
        }
    }

    private void buildResponse(HttpServletResponse response, long elapsed, StringBuilder buff) {
        buff.append("  RESPONSE took ").append(elapsed).append("ms.");
        if (response.getContentType() != null) {
            buff.append(" Content Type: ").append(response.getContentType());
        }
        buff.append(" HTTP status ").append(response.getStatus()).append("\r\n");
        for (String headerName : response.getHeaderNames()) {
            buff.append("\t").append(headerName).append("=").append(response.getHeader(headerName)).append("\r\n");
        }
    }

    private String getUrl(HttpServletRequest request) {
        String uri = request.getScheme() + "://" + request.getServerName() + (String)("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443 ? "" : ":" + request.getServerPort()) + request.getRequestURI() + (String)(request.getQueryString() != null ? "?" + request.getQueryString() : "");
        return uri;
    }

    public void destroy() {
    }
}

