/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.map;

import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ext.INodeGroupExtensionPoint;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterFilterAdapter;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;
import org.jumpmind.symmetric.map.TableColumnValueFilter;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scripting.ScriptCompilationException;

public class ColumnDataFilters
extends DatabaseWriterFilterAdapter
implements IDatabaseWriterFilter,
INodeGroupExtensionPoint {
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String[] nodeGroupIdsToApplyTo;
    List<TableColumnValueFilter> filters;
    private boolean ignoreCase = true;
    private boolean enabled = true;

    public boolean beforeWrite(DataContext context, Table table, CsvData data) {
        this.filterColumnValues((Context)context, table, data);
        return true;
    }

    protected void filterColumnValues(Context context, Table table, CsvData data) {
        if (this.enabled && this.filters != null) {
            for (TableColumnValueFilter filteredColumn : this.filters) {
                try {
                    if (!filteredColumn.isEnabled() || (!this.ignoreCase || !filteredColumn.getTableName().equalsIgnoreCase(table.getName())) && (this.ignoreCase || !filteredColumn.getTableName().equals(table.getName()))) continue;
                    String columnName = filteredColumn.getColumnName();
                    int index = table.getColumnIndex(columnName);
                    if (index < 0 && this.ignoreCase && (index = table.getColumnIndex(columnName = columnName.toUpperCase())) < 0) {
                        columnName = columnName.toLowerCase();
                        index = table.getColumnIndex(columnName);
                    }
                    if (index < 0) continue;
                    try {
                        String[] columnValues = data.getParsedData("rowData");
                        if (columnValues == null || columnValues.length <= index) continue;
                        columnValues[index] = filteredColumn.getFilter().filter(filteredColumn.getTableName(), filteredColumn.getColumnName(), columnValues[index], context);
                    }
                    catch (RuntimeException ex) {
                        Throwable causedBy = ex;
                        do {
                            if (!((causedBy = ex.getCause()) instanceof ScriptCompilationException)) continue;
                            this.log.error("{}", (Object)causedBy.getMessage());
                            throw new RuntimeException(causedBy.getMessage(), ex);
                        } while (causedBy != null);
                        throw ex;
                    }
                }
                catch (RuntimeException ex) {
                    this.log.error("Failed to transform value for column {} on table {}", (Object)filteredColumn.getColumnName(), (Object)filteredColumn.getTableName());
                    throw ex;
                }
            }
        }
    }

    public void setFilters(List<TableColumnValueFilter> filters) {
        this.filters = filters;
    }

    public String[] getNodeGroupIdsToApplyTo() {
        return this.nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdsToApplyTo(String[] nodeGroupIdsToApplyTo) {
        this.nodeGroupIdsToApplyTo = nodeGroupIdsToApplyTo;
    }

    public void setNodeGroupIdToApplyTo(String nodeGroupId) {
        this.nodeGroupIdsToApplyTo = new String[]{nodeGroupId};
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

