/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import org.jumpmind.symmetric.integrate.IPublisher;
import org.jumpmind.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for an jms publisher")
public class SimpleJmsPublisher
implements IPublisher,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(SimpleJmsPublisher.class);
    private BeanFactory beanFactory;
    private String jmsTemplateBeanName;
    public boolean enabled = true;

    @Override
    public void publish(Context context, String text) {
        this.publish(text);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @ManagedOperation(description="Publishes the message text passed in as an argument")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="text", description="The message text that will be published")})
    public boolean publish(String text) {
        try {
            log.debug("Publishing {}", (Object)text);
            if (this.enabled) {
                ((JmsTemplate)this.beanFactory.getBean(this.jmsTemplateBeanName)).convertAndSend((Object)text);
                return true;
            }
            log.info("Message was not published because the publisher is not enabled: \n" + text);
            return false;
        }
        catch (RuntimeException ex) {
            log.error("Failed to publish message: \n" + text, (Throwable)ex);
            throw ex;
        }
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void setJmsTemplateBeanName(String jmsTemplateBeanName) {
        this.jmsTemplateBeanName = jmsTemplateBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

