/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import io.micrometer.common.util.StringUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.HashMap;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.SymmetricBootPropertySetupListener;
import org.jumpmind.symmetric.SymmetricBootStartedListener;
import org.jumpmind.symmetric.transport.TransportManagerFactory;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.symmetric.web.HttpMethodFilter;
import org.jumpmind.symmetric.web.SymmetricContextListener;
import org.jumpmind.symmetric.web.SymmetricServlet;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackages={"org.jumpmind.symmetric", "com.jumpmind.symmetric"})
public class SymmetricBoot
extends SpringBootServletInitializer {
    @Bean
    ServletContextInitializer servletContextInitializer() {
        return new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.setInitParameter("autoStart", Boolean.toString(true));
                String singlePropertiesFile = System.getProperty("server.single.properties.file");
                if (StringUtils.isNotBlank((String)singlePropertiesFile)) {
                    servletContext.setInitParameter("singleServerPropertiesFile", singlePropertiesFile);
                    servletContext.setInitParameter("multiServerMode", Boolean.toString(false));
                } else {
                    servletContext.setInitParameter("multiServerMode", Boolean.toString(true));
                }
            }
        };
    }

    @Bean
    SymmetricContextListener symmetricContextListener() {
        return new SymmetricContextListener();
    }

    @Bean
    ServletRegistrationBean<SymmetricServlet> symmetricServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new SymmetricServlet(), new String[]{"/sync/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    FilterRegistrationBean<HttpMethodFilter> httpMethodFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new HttpMethodFilter());
        bean.setAsyncSupported(true);
        bean.addUrlPatterns(new String[]{"/*"});
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("server.disallow.http.methods", System.getProperty("server.disallow.http.methods", "OPTIONS"));
        bean.setInitParameters(param);
        bean.setOrder(1);
        return bean;
    }

    public static ConfigurableApplicationContext run(String[] args) {
        SymmetricUtils.logNotices();
        TypedProperties sysProps = new TypedProperties(System.getProperties());
        boolean httpsEnabled = sysProps.is("https.enable");
        boolean https2Enabled = sysProps.is("https2.enable");
        boolean allowSelfSignedCerts = sysProps.is("https.allow.self.signed.certs", true);
        String allowServerNames = sysProps.get("https.verified.server.names", "all");
        TransportManagerFactory.initHttps((String)allowServerNames, (boolean)allowSelfSignedCerts, (boolean)https2Enabled);
        if (httpsEnabled) {
            ISecurityService securityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)sysProps);
            securityService.installDefaultSslCert(sysProps.get("host.bind.name"));
        }
        return new SpringApplicationBuilder(new Class[0]).registerShutdownHook(false).listeners(new ApplicationListener[]{new SymmetricBootPropertySetupListener(), new SymmetricBootStartedListener()}).bannerMode(Banner.Mode.OFF).sources(new Class[]{SymmetricBoot.class}).run(args);
    }

    public static void main(String[] args) {
        SymmetricBoot.run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        TypedProperties sysProps = new TypedProperties(System.getProperties());
        if (sysProps.is("server.http.cookies.enabled") && CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        return builder.sources(new Class[]{SymmetricBoot.class});
    }
}

