/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configurer;

import java.util.ArrayList;
import java.util.List;
import org.springdoc.core.configurer.SpringdocBeanFactoryConfigurer;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class SpringdocActuatorBeanFactoryConfigurer
extends SpringdocBeanFactoryConfigurer {
    private final List<GroupedOpenApi> groupedOpenApis;

    public SpringdocActuatorBeanFactoryConfigurer(List<GroupedOpenApi> groupedOpenApis) {
        this.groupedOpenApis = groupedOpenApis;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BindResult result = Binder.get((Environment)this.environment).bind("management.endpoints.web", WebEndpointProperties.class);
        BindResult springDocConfigPropertiesBindResult = Binder.get((Environment)this.environment).bind("springdoc", SpringDocConfigProperties.class);
        if (result.isBound() && springDocConfigPropertiesBindResult.isBound()) {
            WebEndpointProperties webEndpointProperties = (WebEndpointProperties)result.get();
            SpringDocConfigProperties springDocConfigProperties = (SpringDocConfigProperties)springDocConfigPropertiesBindResult.get();
            ArrayList<GroupedOpenApi> newGroups = new ArrayList<GroupedOpenApi>();
            ActuatorOperationCustomizer actuatorCustomizer = new ActuatorOperationCustomizer(springDocConfigProperties);
            beanFactory.registerSingleton("actuatorCustomizer", (Object)actuatorCustomizer);
            GroupedOpenApi actuatorGroup = GroupedOpenApi.builder().group("x-actuator").pathsToMatch(webEndpointProperties.getBasePath() + "/**").pathsToExclude(webEndpointProperties.getBasePath() + "/health/*").build();
            newGroups.add(actuatorGroup);
            if (CollectionUtils.isEmpty(this.groupedOpenApis)) {
                GroupedOpenApi defaultGroup = GroupedOpenApi.builder().group("springdocDefault").pathsToMatch("/**").pathsToExclude(webEndpointProperties.getBasePath() + "/**").build();
                newGroups.add(defaultGroup);
            }
            newGroups.forEach(elt -> beanFactory.registerSingleton(elt.getGroup(), elt));
        }
        SpringdocActuatorBeanFactoryConfigurer.initBeanFactoryPostProcessor(beanFactory);
    }
}

