/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.CallStackTrace;
import com.ibm.mq.jms.services.psk.Tracer;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class PrintWriterTracer
implements Tracer {
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/services/psk/PrintWriterTracer.java, jms, j600, j600-202-070608 1.10.1.2 06/11/30 14:44:42";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String traceFileExt = ".TRC";
    private Hashtable indentsTable;
    protected boolean isMethodTracing = false;
    protected int methodTraceThreshold = 5;
    protected int format = 15;
    protected PrintWriter traceWriter = new PrintWriter(System.err, true);
    protected int traceLevel = 1;
    private static Object traceLock = new Object();

    public PrintWriterTracer() {
        this.indentsTable = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataTrace(int n, Object object, byte[] byArray) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            if (this.traceLevel >= n) {
                this.indent();
                this.traceTime();
                if ((this.format & 4) != 0) {
                    this.traceWriter.print("[" + Thread.currentThread().getName() + "] ");
                }
                if (object != null && (this.format & 8) != 0) {
                    this.traceWriter.print(object + " ");
                }
                this.traceWriter.println("Data trace, " + byArray.length + " bytes of data follow: \n");
                this.printHexBytes(this.traceWriter, byArray);
                this.traceWriter.println();
            }
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    private final void decrementIndents() {
        int n = this.getIndentationLevel();
        if (n > 0) {
            --n;
        }
        this.indentsTable.put(Thread.currentThread(), new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCallStack() {
        Object object = traceLock;
        synchronized (object) {
            this.dumpCallStack(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCallStack(String string) {
        Object object = traceLock;
        synchronized (object) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            CallStackTrace callStackTrace = new CallStackTrace();
            try {
                throw callStackTrace;
            }
            catch (CallStackTrace callStackTrace2) {
                this.indent();
                this.traceTime();
                if ((this.format & 4) != 0) {
                    this.traceWriter.println("[" + Thread.currentThread().getName() + "] ");
                }
                this.traceWriter.println("Stack Trace Follows: (stack trace requires java_g or appletviewer_g)");
                if (string != null) {
                    this.traceWriter.println(string);
                }
                callStackTrace.printStackTrace(this.traceWriter);
                this.traceWriter.flush();
                if (this.isMethodTracing) {
                    Runtime.getRuntime().traceMethodCalls(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(int n, Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.entry(object, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(int n, Object object, String string, String string2) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.entry(object, string);
                int n2 = this.getIndentationLevel();
                for (int i = 0; i < n2; ++i) {
                    this.traceWriter.print("  ");
                }
                this.traceWriter.println("params: " + string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(int n, String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.entry(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(int n, String string, String string2, String string3) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.entry(string, string2);
                int n2 = this.getIndentationLevel();
                for (int i = 0; i < n2; ++i) {
                    this.traceWriter.print("  ");
                }
                this.traceWriter.println("params: " + string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = this.objectToString(object) + " ";
            }
            this.indent();
            this.traceTime();
            this.traceWriter.println(string2 + string3 + "==> " + string + "() entry");
            this.incrementIndents();
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(Object object, String string, String string2) {
        Object object2 = traceLock;
        synchronized (object2) {
            this.entry(object, string);
            int n = this.getIndentationLevel();
            for (int i = 0; i < n; ++i) {
                this.traceWriter.print("  ");
            }
            this.traceWriter.println("params: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.indent();
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = string + "::";
            }
            this.traceWriter.println(string3 + string4 + string2 + "() ==> entry");
            this.incrementIndents();
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(String string, String string2, String string3) {
        Object object = traceLock;
        synchronized (object) {
            this.entry(string, string2);
            int n = this.getIndentationLevel();
            for (int i = 0; i < n; ++i) {
                this.traceWriter.print("  ");
            }
            this.traceWriter.println("params: " + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(int n, Object object, String string, Throwable throwable) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.exception(object, string, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(int n, String string, String string2, Throwable throwable) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.exception(string, string2, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(Object object, String string, Throwable throwable) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.indent();
            this.traceTime();
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = this.objectToString(object) + " ";
            }
            this.traceWriter.println(string2 + string3 + " " + string + "() " + throwable.getClass().getName() + " exception caught: " + throwable.getMessage());
            throwable.printStackTrace(this.traceWriter);
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(String string, String string2, Throwable throwable) {
        Object object = traceLock;
        synchronized (object) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.indent();
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = string + "::";
            }
            this.traceWriter.println(string3 + string4 + " " + string2 + "() " + throwable.getClass().getName() + " exception caught: " + throwable.getMessage());
            throwable.printStackTrace(this.traceWriter);
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n, Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.exit(object, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n, Object object, String string, String string2) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.exit(object, string);
                int n2 = this.getIndentationLevel();
                for (int i = 0; i <= n2; ++i) {
                    this.traceWriter.print("  ");
                }
                this.traceWriter.println("return=" + string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n, String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.exit(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n, String string, String string2, String string3) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.exit(string, string2);
                int n2 = this.getIndentationLevel();
                for (int i = 0; i <= n2; ++i) {
                    this.traceWriter.print("  ");
                }
                this.traceWriter.println("return=" + string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            this.decrementIndents();
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.indent();
            this.traceTime();
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = this.objectToString(object) + " ";
            }
            this.traceWriter.println(string2 + string3 + "<== " + string + "() exit");
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Object object, String string, String string2) {
        Object object2 = traceLock;
        synchronized (object2) {
            this.exit(object, string);
            int n = this.getIndentationLevel();
            for (int i = 0; i <= n; ++i) {
                this.traceWriter.print("  ");
            }
            this.traceWriter.println("return=" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(false);
            }
            this.decrementIndents();
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.indent();
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = string + "::";
            }
            this.traceWriter.println(string3 + string4 + string2 + "() <== exit");
            if (this.isMethodTracing) {
                Runtime.getRuntime().traceMethodCalls(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(String string, String string2, String string3) {
        Object object = traceLock;
        synchronized (object) {
            this.exit(string, string2);
            int n = this.getIndentationLevel();
            for (int i = 0; i <= n; ++i) {
                this.traceWriter.print("  ");
            }
            this.traceWriter.println("return=" + string3);
        }
    }

    public void finalize() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFormat() {
        Object object = traceLock;
        synchronized (object) {
            return this.format;
        }
    }

    protected int getIndentationLevel() {
        int n = 0;
        if (this.indentsTable.containsKey(Thread.currentThread())) {
            Integer n2 = (Integer)this.indentsTable.get(Thread.currentThread());
            n = n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMethodTraceThreshold() {
        Object object = traceLock;
        synchronized (object) {
            return this.methodTraceThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTraceLevel() {
        Object object = traceLock;
        synchronized (object) {
            return this.traceLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getTraceWriter() {
        Object object = traceLock;
        synchronized (object) {
            return this.traceWriter;
        }
    }

    private final void incrementIndents() {
        int n = this.getIndentationLevel();
        this.indentsTable.put(Thread.currentThread(), new Integer(++n));
    }

    protected void indent() {
        int n = this.getIndentationLevel();
        for (int i = 0; i < n; ++i) {
            this.traceWriter.print("  ");
        }
    }

    protected void printHexBytes(PrintWriter printWriter, byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            int n2;
            int n3;
            int n4 = Math.min(i + 16, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n3 = i; n3 < n4; ++n3) {
                n2 = byArray[n3];
                n2 = (n2 + 256) % 256;
                n = n2 / 16;
                int n5 = n2 % 16;
                stringBuffer.append((char)(n < 10 ? 48 + n : 97 + n - 10));
                stringBuffer.append((char)(n5 < 10 ? 48 + n5 : 97 + n5 - 10));
                if (n3 % 2 == 1) {
                    stringBuffer.append(' ');
                }
                if (n2 >= 32 && n2 <= 126) {
                    stringBuffer2.append((char)n2);
                    continue;
                }
                stringBuffer2.append('.');
            }
            n3 = 16 - (n4 - i);
            n2 = (n3 * 5 + n3 % 2) / 2;
            n2 += 3;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            String string = "0000" + Integer.toHexString(i);
            string = string.substring(string.length() - 4);
            printWriter.print(string);
            printWriter.print(":  ");
            printWriter.print(stringBuffer.toString());
            printWriter.println(stringBuffer2.toString());
        }
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(int n) {
        Object object = traceLock;
        synchronized (object) {
            this.format = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMethodTraceThreshold(int n) {
        Object object = traceLock;
        synchronized (object) {
            this.methodTraceThreshold = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTraceLevel(int n) {
        Object object = traceLock;
        synchronized (object) {
            this.traceLevel = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTraceWriter(FileWriter fileWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (fileWriter != null) {
                traceLock = fileWriter;
                this.traceWriter = new PrintWriter((Writer)fileWriter, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTraceWriter(PrintWriter printWriter) {
        Object object = traceLock;
        synchronized (object) {
            if (printWriter != null) {
                this.traceWriter = printWriter;
            }
        }
    }

    public void start() {
    }

    public void stop() {
        this.traceWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int n, Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (this.traceLevel >= n) {
                this.trace(object, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int n, String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            if (this.traceLevel >= n) {
                this.trace(string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Object object, String string) {
        Object object2 = traceLock;
        synchronized (object2) {
            if (object instanceof String) {
                this.traceString((String)object, string);
            } else {
                this.traceObject(object, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String string, String string2) {
        Object object = traceLock;
        synchronized (object) {
            this.traceString(string, string2);
        }
    }

    private void traceObject(Object object, String string) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string2 = "";
        if ((this.format & 4) != 0) {
            string2 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string3 = "";
        if ((this.format & 8) != 0) {
            string3 = this.objectToString(object) + " ";
        }
        this.traceWriter.println(string2 + string3 + string);
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    private void traceString(String string, String string2) {
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        String string3 = "";
        if ((this.format & 4) != 0) {
            string3 = "[" + Thread.currentThread().getName() + "] ";
        }
        this.indent();
        this.traceTime();
        String string4 = "";
        if ((this.format & 8) != 0) {
            string4 = string + " ";
        }
        this.traceWriter.println(string3 + string4 + string2);
        if (this.isMethodTracing) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    protected void traceTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        if ((this.format & 1) != 0) {
            int n = gregorianCalendar.get(10);
            int n2 = gregorianCalendar.get(12);
            int n3 = gregorianCalendar.get(13);
            if (n < 10) {
                this.traceWriter.print("0" + n + ":");
            } else {
                this.traceWriter.print(n + ":");
            }
            if (n2 < 10) {
                this.traceWriter.print("0" + n2 + ":");
            } else {
                this.traceWriter.print(n2 + ":");
            }
            if (n3 < 10) {
                this.traceWriter.print("0" + n3 + " ");
            } else {
                this.traceWriter.print(n3 + " ");
            }
        }
        if ((this.format & 2) != 0) {
            this.traceWriter.print("[" + date.getTime() + "] ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnMethodTracingOff() {
        Object object = traceLock;
        synchronized (object) {
            Runtime.getRuntime().traceMethodCalls(false);
            this.isMethodTracing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnMethodTracingOn() {
        Object object = traceLock;
        synchronized (object) {
            Runtime.getRuntime().traceMethodCalls(true);
            this.isMethodTracing = true;
        }
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "<null object>";
        }
        StringBuffer stringBuffer = new StringBuffer(object.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(object.hashCode()));
        return stringBuffer.toString();
    }
}

