/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services;

import com.ibm.jms.JMSTrace;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.WASManager;
import com.ibm.ras.RASTraceLogger;
import com.ibm.websphere.ras.Manager;

public class WASTraceAdapter
implements JMSTrace {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/WASTraceAdapter.java, jms, j600, j600-201-061220 1.15.1.1 05/05/25 15:07:50";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String groupName = "JMSApi";
    public static final String TRACE_LOGGER_NAME = "JMS_WASTraceAdapter";
    static RASTraceLogger trcLogger = null;

    public void initialise(WASManager wASManager) {
        Manager manager = (Manager)wASManager.getManager();
        trcLogger = manager.createRASTraceLogger("IBM WebSphere JMSApi", TRACE_LOGGER_NAME);
        manager.addLoggerToGroup(trcLogger, groupName);
    }

    public void dataTrace(int n, Object object, byte[] byArray) {
        if (trcLogger.isLoggable(16L)) {
            trcLogger.trace(16L, object, "", "", (Object)byArray);
        }
    }

    public void entry(Object object, String string) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.entry(4L, object, string);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void entry(Object object, String string, String string2) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.entry(4L, object, string, (Object)string2);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void entry(String string, String string2) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.entry(4L, string, string2);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void entry(String string, String string2, String string3) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.entry(4L, string, string2, (Object)string3);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void exit(Object object, String string) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.exit(4L, object, string);
        }
    }

    public void exit(Object object, String string, String string2) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.exit(4L, object, string, (Object)string2);
        }
    }

    public void exit(String string, String string2) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.exit(4L, string, string2);
        }
    }

    public void exit(String string, String string2, String string3) {
        if (trcLogger.isLoggable(4L)) {
            trcLogger.exit(4L, string, string2, (Object)string3);
        }
    }

    public void trace(int n, Object object, String string) {
        this.trace(object, string);
    }

    public void trace(int n, String string, String string2) {
        this.trace(string, string2);
    }

    public void trace(Object object, String string) {
        if (trcLogger.isLoggable(16L)) {
            trcLogger.trace(16L, object, "", string);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void trace(String string, String string2) {
        if (trcLogger.isLoggable(16L)) {
            trcLogger.trace(16L, string, "", string2);
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public void exception(int n, Object object, String string, Throwable throwable) {
        WASTraceAdapter.exception(object, string, throwable);
    }

    public void exception(int n, String string, String string2, Throwable throwable) {
        WASTraceAdapter.exception(string, string2, throwable);
    }

    public static void exception(Object object, String string, Throwable throwable) {
        if (trcLogger.isLoggable(8L)) {
            if (throwable instanceof Exception) {
                trcLogger.exception(8L, object, string, (Exception)throwable);
            } else {
                trcLogger.trace(8L, object, string, "exception caught: " + throwable.getMessage());
            }
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public static void exception(String string, String string2, Throwable throwable) {
        if (trcLogger.isLoggable(8L)) {
            if (throwable instanceof Exception) {
                trcLogger.exception(8L, string, string2, (Exception)throwable);
            } else {
                trcLogger.trace(8L, string, string2, "exception caught: " + throwable.getMessage());
            }
        } else {
            WASTraceAdapter.checkForTurnTracingOff();
        }
    }

    public static void checkForTurnTracingOff() {
        if (!WASTraceAdapter.loggable()) {
            ConfigEnvironment.setTracingOff();
        }
    }

    public static void checkForTurnTracingOn() {
        if (WASTraceAdapter.loggable()) {
            ConfigEnvironment.setTracingOn("base");
        }
    }

    private static boolean loggable() {
        return trcLogger.isLoggable(16L) || trcLogger.isLoggable(4L) || trcLogger.isLoggable(8L);
    }

    public void turnTracingOn() {
    }

    public void turnTracingOff() {
    }
}

