/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.PCF;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.transaction.TransactionManager;

class Utils {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/Utils.java, jms, j600, j600-202-070608 1.26.1.6 07/05/21 15:53:31";
    static final int MQCA_BASE_Q_NAME = 2002;
    static final int MQCA_Q_MGR_NAME = 2015;
    static final int MQCA_Q_NAME = 2016;
    static final int MQCA_Q_MGR_IDENTIFIER = 2032;
    static final int MQCA_DEAD_LETTER_Q_NAME = 2006;
    static final int MQCA_BACKOUT_REQ_Q_NAME = 2019;
    static final int MQIA_DEFINITION_TYPE = 7;
    static final int MQIA_Q_TYPE = 20;
    static final int MQIA_BACKOUT_THRESHOLD = 22;
    private static final String CLASSNAME = "com.ibm.mq.jms.Utils";
    private static final int BUFSIZE = 128;
    private static final String BLANK48 = "                                                ";
    private static Object xactionManager = null;
    private static boolean wasNotDetected = false;
    private static final Object xactionManagerLock = new Object();

    Utils() {
    }

    public static void clearQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "clearQueue");
            Trace.trace(CLASSNAME, "Queue to clear is '" + string + "'");
        }
        try {
            MQQueue mQQueue = mQQueueManager.accessQueue(mQQueueManager.getCommandInputQueueName(), 8208);
            MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.DEFAULT.MODEL.QUEUE", 8196, null, "JMS.UTILS.TEMP.*", null);
            PCF pCF = new PCF(9);
            pCF.addParameter(2016, string);
            MQMessage mQMessage = new MQMessage();
            mQMessage.replyToQueueName = mQQueue2.name;
            pCF.write(mQMessage);
            mQQueue.put(mQMessage, new MQPutMessageOptions());
            mQQueue.close();
            MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 1;
            mQGetMessageOptions.waitInterval = 5000;
            mQMessage.messageId = MQC.MQMI_NONE;
            mQQueue2.get(mQMessage, mQGetMessageOptions);
            mQQueue2.close();
            PCF pCF2 = null;
            if (mQMessage != null) {
                pCF2 = new PCF(mQMessage);
            }
            if (pCF2 == null) {
                throw new Exception("PCF command failed. No response!");
            }
            if (pCF2.reason != 0) {
                throw new Exception("PCF command failed. Reason was " + pCF2.reason);
            }
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Linked Exception " + exception);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "clearQueue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listMatchingQueues(MQQueueManager mQQueueManager, String string) {
        String[] stringArray;
        block6: {
            String[] stringArray2 = null;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "listMatchingQueues");
            }
            try {
                MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.DEFAULT.MODEL.QUEUE", 8196, null, "JMS.UTILS.TEMP.*", null);
                stringArray2 = Utils.listMatchingQueues(mQQueueManager, mQQueue, string);
                mQQueue.closeOptions = 2;
                mQQueue.close();
                stringArray = stringArray2;
                Object var6_7 = null;
                if (!Trace.isOn) break block6;
                Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
            }
            catch (Exception exception) {
                String[] stringArray3;
                block7: {
                    try {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Exception in listMatchingQueues: " + exception);
                            Trace.trace(CLASSNAME, "Consume and continue");
                        }
                        stringArray3 = null;
                        Object var6_8 = null;
                        if (!Trace.isOn) break block7;
                        Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var6_9 = null;
                            if (!Trace.isOn) break block8;
                            Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
                            Trace.exit(CLASSNAME, "listMatchingQueues");
                        }
                        throw throwable;
                    }
                    Trace.exit(CLASSNAME, "listMatchingQueues");
                }
                return stringArray3;
            }
            Trace.exit(CLASSNAME, "listMatchingQueues");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listMatchingQueues(MQQueueManager mQQueueManager, MQQueue mQQueue, String string) {
        String[] stringArray;
        block7: {
            String[] stringArray2 = null;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "listMatchingQueues");
                Trace.trace(CLASSNAME, "Using replyQ '" + mQQueue.name + "'");
                Trace.trace(CLASSNAME, "filter is '" + string + "'");
            }
            try {
                MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.ADMIN.COMMAND.QUEUE", 8208);
                PCF pCF = new PCF(18);
                pCF.addParameter(2016, string);
                pCF.addParameter(20, 1);
                MQMessage mQMessage = new MQMessage();
                mQMessage.replyToQueueName = mQQueue.name;
                mQMessage.expiry = 5000;
                pCF.write(mQMessage);
                mQQueue2.put(mQMessage, new MQPutMessageOptions());
                mQQueue2.close();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 8193;
                mQGetMessageOptions.waitInterval = 5000;
                mQMessage.correlationId = mQMessage.messageId;
                mQMessage.messageId = MQC.MQMI_NONE;
                mQQueue.get(mQMessage, mQGetMessageOptions);
                if (mQMessage != null && (stringArray = new PCF(mQMessage)).getParameterCount() == 1 && stringArray.getParameterType(0) == 6) {
                    stringArray2 = ((PCF.MQCFSL)stringArray.getParameterAt(0)).getStrings();
                }
                stringArray = stringArray2;
                Object var10_11 = null;
                if (!Trace.isOn) break block7;
                Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
            }
            catch (Exception exception) {
                String[] stringArray3;
                block8: {
                    try {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Exception in listMatchingQueues: " + exception);
                            Trace.trace(CLASSNAME, "Consume and continue");
                        }
                        stringArray3 = null;
                        Object var10_12 = null;
                        if (!Trace.isOn) break block8;
                        Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var10_13 = null;
                            if (!Trace.isOn) break block9;
                            Trace.trace(CLASSNAME, "listMatchingQueues returning " + (stringArray2 == null ? "<null>" : stringArray2.length + " queue names"));
                            Trace.exit(CLASSNAME, "listMatchingQueues");
                        }
                        throw throwable;
                    }
                    Trace.exit(CLASSNAME, "listMatchingQueues");
                }
                return stringArray3;
            }
            Trace.exit(CLASSNAME, "listMatchingQueues");
        }
        return stringArray;
    }

    static String bytesToHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "<null>";
        }
        int n2 = byArray.length;
        if (n != -1 && n < n2) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            if (n3 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n3).toUpperCase());
        }
        return stringBuffer.toString();
    }

    static String bytesToHex(byte[] byArray) {
        return Utils.bytesToHex(byArray, -1);
    }

    static byte[] hexToBytes(String string) throws JMSException {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            if (n % 2 != 0) {
                throw ConfigEnvironment.newException("MQJMS1044");
            }
            byArray = new byte[n /= 2];
            for (int i = 0; i < n; ++i) {
                int n2 = Character.digit(string.charAt(2 * i), 16);
                int n3 = Character.digit(string.charAt(2 * i + 1), 16);
                if (n2 == -1 || n3 == -1) {
                    throw ConfigEnvironment.newException("MQJMS1044");
                }
                byArray[i] = (byte)(n2 * 16 + n3);
            }
        }
        return byArray;
    }

    static String inquireString(MQManagedObject mQManagedObject, int n) {
        String string;
        block2: {
            string = null;
            try {
                string = mQManagedObject.getAttributeString(n, 128).trim();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block2;
                Trace.exception(CLASSNAME, "inquireString", (Throwable)exception);
            }
        }
        return string;
    }

    static int inquireInt(MQManagedObject mQManagedObject, int n) {
        int n2;
        block2: {
            n2 = -1;
            try {
                int[] nArray = new int[]{n};
                int[] nArray2 = new int[1];
                byte[] byArray = null;
                mQManagedObject.inquire(nArray, nArray2, byArray);
                n2 = nArray2[0];
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block2;
                Trace.exception(CLASSNAME, "inquireInt", (Throwable)exception);
            }
        }
        return n2;
    }

    static String padString(String string, int n) {
        if (n > 0) {
            int n2;
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) > n) {
                string = string.substring(0, n);
            } else if (n2 < n) {
                int n3 = n - n2;
                while (n3 > 0) {
                    string = string + BLANK48.substring(0, n3 < 48 ? n3 : 48);
                    n3 = n - string.length();
                }
            }
        }
        return string;
    }

    static String getDate(GregorianCalendar gregorianCalendar) {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getDate");
        }
        if (gregorianCalendar != null) {
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2) + 1;
            int n3 = gregorianCalendar.get(5);
            string = "00000000" + (n * 10000 + n2 * 100 + n3);
            string = string.substring(string.length() - 8);
        } else {
            string = "        ";
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "Date string is '" + string + "'");
            Trace.exit(CLASSNAME, "getDate");
        }
        return string;
    }

    static String getTime(GregorianCalendar gregorianCalendar) {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getTime");
        }
        if (gregorianCalendar != null) {
            int n = gregorianCalendar.get(11);
            int n2 = gregorianCalendar.get(12);
            int n3 = gregorianCalendar.get(13);
            int n4 = gregorianCalendar.get(14) / 10;
            string = "00000000" + (n * 1000000 + n2 * 10000 + n3 * 100 + n4);
            string = string.substring(string.length() - 8);
        } else {
            string = "        ";
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "Time string is '" + string + "'");
            Trace.exit(CLASSNAME, "getTime");
        }
        return string;
    }

    static boolean byteArraysEqual(byte[] byArray, byte[] byArray2) {
        boolean bl;
        if (byArray == byArray2) {
            bl = true;
        } else if (byArray.length != byArray2.length) {
            bl = false;
        } else {
            bl = true;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRRSTransactionInProgress() {
        Object object;
        Object object2;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "isRRSTransactionInProgress");
        }
        if (wasNotDetected) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Previous call did not detect a WAS OS/390 TransactionManager");
                Trace.trace(CLASSNAME, "Returning false");
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
            }
            return false;
        }
        if (xactionManager == null) {
            object2 = xactionManagerLock;
            synchronized (object2) {
                if (xactionManager == null) {
                    Class clazz;
                    try {
                        object = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.TransactionManager");
                                    return clazz;
                                }
                                catch (AccessControlException accessControlException) {
                                    if (Trace.isOn) {
                                        Trace.exception(3, "Utils", "isRRSTransactionInProgress", (Throwable)accessControlException);
                                    }
                                    return null;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "TransationManager not found");
                                    }
                                    return null;
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Class javax.transaction.TransactionManager not found; WAS OS/390 not detected");
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("com.ibm.ws390.jta.TransactionManager", "com.ibm.ws390.tx.TransactionManagerImpl");
                        }
                    });
                    Method method = null;
                    try {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Trying to load class " + (String)object);
                        }
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedAction((String)object){
                            private final /* synthetic */ String val$classname;
                            {
                                this.val$classname = string;
                            }

                            public Object run() {
                                try {
                                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.val$classname);
                                    return clazz;
                                }
                                catch (AccessControlException accessControlException) {
                                    if (Trace.isOn) {
                                        Trace.exception(3, "Utils", "isRRSTransactionInProgress", (Throwable)accessControlException);
                                    }
                                    return null;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Transaction manager class not found");
                                    }
                                    return null;
                                }
                            }
                        });
                        method = clazz.getMethod("getTransactionManager", null);
                    }
                    catch (NullPointerException nullPointerException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "NullPointerException getting method 'getTransactionManager'");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)nullPointerException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Method getTransactionManager() not found on tm implementation");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)noSuchMethodException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    try {
                        clazz = (TransactionManager)method.invoke(null, (Object[])null);
                        if (clazz == null) {
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "No TransactionManager present. Reverting to local transaction behaviour for this JVM");
                                Trace.trace(CLASSNAME, "Returning false");
                                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                            }
                            wasNotDetected = true;
                            return false;
                        }
                        xactionManager = clazz;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Error when finding TransactionManager");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)invocationTargetException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        return false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Error when finding TransactionManager");
                            Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)illegalAccessException);
                            Trace.trace(CLASSNAME, "Returning false");
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
                        }
                        wasNotDetected = true;
                        return false;
                    }
                }
            }
        }
        object2 = null;
        try {
            object = (TransactionManager)xactionManager;
            object2 = object.getTransaction();
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Unexpected exception while getting Transaction");
                Trace.exception(CLASSNAME, "isRRSTransactionInProgress", (Throwable)exception);
                Trace.trace(CLASSNAME, "Returning false");
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
            }
            return false;
        }
        if (Trace.isOn) {
            if (object2 == null) {
                Trace.trace(CLASSNAME, "No global transaction present; returning false");
            } else {
                Trace.trace(CLASSNAME, "Global transaction active on this thread; returning true");
            }
            Trace.exit(CLASSNAME, "isRRSTransactionInProgress");
        }
        return object2 != null;
    }
}

