/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.disthub2.spi.ExceptionConstants;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.ExceptionDispatchThread;
import com.ibm.mq.jms.JMSListenerSetException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.SubscriptionInfoImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import java.io.Serializable;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber,
ClientExceptionConstants,
ExceptionConstants,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/TopicSubscriberImpl.java, disthub, j600, j600-201-061220 1.32.1.1 05/05/25 15:22:55";
    private static final long serialVersionUID = -7718791450874296380L;
    private static final DebugObject debug = new DebugObject("TopicSubscriberImpl");
    public TopicSessionImpl jmsSession;

    TopicSubscriberImpl(MQTopic mQTopic, String string, String string2, boolean bl, int n, TopicSessionImpl topicSessionImpl) throws JMSException {
        super(mQTopic, string, string2, bl, n, topicSessionImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newMessage(MessageImpl messageImpl) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"newMessage", (Object)messageImpl);
        }
        if (this.noLocalMessages && this.getSession().getConnection().isLocalMid(messageImpl.getMessageID())) {
            return true;
        }
        SubscriptionInfoImpl subscriptionInfoImpl = (SubscriptionInfoImpl)messageImpl.subInfo;
        if (messageImpl.gapMsg || messageImpl.silenceMsg) {
            Assert.condition((boolean)subscriptionInfoImpl.isJMSdurable);
            bl = true;
        } else {
            bl = subscriptionInfoImpl.subMode == 1 ? false : messageImpl.getPersistent();
        }
        if (subscriptionInfoImpl.subMode == 1) {
            return super.newMessage(messageImpl, true);
        }
        if (subscriptionInfoImpl.subMode == 4) {
            boolean bl2 = true;
            if (bl) {
                SubscriptionInfoImpl subscriptionInfoImpl2 = subscriptionInfoImpl;
                synchronized (subscriptionInfoImpl2) {
                    if (!messageImpl.targetted) {
                        bl2 = subscriptionInfoImpl.greaterThanTmin(messageImpl);
                    }
                    if (bl2) {
                        boolean bl3 = subscriptionInfoImpl.advanceDelivered(messageImpl);
                        if (!bl3 && !messageImpl.gapMsg && !messageImpl.silenceMsg && debug.debugIt(2)) {
                            debug.debug(2L, (Object)"delivered V msg did not advance Delivered");
                        }
                        subscriptionInfoImpl.advanceTmin(messageImpl);
                        messageImpl.vc = subscriptionInfoImpl.Delivered.clonep();
                    }
                }
                if (bl2) {
                    return super.newMessage(messageImpl, false);
                }
            }
        } else {
            boolean bl4 = true;
            SubscriptionInfoImpl subscriptionInfoImpl3 = subscriptionInfoImpl;
            synchronized (subscriptionInfoImpl3) {
                if (bl) {
                    bl4 = subscriptionInfoImpl.greaterThanTmin(messageImpl);
                    if (bl4) {
                        subscriptionInfoImpl.advanceTmin(messageImpl);
                    }
                } else {
                    bl4 = subscriptionInfoImpl.subMode == 2;
                }
            }
            if (bl4) {
                return super.newMessage(messageImpl, !bl);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessage");
        }
        return true;
    }

    public Topic getTopic() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTopic");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTopic", (Object)this.topic);
        }
        return this.topic;
    }

    public boolean getNoLocal() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getNoLocal");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getNoLocal", (Object)new Boolean(this.noLocalMessages));
        }
        return this.noLocalMessages;
    }

    protected void deliverGapToExceptionListener(MessageImpl messageImpl) {
        try {
            ExceptionListener exceptionListener = this.getSession().getConnection().getExceptionListener();
            if (exceptionListener != null) {
                ExceptionDispatchThread.xThread.enqueue(exceptionListener, (Exception)((Object)new JMSException(ExceptionBuilder.buildReasonString((int)-1954489557, (Object[])new Object[]{new Long(messageImpl.gsTic)}))));
            } else if (debug.debugIt(2)) {
                debug.debug(2L, (Object)"receive", (Object)"unable to deliver Gap notification, no JMS exception listener");
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public Message receive() throws JMSListenerSetException, IllegalStateException, JMSWrappedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive");
        }
        boolean bl = false;
        MessageImpl messageImpl = null;
        this.ackLatest(false);
        while ((messageImpl = (MessageImpl)super.receive()) != null) {
            this.subInfo.latest = messageImpl;
            this.subInfo.acked = false;
            if (messageImpl.gapMsg) {
                this.deliverGapToExceptionListener(messageImpl);
                continue;
            }
            if (messageImpl.silenceMsg) continue;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"receive");
        }
        return messageImpl;
    }

    public Message receive(long l) throws JMSException, IllegalStateException {
        boolean bl = false;
        MessageImpl messageImpl = null;
        this.ackLatest(false);
        while ((messageImpl = (MessageImpl)super.receive(l)) != null) {
            this.subInfo.latest = messageImpl;
            this.subInfo.acked = false;
            if (messageImpl.gapMsg) {
                this.deliverGapToExceptionListener(messageImpl);
                continue;
            }
            if (messageImpl.silenceMsg) continue;
        }
        return messageImpl;
    }

    public Message receiveNoWait() throws JMSException {
        boolean bl = false;
        MessageImpl messageImpl = null;
        this.ackLatest(false);
        while ((messageImpl = (MessageImpl)super.receiveNoWait()) != null) {
            this.subInfo.latest = messageImpl;
            this.subInfo.acked = false;
            if (messageImpl.gapMsg) {
                this.deliverGapToExceptionListener(messageImpl);
                continue;
            }
            if (messageImpl.silenceMsg) continue;
        }
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatch(MessageImpl messageImpl) {
        block11: {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"dispatch", (Object)messageImpl);
            }
            this.acquireUpReadLock();
            this.subInfo.latest = messageImpl;
            this.subInfo.acked = false;
            try {
                if (messageImpl.gapMsg) {
                    this.deliverGapToExceptionListener(messageImpl);
                } else if (messageImpl.silenceMsg) {
                } else {
                    this.activeListener.onMessage((Message)messageImpl);
                }
            }
            finally {
                this.releaseUpReadLock();
            }
            try {
                this.ackLatest(false);
            }
            catch (Exception exception) {
                ConnectionImpl connectionImpl;
                SessionImpl sessionImpl = this.getSession();
                if (sessionImpl == null || (connectionImpl = sessionImpl.getConnection()) == null) break block11;
                connectionImpl.connectionDropped(exception, false);
            }
        }
    }
}

