/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;

public class SessionAsyncHelper
implements Runnable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SessionAsyncHelper.java, jms, j600, j600-201-061220 1.30.1.1 05/05/25 15:58:30";
    private Vector receivers = new Vector();
    private boolean going = true;
    private boolean finished = false;
    private MQConnection connection;
    private MQSession session;
    private int pollingInterval;
    private int msgBatchSize;
    private Thread asyncThread = null;
    private static int tId = 0;

    SessionAsyncHelper(MQConnection mQConnection, MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.connection = mQConnection;
        this.session = mQSession;
        this.msgBatchSize = this.connection.getMsgBatchSize();
        this.pollingInterval = this.connection.getPollingInterval();
        String string = "asyncDelivery" + tId;
        ++tId;
        this.asyncThread = MQEnvironment.createThread((Runnable)this, (String)string, (boolean)true);
        this.asyncThread.start();
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    void addReceiver(MQMessageConsumer mQMessageConsumer) {
        if (Trace.isOn) {
            Trace.entry(this, "addReceiver");
        }
        if (!this.receivers.contains(mQMessageConsumer)) {
            this.receivers.addElement(mQMessageConsumer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "addReceiver");
        }
    }

    void removeReceiver(MQMessageConsumer mQMessageConsumer) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "removeReceiver");
        }
        if (!(bl = this.receivers.removeElement(mQMessageConsumer)) && Trace.isOn) {
            Trace.trace(this, "removeReceiver() didn't find the receiver on the list!");
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeReceiver");
        }
    }

    synchronized void shutdown() {
        if (Trace.isOn) {
            Trace.entry(this, "shutdown");
        }
        this.going = false;
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (Trace.isOn) {
            Trace.exit(this, "shutdown");
        }
    }

    private synchronized void setFinished() {
        this.finished = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasReceivers() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "hasReceivers");
            }
            boolean bl = this.receivers.size() > 0;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "hasReceivers");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean callingFromOnMessage() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "callingFromOnMessage");
            }
            Thread thread = Thread.currentThread();
            boolean bl = thread.equals(this.asyncThread);
            if (Trace.isOn) {
                Trace.trace(this, "callingFromOnMessage returning " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "callingFromOnMessage");
            }
        }
    }

    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "run");
        }
        MQMessageConsumer mQMessageConsumer = null;
        while (this.going) {
            MQMessageConsumer mQMessageConsumer2;
            block30: {
                Vector vector = (Vector)this.receivers.clone();
                Enumeration enumeration = vector.elements();
                boolean bl = true;
                mQMessageConsumer2 = null;
                if (vector.size() > 1) {
                    while (this.going) {
                        try {
                            boolean bl2;
                            mQMessageConsumer = (MQMessageConsumer)enumeration.nextElement();
                            for (int i = 0; i < this.msgBatchSize && this.going && (bl2 = mQMessageConsumer.receiveAsync(0L)); ++i) {
                                bl = false;
                                mQMessageConsumer2 = mQMessageConsumer;
                            }
                        }
                        catch (NoMsgListenerException noMsgListenerException) {
                            this.receivers.removeElement(mQMessageConsumer);
                        }
                        catch (JMSException jMSException) {
                            this.receivers.removeElement(mQMessageConsumer);
                            this.connection.deliverException(jMSException);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            if (!Trace.isOn) break;
                            Trace.trace(this, "leaving the recvr polling loop, nothingReceived = " + bl);
                            break;
                        }
                        catch (Throwable throwable) {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS1016", throwable.toString()));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                        }
                    }
                }
                if (!this.going || !bl) continue;
                if (mQMessageConsumer2 == null) {
                    try {
                        mQMessageConsumer2 = (MQMessageConsumer)this.receivers.firstElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block30;
                        Trace.trace(this, "failed to find a consumer for blocking read because of " + exception);
                    }
                }
            }
            if (!this.session.isStarted()) {
                try {
                    this.session.waitForStart(this.pollingInterval);
                }
                catch (SessionClosedException sessionClosedException) {
                    this.going = false;
                }
                catch (JMSException jMSException) {}
                continue;
            }
            if (mQMessageConsumer2 == null || this.session.getPlayNice()) {
                try {
                    Thread.sleep(this.pollingInterval);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                mQMessageConsumer2.receiveAsync(this.pollingInterval);
            }
            catch (NoMsgListenerException noMsgListenerException) {
                this.receivers.removeElement(mQMessageConsumer2);
            }
            catch (JMSException jMSException) {
                this.receivers.removeElement(mQMessageConsumer2);
                this.connection.deliverException(jMSException);
            }
            catch (Throwable throwable) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS1016", throwable.toString()));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
            }
        }
        this.setFinished();
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }
}

