/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.RFH2;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;

class RFH2BrokerMessageImpl
extends MQBrokerMessage {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/RFH2BrokerMessageImpl.java, jms, j600, j600-201-061220 1.15.1.2 05/06/27 17:40:01";
    private static final String clsName = "RFH2BrokerMessageImpl";
    private RFH2 rfh2 = null;
    private Vector auxilliaryNVPairs = new Vector();

    public RFH2BrokerMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "clear");
        }
        this.rfh2 = null;
        this.auxilliaryNVPairs = new Vector();
        super.clear();
        if (Trace.isOn) {
            Trace.exit(this, "clear");
        }
    }

    public void initializeFromMessage(MQMsg2 mQMsg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "initializeFromMessage");
        }
        try {
            this.clear();
            this.rfh2 = new RFH2(mQMsg2);
            String string = null;
            this.setEncoding(this.rfh2.getEncoding());
            this.setCodedCharSetId(this.rfh2.getCodedCharSetId());
            this.setFormat(this.rfh2.getFormat());
            String string2 = this.rfh2.getNameValueString();
            if (Trace.isOn) {
                Trace.trace(this, "nameValueString is " + string2);
            }
            int n = string2.indexOf("<pscr>");
            int n2 = string2.indexOf("</pscr>");
            if (Trace.isOn) {
                Trace.trace(this, "searched for pscr folder. Got index " + n + " and " + n2);
            }
            if (n > -1 && n2 > 0) {
                string = string2.substring(n, n2 + 7);
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "no pscr folder found. Searching for psc folder instead");
                }
                n = string2.indexOf("<psc>");
                n2 = string2.indexOf("</psc>");
                if (Trace.isOn) {
                    Trace.trace(this, "searched for psc folder. Got index " + n + " and " + n2);
                }
                if (n > -1 && n2 > 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "This is not a broker response message. parsing Psc folder rather than Pscr folder");
                        Trace.trace(this, "Remember, trace statements may still refer to Pscr folder while in this method");
                    }
                    string = string2.substring(n, n2 + 6);
                }
            }
            if (string != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "PscrFolder is " + string);
                }
                this.parsePubSubFolder(string);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "initializeFromMessage");
            }
        }
    }

    public void writeToMessage(MQMsg2 mQMsg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "writeToMessage");
        }
        try {
            String string;
            if (this.rfh2 == null) {
                this.rfh2 = new RFH2();
            }
            this.rfh2.setEncoding(this.getEncoding());
            this.rfh2.setCodedCharSetId(this.getCodedCharSetId());
            this.rfh2.setFormat(this.getFormat());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<psc>");
            String string2 = this.get("MQPSCommand");
            if (string2 != null) {
                stringBuffer.append("<Command>");
                this.appendToken(stringBuffer, string2);
                stringBuffer.append("</Command>");
            }
            Enumeration enumeration = this.getFields();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equals("MQPSCommand") || string.equals("MQPSStreamName")) continue;
                string2 = this.get(string);
                if ((string = string.equals("MQPSRegOpts") ? "RegOpt" : (string.equals("MQPSPubOpts") ? "PubOpt" : string.substring(4))).equals("QName")) {
                    string2 = string2.trim();
                }
                stringBuffer.append("<");
                this.appendToken(stringBuffer, string);
                stringBuffer.append(">");
                this.appendToken(stringBuffer, string2);
                stringBuffer.append("</" + string + ">");
            }
            enumeration = this.auxilliaryNVPairs.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = (String)enumeration.nextElement();
                stringBuffer.append("<");
                this.appendToken(stringBuffer, string);
                stringBuffer.append(">");
                this.appendToken(stringBuffer, string2);
                stringBuffer.append(" </" + string + ">");
            }
            stringBuffer.append("</psc>");
            string = stringBuffer.toString();
            Trace.trace(this, "RFH2 nameValueString is " + string);
            this.rfh2.setNameValueString(string);
            this.rfh2.setNameValueLength(string.length());
            this.rfh2.write(mQMsg2);
        }
        catch (JMSException jMSException) {
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Trace.exit(this, "writeToMessage");
        }
    }

    public String getHeaderFormat() {
        return "MQHRF2  ";
    }

    private void appendToken(StringBuffer stringBuffer, String string) {
        String string2 = "";
        if (string.equals("")) {
            stringBuffer.append(string);
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            string2 = string.charAt(i) == '&' ? string2 + "&amp;" : (string.charAt(i) == '\'' ? string2 + "&apos;" : (string.charAt(i) == '\"' ? string2 + "&quot;" : (string.charAt(i) == '>' ? string2 + "&gt;" : (string.charAt(i) == '<' ? string2 + "&lt;" : string2 + string.charAt(i)))));
        }
        stringBuffer.append(string2);
    }

    private String removeEscapes(String string) throws JMSException {
        if (string == null) {
            return null;
        }
        if (string.equals("") || string.indexOf(38) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                String string2 = string.substring(i + 1, i + 4);
                if (string2.startsWith("lt;")) {
                    stringBuffer.append('<');
                    i += 3;
                    continue;
                }
                if (string2.startsWith("gt;")) {
                    stringBuffer.append('>');
                    i += 3;
                    continue;
                }
                if (string2.startsWith("amp")) {
                    stringBuffer.append("&");
                    i += 4;
                    continue;
                }
                if (string2.startsWith("apo")) {
                    stringBuffer.append('\'');
                    i += 5;
                    continue;
                }
                if (string2.startsWith("quo")) {
                    stringBuffer.append('\"');
                    i += 5;
                    continue;
                }
                Trace.trace(this, "Error: invalid escape sequence found &" + string2);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1054", "&" + string2);
                throw jMSException;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void parsePubSubFolder(String string) throws JMSException {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        String string3 = stringTokenizer.nextToken();
        if (!string3.equals("pscr") && !string3.equals("psc")) {
            Trace.trace(this, "Invalid psc or pscr folder");
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1050");
            throw jMSException;
        }
        String string4 = stringTokenizer.nextToken();
        while (!string4.equals("/" + string3)) {
            String string5 = stringTokenizer.nextToken();
            if (!string5.equals("/" + string4)) {
                String string6;
                String string7 = this.removeEscapes(string5);
                if (string4.startsWith("Completion")) {
                    if (string7.equals("ok")) {
                        string7 = Integer.toString(0);
                        string2 = Integer.toString(0);
                        this.rfh2_update("MQPSReason", string2);
                        this.rfh2_update("MQPSReasonText", string2 + " ");
                    } else if (string7.equals("warning")) {
                        string7 = Integer.toString(1);
                    } else if (string7.equals("error")) {
                        string7 = Integer.toString(2);
                    } else {
                        Trace.trace(this, "Invalid Completion Code in pscr folder");
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1050");
                        throw jMSException;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "CompletionCode is " + string7);
                    }
                    this.rfh2_update("MQPSCompCode", string7);
                    string6 = stringTokenizer.nextToken();
                } else if (string4.startsWith("Response")) {
                    if (string7.startsWith("Reason")) {
                        string7 = stringTokenizer.nextToken();
                        if (Trace.isOn) {
                            Trace.trace(this, "Reason is " + string7);
                        }
                        if (string7 != null) {
                            this.rfh2_update("MQPSReason", string7);
                            this.rfh2_update("MQPSReasonText", string7 + " ");
                        }
                        string6 = stringTokenizer.nextToken();
                        while (!string6.equals("/Response")) {
                            string6 = stringTokenizer.nextToken();
                        }
                    }
                } else if (string4.startsWith("Reason")) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Reason is " + string7);
                    }
                    if (string7 != null) {
                        this.rfh2_update("MQPSReason", string7);
                        this.rfh2_update("MQPSReasonText", string7 + " ");
                    }
                    string6 = stringTokenizer.nextToken();
                } else if (string4.startsWith("RegOpt")) {
                    if (Trace.isOn) {
                        Trace.trace(this, "RegOpt are " + string7);
                    }
                    if (string7 != null) {
                        this.rfh2_update("MQPSRegOpts", string7);
                    }
                    string6 = stringTokenizer.nextToken();
                } else if (string4.startsWith("PubOpt")) {
                    if (Trace.isOn) {
                        Trace.trace(this, "PubOpt are " + string7);
                    }
                    if (string7 != null) {
                        this.rfh2_update("MQPSPubOpts", string7);
                    }
                    string6 = stringTokenizer.nextToken();
                } else if (string4.startsWith("DelOpt")) {
                    if (Trace.isOn) {
                        Trace.trace(this, "DelOpt are " + string7);
                    }
                    if (string7 != null) {
                        this.rfh2_update("MQPSDelOpts", string7);
                    }
                    string6 = stringTokenizer.nextToken();
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Name is " + string4 + ", Value is " + string7);
                    }
                    if (string7 != null) {
                        this.rfh2_update("MQPS" + string4, string7);
                    }
                    string6 = stringTokenizer.nextToken();
                }
            }
            string4 = stringTokenizer.nextToken();
        }
    }

    public void rfh2_update(String string, String string2) throws JMSException {
        try {
            this.update(string, string2);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Repeated Name/Value found, saving in auxilliary array Name " + string + "Value " + string2);
            }
            this.auxilliaryNVPairs.addElement(string);
            this.auxilliaryNVPairs.addElement(string2);
        }
    }
}

