/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.RFH2Folder;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.JMSException;

public class RFH2 {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/RFH2.java, jms, j600, j600-201-061220 1.16.1.1 05/05/25 16:02:27";
    private static final String MQRFH_STRUC_ID = "RFH ";
    private static final int MQRFH_ASCII_STRUC_ID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUC_ID_INT = -641284032;
    private static final int MQRFH_VERSION_2 = 2;
    private static final int MQRFH_STRUC_LENGTH_FIXED_2 = 36;
    private String strucId = "RFH ";
    private int version = 2;
    private int strucLength = 36;
    private int encoding = 273;
    private int codedCharSetId = -2;
    private String format = "MQSTR   ";
    private int flags = 0;
    private int nameValueCCSID = 1208;
    private Vector folders = null;
    private String nameValueString;
    private int nameValueLength = 0;
    private int msgCharSet;
    private int msgEncoding;
    private static final byte[] SPACES = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};

    public RFH2() {
        this.folders = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RFH2(MQMsg2 mQMsg2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(message)");
            }
            this.folders = new Vector();
            if (mQMsg2 == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            this.msgCharSet = mQMsg2.getCharacterSet();
            this.msgEncoding = mQMsg2.getEncoding();
            try {
                int n = mQMsg2.readInt(1);
                switch (n) {
                    case 1380337696: {
                        this.msgCharSet = 819;
                        this.strucId = MQRFH_STRUC_ID;
                        break;
                    }
                    case -641284032: {
                        this.msgCharSet = 500;
                        this.strucId = MQRFH_STRUC_ID;
                        break;
                    }
                    default: {
                        throw new Exception("strucId");
                    }
                }
                this.version = mQMsg2.readInt(this.msgEncoding);
                if (this.version != 2) {
                    throw new Exception("version");
                }
                this.strucLength = mQMsg2.readInt(this.msgEncoding);
                this.encoding = mQMsg2.readInt(this.msgEncoding);
                this.codedCharSetId = mQMsg2.readInt(this.msgEncoding);
                byte[] byArray = new byte[8];
                mQMsg2.read(byArray);
                this.format = this.getString(byArray);
                this.flags = mQMsg2.readInt(this.msgEncoding);
                this.nameValueCCSID = mQMsg2.readInt(this.msgEncoding);
                if (this.strucLength > 36) {
                    int n2 = this.strucLength - 40;
                    mQMsg2.skipReadingBytes(4);
                    byArray = new byte[n2];
                    mQMsg2.read(byArray);
                    try {
                        this.nameValueString = this.getString(byArray, MQCcsidTable.lookup((String)Integer.toString(this.nameValueCCSID)));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (Trace.isOn()) {
                            Trace.trace(this, "RFH2, NameValue CCSID " + this.nameValueCCSID + " not valid, using 819");
                        }
                        this.nameValueString = this.getString(byArray, "819");
                    }
                } else {
                    this.nameValueString = "";
                }
                if (Trace.isOn) {
                    Trace.trace(this, "The following fields have been read:\n" + this.toString());
                }
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1086");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + exception);
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(message)");
            }
        }
    }

    public void addFolder(RFH2Folder rFH2Folder) {
        int n = rFH2Folder.render().length();
        this.folders.addElement(rFH2Folder);
        this.strucLength += 4;
    }

    private byte[] getByteArray(String string) throws UnsupportedEncodingException {
        return string.getBytes(MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    public int getCodedCharSetId() {
        return this.codedCharSetId;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getFormat() {
        return this.format;
    }

    public int getMsgEncoding() {
        return this.msgEncoding;
    }

    public int getNameValueCCSID() {
        return this.nameValueCCSID;
    }

    public int getNameValueLength() {
        return this.nameValueLength;
    }

    public String getNameValueString() {
        return this.nameValueString;
    }

    private String getString(byte[] byArray) throws UnsupportedEncodingException {
        return new String(byArray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    private String getString(byte[] byArray, String string) throws UnsupportedEncodingException {
        return new String(byArray, string);
    }

    public String getStrucId() {
        return this.strucId;
    }

    public int getStrucLength() {
        return this.strucLength;
    }

    public void setCodedCharSetId(int n) {
        this.codedCharSetId = n;
    }

    public void setEncoding(int n) {
        this.encoding = n;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setMsgEncoding(int n) {
        this.msgEncoding = n;
    }

    public void setNameValueCCSID(int n) {
        this.nameValueCCSID = n;
    }

    public void setNameValueLength(int n) {
        this.nameValueLength = n;
    }

    public void setNameValueString(String string) {
        this.nameValueString = string;
    }

    public void setStrucId(String string) {
        this.strucId = string;
    }

    public void setStrucLength(int n) {
        this.strucLength = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("Dumping fixed portion of RFH2");
            stringBuffer.append("\n   StrucId        = " + this.strucId);
            stringBuffer.append("\n   Version        = " + this.version);
            stringBuffer.append("\n   StrucLength    = " + this.strucLength);
            stringBuffer.append("\n   Encoding       = " + this.encoding);
            stringBuffer.append("\n   CodedCharSetId = " + this.codedCharSetId);
            stringBuffer.append("\n   Format         = " + this.format);
            stringBuffer.append("\n   Flags          = " + this.flags);
            stringBuffer.append("\n   NameValueCCSID = " + this.nameValueCCSID);
            for (int i = 0; i < this.folders.size(); ++i) {
                String string = this.folders.elementAt(i).toString();
                stringBuffer.append("\n\nDumping folder " + (i + 1));
                stringBuffer.append("\n   " + string);
                stringBuffer.append("\n NameValueLength " + this.nameValueLength);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("RFH2 toString() Exception : " + exception);
            return stringBuffer.toString();
        }
    }

    public void write(MQMsg2 mQMsg2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "write(MQMsg2)");
            }
            int n = 0;
            byte[] byArray = null;
            if (this.nameValueString != null) {
                byArray = this.nameValueString.getBytes("UTF8");
                this.nameValueLength = byArray.length;
                n = 3 - (this.nameValueLength - 1) % 4;
                this.nameValueLength += n;
                if (this.nameValueLength > 0) {
                    this.strucLength = this.strucLength + this.nameValueLength + 4;
                }
            } else {
                this.strucLength = 36;
            }
            this.msgEncoding = mQMsg2.getEncoding();
            this.msgCharSet = mQMsg2.getCharacterSet();
            mQMsg2.appendByteArray(this.getByteArray(this.strucId));
            mQMsg2.appendInt(this.version, this.msgEncoding);
            mQMsg2.appendInt(this.strucLength, this.msgEncoding);
            mQMsg2.appendInt(this.encoding, this.msgEncoding);
            mQMsg2.appendInt(this.codedCharSetId, this.msgEncoding);
            mQMsg2.appendByteArray(this.getByteArray(this.format));
            mQMsg2.appendInt(this.flags, this.msgEncoding);
            mQMsg2.appendInt(this.nameValueCCSID, this.msgEncoding);
            if (this.nameValueString != null) {
                mQMsg2.appendInt(this.nameValueLength, this.msgEncoding);
                mQMsg2.appendByteArray(byArray);
                mQMsg2.appendByteArray(SPACES, 0, n);
            }
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1085");
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + exception);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "write(MQMsg2)");
            }
        }
    }

    public void writeToMessage(MQMessage mQMessage) throws Exception {
        if (mQMessage == null) {
            throw new Exception("Null message passed in");
        }
        mQMessage.format = "MQHRF2  ";
        try {
            mQMessage.writeString(this.strucId);
            mQMessage.writeInt(this.version);
            mQMessage.writeInt(this.strucLength);
            mQMessage.writeInt(this.encoding);
            mQMessage.writeInt(this.codedCharSetId);
            mQMessage.writeString(this.format);
            mQMessage.writeInt(this.flags);
            mQMessage.writeInt(this.nameValueCCSID);
            for (int i = 0; i < this.folders.size(); ++i) {
                RFH2Folder rFH2Folder = (RFH2Folder)this.folders.elementAt(i);
                String string = rFH2Folder.render();
                mQMessage.writeInt(string.length());
            }
        }
        catch (IOException iOException) {
            Exception exception = new Exception("IOException in writeToMessage: " + iOException);
            throw exception;
        }
    }
}

