/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class PCF {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/PCF.java, jms, j600, j600-201-061220 1.9.1.1 05/05/25 16:01:37";
    private static final int MQCFH_STRUC_LENGTH = 36;
    private static final int MQCFH_VERSION_1 = 1;
    private static final int MQCFC_LAST = 1;
    private static final int MQCFC_NOT_LAST = 0;
    public static final int MQCFT_COMMAND = 1;
    public static final int MQCFT_RESPONSE = 2;
    public static final int MQCFT_INTEGER = 3;
    public static final int MQCFT_STRING = 4;
    public static final int MQCFT_INTEGER_LIST = 5;
    public static final int MQCFT_STRING_LIST = 6;
    public static final int MQCFT_EVENT = 7;
    public static final int MQCACF_TOPIC = 3031;
    public static final int MQCACF_PUBLISH_TIMESTAMP = 3034;
    public static final int MQCACF_REG_TIME = 3038;
    public static final int MQCACF_REG_USER_ID = 3039;
    public static final int MQCACF_REG_Q_MGR_NAME = 3042;
    public static final int MQCACF_REG_Q_NAME = 3043;
    public static final int MQCACF_REG_CORREL_ID = 3044;
    public static final int MQCMD_CLEAR_Q = 9;
    public static final int MQCMD_INQUIRE_Q_NAMES = 18;
    public static final int MQCA_Q_NAME = 2016;
    public static final int MQIA_Q_TYPE = 20;
    public static final int MQCFIL_STRUC_LENGTH_FIXED = 16;
    public static final int MQCFIN_STRUC_LENGTH = 16;
    public static final int MQCFSL_STRUC_LENGTH_FIXED = 24;
    public static final int MQCFST_STRUC_LENGTH_FIXED = 20;
    int type;
    int strucLength;
    int version;
    int command;
    int msgSeqNumber;
    int control;
    int compCode;
    int reason;
    int parameterCount;
    int[] paramTypes = null;
    Object[] paramValues = null;
    private Vector paramOut = null;

    public PCF(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor()");
        }
        this.type = 1;
        this.strucLength = 36;
        this.version = 1;
        this.command = n;
        this.msgSeqNumber = 1;
        this.control = 1;
        this.compCode = 0;
        this.reason = 0;
        this.parameterCount = 0;
        if (Trace.isOn) {
            Trace.exit(this, "constructor()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCF(BytesMessage bytesMessage) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(message)");
            }
            if (bytesMessage == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
                if (Trace.isOn) {
                    Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            try {
                this.type = bytesMessage.readInt();
                this.strucLength = bytesMessage.readInt();
                this.version = bytesMessage.readInt();
                this.command = bytesMessage.readInt();
                this.msgSeqNumber = bytesMessage.readInt();
                this.control = bytesMessage.readInt();
                this.compCode = bytesMessage.readInt();
                this.reason = bytesMessage.readInt();
                this.parameterCount = bytesMessage.readInt();
                if (this.version != 1) {
                    throw new Exception("Unknown version: " + this.version);
                }
                this.paramTypes = new int[this.parameterCount];
                this.paramValues = new Object[this.parameterCount];
                for (int i = 0; i < this.parameterCount; ++i) {
                    int n;
                    this.paramTypes[i] = n = bytesMessage.readInt();
                    if (n == 4) {
                        this.paramValues[i] = new MQCFST(bytesMessage);
                        continue;
                    }
                    if (n == 3) {
                        this.paramValues[i] = new MQCFIN(bytesMessage);
                        continue;
                    }
                    throw new Exception("Unknown paramType: " + n);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "The following fields have been read:\n" + this.toString());
                }
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1086");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + exception);
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(message)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCF(MQMessage mQMessage) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(message)");
            }
            if (mQMessage == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
                if (Trace.isOn) {
                    Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            try {
                this.type = mQMessage.readInt();
                this.strucLength = mQMessage.readInt();
                this.version = mQMessage.readInt();
                this.command = mQMessage.readInt();
                this.msgSeqNumber = mQMessage.readInt();
                this.control = mQMessage.readInt();
                this.compCode = mQMessage.readInt();
                this.reason = mQMessage.readInt();
                this.parameterCount = mQMessage.readInt();
                if (this.version != 1) {
                    throw new Exception("Unknown version: " + this.version);
                }
                this.paramTypes = new int[this.parameterCount];
                this.paramValues = new Object[this.parameterCount];
                for (int i = 0; i < this.parameterCount; ++i) {
                    int n;
                    this.paramTypes[i] = n = mQMessage.readInt();
                    if (n == 4) {
                        this.paramValues[i] = new MQCFST(mQMessage);
                        continue;
                    }
                    if (n == 3) {
                        this.paramValues[i] = new MQCFIN(mQMessage);
                        continue;
                    }
                    if (n == 6) {
                        this.paramValues[i] = new MQCFSL(mQMessage);
                        continue;
                    }
                    throw new Exception("Unknown paramType: " + n);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "The following fields have been read:\n" + this.toString());
                }
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1086");
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + exception);
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(message)");
            }
        }
    }

    public void write(MQMessage mQMessage) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "write");
            }
            mQMessage.messageType = 1;
            mQMessage.expiry = 1000;
            mQMessage.format = "MQADMIN ";
            mQMessage.feedback = 0;
            mQMessage.writeInt(this.type);
            mQMessage.writeInt(this.strucLength);
            mQMessage.writeInt(this.version);
            mQMessage.writeInt(this.command);
            mQMessage.writeInt(this.msgSeqNumber);
            mQMessage.writeInt(this.control);
            mQMessage.writeInt(this.compCode);
            mQMessage.writeInt(this.reason);
            mQMessage.writeInt(this.parameterCount);
            for (int i = 0; i < this.parameterCount; ++i) {
                Object e = this.paramOut.elementAt(i);
                if (e instanceof MQCFST) {
                    ((MQCFST)e).writeTo(mQMessage);
                    continue;
                }
                if (e instanceof MQCFIN) {
                    ((MQCFIN)e).writeTo(mQMessage);
                    continue;
                }
                throw new Exception("Unable to write unknown parameter: " + i);
            }
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1085");
            jMSException.setLinkedException(exception);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "write");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type='" + this.type + "'\n");
        stringBuffer.append("StrucLength='" + this.strucLength + "'\n");
        stringBuffer.append("Version='" + this.version + "'\n");
        stringBuffer.append("Command='" + this.command + "'\n");
        stringBuffer.append("MsgSeqNumber='" + this.msgSeqNumber + "'\n");
        stringBuffer.append("Control='" + this.control + "'\n");
        stringBuffer.append("CompCode='" + this.compCode + "'\n");
        stringBuffer.append("Reason='" + this.reason + "'\n");
        stringBuffer.append("ParameterCount='" + this.parameterCount + "'\n");
        for (int i = 0; i < this.parameterCount; ++i) {
            stringBuffer.append("  Parameter " + (i + 1) + "\n");
            stringBuffer.append("    " + this.paramValues[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public Object getParameterAt(int n) {
        if (n < this.parameterCount) {
            return this.paramValues[n];
        }
        return null;
    }

    public int getParameterType(int n) {
        if (n < this.parameterCount) {
            return this.paramTypes[n];
        }
        return -1;
    }

    public int getControl() {
        return this.control;
    }

    public int getMsgSeqNumber() {
        return this.msgSeqNumber;
    }

    public int getCompCode() {
        return this.compCode;
    }

    public int getReason() {
        return this.reason;
    }

    public void addParameter(int n, int n2) {
        if (this.paramOut == null) {
            this.paramOut = new Vector();
        }
        MQCFIN mQCFIN = new MQCFIN(n, n2);
        this.paramOut.addElement(mQCFIN);
        ++this.parameterCount;
    }

    public void addParameter(int n, String string) {
        if (this.paramOut == null) {
            this.paramOut = new Vector();
        }
        MQCFST mQCFST = new MQCFST(n, string);
        this.paramOut.addElement(mQCFST);
        ++this.parameterCount;
    }

    public class MQCFSL {
        int type = 6;
        int strucLength;
        int paramId;
        int CCSID;
        int count;
        int strLength;
        String[] strings;

        MQCFSL(MQMessage mQMessage) throws Exception {
            this.strucLength = mQMessage.readInt();
            this.paramId = mQMessage.readInt();
            this.CCSID = mQMessage.readInt();
            this.count = mQMessage.readInt();
            this.strLength = mQMessage.readInt();
            this.strings = new String[this.count];
            for (int i = 0; i < this.count; ++i) {
                byte[] byArray = new byte[this.strLength];
                mQMessage.readFully(byArray);
                this.strings[i] = new String(byArray);
            }
        }

        public String[] getStrings() {
            return this.strings;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("MQCFSL [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",CCSID=" + this.CCSID + ",Count=" + this.count + ",StrLength=" + this.strLength + ",Strings={");
            for (int i = 0; i < this.count; ++i) {
                String string = this.strings[i];
                stringBuffer.append(string);
                if (i < this.count - 1) {
                    stringBuffer.append(",");
                    continue;
                }
                stringBuffer.append("}]");
            }
            return stringBuffer.toString();
        }
    }

    public class MQCFIN {
        int strucLength;
        int paramId;
        int value;

        MQCFIN(BytesMessage bytesMessage) throws Exception {
            this.strucLength = bytesMessage.readInt();
            this.paramId = bytesMessage.readInt();
            this.value = bytesMessage.readInt();
        }

        MQCFIN(MQMessage mQMessage) throws Exception {
            this.strucLength = mQMessage.readInt();
            this.paramId = mQMessage.readInt();
            this.value = mQMessage.readInt();
        }

        MQCFIN(int n, int n2) {
            this.value = n2;
            this.paramId = n;
            this.strucLength = 16;
        }

        public void writeTo(MQMessage mQMessage) throws Exception {
            mQMessage.writeInt(3);
            mQMessage.writeInt(this.strucLength);
            mQMessage.writeInt(this.paramId);
            mQMessage.writeInt(this.value);
        }

        public String toString() {
            return "MQCFIN [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",Value=" + this.value + "]";
        }
    }

    public class MQCFST {
        int strucLength;
        int paramId;
        int CCSID;
        int strLength;
        String value;

        MQCFST(BytesMessage bytesMessage) throws Exception {
            this.strucLength = bytesMessage.readInt();
            this.paramId = bytesMessage.readInt();
            this.CCSID = bytesMessage.readInt();
            this.strLength = bytesMessage.readInt();
            byte[] byArray = new byte[this.strLength];
            bytesMessage.readBytes(byArray, this.strLength);
            this.value = new String(byArray);
            int n = this.strLength % 4;
            if (n != 0) {
                int n2 = 4 - n;
                byte[] byArray2 = new byte[n2];
                bytesMessage.readBytes(byArray2, n2);
            }
        }

        MQCFST(MQMessage mQMessage) throws Exception {
            this.strucLength = mQMessage.readInt();
            this.paramId = mQMessage.readInt();
            this.CCSID = mQMessage.readInt();
            this.strLength = mQMessage.readInt();
            byte[] byArray = new byte[this.strLength];
            mQMessage.readFully(byArray);
            this.value = new String(byArray);
            int n = this.strLength % 4;
            if (n != 0) {
                int n2 = 4 - n;
                byte[] byArray2 = new byte[n2];
                mQMessage.readFully(byArray2);
            }
        }

        MQCFST(int n, String string) {
            this.value = string;
            this.paramId = n;
            this.CCSID = 0;
        }

        public void writeTo(MQMessage mQMessage) throws Exception {
            this.strLength = this.value == null ? 0 : this.value.length();
            int n = this.strLength % 4;
            if (n != 0) {
                n = 4 - n;
            }
            this.strucLength = 20 + this.strLength + n;
            mQMessage.writeInt(4);
            mQMessage.writeInt(this.strucLength);
            mQMessage.writeInt(this.paramId);
            mQMessage.writeInt(mQMessage.characterSet);
            mQMessage.writeInt(this.strLength);
            mQMessage.writeString(this.value);
            while (n-- > 0) {
                mQMessage.write(32);
            }
        }

        public String toString() {
            return "MQCFST [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",CCSID=" + this.CCSID + ",StrLength=" + this.strLength + ",Value=" + this.value + "]";
        }
    }
}

