/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.PriorityQueueNode;
import com.ibm.disthub2.impl.util.Queue;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.ExceptionDispatchThread;
import com.ibm.mq.jms.JMSMessageQueueOverflowException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import java.io.IOException;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class MessageQueue
implements ClientExceptionConstants,
ClientLogConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MessageQueue.java, disthub, j600, j600-201-061220 1.13.1.1 05/05/25 15:43:44";
    private static final DebugObject debug = new DebugObject("MessageQueue");
    private Queue normalQueue;
    private Queue priorityQueue;
    private Thread blockedThread;
    private volatile boolean alive = true;
    private boolean stopped = true;
    private boolean appConnectionClosed = true;
    private Exception eConnectionClosed = null;
    private int messageCount;
    private int maxMessageCount;
    private PriorityQueueNode hdl;
    private ConnectionImpl.FreeSpaceHeap fsh;
    private ConnectionImpl conn;
    private boolean enableFlowControl;

    MessageQueue(int n) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageQueue");
        }
        this.normalQueue = new Queue();
        this.priorityQueue = new Queue();
        this.maxMessageCount = n;
        this.enableFlowControl = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageQueue");
        }
    }

    public void setFreeSpaceHeapStuff(ConnectionImpl.FreeSpaceHeap freeSpaceHeap, PriorityQueueNode priorityQueueNode, ConnectionImpl connectionImpl) {
        this.fsh = freeSpaceHeap;
        this.hdl = priorityQueueNode;
        this.conn = connectionImpl;
        this.enableFlowControl = BaseConfig.getBaseConfig().ENABLE_CLIENT_FLOW_CONTROL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean enqueue(MessageImpl messageImpl) {
        ConnectionImpl.FreeSpaceHeap freeSpaceHeap;
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"enqueue", (Object)messageImpl);
        }
        if (this.maxMessageCount > 0 && this.messageCount >= this.maxMessageCount) {
            block29: {
                int n;
                MessageImpl messageImpl2;
                if (debug.debugIt(2)) {
                    debug.debug(2L, (Object)"enqueue", (Object)("**>Msg count=" + this.messageCount + " .ge. max(" + this.maxMessageCount + ") will clear disposables"));
                }
                Vector<MessageImpl> vector = new Vector<MessageImpl>();
                while ((messageImpl2 = (MessageImpl)this.priorityQueue.dequeueOrNull()) != null) {
                    if (messageImpl2.getDisposable()) continue;
                    vector.addElement(messageImpl2);
                }
                this.messageCount = n = vector.size();
                while (n-- > 0) {
                    this.priorityQueue.enqueue(vector.remove(0));
                }
                while ((messageImpl2 = (MessageImpl)this.normalQueue.dequeueOrNull()) != null) {
                    if (messageImpl2.getDisposable()) continue;
                    vector.addElement(messageImpl2);
                }
                n = vector.size();
                this.messageCount += n;
                while (n-- > 0) {
                    this.normalQueue.enqueue(vector.remove(0));
                }
                try {
                    if (debug.debugIt(16)) {
                        debug.debug(16L, (Object)"enqueue", (Object)"***>will attempt alert of JMS exception listener");
                    }
                    if ((freeSpaceHeap = messageImpl.getConsumer().getSession().getConnection().getExceptionListener()) != null) {
                        ExceptionDispatchThread.xThread.enqueue((ExceptionListener)freeSpaceHeap, (Exception)((Object)new JMSMessageQueueOverflowException(ExceptionBuilder.buildReasonString((int)1003358355, (Object[])new Object[]{new Integer(this.maxMessageCount - this.messageCount)}))));
                    } else if (debug.debugIt(16)) {
                        debug.debug(16L, (Object)"enqueue", (Object)"***> no JMS exception listener found");
                    }
                }
                catch (JMSException jMSException) {
                    if (!debug.debugIt(16)) break block29;
                    debug.debug(16L, (Object)"enqueue", (Object)("***> got JMS exception, ignored je=" + jMSException.toString()));
                }
            }
            if (this.messageCount >= this.maxMessageCount) {
                if (debug.debugIt(2)) {
                    debug.debug(2L, (Object)"enqueue", (Object)"**>Msg Q full with NON disposables, will throw exception to close connection");
                }
                this.alive = false;
                this.normalQueue.makeEmptyAndClean();
                this.priorityQueue.makeEmptyAndClean();
                return false;
            }
        }
        ++this.messageCount;
        if (this.enableFlowControl) {
            int n = this.maxMessageCount - this.messageCount;
            long l = this.hdl.priority;
            if ((long)n < this.hdl.priority) {
                freeSpaceHeap = this.fsh;
                synchronized (freeSpaceHeap) {
                    this.fsh.changePriority(n - (int)this.hdl.priority, this.hdl);
                }
                if (debug.debugIt(2)) {
                    debug.debug(-175584356845707L, (Object)"enqueue", (Object)((Object)((Object)this.conn) + ":freeSpace=" + n + ",changed priority from " + l));
                }
            } else if (debug.debugIt(2)) {
                debug.debug(-175584356845707L, (Object)"enqueue", (Object)((Object)((Object)this.conn) + ":freeSpace=" + n + ",priority not updated:" + l));
            }
        }
        try {
            if (debug.debugIt(16)) {
                debug.debug(16L, (Object)"enqueue", (Object)"finally doing it", (Object)messageImpl);
            }
            if (messageImpl.getJMSPriority() > 4) {
                this.priorityQueue.enqueue((Object)messageImpl);
            } else {
                this.normalQueue.enqueue((Object)messageImpl);
            }
            this.notifyAll();
        }
        catch (JMSException jMSException) {
            Assert.failure((Exception)((Object)jMSException));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"enqueue");
        }
        return true;
    }

    synchronized MessageImpl dequeue() throws InterruptedException, JMSWrappedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeue");
        }
        while (this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty()) {
            if (!this.alive) {
                if (this.appConnectionClosed) {
                    if (debug.debugIt(64)) {
                        debug.debug(-142394261359015L, (Object)"dequeue", null);
                    }
                    return null;
                }
                throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)218068710, (Object[])new Object[]{this.eConnectionClosed}), this.eConnectionClosed);
            }
            this.blockedThread = Thread.currentThread();
            try {
                this.wait();
                if (this.alive) continue;
                if (this.appConnectionClosed) {
                    if (debug.debugIt(64)) {
                        debug.debug(-142394261359015L, (Object)"dequeue", (Object)"appConnectionClosed=true", null);
                    }
                    MessageImpl messageImpl = null;
                    return messageImpl;
                }
                throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)218068710, (Object[])new Object[]{this.eConnectionClosed}), this.eConnectionClosed);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedException(ExceptionBuilder.buildReasonString((int)1613710283, (Object[])new Object[]{interruptedException}));
            }
            finally {
                this.blockedThread = null;
            }
        }
        MessageImpl messageImpl = this.dequeueImmediate();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeue", (Object)messageImpl);
        }
        return messageImpl;
    }

    synchronized MessageImpl dequeueNoWait() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueNoWait");
        }
        MessageImpl messageImpl = null;
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            messageImpl = this.dequeueImmediate();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueNoWait", (Object)messageImpl);
        }
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized MessageImpl dequeueWait(long l) throws InterruptedException, JMSWrappedException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueWait", (Object)new Long(l));
        }
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            MessageImpl messageImpl = this.dequeueImmediate();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"dequeueWait", (Object)messageImpl);
            }
            return messageImpl;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        while (l3 > l2) {
            if (!this.alive) {
                throw new InterruptedException(ExceptionBuilder.buildReasonString((int)-1683405580, null));
            }
            this.blockedThread = Thread.currentThread();
            try {
                this.wait(l3 - l2);
            }
            finally {
                this.blockedThread = null;
            }
            if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
                MessageImpl messageImpl = this.dequeueImmediate();
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"dequeueWait", (Object)messageImpl);
                }
                return messageImpl;
            }
            l2 = System.currentTimeMillis();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueWait", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized MessageImpl dequeueImmediate() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueImmediate");
        }
        MessageImpl messageImpl = null;
        if (!this.priorityQueue.isEmpty()) {
            messageImpl = (MessageImpl)this.priorityQueue.dequeue();
        } else if (!this.normalQueue.isEmpty()) {
            messageImpl = (MessageImpl)this.normalQueue.dequeue();
        }
        if (messageImpl == null) {
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"dequeueImmediate: result==null");
            }
            Assert.failure();
        }
        --this.messageCount;
        Assert.condition((this.messageCount >= 0 ? 1 : 0) != 0);
        if (this.enableFlowControl) {
            int n = this.maxMessageCount - this.messageCount;
            ConnectionImpl.FreeSpaceHeap freeSpaceHeap = this.fsh;
            synchronized (freeSpaceHeap) {
                long l = this.hdl.priority;
                if (this.hdl == this.fsh.minNode()) {
                    this.fsh.changePriority(n - (int)this.hdl.priority, this.hdl);
                    if (this.fsh.minPriority() > l) {
                        try {
                            this.conn.advanceRecvWindow((int)this.fsh.minPriority());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (debug.debugIt(2)) {
                            debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)((Object)((Object)this.conn) + ":freeSpace=" + n + ",oldprio=" + l + ",advancedRecvWindow to " + this.fsh.minPriority()));
                        }
                    } else if (debug.debugIt(2)) {
                        debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)((Object)((Object)this.conn) + ":freeSpace=" + n + ",oldprio=" + l + ",recvwindow not advanced:" + this.fsh.minPriority()));
                    }
                } else if (debug.debugIt(2)) {
                    debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)((Object)((Object)this.conn) + ":freeSpace=" + n + ",priority not changed"));
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueImmediate", (Object)messageImpl);
        }
        return messageImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveTo(MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"moveTo", (Object)messageQueue);
        }
        MessageQueue messageQueue2 = messageQueue;
        synchronized (messageQueue2) {
            while (!this.priorityQueue.isEmpty()) {
                messageQueue.priorityQueue.enqueue(this.priorityQueue.dequeue());
                ++messageQueue.messageCount;
                --this.messageCount;
            }
            while (!this.normalQueue.isEmpty()) {
                messageQueue.normalQueue.enqueue(this.normalQueue.dequeue());
                ++messageQueue.messageCount;
                --this.messageCount;
            }
            messageQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"moveTo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveMessagesFor(MessageConsumerImpl messageConsumerImpl, MessageQueue messageQueue) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"moveMessageFor", (Object)messageConsumerImpl, (Object)messageQueue);
        }
        MessageQueue messageQueue2 = new MessageQueue(0);
        MessageQueue messageQueue3 = messageQueue;
        synchronized (messageQueue3) {
            MessageImpl messageImpl;
            while (!this.priorityQueue.isEmpty()) {
                messageImpl = (MessageImpl)this.priorityQueue.dequeue();
                --this.messageCount;
                if (messageImpl.isFor(messageConsumerImpl)) {
                    messageQueue.priorityQueue.enqueue((Object)messageImpl);
                    ++messageQueue.messageCount;
                    continue;
                }
                messageQueue2.enqueue(messageImpl);
            }
            while (!this.normalQueue.isEmpty()) {
                messageImpl = (MessageImpl)this.normalQueue.dequeue();
                --this.messageCount;
                if (messageImpl.isFor(messageConsumerImpl)) {
                    messageQueue.normalQueue.enqueue((Object)messageImpl);
                    ++messageQueue.messageCount;
                    continue;
                }
                messageQueue2.enqueue(messageImpl);
            }
            messageQueue2.moveTo(this);
            messageQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"moveMessagesFor");
        }
    }

    synchronized void close(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)exception, (Object)new Boolean(bl));
        }
        this.alive = false;
        if (this.blockedThread != null) {
            this.appConnectionClosed = bl;
            this.eConnectionClosed = exception;
            this.blockedThread = null;
            this.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    synchronized void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.stopped = true;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
    }

    synchronized void start() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.stopped = false;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
    }
}

