/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.client.Message;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.BytesMessageImpl;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MapMessageImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.ObjectMessageImpl;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.StreamMessageImpl;
import com.ibm.mq.jms.TemporaryTopicImpl;
import com.ibm.mq.jms.TextMessageImpl;
import com.ibm.mq.jms.TopicPublisherImpl;
import com.ibm.mq.jms.TopicSessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageProducerImpl
implements MessageProducer,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MessageProducerImpl.java, disthub, j600, j600-201-061220 1.23.1.1 05/05/25 15:43:37";
    private static final DebugObject debug = new DebugObject("MessageProducerImpl");
    private boolean active = true;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    protected int deliveryMode = 1;
    protected int priority = 4;
    protected long timeToLive = 0L;
    private SessionImpl parentSession;
    protected MQTopic topic;

    public MessageProducerImpl(SessionImpl sessionImpl) throws JMSNotActiveException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageProducerImpl", (Object)sessionImpl);
        }
        this.parentSession = sessionImpl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageProducerImpl");
        }
    }

    MessageProducerImpl(Destination destination, SessionImpl sessionImpl) throws JMSNotActiveException, InvalidDestinationException {
        this(sessionImpl);
        if (Trace.isOn) {
            Trace.entry(this, "MessageProducerImpl");
        }
        if (destination != null) {
            if (!(destination instanceof MQTopic)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                    Trace.exit(this, "MessageProducerImpl");
                }
                throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{destination.getClass().toString()}));
            }
            this.topic = (MQTopic)destination;
            if (this.topic.containsWildcard()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Not an MQTopic - InvalidDestinationException");
                    Trace.exit(this, "MessageProducerImpl");
                }
                throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{this.topic}));
            }
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDisableMessageID", (Object)new Boolean(bl));
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        this.disableMessageID = bl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDisableMessageID");
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDisableMessageID");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDisableMessageID", (Object)new Boolean(this.disableMessageID));
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDisableMessageTimestamp", (Object)new Boolean(bl));
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        this.disableMessageTimestamp = bl;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDisableMessageTimestamp");
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDisableMessageTimestamp");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDisableMessageTimestamp", (Object)new Boolean(this.disableMessageTimestamp));
        }
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int n) throws JMSInvalidParameterException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDeliveryMode", (Object)new Integer(n));
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        MessageImpl.validateDeliveryMode(n);
        this.deliveryMode = n;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDeliveryMode");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDeliveryMode");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDeliveryMode", (Object)new Integer(this.deliveryMode));
        }
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setPriority", (Object)new Integer(n));
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        MessageImpl.validatePriority(n);
        this.priority = n;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setPriority");
        }
    }

    public int getPriority() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getPriority");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setTimeToLive", (Object)new Long(l));
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (l < 0L) {
            String string = "MQJMS1006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSInvalidParameterException(string2);
        }
        if (l > 0L) {
            String string = "MQJMS6402";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        this.timeToLive = l;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTimeToLive");
        }
    }

    public void setTimeToLive(int n) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setTimeToLive", (Object)new Long(n));
        }
        this.setTimeToLive((long)n);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTimeToLive");
        }
    }

    public long getTimeToLive() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTimeToLive");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTimeToLive", (Object)new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"close");
            }
            return;
        }
        this.active = false;
        this.parentSession = null;
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
    }

    SessionImpl getSession() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getSession");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getSession", (Object)this.parentSession);
        }
        return this.parentSession;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        return !this.active;
    }

    public void send(javax.jms.Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "send");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.trace(this, "this.topic == null - JMSNotSupportedException");
                Trace.exit(this, "send");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "send");
        }
    }

    public void send(javax.jms.Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "send");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.entry(this, "send");
                Trace.trace(this, "this.topic == null - JMSNotSupportedException");
                Trace.exit(this, "send");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSNotSupportedException(string2);
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS6402";
            String string3 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string3, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(this.topic, messageImpl, n, n2, l);
    }

    private MessageImpl createGryphonDomesticMessage(javax.jms.Message message) throws JMSException {
        Object object;
        if (message instanceof MessageImpl) {
            return (MessageImpl)message;
        }
        MessageImpl messageImpl = null;
        SessionImpl sessionImpl = this.getSession();
        Class<?> clazz = message.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getName().equals("javax.jms.ByteMessage")) {
                messageImpl = (BytesMessageImpl)sessionImpl.createBytesMessage();
                object = new byte[256];
                int n = -1;
                while ((n = ((BytesMessage)message).readBytes((byte[])object)) == ((byte[])object).length) {
                    ((BytesMessage)messageImpl).writeBytes((byte[])object);
                }
                if (n == -1) break;
                ((BytesMessage)messageImpl).writeBytes((byte[])object, 0, n);
                break;
            }
            if (classArray[i].getName().equals("javax.jms.StreamMessage")) {
                messageImpl = (StreamMessageImpl)sessionImpl.createStreamMessage();
                try {
                    while (true) {
                        ((StreamMessage)messageImpl).writeObject(((StreamMessage)message).readObject());
                    }
                }
                catch (MessageEOFException messageEOFException) {
                    break;
                }
            }
            if (classArray[i].getName().equals("javax.jms.TextMessage")) {
                messageImpl = (TextMessageImpl)sessionImpl.createTextMessage();
                ((TextMessage)messageImpl).setText(((TextMessage)message).getText());
                break;
            }
            if (classArray[i].getName().equals("javax.jms.ObjectMessage")) {
                messageImpl = (ObjectMessageImpl)sessionImpl.createObjectMessage();
                ((ObjectMessage)messageImpl).setObject(((ObjectMessage)message).getObject());
                break;
            }
            if (!classArray[i].getName().equals("javax.jms.MapMessage")) continue;
            messageImpl = (MapMessageImpl)sessionImpl.createMapMessage();
            object = ((MapMessage)messageImpl).getMapNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                ((MapMessage)messageImpl).setObject(string, ((MapMessage)message).getObject(string));
            }
            break;
        }
        if (messageImpl == null) {
            messageImpl = new MessageImpl();
        }
        messageImpl.setJMSCorrelationID(message.getJMSCorrelationID());
        messageImpl.setJMSPriority(message.getJMSPriority());
        messageImpl.setJMSExpiration(message.getJMSExpiration());
        messageImpl.setJMSType(message.getJMSType());
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            messageImpl.setObjectProperty((String)object, message.getObjectProperty((String)object));
        }
        return messageImpl;
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (destination == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null, JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string2);
        }
        if (!(destination instanceof MQTopic)) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "Not an MQ Topic");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{destination.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)destination;
        if (mQTopic.containsWildcard()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "InvalidDestinationException");
                Trace.exit(this, "publish");
            }
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{destination}));
        }
        this.send(mQTopic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, javax.jms.Message message, int n, int n2, long l) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publish");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (destination != null && destination instanceof TemporaryTopicImpl && ((TemporaryTopicImpl)destination).isDeleted()) {
            String string = "MQJMS3019";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string2, string);
        }
        if (destination == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publish");
                Trace.trace(this, "topic == null JMSParameterIsNullException");
                Trace.exit(this, "publish");
            }
            String string = "MQJMS4124";
            String string3 = ConfigEnvironment.getErrorMessage(string, "Topic");
            throw new JMSParameterIsNullException(string3);
        }
        if (!(destination instanceof MQTopic)) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{destination.getClass().toString()}));
        }
        MQTopic mQTopic = (MQTopic)destination;
        if (mQTopic.containsWildcard()) {
            throw new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{destination}));
        }
        MessageImpl.validateDeliveryMode(n);
        MessageImpl.validatePriority(n2);
        if (l > 0L) {
            String string = "MQJMS6402";
            String string4 = ConfigEnvironment.getErrorMessage(string);
            throw new JMSException(string4, string);
        }
        if (l != -1L && l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
            throw jMSException;
        }
        MessageImpl messageImpl = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(mQTopic, messageImpl, n, n2, l);
    }

    protected void publishInternal(MQTopic mQTopic, MessageImpl messageImpl, int n, int n2, long l) throws JMSException {
        int n3;
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "publishInternal");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        if (messageImpl == null) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "message == null MessageFormatException");
                Trace.exit(this, "publishInternal");
            }
            String string = "MQJMS4124";
            String string2 = ConfigEnvironment.getErrorMessage(string, "Message");
            throw new MessageFormatException(string2, string);
        }
        if (messageImpl instanceof BytesMessageImpl) {
            ((BytesMessageImpl)messageImpl).prepareMessage();
        }
        messageImpl.setTopic(mQTopic);
        long l2 = mQTopic.getExpiry();
        if (l2 == -2L) {
            if (l == -1L) {
                messageImpl.setJMSExpiration(this.getTimeToLive());
            } else {
                messageImpl.setJMSExpiration(l);
            }
        } else {
            if (l2 > 0L) {
                String string = "MQJMS6403";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                throw new JMSException(string3, string);
            }
            messageImpl.setJMSExpiration(l2);
        }
        int n4 = mQTopic.getPriority();
        if (n4 == -2) {
            if (n2 == -1) {
                messageImpl.setPriority(this.getPriority());
            } else {
                messageImpl.setPriority(n2);
            }
        } else if (n4 == -1) {
            messageImpl.setJMSPriority(4);
        } else {
            messageImpl.setJMSPriority(n4);
        }
        int n5 = mQTopic.getPersistence();
        if (n5 == -2) {
            if (n == -1) {
                messageImpl.setJMSDeliveryMode(this.getDeliveryMode());
            } else {
                messageImpl.setJMSDeliveryMode(n);
            }
        } else {
            MessageImpl.validateDeliveryMode(n5);
            messageImpl.setJMSDeliveryMode(n5);
        }
        Integer n6 = (Integer)messageImpl.getObjectProperty("JMS_IBM_Encoding");
        if (n6 == null) {
            n3 = mQTopic.getEncoding();
            messageImpl.setIntProperty("JMS_IBM_Encoding", n3);
            messageImpl.setJMSEncoding(n3);
        } else {
            n3 = n6;
        }
        if (messageImpl.getStringProperty("JMS_IBM_Character_Set") == null) {
            int n7 = mQTopic.getCCSID();
            String string = MQJMSMessage.getCharacterSetString(n7, n3);
            messageImpl.setStringProperty("JMS_IBM_Character_Set", string);
            messageImpl.setJMSCharset(string);
        }
        if (!this.getDisableMessageTimestamp()) {
            messageImpl.setJMSTimestamp(System.currentTimeMillis());
        } else {
            messageImpl.resetJMSTimestamp();
        }
        try {
            if (messageImpl instanceof BytesMessageImpl) {
                ((BytesMessageImpl)messageImpl).reset();
            }
            if (messageImpl instanceof StreamMessageImpl) {
                ((StreamMessageImpl)messageImpl).reset();
            }
            this.getSession().getConnection().send((Message)messageImpl);
            messageImpl.messageId = null;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.entry(this, "publishInternal");
                Trace.trace(this, "IOException - " + iOException + ".");
                Trace.exit(this, "publishInternal");
            }
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)800870265, (Object[])new Object[]{iOException}), iOException);
        }
    }

    public void closeTP() throws JMSException {
        TopicSessionImpl topicSessionImpl;
        if (this.isClosed()) {
            return;
        }
        if (this.topic != null && this.topic instanceof TemporaryTopicImpl) {
            ((TemporaryTopicImpl)this.topic).decUse();
        }
        if ((topicSessionImpl = (TopicSessionImpl)this.getSession()) != null) {
            topicSessionImpl.closed((TopicPublisherImpl)this);
        }
        this.topic = null;
        this.close();
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public Destination getDestination() throws JMSException {
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.trace(this, "this.isClosed() IllegalStateException");
                Trace.exit(this, "send");
            }
            throw new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
        }
        return this.topic;
    }
}

