/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQXAConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;

public class MQXAConnectionFactory
extends MQConnectionFactory
implements XAConnectionFactory {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXAConnectionFactory.java, jms, j600, j600-202-070608 1.15.1.4 07/02/07 14:00:19";
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXAConnectionFactoryFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference = new Reference((class$com$ibm$mq$jms$MQXAConnectionFactory == null ? (class$com$ibm$mq$jms$MQXAConnectionFactory = MQXAConnectionFactory.class$("com.ibm.mq.jms.MQXAConnectionFactory")) : class$com$ibm$mq$jms$MQXAConnectionFactory).getName(), (class$com$ibm$mq$jms$MQXAConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQXAConnectionFactoryFactory = MQXAConnectionFactory.class$("com.ibm.mq.jms.MQXAConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQXAConnectionFactoryFactory).getName(), null);
            super.populateReference(reference);
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        try {
            Object var4_3 = null;
            if (Trace.isOn) {
                Trace.entry(this, "createXAConnection");
                Trace.trace(this, "userName=" + string);
                if (string2 != null) {
                    Trace.trace(this, "password is not-null");
                    Trace.trace(this, "password length=" + string2.length());
                } else {
                    Trace.trace(this, "password is null");
                }
            }
            if (2 == this.getTransportType()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
                throw jMSException;
            }
            if (MQEnvironment.runningInWS() && string != null && string.length() > 12) {
                if (Trace.isOn) {
                    Trace.trace(this, "Running in Websphere with userName longer than 12 chars");
                    Trace.trace(this, "UserName is " + string);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1092", string);
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            MQXAConnection mQXAConnection = new MQXAConnection(this, string, string2);
            return mQXAConnection;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            MQXAConnection mQXAConnection;
            if (Trace.isOn) {
                Trace.entry(this, "createXAConnection");
            }
            if (2 == this.getTransportType()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
                throw jMSException;
            }
            MQXAConnection mQXAConnection2 = mQXAConnection = new MQXAConnection(this);
            return mQXAConnection2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public void setTransportType(int n) throws JMSException {
        if (n == 2 | n == 4) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
            throw jMSException;
        }
        super.setTransportType(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQXAConnectionFactory) {
                MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)object;
                bl = this.equalsComparison(object);
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equals");
            }
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        return n ^= 0x4200000;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

