/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.TopicConnectionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQTopicConnectionFactory
extends MQConnectionFactory
implements TopicConnectionFactory,
Referenceable,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQTopicConnectionFactory.java, jms, j600, j600-202-070608 1.112.1.8 07/05/21 16:34:42";
    static final long serialVersionUID = 4166164173764320001L;
    private static final int defaultCCSID = 819;
    private static final String defaultHostName = "localhost";
    private static final String defaultQueueManager = "";
    public static final String KEY_BROKER_CONTROL_QUEUE = "BCON";
    public static final String KEY_BROKER_PUB_QUEUE = "BPUB";
    public static final String KEY_BROKER_SUB_QUEUE = "BSUB";
    public static final String KEY_BROKER_CCSUB_QUEUE = "CCSUB";
    public static final String KEY_BROKER_QUEUE_MANAGER = "BQM";
    public static final String KEY_BROKER_VERSION = "BVER";
    public static final String KEY_MESSAGE_SELECTION = "MSEL";
    public static final String KEY_PUB_ACK_INTERVAL = "PAI";
    public static final String KEY_STATUS_REFRESH_INTERVAL = "SRI";
    public static final String KEY_SUBSCRIPTION_STORE = "SUBST";
    public static final String KEY_CLEANUP_LEVEL = "CL";
    public static final String KEY_CLEANUP_INTERVAL = "CLINT";
    public static final String KEY_CLONE_SUPPORT = "CLS";
    public static final String KEY_SPARSE_SUBS = "SSUBS";
    public static final String KEY_MULTICAST = "MCAST";
    public static final String KEY_PROXY_HOSTNAME = "PHOST";
    public static final String KEY_PROXY_PORT = "PPORT";
    public static final String KEY_DIRECTAUTH = "DAUTH";
    public static final String KEY_MAXBUFFERSIZE = "MBSZ";
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory;

    public TopicConnection createTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopicConnection");
        }
        TopicConnection topicConnection = null;
        int n = this.getTransportType();
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                topicConnection = this.createMQTopicConnection();
                break;
            }
            case 2: 
            case 4: {
                topicConnection = this.createDirectTopicConnection();
                break;
            }
            default: {
                topicConnection = this.createMQTopicConnection();
            }
        }
        if (n == 2 || n == 4) {
            ((TopicConnectionImpl)topicConnection).mapNameStyle = this.mapNameStyle;
        } else {
            ((MQConnection)topicConnection).mapNameStyle = this.mapNameStyle;
        }
        if (Trace.isOn) {
            Trace.exit(this, "createTopicConnection");
        }
        return topicConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopicConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password is not-null");
                Trace.trace(this, "password length=" + string2.length());
            } else {
                Trace.trace(this, "password is null");
            }
        }
        if (MQEnvironment.runningInWS() && string != null && string.length() > 12) {
            if (Trace.isOn) {
                Trace.trace(this, "Running in Websphere with userName longer than 12 chars");
                Trace.trace(this, "UserName is " + string);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1092", string);
            throw jMSException;
        }
        TopicConnection topicConnection = null;
        int n = this.getTransportType();
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                topicConnection = this.createMQTopicConnection(string, string2);
                break;
            }
            case 2: 
            case 4: {
                topicConnection = this.createDirectTopicConnection(string, string2);
                break;
            }
            default: {
                topicConnection = this.createMQTopicConnection(string, string2);
            }
        }
        if (n == 2 || n == 4) {
            ((TopicConnectionImpl)topicConnection).mapNameStyle = this.mapNameStyle;
        } else {
            ((MQConnection)topicConnection).mapNameStyle = this.mapNameStyle;
        }
        if (Trace.isOn) {
            Trace.exit(this, "createTopicConnection");
        }
        return topicConnection;
    }

    private TopicConnection createMQTopicConnection() throws JMSException {
        return this.createMQTopicConnection(null, null);
    }

    private TopicConnection createMQTopicConnection(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createMQTopicConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password is not-null");
                Trace.trace(this, "password length=" + string2.length());
            } else {
                Trace.trace(this, "password is null");
            }
        }
        int n = this.getTransportType();
        if (this.brokerVersion != 1 && this.messageSelection == 1) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3036");
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "createMQTopicConnection");
            }
            throw jMSException;
        }
        if (n == 0) {
            MQTopicConnection mQTopicConnection = string == null ? new MQTopicConnection(this) : new MQTopicConnection(this, string, string2);
            mQTopicConnection.mapNameStyle = this.mapNameStyle;
            if (Trace.isOn) {
                Trace.exit(this, "createMQTopicConnection");
            }
            return mQTopicConnection;
        }
        if (string == null) {
            string = System.getProperty("user.name");
        }
        if (Trace.isOn) {
            Trace.trace(this, "connecting as user: " + string);
        }
        MQTopicConnection mQTopicConnection = new MQTopicConnection(this, string, string2);
        mQTopicConnection.mapNameStyle = this.mapNameStyle;
        if (Trace.isOn) {
            Trace.exit(this, "createMQTopicConnection");
        }
        return mQTopicConnection;
    }

    private TopicConnection createDirectTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDirectTopicConnection");
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("user.name");
                }
                catch (AccessControlException accessControlException) {
                    return "anonymous";
                }
            }
        });
        TopicConnection topicConnection = this.createDirectTopicConnection(string, null);
        ((TopicConnectionImpl)topicConnection).mapNameStyle = this.mapNameStyle;
        if (Trace.isOn) {
            Trace.exit(this, "createDirectTopicConnection");
        }
        return topicConnection;
    }

    private TopicConnection createDirectTopicConnection(String string, String string2) throws JMSException {
        TopicConnectionImpl topicConnectionImpl;
        if (Trace.isOn) {
            Trace.entry(this, "createDirectMQTopicConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password is not-null");
                Trace.trace(this, "password length=" + string2.length());
            } else {
                Trace.trace(this, "password is null");
            }
        }
        if (string == null || string.equals(defaultQueueManager)) {
            String string3 = ConfigEnvironment.getErrorMessage("MQJMS4124", "userName");
            throw new JMSParameterIsNullException(string3);
        }
        SessionConfig sessionConfig = new SessionConfig();
        String string4 = "tcp";
        if (this.directAuth == 0) {
            sessionConfig.AUTH_PROTOCOLS = "PM";
        } else if (this.directAuth == 1) {
            sessionConfig.AUTH_PROTOCOLS = "SR";
            sessionConfig.SSL_CIPHER_SUITES = "SSL_RSA_WITH_RC4_128_SHA";
            if (Trace.isOn && this.getSSLCipherSuite() != null) {
                Trace.trace(this, "WARNING: User specified ciphersuite " + this.getSSLCipherSuite() + " ignored for DIRECTAUTH");
            }
            SessionConfig.CLIENT_SECURITY_IMPL = "com.ibm.mq.jms.SxaSecurityImpl";
            sessionConfig.SSL_CLASS = "com.ibm.mq.jms.JsseImpl";
            sessionConfig.SSL_PEER_NAME = this.getSSLPeerName();
            sessionConfig.SSL_CERT_STORES = this.getSSLCertStores();
            sessionConfig.SSL_SOCKET_FACTORY = this.getSSLSocketFactory();
        }
        sessionConfig.MULTICAST_ENABLED = true;
        String string5 = this.getLocalAddress();
        if (string5 != null && !string5.equals(defaultQueueManager)) {
            if (string5.indexOf(40) != -1) {
                Trace.trace(this, "Port specified on localAddr parameter (" + string5 + ") on a DH connect - failing connect");
                throw ConfigEnvironment.newException("MQJMS1105");
            }
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = string5;
        } else {
            sessionConfig.MULTICAST_MULTICAST_INTERFACE = "none";
        }
        if (this.proxyHostName != null && !this.proxyHostName.equals(defaultQueueManager)) {
            sessionConfig.HTTP_PROXY = this.proxyHostName;
            sessionConfig.HTTP_PROXY_PORT = this.proxyPort;
            string4 = "connect-via-proxy";
        } else if (this.getTransportType() == 4) {
            string4 = "http";
        }
        sessionConfig.MAX_MESSAGE_QUEUE_SIZE = this.maxBufferSize;
        String string6 = this.getHostName();
        int n = this.getPort();
        SessionConfig.noMoreChanges = true;
        if (Trace.isOn) {
            Trace.trace(this, "DH: directSocketType = " + string4);
            Trace.trace(this, "DH: AUTH_PROTOCOLS = " + sessionConfig.AUTH_PROTOCOLS);
            Trace.trace(this, "DH: SSL_PEER_NAME = " + sessionConfig.SSL_PEER_NAME);
            Trace.trace(this, "DH: MCAST_INTERFACE = " + sessionConfig.MULTICAST_MULTICAST_INTERFACE);
            Trace.trace(this, "DH: HTTP_PROXY = " + sessionConfig.HTTP_PROXY);
            Trace.trace(this, "DH: HTTP_PROXY_PORT = " + sessionConfig.HTTP_PROXY_PORT);
            Trace.trace(this, "DH: MAX_MESSAGE_QUEUE_SIZE = " + sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        }
        try {
            switch (this.getTransportType()) {
                case 4: {
                    topicConnectionImpl = new TopicConnectionImpl(this, string4, string6, n, string, string2, sessionConfig);
                    break;
                }
                default: {
                    topicConnectionImpl = this.proxyHostName != null ? new TopicConnectionImpl(this, string4, string6, n, string, string2, sessionConfig) : new TopicConnectionImpl(this, string4, string6, n, string, string2, sessionConfig);
                }
            }
            String string7 = this.getClientID();
            if (string7 != null && string7.length() > 0) {
                topicConnectionImpl.setClientID(string7);
            }
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1923708604, (Object[])new Object[]{iOException}), iOException);
        }
        topicConnectionImpl.mapNameStyle = this.mapNameStyle;
        if (Trace.isOn) {
            Trace.exit(this, "createDirectTopicConnection");
        }
        return topicConnectionImpl;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference((class$com$ibm$mq$jms$MQTopicConnectionFactory == null ? (class$com$ibm$mq$jms$MQTopicConnectionFactory = MQTopicConnectionFactory.class$("com.ibm.mq.jms.MQTopicConnectionFactory")) : class$com$ibm$mq$jms$MQTopicConnectionFactory).getName(), (class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory = MQTopicConnectionFactory.class$("com.ibm.mq.jms.MQTopicConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory).getName(), null);
        this.populateReference(reference);
        return reference;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "equals");
        }
        if (object == null) {
            bl = false;
        } else if (this == object) {
            bl = true;
        } else if (object instanceof MQTopicConnectionFactory) {
            MQTopicConnectionFactory mQTopicConnectionFactory = (MQTopicConnectionFactory)object;
            bl = super.equalsCommon(object) && MQTopicConnectionFactory.twoStringsEqual(this.brokerControlQueue, mQTopicConnectionFactory.brokerControlQueue) && MQTopicConnectionFactory.twoStringsEqual(this.brokerPubQueue, mQTopicConnectionFactory.brokerPubQueue) && MQTopicConnectionFactory.twoStringsEqual(this.brokerQueueManager, mQTopicConnectionFactory.brokerQueueManager) && MQTopicConnectionFactory.twoStringsEqual(this.brokerSubQueue, mQTopicConnectionFactory.brokerSubQueue) && MQTopicConnectionFactory.twoStringsEqual(this.brokerCCSubQueue, mQTopicConnectionFactory.brokerCCSubQueue) && MQTopicConnectionFactory.twoStringsEqual(this.proxyHostName, mQTopicConnectionFactory.proxyHostName) && this.proxyPort == mQTopicConnectionFactory.proxyPort && this.multicast == mQTopicConnectionFactory.multicast && this.directAuth == mQTopicConnectionFactory.directAuth && this.maxBufferSize == mQTopicConnectionFactory.maxBufferSize && this.pubAckInterval == mQTopicConnectionFactory.pubAckInterval && this.statusRefreshInterval == mQTopicConnectionFactory.statusRefreshInterval && this.messageSelection == mQTopicConnectionFactory.messageSelection && this.brokerVersion == mQTopicConnectionFactory.brokerVersion && this.subscriptionStore == mQTopicConnectionFactory.subscriptionStore && this.cleanupLevel == mQTopicConnectionFactory.cleanupLevel && this.cleanupInterval == mQTopicConnectionFactory.cleanupInterval && this.sparseSubscriptions == mQTopicConnectionFactory.sparseSubscriptions;
        } else {
            bl = false;
        }
        if (Trace.isOn) {
            Trace.trace(this, "equals - result is " + bl);
            Trace.exit(this, "equals");
        }
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode() ^ this.brokerVersion;
        if (this.brokerControlQueue != null) {
            n ^= this.brokerControlQueue.hashCode();
        }
        if (this.brokerPubQueue != null) {
            n ^= this.brokerPubQueue.hashCode();
        }
        if (this.brokerQueueManager != null) {
            n ^= this.brokerQueueManager.hashCode();
        }
        if (this.brokerSubQueue != null) {
            n ^= this.brokerSubQueue.hashCode();
        }
        if (this.brokerCCSubQueue != null) {
            n ^= this.brokerCCSubQueue.hashCode();
        }
        if (this.proxyHostName != null) {
            n ^= this.proxyHostName.hashCode();
        }
        n ^= this.messageSelection;
        n ^= this.pubAckInterval << 3;
        n ^= this.statusRefreshInterval;
        n ^= this.subscriptionStore;
        n ^= this.cleanupLevel;
        n ^= (int)this.cleanupInterval;
        n ^= this.cloneSupport;
        n ^= this.proxyPort;
        n ^= this.multicast << 2;
        n ^= this.directAuth << 4;
        n ^= this.maxBufferSize;
        if (this.sparseSubscriptions) {
            n ^= 0x20000;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateReference(Reference reference) throws OperationNotSupportedException {
        String string = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "populateReference");
            }
            super.updateReference(reference);
            string = this.getBrokerControlQueue();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CONTROL_QUEUE, string));
            }
            if ((string = this.getBrokerPubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_PUB_QUEUE, string));
            }
            if ((string = this.getBrokerSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_SUB_QUEUE, string));
            }
            if ((string = this.getBrokerCCSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CCSUB_QUEUE, string));
            }
            if ((string = this.getBrokerQueueManager()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_QUEUE_MANAGER, string));
            }
            if ((string = this.getProxyHostName()) != null) {
                reference.add(new StringRefAddr(KEY_PROXY_HOSTNAME, string));
            }
            reference.add(new StringRefAddr(KEY_BROKER_VERSION, String.valueOf(this.getBrokerVersion())));
            reference.add(new StringRefAddr(KEY_MESSAGE_SELECTION, String.valueOf(this.getMessageSelection())));
            reference.add(new StringRefAddr(KEY_PUB_ACK_INTERVAL, String.valueOf(this.getPubAckInterval())));
            reference.add(new StringRefAddr(KEY_STATUS_REFRESH_INTERVAL, String.valueOf(this.getStatusRefreshInterval())));
            reference.add(new StringRefAddr(KEY_SUBSCRIPTION_STORE, String.valueOf(this.getSubscriptionStore())));
            reference.add(new StringRefAddr(KEY_CLEANUP_LEVEL, String.valueOf(this.getCleanupLevel())));
            reference.add(new StringRefAddr(KEY_CLEANUP_INTERVAL, String.valueOf(this.getCleanupInterval())));
            reference.add(new StringRefAddr(KEY_CLONE_SUPPORT, String.valueOf(this.getCloneSupport())));
            reference.add(new StringRefAddr(KEY_SPARSE_SUBS, String.valueOf(this.sparseSubscriptions)));
            reference.add(new StringRefAddr(KEY_MULTICAST, String.valueOf(this.getMulticast())));
            reference.add(new StringRefAddr(KEY_PROXY_PORT, String.valueOf(this.getProxyPort())));
            reference.add(new StringRefAddr(KEY_DIRECTAUTH, String.valueOf(this.getDirectAuth())));
            reference.add(new StringRefAddr(KEY_MAXBUFFERSIZE, String.valueOf(this.getMaxBufferSize())));
            reference.add(new StringRefAddr("RCVISOL", String.valueOf(this.getReceiveIsolation())));
            reference.add(new StringRefAddr("PROCDUR", String.valueOf(this.getProcessDuration())));
            reference.add(new StringRefAddr("NOTIFY", String.valueOf(this.getOutcomeNotification())));
            reference.add(new StringRefAddr("OPTPUB", String.valueOf(this.getOptimisticPublication())));
            if (Trace.isOn) {
                Trace.trace(this, "ref=" + reference);
            }
        }
        catch (JMSException jMSException) {
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "populateReference");
            }
        }
    }

    void setFromReference(Reference reference) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFromReference");
                Trace.trace(this, "ref=" + reference);
            }
            super.setCommonFromReference(reference);
            RefAddr refAddr = reference.get(KEY_BROKER_CONTROL_QUEUE);
            if (refAddr != null) {
                this.setBrokerControlQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_PUB_QUEUE)) != null) {
                this.setBrokerPubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_SUB_QUEUE)) != null) {
                this.setBrokerSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_CCSUB_QUEUE)) != null) {
                this.setBrokerCCSubQueue((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_QUEUE_MANAGER)) != null) {
                String string = (String)refAddr.getContent();
                if (string == null) {
                    string = defaultQueueManager;
                }
                this.setBrokerQueueManager(string);
            }
            if ((refAddr = reference.get(KEY_PROXY_HOSTNAME)) != null) {
                this.setProxyHostName((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_BROKER_VERSION)) != null) {
                this.setBrokerVersion(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_MESSAGE_SELECTION)) != null) {
                this.setMessageSelection(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_PUB_ACK_INTERVAL)) != null) {
                this.setPubAckInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_STATUS_REFRESH_INTERVAL)) != null) {
                this.setStatusRefreshInterval(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_SUBSCRIPTION_STORE)) != null) {
                this.setSubscriptionStore(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLEANUP_LEVEL)) != null) {
                this.setCleanupLevel(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLEANUP_INTERVAL)) != null) {
                this.setCleanupInterval(Long.parseLong((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_CLONE_SUPPORT)) != null) {
                this.setCloneSupport(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_SPARSE_SUBS)) != null) {
                this.sparseSubscriptions = Boolean.valueOf((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_MULTICAST)) != null) {
                this.setMulticast(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_PROXY_PORT)) != null) {
                this.setProxyPort(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_DIRECTAUTH)) != null) {
                this.setDirectAuth(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get(KEY_MAXBUFFERSIZE)) != null) {
                this.setMaxBufferSize(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("RCVISOL")) != null) {
                this.setReceiveIsolation(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("PROCDUR")) != null) {
                this.setProcessDuration(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("NOTIFY")) != null) {
                this.setOutcomeNotification(Boolean.valueOf((String)refAddr.getContent()));
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromReference");
            }
        }
    }

    public String getTemporaryModel() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getMessageRetention() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getTempQPrefix() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setTempQPrefix(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setMessageRetention(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setTemporaryModel(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConnection");
            }
            TopicConnection topicConnection = this.createTopicConnection();
            return topicConnection;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(String string, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConnection");
                Trace.trace(this, "userName=" + string);
                if (string2 != null) {
                    Trace.trace(this, "password is not-null");
                    Trace.trace(this, "password length=" + string2.length());
                } else {
                    Trace.trace(this, "password is null");
                }
            }
            TopicConnection topicConnection = this.createTopicConnection(string, string2);
            return topicConnection;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnection");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.mq.jms.services.ConfigEnvironment");
                        return clazz;
                    }
                    catch (AccessControlException accessControlException) {
                        System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + accessControlException);
                        return null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + classNotFoundException);
                        return null;
                    }
                }
            });
            if (clazz != null) {
                clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: couldn't load ConfigEnvironment class. Exception: " + exception);
        }
    }
}

