/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.matching.selector.MatchParser;
import com.ibm.disthub2.impl.matching.selector.Resolver;
import com.ibm.disthub2.impl.matching.selector.Selector;
import com.ibm.disthub2.impl.matching.selector.Transformer;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.JMSResolver;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;

abstract class MQSubscription {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/MQSubscription.java, jms, j600, j600-201-061220 1.28.1.1 05/05/25 15:23:02";
    private MQSubscriptionEngine subscriptionEngine;
    private boolean durable;
    private boolean sharedQueue;
    private String qmgrName;
    private String clientId;
    private String subName;
    private String topic;
    private MQTopic mqTopic;
    private String selector;
    private String filter = null;
    private boolean noLocal;
    private String queueName;
    private byte[] correlationId;
    private MQSession session;
    private MQQueue subscriberQueue;
    private boolean closed = false;

    public MQSubscription(MQSubscriptionEngine mQSubscriptionEngine) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor(MQSubscriptionEngine)");
            Trace.trace(this, sccsid);
        }
        this.subscriptionEngine = mQSubscriptionEngine;
        Trace.exit(this, "constructor(MQSubscriptionEngine)");
    }

    public MQSubscription(MQSubscriptionEngine mQSubscriptionEngine, MQSession mQSession, boolean bl, boolean bl2, String string, String string2, String string3, MQTopic mQTopic, String string4, boolean bl3, String string5, MQQueue mQQueue, byte[] byArray) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor(11 params)");
            Trace.trace(this, sccsid);
        }
        this.subscriptionEngine = mQSubscriptionEngine;
        this.session = mQSession;
        this.durable = bl;
        this.sharedQueue = bl2;
        this.qmgrName = string;
        this.clientId = string2;
        this.subName = string3;
        this.topic = mQTopic != null ? mQTopic.getBaseTopicName() : null;
        this.mqTopic = mQTopic;
        this.noLocal = bl3;
        this.queueName = string5;
        this.subscriberQueue = mQQueue;
        if (byArray == null) {
            this.correlationId = null;
        } else {
            this.correlationId = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.correlationId, 0, byArray.length);
        }
        this.setSelector(string4);
        if (Trace.isOn) {
            Trace.exit(this, "constructor(11 params)");
        }
    }

    public final MQSubscriptionEngine getMQSubscriptionEngine() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQSubscriptionEngine");
            Trace.exit(this, "getMQSubscriptionEngine");
        }
        return this.subscriptionEngine;
    }

    public final MQSession getMQSession() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQTopicSession");
            Trace.exit(this, "getMQTopicSession");
        }
        return this.session;
    }

    public void setDurable(boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "setDurable");
        }
        this.durable = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setDurable");
        }
    }

    public boolean isDurable() {
        if (Trace.isOn) {
            Trace.entry(this, "isDurable");
            Trace.exit(this, "isDurable");
        }
        return this.durable;
    }

    public void setSharedQueue(boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "setSharedQueue");
        }
        this.sharedQueue = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setSharedQueue");
        }
    }

    public boolean isSharedQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "isSharedQueue");
            Trace.exit(this, "isSharedQueue");
        }
        return this.sharedQueue;
    }

    public void setQmgrName(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setQmgrName");
        }
        this.qmgrName = string;
        if (Trace.isOn) {
            Trace.exit(this, "setQmgrName");
        }
    }

    public String getQmgrName() {
        if (Trace.isOn) {
            Trace.entry(this, "getQmgrName");
            Trace.exit(this, "getQmgrName");
        }
        return this.qmgrName;
    }

    public final MQTopic getMQTopic() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQTopic");
            Trace.exit(this, "getMQTopic");
        }
        return this.mqTopic;
    }

    public void setMQTopic(MQTopic mQTopic) {
        if (Trace.isOn) {
            Trace.entry(this, "setMQTopic");
        }
        this.mqTopic = mQTopic;
        if (this.topic == null && Trace.isOn) {
            Trace.trace(this, "New MQTopic set in subscription. TopicName still null");
        }
        if (Trace.isOn) {
            Trace.exit(this, "setMQTopic");
        }
    }

    public void setClientId(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setQmgrName");
        }
        this.clientId = string;
        if (Trace.isOn) {
            Trace.exit(this, "setQmgrName");
        }
    }

    public String getClientId() {
        if (Trace.isOn) {
            Trace.entry(this, "getClientId");
            Trace.exit(this, "getClientId");
        }
        return this.clientId;
    }

    public void setSubName(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSubName");
        }
        this.subName = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSubName");
        }
    }

    public String getSubName() {
        if (Trace.isOn) {
            Trace.entry(this, "getSubName");
            Trace.exit(this, "getSubName");
        }
        return this.subName;
    }

    public void setTopic(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setTopic", "topic='" + string + "'");
        }
        this.topic = string;
        if (Trace.isOn) {
            Trace.exit(this, "setTopic");
        }
    }

    public String getTopic() {
        if (Trace.isOn) {
            Trace.entry(this, "getTopic");
            Trace.exit(this, "getTopic");
        }
        return this.topic;
    }

    public void setSelector(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSelector");
        }
        this.selector = string;
        if (string == null) {
            this.filter = null;
        } else {
            int n;
            try {
                n = this.session.getConnectionMsgSelection();
            }
            catch (JMSException jMSException) {
                throw new RuntimeException(ConfigEnvironment.getErrorMessage("MQJMS1016"));
            }
            if (n == 1) {
                if ((String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.mq.jms.pubsub.rawBrokerSelectors");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                }) != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Passing unparsed raw selector to the broker - BYPASSING VALIDATION");
                    }
                    this.filter = string;
                } else {
                    try {
                        JMSResolver jMSResolver = new JMSResolver();
                        MatchParser matchParser = MatchParser.prime(null, (String)string, (boolean)true);
                        Selector selector = matchParser.getSelector();
                        if (selector.type == 2) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Reverting to Client side filtering due to SyntaxException");
                            }
                            this.filter = null;
                        } else {
                            Selector selector2 = Transformer.resolve((Selector)selector, (Resolver)jMSResolver, null);
                            this.filter = selector2.toString();
                            if (Trace.isOn) {
                                Trace.trace(this, "Filter is " + this.filter);
                            }
                            if (this.filter != null && this.filter.indexOf("Root.MQRFH2.jms.Dlv") >= 0) {
                                int n2 = 0;
                                n2 = this.filter.indexOf("'NON_PERSISTENT'");
                                if (n2 > 0) {
                                    this.filter = this.filter.substring(0, n2) + 1 + this.filter.substring(n2 + 16);
                                } else {
                                    n2 = this.filter.indexOf("'PERSISTENT'");
                                    if (n2 > 0) {
                                        this.filter = this.filter.substring(0, n2) + 2 + this.filter.substring(n2 + 12);
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Adjusted filter is " + this.filter);
                                }
                            }
                            if (this.filter.indexOf("JMS_ERROR") >= 0) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Reverting to Client side filtering");
                                }
                                this.filter = null;
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Reverting to Client side filtering due to SyntaxException");
                        }
                        this.filter = null;
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setSelector");
        }
    }

    public String getSelector() {
        if (Trace.isOn) {
            Trace.entry(this, "getSelector");
            Trace.exit(this, "getSelector");
        }
        return this.selector;
    }

    public String getFilter() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getFilter");
            Trace.exit(this, "getFilter");
        }
        return this.filter;
    }

    public void setNoLocal(boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "setNoLocal");
        }
        this.noLocal = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setNoLocal");
        }
    }

    public boolean getNoLocal() {
        if (Trace.isOn) {
            Trace.entry(this, "getNoLocal");
            Trace.exit(this, "getNoLocal");
        }
        return this.noLocal;
    }

    public void setQueueName(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setQueueName");
        }
        this.queueName = string;
        if (Trace.isOn) {
            Trace.exit(this, "setQueueName");
        }
    }

    public String getQueueName() {
        if (Trace.isOn) {
            Trace.entry(this, "getQueueName");
            Trace.exit(this, "getQueueName");
        }
        return this.queueName;
    }

    public void setSubscriberQueue(MQQueue mQQueue) {
        if (Trace.isOn) {
            Trace.entry(this, "setSubscriberQueue");
        }
        this.subscriberQueue = mQQueue;
        if (Trace.isOn) {
            Trace.trace(this, "set subscriber queue to '" + mQQueue + "'");
            Trace.exit(this, "setSubscriberQueue");
        }
    }

    public MQQueue getSubscriberQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "getSubscriberQueue");
        }
        if (this.subscriberQueue == null) {
            if (Trace.isOn) {
                Trace.trace(this, "subscriber queue is null!");
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "getSubscriberQueue");
        }
        return this.subscriberQueue;
    }

    public void setCorrelationId(byte[] byArray) {
        if (Trace.isOn) {
            Trace.entry(this, "setCorrelationId");
        }
        if (byArray == null) {
            this.correlationId = null;
        } else {
            this.correlationId = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.correlationId, 0, byArray.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "setCorrelationId");
        }
    }

    public byte[] getCorrelationId() {
        if (Trace.isOn) {
            Trace.entry(this, "getCorrelationId");
            Trace.exit(this, "getCorrelationId");
        }
        return this.correlationId;
    }

    public boolean isClosed() {
        if (Trace.isOn) {
            Trace.entry(this, "isClosed");
            Trace.exit(this, "isClosed");
        }
        return this.closed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                if (this.isDurable()) {
                    this.subscriptionEngine.closeDurableSubscription(this);
                }
                this.subscriptionEngine.closeSubscription(this);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var3_1 = null;
            this.closed = true;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.closed = true;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public String toString() {
        return new String("\nsubName       : " + this.subName + "\nTopic         : " + this.topic + "\nQueue Manager : " + this.qmgrName + "\nQueue Name    : " + this.queueName + "\nSelector      : " + this.selector + "\nnoLocal?      : " + (this.noLocal ? "Y" : "N") + "\nClient Id     : " + this.clientId + "\ncorrelationId : " + Utils.bytesToHex(this.correlationId) + "\nsharedQ?      : " + (this.sharedQueue ? "Y" : "N") + "\ndurable?      : " + (this.durable ? "Y" : "N"));
    }
}

