/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionRolledBackException;

public class MQQueueServices {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueServices.java, jms, j600, j600-201-061220 1.12.1.1 05/05/25 15:52:56";
    static final int MQCA_QSG_NAME = 2040;
    private String deadLetterQueue;
    private String resolvedQmName;
    private String resolvedQSGName;
    private String dynamicQName;
    private MQQueueManager tempQqm;
    private MQQueueManager initialQm;
    private String qmName;
    private int tmpQOpenOptions;
    private String temporaryModelQ;
    private String tempQPrefix;
    private int messageRetention;
    protected byte[] sessionName;
    private MQQueue cbInputQueue;
    private String lastQueueName;
    private String messageQueueName;

    MQQueueServices() {
        this.deadLetterQueue = null;
        this.resolvedQmName = null;
        this.resolvedQSGName = null;
        this.dynamicQName = null;
        this.tempQqm = null;
        this.initialQm = null;
        this.qmName = null;
        this.tmpQOpenOptions = 32;
        this.cbInputQueue = null;
        this.lastQueueName = null;
    }

    MQQueueServices(MQConnection mQConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        block8: {
            int n2;
            this.deadLetterQueue = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.dynamicQName = null;
            this.tempQqm = null;
            this.initialQm = null;
            this.qmName = null;
            this.tmpQOpenOptions = 32;
            this.cbInputQueue = null;
            this.lastQueueName = null;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            try {
                n2 = 2015;
                this.resolvedQmName = mQQueueManager.getAttributeString(n2, 48).trim();
            }
            catch (Exception exception) {
                this.resolvedQmName = mQQueueManager.name;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Resolving QSGName");
            }
            try {
                n2 = 2040;
                this.resolvedQSGName = mQQueueManager.getAttributeString(n2, 4).trim();
            }
            catch (Exception exception) {
                this.resolvedQSGName = null;
                if (!Trace.isOn) break block8;
                Trace.trace(this, "Setting QSGName to null");
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, "QSGName set to " + this.resolvedQSGName);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    void checkQueueAccess(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        if (mQQueue instanceof MQTemporaryQueue) {
            ((MQTemporaryQueue)mQQueue).checkAccess(mQSession.connection);
        } else {
            mQQueue.checkAccess(mQSession.connection);
        }
    }

    MQQueue getQueueForBrowse(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        try {
            MQQueue mQQueue2;
            if (Trace.isOn) {
                Trace.entry(this, "getQueueForBrowse");
            }
            if (mQSession.isClosed()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                throw jMSException;
            }
            if (mQQueue == null) {
                String string = "MQJMS0003";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                throw invalidDestinationException;
            }
            if (mQSession.getQM() == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            String string = mQQueue.getBaseQueueManagerName();
            if (!(string == null || string.equals("") || string.equals(this.resolvedQmName) || string.equals(this.resolvedQSGName))) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                throw jMSException;
            }
            String string3 = mQQueue.getBaseQueueName();
            int n = 8;
            if (mQQueue.getFailIfQuiesce() == 1) {
                n |= 0x2000;
            }
            try {
                mQQueue2 = mQSession.getQM().accessQueue(string3, n);
            }
            catch (MQException mQException) {
                JMSException jMSException = this.getQueueOpenException(mQException, string3);
                throw jMSException;
            }
            MQQueue mQQueue3 = mQQueue2;
            return mQQueue3;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueueForBrowse");
            }
        }
    }

    MQQueue getOutputQueue(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        try {
            MQQueue mQQueue2 = null;
            if (Trace.isOn) {
                Trace.entry(this, "getOutputQueue");
            }
            if (mQSession.isClosed()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                throw jMSException;
            }
            if (mQQueue == null) {
                String string = "MQJMS0003";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                throw invalidDestinationException;
            }
            String string = mQQueue.getBaseQueueName();
            String string3 = mQQueue.getBaseQueueManagerName();
            int n = 16;
            if (mQQueue.getFailIfQuiesce() == 1) {
                n |= 0x2000;
            }
            try {
                mQQueue2 = mQSession.getQM().accessQueue(string, n, string3, this.dynamicQName, "");
            }
            catch (MQException mQException) {
                JMSException jMSException = this.getQueueOpenException(mQException, string);
                throw jMSException;
            }
            string = mQQueue2;
            return string;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getOutputQueue");
            }
        }
    }

    protected JMSException getQueueOpenException(MQException mQException, String string) {
        Object object;
        String string2 = "MQJMS2008";
        String string3 = ConfigEnvironment.getErrorMessage(string2, string);
        switch (mQException.reasonCode) {
            case 2001: 
            case 2011: 
            case 2043: 
            case 2052: 
            case 2057: 
            case 2058: 
            case 2082: 
            case 2085: 
            case 2086: 
            case 2087: 
            case 2091: 
            case 2092: 
            case 2152: 
            case 2153: 
            case 2184: 
            case 2194: 
            case 2196: 
            case 2197: 
            case 2198: 
            case 2199: {
                object = new InvalidDestinationException(string3, string2);
                break;
            }
            case 2017: 
            case 2071: 
            case 2102: 
            case 2192: {
                object = new ResourceAllocationException(string3, string2);
                break;
            }
            case 2035: {
                object = new JMSSecurityException(string3, string2);
                break;
            }
            default: {
                object = new JMSException(string3, string2);
            }
        }
        object.setLinkedException((Exception)((Object)mQException));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitQ(MQSession mQSession, MQSession mQSession2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "commit");
            }
            if (mQSession.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!mQSession.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (mQSession2.getQM() == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                Object object = mQSession.getTransactionLock();
                synchronized (object) {
                    mQSession2.getQM().commit();
                }
            }
            catch (MQException mQException) {
                JMSException jMSException;
                int n = mQException.completionCode;
                int n2 = mQException.reasonCode;
                if (n == 1 && n2 == 2003) {
                    String string = "MQJMS0011";
                    String string4 = ConfigEnvironment.getErrorMessage(string);
                    jMSException = new TransactionRolledBackException(string4, string);
                } else {
                    jMSException = ConfigEnvironment.newException("MQJMS2009");
                }
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commit");
            }
        }
    }

    protected Message consume(MessageReference messageReference, MQSession mQSession) throws JMSException {
        Object object;
        int n = 0;
        try {
            Object object2;
            MQGetMessageOptions mQGetMessageOptions;
            MQMessageReference mQMessageReference;
            block44: {
                if (Trace.isOn) {
                    Trace.entry(this, "consume", "mr = \n" + (messageReference instanceof MQMessageReference ? messageReference.toString() : "not an MQMessageReference"));
                }
                if (!(messageReference instanceof MQMessageReference)) {
                    JMSException jMSException = new JMSException("MQJMS1096");
                    if (Trace.isOn) {
                        Trace.trace(this, "MessageReference is not an MQMessageReference, throwing exception");
                        Trace.exception(this, "consume", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
                mQMessageReference = (MQMessageReference)messageReference;
                object = mQMessageReference.getReferenceQueue();
                if (Trace.isOn) {
                    Trace.trace(this, "Got referenceQueueName = '" + (String)object + "'");
                }
                this.messageQueueName = object;
                mQGetMessageOptions = new MQGetMessageOptions(true);
                MQQueueManager mQQueueManager = mQSession.getQM();
                if (Trace.isOn) {
                    Trace.trace(this, "Setting up GMO");
                }
                mQGetMessageOptions.matchOptions = 1;
                mQGetMessageOptions.options = 8256;
                if (Trace.isOn) {
                    Trace.trace(this, "useSPIP = " + mQSession.useSPIP);
                }
                mQGetMessageOptions.options = mQSession.useSPIP ? (mQGetMessageOptions.options |= 0x1000) : (mQGetMessageOptions.options |= 2);
                try {
                    if (this.cbInputQueue == null || this.messageQueueName != this.lastQueueName) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue " + this.messageQueueName + " to be opened");
                        }
                        if (this.cbInputQueue != null) {
                            this.cbInputQueue.close();
                        }
                        this.cbInputQueue = mQQueueManager.accessQueue(this.messageQueueName, 8194);
                        this.lastQueueName = this.messageQueueName;
                        if (Trace.isOn) {
                            Trace.trace(this, "Got access to " + this.cbInputQueue.name);
                        }
                    } else if (Trace.isOn) {
                        Trace.trace(this, "using cached queue for " + this.messageQueueName);
                    }
                }
                catch (MQException mQException) {
                    if (mQException.completionCode != 2) break block44;
                    if (Trace.isOn) {
                        Trace.exception(this, "run", (Throwable)mQException);
                    }
                    Message message = null;
                    if (Trace.isOn) {
                        Trace.exit(this, "consume");
                    }
                    return message;
                }
            }
            JMSMessage jMSMessage = null;
            if (this.cbInputQueue != null) {
                if (mQMessageReference.getDataQuantity() == 2) {
                    jMSMessage = mQMessageReference.getJMSMessage();
                    object2 = mQMessageReference.getMQJMSMessage();
                    if (object2 == null) {
                        object2 = new MQJMSMessage();
                        object2.setMessageId(mQMessageReference.getMessageId());
                        object2.setCorrelationId(mQMessageReference.getCorrelId());
                    }
                    if ((n = this.cbInputQueue.getMsg2NoExc((MQMsg2)object2, mQGetMessageOptions, 0)) == 2079) {
                        n = 0;
                    }
                    if (n != 0) {
                        jMSMessage = null;
                    }
                } else {
                    object2 = mQMessageReference.getMQJMSMessage();
                    if (object2 == null) {
                        object2 = new MQJMSMessage();
                        object2.setMessageId(mQMessageReference.getMessageId());
                        object2.setCorrelationId(mQMessageReference.getCorrelId());
                    }
                    mQGetMessageOptions.options &= 0xFFFFFFBF;
                    n = this.cbInputQueue.getMsg2NoExc((MQMsg2)object2, mQGetMessageOptions);
                    if (n == 0) {
                        jMSMessage = object2.createJMSMessage(mQSession);
                    }
                }
                if (n == 2033) {
                    if (Trace.isOn) {
                        Trace.trace(this, "NO_MSG_AVAILABLE - message removed from queue");
                    }
                    object2 = null;
                    return object2;
                }
                if (n != 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Got MQRC " + n);
                    }
                    throw new MQException(2, n, (Object)this);
                }
            } else {
                Message message = null;
                return message;
            }
            if (!mQSession.getTransacted()) {
                jMSMessage._setSession(mQSession);
            }
            object2 = jMSMessage;
            return object2;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "caught MQException", (Throwable)mQException);
            }
            object = ConfigEnvironment.newException("MQJMS2002");
            object.setLinkedException((Exception)((Object)mQException));
            throw object;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exception(this, "caught IOException - badly formatted message", (Throwable)iOException);
            }
            object = ConfigEnvironment.newException("MQJMS0006");
            object.setLinkedException((Exception)iOException);
            throw object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "consume");
            }
        }
    }

    protected Message consume(byte[] byArray, MQSession mQSession) throws JMSException {
        try {
            Message message;
            if (Trace.isOn) {
                Trace.entry(this, "consume(byte[])");
                Trace.trace(this, "recreating MessageReference");
            }
            MessageReference messageReference = this.recreateMessageReference(byArray, mQSession);
            if (Trace.isOn) {
                Trace.trace(this, "Recreated MessageReference. Trying to consume message");
            }
            Message message2 = message = this.consume(messageReference, mQSession);
            return message2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "consume(byte[])");
            }
        }
    }

    /*
     * Loose catch block
     */
    void redirectMessage(String string, MQMsg2 mQMsg2, boolean bl, MQSession mQSession) throws JMSException {
        block27: {
            Object var5_5 = null;
            try {
                block26: {
                    if (Trace.isOn) {
                        Trace.entry(this, "redirectMessage");
                        Trace.trace(this, "sending message to '" + string + "'");
                    }
                    if (mQSession.isClosed()) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                        throw jMSException;
                    }
                    if (mQSession.getQM() == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                        throw jMSException;
                    }
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    if (bl) {
                        mQPutMessageOptions.options |= 2;
                        mQPutMessageOptions.options &= 0xFFFFFFFB;
                    } else {
                        mQPutMessageOptions.options |= 4;
                        mQPutMessageOptions.options &= 0xFFFFFFFD;
                    }
                    mQSession.getQM().putMsg2(string, "", mQMsg2, mQPutMessageOptions);
                    Object var9_11 = null;
                    if (!Trace.isOn) break block26;
                    Trace.trace(this, "redirectMessage finally block");
                }
                if (var5_5 == null) break block27;
                try {
                    var5_5.close();
                }
                catch (MQException mQException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS2000"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    if (Trace.isOn) {
                        Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                    }
                    break block27;
                }
                {
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    block29: {
                        Object var9_12 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "redirectMessage finally block");
                        }
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                            }
                            catch (MQException mQException) {
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS2000"));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                if (!Trace.isOn) break block29;
                                Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                            }
                        }
                    }
                    throw throwable;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing exception: " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "redirectMessage");
                }
            }
        }
    }

    protected MessageReference recreateMessageReference(byte[] byArray, MQSession mQSession) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recreateMessageReference");
                Trace.trace(this, "flattened MessageReference follows");
                Trace.dataTrace(1, this, byArray);
            }
            MQMessageReference mQMessageReference = new MQMessageReference(mQSession, byArray);
            return mQMessageReference;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recreateMessageReference");
            }
        }
    }
}

