/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQQueue
extends MQDestination
implements Queue,
Referenceable,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/MQQueue.java, jms, j600, j600-201-061220 1.61.1.2 05/08/02 14:47:29";
    private String baseQueueName = null;
    private String baseQueueManagerName = "";
    private String cachedQueueName = null;
    private String cachedNVs = null;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueue;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueFactory;

    public MQQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQQueue(String string) throws JMSException {
        String string2 = "MQJMS0003";
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(queueName)");
            }
            if (string == null || string.trim().length() == 0) {
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if ((string = string.trim()).startsWith("queue://")) {
                if (string.length() <= 8) {
                    String string4 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string2);
                    throw invalidDestinationException;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(5, this, "no URI found, setting queue name to: " + string);
                }
                this.setBaseQueueName(string);
                return;
            }
            int n = string.indexOf(47, 8);
            if (n == -1) {
                String string5 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string2);
                throw invalidDestinationException;
            }
            if (n == 8) {
                this.setBaseQueueManagerName("");
            } else {
                this.setBaseQueueManagerName(string.substring(8, n));
            }
            if (string.length() > n + 1) {
                int n2 = string.indexOf(63, n + 1);
                if (n2 != -1) {
                    this.setBaseQueueName(string.substring(n + 1, n2));
                    String string6 = string.substring(n2 + 1);
                    if (Trace.isOn) {
                        Trace.trace(5, this, "name,value pairs found in URI: " + string6);
                    }
                    Properties properties = this.getPropertiesFromURI(string6);
                    this.setFromProperties(properties);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(5, this, "no name,value pairs found in URI");
                    }
                    this.setBaseQueueName(string.substring(n + 1));
                }
            } else {
                String string7 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string2);
                throw invalidDestinationException;
            }
            if (Trace.isOn) {
                Trace.trace(5, this, "orig = " + string + ", qmName = " + this.baseQueueManagerName + ", qName = " + this.baseQueueName);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(queueName)");
            }
        }
    }

    public MQQueue(String string, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(qmgr, q)");
            }
            this.setBaseQueueName(string2);
            this.setBaseQueueManagerName(string);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor(qmgr, q)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueName() {
        try {
            CharSequence charSequence;
            if (Trace.isOn) {
                Trace.entry(this, "getQueueName");
            }
            if (this.cachedQueueName == null || this.cachedDNVs == null || this.cachedUNVs == null || this.cachedNVs == null) {
                String string;
                charSequence = new StringBuffer(40).append("queue://");
                if (this.baseQueueManagerName != null) {
                    ((StringBuffer)charSequence).append(this.baseQueueManagerName);
                }
                ((StringBuffer)charSequence).append("/");
                if (this.baseQueueName != null) {
                    ((StringBuffer)charSequence).append(this.baseQueueName);
                }
                if ((string = this.getNVs()).length() > 0) {
                    ((StringBuffer)charSequence).append('?').append(string);
                }
                this.cachedQueueName = ((StringBuffer)charSequence).toString();
            }
            charSequence = this.cachedQueueName;
            return charSequence;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueueName");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "toString");
            }
            String string = this.getQueueName();
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "toString");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            String string = null;
            Reference reference = new Reference((class$com$ibm$mq$jms$MQQueue == null ? (class$com$ibm$mq$jms$MQQueue = MQQueue.class$("com.ibm.mq.jms.MQQueue")) : class$com$ibm$mq$jms$MQQueue).getName(), (class$com$ibm$mq$jms$MQQueueFactory == null ? (class$com$ibm$mq$jms$MQQueueFactory = MQQueue.class$("com.ibm.mq.jms.MQQueueFactory")) : class$com$ibm$mq$jms$MQQueueFactory).getName(), null);
            reference.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
            string = this.getDescription();
            if (string != null) {
                reference.add(new StringRefAddr("DESC", string));
            }
            reference.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
            reference.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
            reference.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
            reference.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
            reference.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
            reference.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
            reference.add(new StringRefAddr("FIQ", String.valueOf(this.getFailIfQuiesce())));
            string = this.getBaseQueueName();
            if (string != null) {
                reference.add(new StringRefAddr("QU", string));
            }
            if ((string = this.getBaseQueueManagerName()) != null) {
                reference.add(new StringRefAddr("QMGR", string));
            }
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    public void setBaseQueueName(String string) throws JMSException {
        String string2 = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBaseQueueName");
            }
            if (string != null) {
                string2 = string.trim();
            }
            if (string2 == null || string2.length() > 48 || string2.length() == 0) {
                String string3 = string2;
                if (string3 == null) {
                    string3 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseQueueName", string3);
                throw jMSException;
            }
            this.baseQueueName = string2;
            this.cachedQueueName = null;
        }
        catch (JMSException jMSException) {
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Trace.exit(this, "setBaseQueueName");
        }
    }

    public void setBaseQueueManagerName(String string) throws JMSException {
        String string2 = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBaseQueueManagerName");
            }
            if (string != null) {
                string2 = string.trim();
            }
            if (string2 == null || string2.length() > 48) {
                String string3 = string2;
                if (string3 == null) {
                    string3 = "<null>";
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseQueueManagerName", string3);
                throw jMSException;
            }
            this.baseQueueManagerName = string2;
            this.cachedQueueName = null;
        }
        catch (JMSException jMSException) {
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            Trace.exit(this, "setBaseQueueManagerName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseQueueName() {
        try {
            Trace.entry(this, "getBaseQueueName");
            String string = this.baseQueueName;
            return string;
        }
        finally {
            Trace.exit(this, "getBaseQueueName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseQueueManagerName() {
        try {
            Trace.entry(this, "getBaseQueueManagerName");
            String string = this.baseQueueManagerName;
            return string;
        }
        finally {
            Trace.exit(this, "getBaseQueueManagerName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQQueue) {
                MQQueue mQQueue = (MQQueue)object;
                bl = super.equals(object) && this.twoStringsEqual(this.baseQueueName, mQQueue.baseQueueName) && this.twoStringsEqual(this.baseQueueManagerName, mQQueue.baseQueueManagerName);
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equals");
            }
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.baseQueueName != null) {
            n ^= this.baseQueueName.hashCode();
        }
        if (this.baseQueueManagerName != null) {
            n ^= this.baseQueueManagerName.hashCode();
        }
        return n;
    }

    void setFromProperties(Properties properties) throws JMSException {
        super.setFromProperties(properties);
    }

    String getNVs() {
        if (this.cachedDNVs == null || this.cachedUNVs == null || this.cachedNVs == null) {
            String string = super.getDestNVs();
            String string2 = super.getUserNVs();
            this.cachedNVs = string2.length() == 0 ? string : (string.length() == 0 ? string2 : string + '&' + string2);
        }
        return this.cachedNVs;
    }

    void checkAccess(MQConnection mQConnection) throws JMSException {
    }

    void setFromReference(Reference reference) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFromReference");
            }
            super.setCommonFromReference(reference);
            RefAddr refAddr = reference.get("QMGR");
            if (refAddr != null) {
                String string = (String)refAddr.getContent();
                if (string == null) {
                    string = "";
                }
                this.setBaseQueueManagerName(string);
            }
            if ((refAddr = reference.get("QU")) != null) {
                this.setBaseQueueName((String)refAddr.getContent());
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromReference");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

