/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Topic;

public class MQMessageProducer
implements MessageProducer {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQMessageProducer.java, jms, j600, j600-201-061220 1.66.1.4 06/08/16 15:31:43";
    static final int JMS101_DEFAULT_VAL = -1;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    protected boolean closed = false;
    private MQPutMessageOptions pmo;
    private MQConnection connection;
    private MQSession session = null;
    private boolean setForPTP = false;
    private boolean setForPubSub = false;
    private com.ibm.mq.jms.MQQueue queueSpec = null;
    private MQQueue queue = null;
    private MQJMSMessage mqMessage = new MQJMSMessage();
    private MQTopic TopicSpec = null;
    private MQQueue mqPubQ = null;
    private MQQueueManager qm = null;
    private MQJMSMessage baseMessage = new MQJMSMessage();
    private String publishQ;
    private String streamQ;
    private boolean firstMsg = true;
    private byte[] cachedRFHData = null;
    private String cachedBaseTopic = null;
    private int cachedEncoding = 0;
    private String brokerPubQMgr;

    MQMessageProducer(com.ibm.mq.jms.MQQueue mQQueue, MQQueue mQQueue2, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
            if (mQQueue != null) {
                Trace.trace(this, "dest = " + mQQueue);
            } else {
                Trace.trace(this, "null dest");
            }
        }
        this.setForPTP = true;
        this.queueSpec = mQQueue;
        this.queue = mQQueue2;
        this.session = mQSession;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQMessageProducer(MQTopic mQTopic, MQQueue mQQueue, MQQueueManager mQQueueManager, MQConnection mQConnection, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            if (mQTopic != null) {
                Trace.trace(this, "dest = " + mQTopic);
            }
            if (mQQueue != null) {
                Trace.trace(this, mQQueue + "(" + mQQueue.name + ")");
            }
        }
        this.setForPubSub = true;
        this.TopicSpec = mQTopic;
        this.mqPubQ = mQQueue;
        this.qm = mQQueueManager;
        this.connection = mQConnection;
        this.session = mQSession;
        this.brokerPubQMgr = mQQueueManager.name;
        this.publishQ = this.connection.getBrkPubQueue();
        if (mQTopic != null && mQTopic.getBrokerPubQueue() != null && mQTopic.getBrokerPubQueue().length() != 0) {
            this.publishQ = mQTopic.getBrokerPubQueue();
        }
        this.streamQ = this.publishQ;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQMessageProducer(MQDestination mQDestination, MQQueue mQQueue, MQQueueManager mQQueueManager, MQConnection mQConnection, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            if (mQDestination != null) {
                Trace.trace(this, "dest = " + mQDestination);
            }
        }
        this.TopicSpec = null;
        this.queue = null;
        this.mqPubQ = mQQueue;
        this.qm = mQQueueManager;
        this.connection = mQConnection;
        this.session = mQSession;
        this.publishQ = this.connection.getBrkPubQueue();
        if (mQDestination != null && mQDestination instanceof MQTopic && ((MQTopic)mQDestination).getBrokerPubQueue() != null && ((MQTopic)mQDestination).getBrokerPubQueue().length() != 0) {
            this.publishQ = ((MQTopic)mQDestination).getBrokerPubQueue();
        }
        this.streamQ = this.publishQ;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void close() throws JMSException {
        try {
            block17: {
                if (Trace.isOn) {
                    Trace.entry(this, "close");
                }
                this.closed = true;
                if (this.setForPTP) {
                    this.closeQ();
                }
                if (this.setForPubSub) {
                    this.closeT();
                }
                try {
                    if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                        this.mqPubQ.close();
                    }
                    this.mqPubQ = null;
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block17;
                    Trace.trace(this, "Exception closing mqPubQ: " + mQException.getMessage() + " Reason: " + mQException.reasonCode);
                }
            }
            if (this.session != null) {
                this.session.removeProducer(this);
            } else if (Trace.isOn) {
                Trace.trace(this, "session null, can't call removeSender");
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    void closeQ() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "closeQ");
            }
            this.closed = true;
            if (this.session != null) {
                this.session.removeSender(this);
            } else if (Trace.isOn) {
                Trace.trace(this, "session null, can't call removeSender");
            }
            if (this.queue != null) {
                try {
                    this.queue.close();
                    this.queue = null;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
            }
            try {
                if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                    this.mqPubQ.close();
                }
                this.mqPubQ = null;
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Exception closing mqPubQ: " + mQException.getMessage() + " Reason: " + mQException.reasonCode);
                }
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeQ");
            }
        }
    }

    void closeT() throws JMSException {
        block14: {
            if (Trace.isOn) {
                Trace.entry(this, "closeT");
            }
            this.closed = true;
            if (this.TopicSpec != null) {
                try {
                    this.TopicSpec = null;
                    this.mqPubQ.close();
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException(exception);
                    if (Trace.isOn) {
                        Trace.trace(this, "create and thrown " + (Object)((Object)jMSException));
                        Trace.trace(this, "Linked Exception " + exception);
                        Trace.exit(this, "close");
                    }
                    this.session.connection.deliverExceptionCheck(jMSException);
                    throw jMSException;
                }
                finally {
                    this.mqPubQ = null;
                }
                this.session.removePublisher(this);
            } else {
                try {
                    if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                        this.mqPubQ.close();
                    }
                    this.mqPubQ = null;
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block14;
                    Trace.trace(this, "Exception closing mqPubQ: " + mQException.getMessage() + " Reason: " + mQException.reasonCode);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "closeT");
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDisableMessageID");
        }
        this.checkProducerOpen();
        this.disableMessageID = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setDisableMessageID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageID() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDisableMessageID");
            }
            this.checkProducerOpen();
            boolean bl = this.disableMessageID;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getDesableMessageID");
            }
        }
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDisableMessageTimestamp");
        }
        this.checkProducerOpen();
        this.disableMessageTimestamp = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setDisableMessageTimestamp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageTimestamp() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDisableMessageTimestamp");
            }
            this.checkProducerOpen();
            boolean bl = this.disableMessageTimestamp;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getDisableMessageTimestamp");
            }
        }
    }

    public void setDeliveryMode(int n) throws JMSException {
        block9: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setDeliveryMode");
                }
                this.checkProducerOpen();
                if (n == 2 || n == 1) {
                    this.deliveryMode = n;
                    break block9;
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "deliveryMode", String.valueOf(n));
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setDeliveryMode");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeliveryMode() throws JMSException {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getDeliveryMode");
                this.checkProducerOpen();
                int n = this.deliveryMode;
                return n;
            }
            finally {
                Trace.exit(this, "getDeliveryMode");
            }
        }
        this.checkProducerOpen();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPriority");
            }
            this.checkProducerOpen();
            if (n < 0 || n > 9) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n));
                throw jMSException;
            }
            this.priority = n;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPriority");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() throws JMSException {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getPriority");
                this.checkProducerOpen();
                int n = this.priority;
                return n;
            }
            finally {
                Trace.exit(this, "getPriority");
            }
        }
        this.checkProducerOpen();
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTimeToLive");
            }
            this.checkProducerOpen();
            if (l < 0L) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "timeToLive", Long.toString(l));
                throw jMSException;
            }
            this.timeToLive = l;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setTimeToLive");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToLive() throws JMSException {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getTimeToLive");
                this.checkProducerOpen();
                long l = this.timeToLive;
                return l;
            }
            finally {
                Trace.exit(this, "getTimeToLive");
            }
        }
        this.checkProducerOpen();
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "isClosed");
                boolean bl = this.closed;
                Trace.trace(this, "isClosed returning " + bl);
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                Trace.exit(this, "isClosed");
            }
        }
        return this.closed;
    }

    void checkProducerOpen() throws JMSException {
        if (Trace.isOn || this.isClosed()) {
            if (Trace.isOn) {
                Trace.entry(this, "checkProducerOpen");
            }
            if (this.isClosed()) {
                String string = "MQJMS3037";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                if (Trace.isOn) {
                    Trace.trace(this, "MessageProducer is closed. Throwing IllegalStateException.");
                }
                this.session.connection.deliverExceptionCheck((JMSException)((Object)illegalStateException));
                throw illegalStateException;
            }
            if (Trace.isOn) {
                Trace.exit(this, "checkProducerOpen");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Queue getQueueInt() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueueInt");
            }
            this.checkProducerOpen();
            com.ibm.mq.jms.MQQueue mQQueue = this.queueSpec;
            return mQQueue;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueueInt");
            }
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        try {
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "send(message, d, p, t)");
            }
            if (this.closed) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS3026");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                throw illegalStateException;
            }
            if (this.setForPubSub) {
                this.publishInt(message, n, n2, l);
            } else {
                if (this.session.isClosed()) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.queueSpec == null) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1091");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
                    throw unsupportedOperationException;
                }
                if (this.queue == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                    throw jMSException;
                }
                if (this.session.usingAsyncMode() && !this.session.callingFromOnMessage() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "can't send because session is actively using async delivery");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                this.sendInternal(this.queueSpec, this.queue, message, n, n2, l);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "send(message, d, p, t)");
            }
        }
    }

    public void send(Message message) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "send(message)");
            }
            this.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "send(message)");
            }
        }
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        block21: {
            try {
                Trace.checkForTurnTracingOn();
                if (Trace.isOn) {
                    Trace.entry(this, "send(queue, message, d,p,t)");
                }
                if (this.closed) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS3026");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                if (this.session.isClosed()) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.queueSpec != null) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1014");
                    UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
                    throw unsupportedOperationException;
                }
                if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "can't publish because session is actively using async delivery");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string = "MQJMS0003";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                    throw invalidDestinationException;
                }
                com.ibm.mq.jms.MQQueue mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                if (mQQueue == null) {
                    String string = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                    throw invalidDestinationException;
                }
                try {
                    try {
                        this.sendInternal(mQQueue, null, message, n, n2, l);
                    }
                    catch (JMSException jMSException) {
                        boolean bl = false;
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null && exception instanceof MQException) {
                            MQException mQException = (MQException)((Object)exception);
                            boolean bl2 = bl = mQException.reasonCode == 2057 && mQException.completionCode == 2;
                        }
                        if (bl) {
                            MQQueue mQQueue2 = this.session.getServicesMgr().getOutputQueue(mQQueue, this.session);
                            this.sendInternal(mQQueue, mQQueue2, message, n, n2, l);
                            mQQueue2.close();
                            break block21;
                        }
                        throw jMSException;
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "send(queue, message, d,p,t)");
                }
            }
        }
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "send(queue, message)");
        }
        this.send(queue, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "send(queue, message)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendInternal(com.ibm.mq.jms.MQQueue mQQueue, MQQueue mQQueue2, Message message, int n, int n2, long l) throws JMSException {
        try {
            long l2;
            boolean bl;
            JMSMessage jMSMessage;
            block78: {
                jMSMessage = null;
                if (Trace.isOn) {
                    Trace.entry(this, "sendInternal");
                }
                if (message == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "sendInternal given a null message");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "message", "null");
                    throw jMSException;
                }
                if (!(message instanceof JMSMessage)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "sendInternal publishing alien message of class " + message.getClass().getName());
                    }
                    jMSMessage = JMSMessage._copyFromMessage(this.session, message);
                } else {
                    jMSMessage = (JMSMessage)message;
                }
                if (mQQueue != null) {
                    if (mQQueue.getFailIfQuiesce() == 1) {
                        this.pmo.options |= 0x2000;
                        if (Trace.isOn) {
                            Trace.trace(this, "FIQ behaviour: YES");
                        }
                    } else {
                        this.pmo.options &= 0xFFFFDFFF;
                        if (Trace.isOn) {
                            Trace.trace(this, "FIQ behaviour: NO");
                        }
                    }
                }
                if (bl = this.session.getTransacted()) {
                    this.pmo.options |= 2;
                    this.pmo.options &= 0xFFFFFFFB;
                } else {
                    this.pmo.options |= 4;
                    this.pmo.options &= 0xFFFFFFFD;
                }
                l2 = System.currentTimeMillis();
                try {
                    int n3;
                    String string;
                    int n4;
                    int n5;
                    block81: {
                        block80: {
                            block77: {
                                block79: {
                                    this.mqMessage.clearMessageData();
                                    this.mqMessage.setFormat("MQHRF2  ");
                                    this.mqMessage.setEncoding(mQQueue.getEncoding());
                                    if (mQQueue2 != null) {
                                        this.mqMessage.setCharacterSet(mQQueue2._getConnectionCCSID());
                                    } else {
                                        this.mqMessage.setCharacterSet(this.session.qm._getConnectionCCSID());
                                    }
                                    jMSMessage.setJMSDestination(mQQueue);
                                    jMSMessage.setJMSTimestamp(l2);
                                    this.mqMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
                                    long l3 = mQQueue.getExpiry();
                                    if (l3 == -2L) {
                                        if (l == -1L) {
                                            jMSMessage._setTimeToLive(l2, this.getTimeToLive());
                                        } else {
                                            if (l < 0L) {
                                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "timeToLive", String.valueOf(l));
                                                throw jMSException;
                                            }
                                            jMSMessage._setTimeToLive(l2, l);
                                        }
                                    } else {
                                        jMSMessage._setTimeToLive(l2, l3);
                                    }
                                    n5 = mQQueue.getPriority();
                                    if (n5 != -2) break block79;
                                    if (n2 == -1) {
                                        jMSMessage.setJMSPriority(this.getPriority());
                                        break block77;
                                    } else if (n2 >= 0 && n2 <= 9) {
                                        jMSMessage.setJMSPriority(n2);
                                        break block77;
                                    } else {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n2));
                                        throw jMSException;
                                    }
                                }
                                if (n5 == -1) {
                                    jMSMessage.setJMSPriority(4);
                                } else {
                                    jMSMessage.setJMSPriority(n5);
                                }
                            }
                            if (mQQueue.getPersistence() == 3 && !mQQueue.isNPHighCheckDone()) {
                                if (this.queue != null) {
                                    mQQueue.setNPHighSupported(!this.session.getPersistenceFromMD() && mQQueue.getTargetClient() != 1 && this.queue.isNPMClassHigh());
                                } else {
                                    try {
                                        MQQueue mQQueue3 = this.session.qm.accessQueue(mQQueue.getBaseQueueName(), 32, mQQueue.getBaseQueueManagerName(), this.session.connection != null ? this.session.connection.temporaryModelQ : null, null);
                                        if (mQQueue3 != null) {
                                            mQQueue.setNPHighSupported(!this.session.getPersistenceFromMD() && mQQueue.getTargetClient() != 1 && mQQueue3.isNPMClassHigh());
                                        } else {
                                            mQQueue.setNPHighSupported(false);
                                        }
                                        if (mQQueue3 != null) {
                                            mQQueue3.close();
                                        }
                                    }
                                    catch (MQException mQException) {
                                        mQQueue.setNPHighSupported(false);
                                    }
                                }
                            }
                            if ((n4 = mQQueue.getPersistence()) != -2 && n4 != 3) break block80;
                            switch (n) {
                                case -1: {
                                    jMSMessage.setJMSDeliveryMode(this.getDeliveryMode());
                                    break block81;
                                }
                                case 1: 
                                case 2: {
                                    jMSMessage.setJMSDeliveryMode(n);
                                    break block81;
                                }
                                default: {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "deliveryMode", String.valueOf(n));
                                    throw jMSException;
                                }
                            }
                        }
                        if (n4 == -1) {
                            jMSMessage.setJMSDeliveryMode(-2);
                        } else {
                            jMSMessage.setJMSDeliveryMode(n4);
                        }
                    }
                    Integer n6 = (Integer)jMSMessage.getObjectProperty("JMS_IBM_Encoding");
                    if (n6 != null) {
                        this.mqMessage.setEncoding(n6);
                    }
                    if ((string = jMSMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                        n3 = mQQueue.getCCSID();
                    } else {
                        n3 = MQJMSMessage.getCCSID(string);
                        if (n3 == 0) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", string);
                            throw jMSException;
                        }
                    }
                    switch (mQQueue.getTargetClient()) {
                        case 1: {
                            this.mqMessage.write(jMSMessage, false, n3);
                            break;
                        }
                        case 0: {
                            this.mqMessage.write(jMSMessage, true, n3);
                            break;
                        }
                        default: {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS1015", String.valueOf(mQQueue.getTargetClient())));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            String string2 = "MQJMS1015";
                            String string3 = ConfigEnvironment.getErrorMessage(string2, String.valueOf(mQQueue.getTargetClient()));
                            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                            throw invalidDestinationException;
                        }
                    }
                    if (n5 == -1) {
                        if (Trace.isOn) {
                            Trace.trace(this, "sendInternal fixing MQMD for priority as qdef");
                        }
                        this.mqMessage.setPriority(-1);
                    }
                    if (n4 == -1) {
                        if (Trace.isOn) {
                            Trace.trace(this, "sendInternal fixing MQMD for persistence as qdef");
                        }
                        this.mqMessage.setPersistence(2);
                        break block78;
                    }
                    if (n4 == 3 && mQQueue.getNPHighSupported()) {
                        this.mqMessage.setPersistence(0);
                    }
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                }
                catch (Exception exception) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1016", exception.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", exception.toString());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            }
            try {
                if (mQQueue2 == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "put1 to " + mQQueue);
                    }
                    this.session.qm.putMsg2(mQQueue.getBaseQueueName(), mQQueue.getBaseQueueManagerName(), (MQMsg2)this.mqMessage, this.pmo);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "send to " + mQQueue2.name);
                    }
                    mQQueue2.putMsg2((MQMsg2)this.mqMessage, this.pmo);
                }
                if (bl) {
                    this.session.setCommitRequired(true);
                }
                this.mqMessage.setHeaderFromMQMD(message);
            }
            catch (MQException mQException) {
                JMSException jMSException;
                if (mQException.reasonCode == 2052) {
                    String string = "MQJMS3001";
                    String string4 = ConfigEnvironment.getErrorMessage(string);
                    jMSException = new InvalidDestinationException(string4, string);
                } else {
                    jMSException = ConfigEnvironment.newException("MQJMS2007");
                }
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            if (jMSMessage == message) return;
            message.setJMSDestination((Destination)mQQueue);
            message.setJMSDeliveryMode(n);
            message.setJMSTimestamp(l2);
            message.setJMSExpiration(jMSMessage.getJMSExpiration());
            return;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendInternal");
            }
        }
    }

    public void finalize() throws Throwable {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            try {
                this.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block4;
                Trace.trace(this, "calling close from finalize failed: " + (Object)((Object)jMSException));
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    Topic getTopicInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getTopicInt");
        }
        this.checkProducerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getTopicInt");
        }
        return this.TopicSpec;
    }

    protected void publishInt(Message message, int n, int n2, long l) throws JMSException {
        int n3 = -1;
        boolean bl = false;
        try {
            boolean bl2;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "publishInt(m,d,p,t)");
                Trace.trace(this, "dest = " + this.TopicSpec);
            }
            if (this.closed) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS3028");
                throw new IllegalStateException(string);
            }
            if (this.TopicSpec == null) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS1091");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
                throw unsupportedOperationException;
            }
            this.validateParms(this.TopicSpec, message, n, n2, l);
            if (this.mqPubQ == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                throw jMSException;
            }
            if (this.session.usingAsyncMode() && !this.session.callingFromOnMessage() && this.session.isStarted()) {
                if (Trace.isOn) {
                    Trace.trace(this, "can't publish because session is actively using async delivery");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                throw jMSException;
            }
            if (this.TopicSpec != null) {
                if (this.TopicSpec.getFailIfQuiesce() == 1) {
                    this.pmo.options |= 0x2000;
                    if (Trace.isOn) {
                        Trace.trace(this, "FIQ behaviour YES");
                    }
                } else {
                    this.pmo.options &= 0xFFFFDFFF;
                    if (Trace.isOn) {
                        Trace.trace(this, "FIQ behaviour NO");
                    }
                }
            }
            if (bl2 = this.session.getTransacted()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is transacted");
                }
                this.pmo.options |= 2;
                this.pmo.options &= 0xFFFFFFFB;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is NOT transacted");
                }
                this.pmo.options |= 4;
                this.pmo.options &= 0xFFFFFFFD;
            }
            this.buildBaseMessage(this.TopicSpec, message, n, n2, l);
            if (this.firstMsg && !bl2) {
                if (Trace.isOn) {
                    Trace.trace(this, "First message on this publisher");
                }
                bl = true;
            } else if (!this.firstMsg && this.session.responseInterval > 0 && this.session.getServicesMgr().requestResponse(this.session)) {
                bl = true;
            }
            if (this.baseMessage.getReport() != 0) {
                bl = false;
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "Requesting a Broker response");
                }
                n3 = this.baseMessage.getMessageType();
                this.baseMessage.setReport(3);
                this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                this.baseMessage.setReplyToQueueManagerName("");
            } else if (this.baseMessage.getReport() == 0) {
                this.baseMessage.setMessageType(8);
            }
            if (this.session.getSessionName() != null && null == message.getJMSCorrelationID()) {
                this.baseMessage.setCorrelationId(this.session.getSessionName());
            }
            try {
                if (this.session.getAcknowledgeMode() == 0 && this.session.getOptimisticPublication() && this.session.qm instanceof MQSPIQueueManager && ((MQSPIQueueManager)this.session.qm).spiSupportsInherited()) {
                    ((MQSPIQueue)this.mqPubQ).spiPut((MQMsg2)this.baseMessage, this.pmo, 32);
                } else {
                    this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                }
                if (bl2) {
                    this.session.setCommitRequired(true);
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            if (bl) {
                if (!this.firstMsg) {
                    this.session.responseRequested(System.currentTimeMillis(), this.baseMessage.getMessageId());
                }
                this.baseMessage.setMessageType(n3);
                this.baseMessage.setReport(0);
                this.baseMessage.setReplyToQueueName("");
                this.baseMessage.setReplyToQueueManagerName("");
            }
            this.baseMessage.setHeaderFromMQMD(message);
            if (this.firstMsg && bl || this.session.getServicesMgr().checkForResponse(this.session)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Checking for a Broker response");
                }
                this.checkBrokerResponse();
                if (this.firstMsg) {
                    SubscriptionHelper.checkResponse(this.baseMessage);
                }
            }
            if (this.firstMsg) {
                this.firstMsg = false;
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "publishInt(m,d,p,t)");
            }
        }
    }

    protected void publishInt(Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publishInt(m)");
        }
        this.publishInt(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "publishInt(m)");
        }
    }

    protected void publishInt(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        int n3 = -1;
        boolean bl = false;
        try {
            boolean bl2;
            Object object;
            Object object2;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "publishInt(t,m,d,p,t)");
                if (topic != null) {
                    Trace.trace(this, "topic = " + topic);
                }
            }
            if (this.closed) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS3028");
                throw new IllegalStateException(string);
            }
            if (this.TopicSpec != null) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS1014");
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException(string);
                throw unsupportedOperationException;
            }
            this.validateParms(topic, message, n, n2, l);
            if (this.mqPubQ == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                throw jMSException;
            }
            if (topic != null && topic instanceof MQTopic) {
                object2 = this.mqPubQ.name;
                String string = ((MQTopic)topic).getBrokerPubQueue();
                object = ((MQTopic)topic).getBrokerPubQueueManager();
                boolean bl3 = false;
                if (!(string == null || string.length() == 0 || string != null && ((String)object2).equals(string))) {
                    object2 = string;
                    bl3 = true;
                }
                if (!(object == null || object.length() == 0 || object != null && this.brokerPubQMgr.equals(object))) {
                    this.brokerPubQMgr = object;
                    bl3 = true;
                }
                if (bl3) {
                    try {
                        this.mqPubQ = this.qm.accessQueue((String)object2, this.mqPubQ.openOptions, this.brokerPubQMgr, null, null);
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "publish failed to access publish queue because of " + (Object)((Object)mQException));
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", object2);
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                if (Trace.isOn) {
                    Trace.trace(this, "can't publish because session is actively using async delivery");
                }
                object2 = ConfigEnvironment.newException("MQJMS1013");
                throw object2;
            }
            if (topic != null && topic instanceof MQTopic) {
                if (((MQTopic)topic).getFailIfQuiesce() == 1) {
                    this.pmo.options |= 0x2000;
                    if (Trace.isOn) {
                        Trace.trace(this, "FIQ behaviour YES");
                    }
                } else {
                    this.pmo.options &= 0xFFFFDFFF;
                    if (Trace.isOn) {
                        Trace.trace(this, "FIQ behaviour NO");
                    }
                }
            }
            if (bl2 = this.session.getTransacted()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is transacted");
                }
                this.pmo.options |= 2;
                this.pmo.options &= 0xFFFFFFFB;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is NOT transacted");
                }
                this.pmo.options |= 4;
                this.pmo.options &= 0xFFFFFFFD;
            }
            this.buildBaseMessage((MQTopic)topic, message, n, n2, l);
            if (this.firstMsg && !bl2) {
                if (Trace.isOn) {
                    Trace.trace(this, "First message on this publisher");
                }
                bl = true;
            } else if (!this.firstMsg && this.session.responseInterval > 0 && this.session.getServicesMgr().requestResponse(this.session)) {
                bl = true;
            }
            if (this.baseMessage.getReport() != 0) {
                bl = false;
            }
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "Requesting a Broker response");
                }
                n3 = this.baseMessage.getMessageType();
                this.baseMessage.setReport(3);
                this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                this.baseMessage.setReplyToQueueManagerName("");
            } else if (this.baseMessage.getReport() == 0) {
                this.baseMessage.setMessageType(8);
            }
            if (this.session.getSessionName() != null && null == message.getJMSCorrelationID()) {
                this.baseMessage.setCorrelationId(this.session.getSessionName());
            }
            try {
                if (this.session.getAcknowledgeMode() == 0 && this.session.getOptimisticPublication() && this.session.qm instanceof MQSPIQueueManager && ((MQSPIQueueManager)this.session.qm).spiSupportsInherited()) {
                    ((MQSPIQueue)this.mqPubQ).spiPut((MQMsg2)this.baseMessage, this.pmo, 32);
                } else {
                    this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                }
                if (bl2) {
                    this.session.setCommitRequired(true);
                }
            }
            catch (MQException mQException) {
                object = ConfigEnvironment.newException("MQJMS3011");
                object.setLinkedException((Exception)((Object)mQException));
                throw object;
            }
            if (bl) {
                if (!this.firstMsg) {
                    this.session.responseRequested(System.currentTimeMillis(), this.baseMessage.getMessageId());
                }
                this.baseMessage.setMessageType(n3);
                this.baseMessage.setReport(0);
                this.baseMessage.setReplyToQueueName("");
                this.baseMessage.setReplyToQueueManagerName("");
            }
            this.baseMessage.setHeaderFromMQMD(message);
            if (this.firstMsg && bl || this.session.getServicesMgr().checkForResponse(this.session)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Checking for a Broker response");
                }
                this.checkBrokerResponse();
                if (this.firstMsg) {
                    SubscriptionHelper.checkResponse(this.baseMessage);
                }
            }
            if (this.firstMsg) {
                this.firstMsg = false;
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
            this.session.connection.deliverExceptionCheck(jMSException);
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(this, "Create Exception " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
            }
            if (Trace.isOn) {
                Trace.exception(this, "publish(t,n,d,p,t)", (Throwable)jMSException);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "publishInt(t,m,d,p,t)");
            }
        }
    }

    protected void publishInt(Topic topic, Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publishInt(t,m)");
        }
        this.publishInt(topic, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "publish(t,m)");
        }
    }

    private void validateParms(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "validateParms");
            }
            if (topic == null) {
                String string = "MQJMS3006";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                throw new InvalidDestinationException(string2, string);
            }
            if (topic instanceof MQTemporaryTopic && ((MQTemporaryTopic)topic).isDeleted()) {
                String string = "MQJMS3019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                throw new InvalidDestinationException(string3, string);
            }
            if (message == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "message", "null");
                throw jMSException;
            }
            if (n != 2 && n != 1 && n != -1) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Delivery Mode", String.valueOf(n));
                throw jMSException;
            }
            if (n2 != -1 && (n2 < 0 || n2 > 9)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Priority", String.valueOf(n2));
                throw jMSException;
            }
            if (l != -1L && l < 0L) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "validateParms");
            }
        }
    }

    private void buildBaseMessage(MQTopic mQTopic, Message message, int n, int n2, long l) throws JMSException {
        try {
            int n3;
            int n4;
            long l2;
            JMSMessage jMSMessage;
            block52: {
                if (Trace.isOn) {
                    Trace.entry(this, "buildBaseMessage");
                }
                if (message instanceof JMSMessage) {
                    jMSMessage = (JMSMessage)message;
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "buildBaseMessage publishing alien message");
                    }
                    jMSMessage = JMSMessage._copyFromMessage(this.session, message);
                }
                l2 = System.currentTimeMillis();
                this.baseMessage.clearMessageData();
                this.baseMessage.setEncoding(mQTopic.getEncoding());
                this.baseMessage.setCharacterSet(this.qm._getConnectionCCSID());
                jMSMessage.setJMSDestination(mQTopic);
                jMSMessage.setJMSTimestamp(l2);
                this.baseMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
                long l3 = mQTopic.getExpiry();
                if (l3 == -2L) {
                    if (l == -1L) {
                        jMSMessage._setTimeToLive(l2, this.getTimeToLive());
                    } else {
                        jMSMessage._setTimeToLive(l2, l);
                    }
                } else {
                    jMSMessage._setTimeToLive(l2, l3);
                }
                n4 = mQTopic.getPriority();
                if (n4 == -2) {
                    if (n2 == -1) {
                        jMSMessage.setJMSPriority(this.getPriority());
                    } else {
                        jMSMessage.setJMSPriority(n2);
                    }
                } else if (n4 == -1) {
                    jMSMessage.setJMSPriority(4);
                } else {
                    jMSMessage.setJMSPriority(n4);
                }
                if (mQTopic.getPersistence() == 3 && !mQTopic.isNPHighCheckDone()) {
                    mQTopic.setNPHighSupported(!this.session.getPersistenceFromMD() && mQTopic.getTargetClient() != 1 && this.mqPubQ.isNPMClassHigh());
                }
                if ((n3 = mQTopic.getPersistence()) == -2 || n3 == 3) {
                    if (n == -1) {
                        jMSMessage.setJMSDeliveryMode(this.getDeliveryMode());
                    } else {
                        jMSMessage.setJMSDeliveryMode(n);
                    }
                } else if (n3 == -1) {
                    jMSMessage.setJMSDeliveryMode(-2);
                } else {
                    jMSMessage.setJMSDeliveryMode(n3);
                }
                String string = "";
                string = "UNIQUE_CONNECTION_ID " + this.session.getConnectionID() + " " + "MQPSCommand Publish MQPSTopic " + mQTopic.getBaseTopicName() + " MQPSPubOpts NoReg";
                try {
                    int n5;
                    String string2;
                    jMSMessage.setJMSDestination(mQTopic);
                    Integer n6 = (Integer)jMSMessage.getObjectProperty("JMS_IBM_Encoding");
                    if (n6 != null) {
                        this.baseMessage.setEncoding(n6);
                    }
                    if ((string2 = jMSMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                        n5 = mQTopic.getCCSID();
                    } else {
                        n5 = MQJMSMessage.getCCSID(string2);
                        if (n5 == 0) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", string2);
                            throw jMSException;
                        }
                    }
                    if (this.session.getConnectionBrokerVersion() == 1) {
                        jMSMessage.setPSCTopic(mQTopic.getBaseTopicName());
                        jMSMessage.setPSCConnID(this.session.getConnectionID());
                        this.baseMessage.write(jMSMessage, true, n5);
                        break block52;
                    }
                    switch (mQTopic.getTargetClient()) {
                        case 1: {
                            this.baseMessage.writeRFH(string, jMSMessage, false, n5);
                            break;
                        }
                        case 0: {
                            this.buildBaseMessageWithCachedRFHAndRFH2(string, jMSMessage, n5);
                            break;
                        }
                        default: {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS1015", String.valueOf(mQTopic.getTargetClient())));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            String string3 = "MQJMS1015";
                            String string4 = ConfigEnvironment.getErrorMessage(string3, String.valueOf(mQTopic.getTargetClient()));
                            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string3);
                            throw invalidDestinationException;
                        }
                    }
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3010");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
            }
            if (n4 == -1) {
                if (Trace.isOn) {
                    Trace.trace(this, "buildBaseMessage: MQMD priority set as QDEF");
                }
                this.baseMessage.setPriority(-1);
            }
            if (n3 == -1) {
                if (Trace.isOn) {
                    Trace.trace(this, "buildBaseMessage: MQMD persistence set as QDEF");
                }
                this.baseMessage.setPersistence(2);
            } else if (n3 == 3 && mQTopic.getNPHighSupported()) {
                this.baseMessage.setPersistence(0);
            }
            if (this.session.getConnectionBrokerVersion() == 1) {
                this.baseMessage.setFormat("MQHRF2  ");
            } else {
                this.baseMessage.setFormat("MQHRF   ");
            }
            this.baseMessage.setGroupId(MQC.MQGI_NONE);
            this.baseMessage.setMessageSequenceNumber(1);
            this.baseMessage.setMessageFlags(this.baseMessage.getMessageFlags() & 0xFFFFFFF7);
            if (jMSMessage != message) {
                message.setJMSDestination((Destination)mQTopic);
                message.setJMSDeliveryMode(n);
                message.setJMSTimestamp(l2);
                message.setJMSExpiration(jMSMessage.getJMSExpiration());
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)((Object)mQException));
            Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "buildBaseMessage");
            }
        }
    }

    private void buildBaseMessageWithCachedRFHAndRFH2(String string, JMSMessage jMSMessage, int n) throws JMSException {
        if (Trace.isOn()) {
            Trace.entry(this, "buildBaseMessageWithCachedRFHAndRFH2");
        }
        try {
            if (this.TopicSpec != null) {
                if (this.cachedRFHData == null || !this.cachedBaseTopic.equals(this.TopicSpec.getBaseTopicName()) || this.cachedEncoding != this.baseMessage.getEncoding()) {
                    this.cachedRFHData = this.baseMessage.buildCacheableRFH(string, n, this.baseMessage.getEncoding());
                    this.cachedBaseTopic = this.TopicSpec.getBaseTopicName();
                    this.cachedEncoding = this.baseMessage.getEncoding();
                }
                this.baseMessage.appendByteArray(this.cachedRFHData);
                this.baseMessage.write(jMSMessage, true, n);
            } else {
                this.baseMessage.writeRFH(string, jMSMessage, true, n);
            }
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)iOException);
            Trace.trace(this, "buildBaseMessageWithCachedRFHAndRFH2 throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + iOException);
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)((Object)mQException));
            Trace.trace(this, "buildBaseMessageWithCachedRFHAndRFH2 throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + (Object)((Object)mQException));
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "buildBaseMessageWithCachedRFHAndRFH2");
            }
        }
    }

    private void checkBrokerResponse() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "checkBrokerResponse");
            }
            this.session.getServicesMgr().getBrokerResponse(this.session, this.baseMessage, this.firstMsg);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "checkBrokerResponse");
            }
        }
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        block10: {
            try {
                if (Trace.isOn) {
                    Trace.exit(this, "send(destination, message, d,p,t)");
                }
                if (destination instanceof com.ibm.mq.jms.MQQueue) {
                    this.send((com.ibm.mq.jms.MQQueue)destination, message, n, n2, l);
                    break block10;
                }
                if (destination instanceof MQTopic) {
                    this.publishInt((MQTopic)destination, message, n, n2, l);
                    break block10;
                }
                String string = "MQJMS0003";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "send(destination, message, d,p,t)");
                }
            }
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, "send(destination, message)");
            }
            try {
                if (destination instanceof com.ibm.mq.jms.MQQueue) {
                    this.send((com.ibm.mq.jms.MQQueue)destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
                    break block10;
                }
                if (destination instanceof MQTopic) {
                    this.publishInt((MQTopic)destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
                    break block10;
                }
                String string = "MQJMS0003";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "send(destination, message)");
                }
            }
        }
    }

    public Destination getDestination() throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "getDestination");
            }
            if (this.setForPTP) {
                return this.getQueueInt();
            }
            if (this.setForPubSub) {
                return this.getTopicInt();
            }
            if (this.getQueueInt() == null || this.getTopicInt() == null) {
                return null;
            }
            if (this.getQueueInt() != null && this.getTopicInt() == null) {
                return this.getQueueInt();
            }
            if (this.getQueueInt() == null && this.getTopicInt() != null) {
                return this.getTopicInt();
            }
            String string = "MQJMS1016";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Both a Topic and Queue destination are defined for this Producer. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn()) {
                Trace.exit(this, "getDestination");
            }
            this.session.connection.deliverExceptionCheck(jMSException);
            throw jMSException;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.trace("MQMessageProducer", sccsid);
        }
    }
}

