/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.DLH;
import com.ibm.mq.jms.IntErrorException;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.RFH;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;

public class MQMessageConsumer
implements MessageConsumer {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQMessageConsumer.java, jms, j600, j600-202-070608 1.102.1.20 07/04/10 08:49:50";
    private MQMessageSelector messageSelector;
    private boolean closed;
    private boolean closing;
    private static final String CLASSNAME = "MQMessageConsumer";
    private static int CHUNKTIME;
    private static final int ACCEPTABLE_INVERVAL = 10000;
    static final int DEFAULT_MAX_ASYNC_ATTEMPTS = 5;
    private com.ibm.mq.jms.MQQueue queueSpec;
    private MQQueue queue;
    private MQGetMessageOptions gmo;
    private MQJMSMessage baseMessage;
    private int acknowledgeMode;
    private MQSession session;
    private boolean transacted;
    private MessageListener listener;
    private Hashtable nextGenSeenList;
    private Hashtable prevGenSeenList;
    private Object nullValue;
    private int maxAsyncAttempts;
    private String backoutRetryQueue;
    private int backoutThreshold;
    private String mqDLQName;
    private String baseQueueName;
    private int type;
    private boolean needsRestart;
    private long rescanTimeMillis;
    private long rescanTimeInterval;
    private long rescanTimeMillisNoted;
    private boolean specialCase;
    private static final int SYNCPOINT = 1;
    private static final int SPIP = 2;
    private static final int NO_SYNCPOINT = 3;
    private int syncPoint;
    private MQTopic topicSpec;
    private boolean noLocal;
    private boolean selectorSet;
    private boolean durable;
    private String name;
    private byte[] subscriberId;
    private byte[] statusMgrId;
    private boolean shared_queue;
    MQSubscription subscription;
    private boolean useBrowse;
    private int getOptions;
    private int browseOptions;
    private int deleteOptions;
    private int acceptOptions;
    private boolean setForPTP;
    private boolean setForPubSub;

    protected MQMessageConsumer(com.ibm.mq.jms.MQQueue mQQueue, String string, MQQueue mQQueue2, boolean bl, int n, MQSession mQSession) throws JMSException {
        block21: {
            this.messageSelector = null;
            this.closed = false;
            this.closing = false;
            this.queueSpec = null;
            this.queue = null;
            this.session = null;
            this.listener = null;
            this.nextGenSeenList = new Hashtable();
            this.prevGenSeenList = new Hashtable();
            this.nullValue = new Object();
            this.maxAsyncAttempts = 5;
            this.backoutRetryQueue = null;
            this.backoutThreshold = 20;
            this.mqDLQName = null;
            this.baseQueueName = null;
            this.type = 0;
            this.needsRestart = true;
            this.rescanTimeMillis = 0L;
            this.rescanTimeMillisNoted = 0L;
            this.syncPoint = 1;
            this.topicSpec = null;
            this.noLocal = false;
            this.selectorSet = false;
            this.name = null;
            this.subscriberId = null;
            this.statusMgrId = null;
            this.shared_queue = false;
            this.subscription = null;
            this.useBrowse = false;
            this.setForPTP = false;
            this.setForPubSub = false;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                if (mQQueue != null) {
                    Trace.trace(this, "queueSpec = " + mQQueue);
                }
                if (mQQueue2 != null) {
                    Trace.trace(this, mQQueue2 + " (" + mQQueue2.name + ")");
                }
            }
            this.setForPTP = true;
            this.queueSpec = mQQueue;
            n = mQSession.getAcknowledgeMode();
            this.baseMessage = new MQJMSMessage();
            this.gmo = new MQGetMessageOptions(true);
            this.rescanTimeInterval = mQSession.connection.getRescanInterval();
            if (mQQueue.getFailIfQuiesce() == 1) {
                this.gmo.options |= 0x2000;
                this.browseOptions |= 0x2000;
                this.acceptOptions |= 0x2000;
                this.deleteOptions |= 0x2000;
            }
            this.gmo.matchOptions = 0;
            this.specialCase = this.setMessageSelector(string, this.baseMessage, this.gmo);
            if (!this.specialCase) {
                this.gmo.matchOptions = 0;
            }
            if (string == null || string.trim().length() == 0) {
                this.useBrowse = false;
            } else {
                boolean bl2 = this.useBrowse = !this.specialCase;
            }
            if (mQQueue != null && mQQueue.getPersistence() == 3 && mQQueue2 != null && !mQQueue2.isNPMClassHigh()) {
                String string2 = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            this.queue = mQQueue2;
            this.acknowledgeMode = n;
            this.session = mQSession;
            this.transacted = bl;
            this.setSyncpointBehaviour(true);
            this.getOptions = this.gmo.options;
            this.browseOptions |= 0x10;
            this.acceptOptions |= 0x140;
            this.deleteOptions |= 0x144;
            try {
                String string4 = "";
                int n2 = 0;
                this.type = Utils.inquireInt((MQManagedObject)this.queue, 20);
                if (Trace.isOn) {
                    Trace.trace(this, "queue type: " + this.type);
                }
                int[] nArray = new int[]{22, 2019};
                int[] nArray2 = new int[1];
                byte[] byArray = new byte[48];
                if (this.type == 3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "QUEUE is an ALIAS queue, checking TARGQ");
                    }
                    this.baseQueueName = Utils.inquireString((MQManagedObject)this.queue, 2002);
                    try {
                        int n3 = 8232;
                        MQQueue mQQueue3 = this.session.qm.accessQueue(this.baseQueueName, n3);
                        mQQueue3.inquire(nArray, nArray2, byArray);
                        mQQueue3.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1062");
                        if (Trace.isOn) {
                            Trace.trace(this, "Exception detected " + (Object)((Object)jMSException));
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                        }
                    }
                } else {
                    mQQueue2.inquire(nArray, nArray2, byArray);
                }
                string4 = new String(byArray);
                n2 = nArray2[0];
                if (Trace.isOn) {
                    Trace.trace(this, "returned from inquire, threshold = " + n2 + ", borq = '" + string4 + "'" + " type: " + this.type);
                }
                this.backoutThreshold = n2;
                if (n2 != 0) {
                    this.maxAsyncAttempts = n2;
                }
                this.backoutRetryQueue = string4.length() != 0 ? string4 : mQSession.getDLQName();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block21;
                Trace.trace(this, "constructor: queue.inquire threw " + exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    protected MQMessageConsumer(MQTopic mQTopic, MQSession mQSession, MQSubscription mQSubscription, boolean bl, int n) throws JMSException {
        String string;
        Object object;
        Object object2;
        block24: {
            this.messageSelector = null;
            this.closed = false;
            this.closing = false;
            this.queueSpec = null;
            this.queue = null;
            this.session = null;
            this.listener = null;
            this.nextGenSeenList = new Hashtable();
            this.prevGenSeenList = new Hashtable();
            this.nullValue = new Object();
            this.maxAsyncAttempts = 5;
            this.backoutRetryQueue = null;
            this.backoutThreshold = 20;
            this.mqDLQName = null;
            this.baseQueueName = null;
            this.type = 0;
            this.needsRestart = true;
            this.rescanTimeMillis = 0L;
            this.rescanTimeMillisNoted = 0L;
            this.syncPoint = 1;
            this.topicSpec = null;
            this.noLocal = false;
            this.selectorSet = false;
            this.name = null;
            this.subscriberId = null;
            this.statusMgrId = null;
            this.shared_queue = false;
            this.subscription = null;
            this.useBrowse = false;
            this.setForPTP = false;
            this.setForPubSub = false;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                if (mQTopic != null) {
                    Trace.trace(this, "topic = " + mQTopic);
                }
            }
            this.setForPubSub = true;
            n = mQSession.getAcknowledgeMode();
            this.topicSpec = mQTopic;
            this.queue = mQSubscription.getSubscriberQueue();
            this.session = mQSession;
            this.transacted = bl;
            if (Trace.isOn && this.queue != null) {
                Trace.trace(this, this.queue + "(" + this.queue.name + ")");
            }
            this.noLocal = mQSubscription.getNoLocal();
            this.name = mQSubscription.getQueueName();
            this.subscriberId = mQSubscription.getCorrelationId();
            if (mQSubscription instanceof MQQueueSubscription) {
                this.statusMgrId = ((MQQueueSubscription)mQSubscription).getStatusMgrId();
            }
            this.shared_queue = mQSubscription.isSharedQueue();
            String string2 = mQSubscription.getSelector();
            this.subscription = mQSubscription;
            this.acknowledgeMode = n;
            if (Trace.isOn) {
                Trace.trace(this, "Queue name = " + this.name);
            }
            if (this.name.startsWith("SYSTEM.JMS.D.")) {
                if (Trace.isOn) {
                    Trace.trace(this, "durable set to TRUE");
                }
                this.durable = true;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "durable set to FALSE");
                }
                this.durable = false;
            }
            try {
                this.setMessageSelector(string2);
            }
            catch (JMSException jMSException) {
                this.session = null;
                this.topicSpec = null;
                this.queue = null;
                if (Trace.isOn) {
                    Trace.trace(this, "constructor: setMessageSelector() threw " + (Object)((Object)jMSException));
                    Trace.exit(this, "constructor");
                }
                throw jMSException;
            }
            this.selectorSet = string2 != null && string2.length() != 0;
            try {
                int n2;
                object2 = new int[]{22, 20};
                object = new int[2];
                this.queue.inquire(object2, object, null);
                string = this.queue.getAttributeString(2019, 48).trim();
                this.backoutThreshold = n2 = object[0];
                this.type = object[1];
                if (Trace.isOn) {
                    Trace.trace(this, "returned from inquire, threshold = " + n2 + ", borq = '" + string + "'");
                }
                if (n2 != 0) {
                    this.maxAsyncAttempts = n2;
                }
                this.backoutRetryQueue = string.length() != 0 ? string : mQSession.getDLQName();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block24;
                Trace.trace(this, "constructor: queue.inquire threw " + exception);
            }
        }
        this.gmo = new MQGetMessageOptions(true);
        this.gmo.matchOptions = this.shared_queue ? 2 : 0;
        this.getOptions = this.gmo.options;
        this.browseOptions |= 0x10;
        this.acceptOptions |= 0x140;
        this.deleteOptions |= 0x144;
        if (mQTopic.getFailIfQuiesce() == 1) {
            this.gmo.options |= 0x2000;
            this.browseOptions |= 0x2000;
            this.acceptOptions |= 0x2000;
            this.deleteOptions |= 0x2000;
        }
        this.setSyncpointBehaviour(false);
        this.baseMessage = new MQJMSMessage();
        if (mQTopic instanceof MQTemporaryTopic) {
            ((MQTemporaryTopic)mQTopic).usageUp();
        }
        if ((this.noLocal || this.selectorSet) && mQSession.getSparseSubscriptions() && this.syncPoint != 3) {
            if (Trace.isOn) {
                Trace.trace(this, "browse mode");
            }
            this.useBrowse = true;
        }
        if (!(mQTopic.getPersistence() != 3 || mQSubscription == null || (object2 = (Object)mQSubscription.getSubscriberQueue()) != null && object2.isNPMClassHigh())) {
            this.session = null;
            this.topicSpec = null;
            this.queue = null;
            if (mQSubscription.isDurable()) {
                mQSession.connection.getSubscriptionEngine().closeDurableSubscription(mQSubscription);
            } else {
                mQSession.connection.getSubscriptionEngine().closeSubscription(mQSubscription);
            }
            object = "MQJMS0003";
            string = ConfigEnvironment.getErrorMessage((String)object);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string, (String)object);
            throw invalidDestinationException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageSelector() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMessageSelector");
            }
            this.checkConsumerOpen();
            String string = this.messageSelector != null ? this.messageSelector.getSelector() : null;
            String string2 = string;
            return string2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMessageSelector");
            }
        }
    }

    void setMessageSelector(String string) throws InvalidSelectorException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setMessageSelector");
            }
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            try {
                if (string != null) {
                    if (string.equals("\u0000")) {
                        throw new SyntaxException();
                    }
                    boolean bl = false;
                    boolean bl2 = true;
                    for (int i = 0; bl2 && i < string.length(); ++i) {
                        if (string.charAt(i) == ' ') {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        bl2 = false;
                    }
                    if (string.length() == 0 || bl) {
                        string = null;
                    }
                }
                this.messageSelector.setSelector(string);
            }
            catch (SyntaxException syntaxException) {
                String string2 = "MQJMS0004";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string3, string2);
                invalidSelectorException.setLinkedException((Exception)syntaxException);
                throw invalidSelectorException;
            }
        }
        catch (InvalidSelectorException invalidSelectorException) {
            Trace.trace(this, "Throwing" + (Object)((Object)invalidSelectorException));
            throw invalidSelectorException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageSelector");
            }
        }
    }

    boolean setMessageSelector(String string, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws InvalidSelectorException {
        try {
            boolean bl;
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "setMessageSelector");
            }
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            try {
                if (string != null) {
                    if (string.equals("\u0000")) {
                        throw new SyntaxException();
                    }
                    bl2 = false;
                    boolean bl3 = true;
                    for (int i = 0; bl3 && i < string.length(); ++i) {
                        if (string.charAt(i) == ' ') {
                            bl2 = true;
                            continue;
                        }
                        bl2 = false;
                        bl3 = false;
                    }
                    if (string.length() == 0 || bl2) {
                        string = null;
                    }
                }
                bl = this.messageSelector.setSelector(string, mQMsg2, mQGetMessageOptions);
            }
            catch (SyntaxException syntaxException) {
                String string2 = "MQJMS0004";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string3, string2);
                invalidSelectorException.setLinkedException((Exception)syntaxException);
                throw invalidSelectorException;
            }
            bl2 = bl;
            return bl2;
        }
        catch (InvalidSelectorException invalidSelectorException) {
            Trace.exception(this, "setMessageSelector", (Throwable)invalidSelectorException);
            throw invalidSelectorException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageSelector");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MQMessageSelector getSelectorInstance() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSelectorInstance");
            }
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            MQMessageSelector mQMessageSelector = this.messageSelector;
            return mQMessageSelector;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSelectorInstance");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            boolean bl2 = bl = this.closed;
            if (Trace.isOn) {
                Trace.trace(this, "isClosed returning " + bl);
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isClosed");
            }
        }
    }

    void checkConsumerOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkConsumerOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "MessageConsumer is closed. Throwing IllegalStateException.");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck((JMSException)((Object)illegalStateException));
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkConsumerOpen");
        }
    }

    protected void setSyncpointBehaviour(boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "setSyncpointBehaviour");
        }
        boolean bl2 = this.session.getSyncpointAllGets();
        if (this.transacted || bl2 || this.acknowledgeMode == 2 || this.session.getDistTransactionMode() == 2) {
            this.syncPoint = 1;
            this.getOptions |= 2;
            this.acceptOptions |= 2;
            if (Trace.isOn) {
                Trace.trace(this, "syncpoint enabled");
            }
        } else if (this.durable || bl) {
            this.syncPoint = 2;
            this.getOptions |= 0x1000;
            this.acceptOptions |= 0x1000;
            if (Trace.isOn) {
                Trace.trace(this, "using syncpoint if persistent");
            }
        } else {
            this.syncPoint = 3;
            this.getOptions |= 4;
            this.acceptOptions |= 4;
            if (Trace.isOn) {
                Trace.trace(this, "syncpoint disabled");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setSyncpointBehaviour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Queue getQueue() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueue");
            }
            this.checkConsumerOpen();
            com.ibm.mq.jms.MQQueue mQQueue = this.queueSpec;
            return mQQueue;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getQueue");
            }
        }
    }

    void resetBrowse() {
        if (Trace.isOn) {
            Trace.entry(this, "resetBrowse");
        }
        this.needsRestart = true;
        if (Trace.isOn) {
            Trace.exit(this, "resetBrowse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIDFromMessage(MQMsg2 mQMsg2) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getIDFromMessage");
            }
            if (mQMsg2 == null) {
                String string = null;
                return string;
            }
            byte[] byArray = mQMsg2.getMessageId();
            switch (byArray[0]) {
                case 65: {
                    if (byArray[1] == 77 && byArray[2] == 81 && byArray[3] == 32) break;
                    String string = null;
                    return string;
                }
                case 67: {
                    if (byArray[1] == 83 && byArray[2] == 81 && byArray[3] == 32) break;
                    String string = null;
                    return string;
                }
                case -63: {
                    if (byArray[1] == -44 && byArray[2] == -40 && byArray[3] == 64) break;
                    String string = null;
                    return string;
                }
                case -61: {
                    if (byArray[1] == -30 && byArray[2] == -40 && byArray[3] == 64) break;
                    String string = null;
                    return string;
                }
                default: {
                    String string = null;
                    return string;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 4; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                if (n < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n));
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getIDFromMessage");
            }
        }
    }

    void setRescanInterval(long l) {
        if (Trace.isOn) {
            Trace.entry(this, "setRescanInterval");
        }
        this.rescanTimeInterval = l;
        if (Trace.isOn) {
            Trace.exit(this, "setRescanInterval");
        }
    }

    long getRescanInterval() {
        if (Trace.isOn) {
            Trace.entry(this, "setRescanInterval");
            Trace.exit(this, "setRescanInterval");
        }
        return this.rescanTimeInterval;
    }

    public boolean getNoLocal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getNoLocal");
        }
        this.checkConsumerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getNoLocal");
        }
        return this.noLocal;
    }

    Topic getTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getTopic");
        }
        this.checkConsumerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getTopic");
        }
        return this.topicSpec;
    }

    boolean isDurable() {
        return this.durable;
    }

    protected void finalizeQ() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalizeQ");
        }
        if (this.queue != null) {
            Trace.trace(this, "about to close MQ queue");
            try {
                this.queue.close();
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "failed to close queue from finalizer: " + (Object)((Object)mQException));
                }
            }
        } else {
            Trace.trace(this, "MQ queue already null");
        }
        if (Trace.isOn) {
            Trace.exit(this, "finalizeQ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeQ() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "closeQ");
        }
        try {
            try {
                if (this.session != null) {
                    this.session.setPlayNice(true);
                }
                this.closing = true;
                MQMessageConsumer mQMessageConsumer = this;
                synchronized (mQMessageConsumer) {
                    if (this.session != null) {
                        this.session.removeConsumer(this);
                    }
                    if (this.listener != null) {
                        if (this.session != null) {
                            this.session.removeAsync(this);
                        }
                        this.listener = null;
                    }
                    this.closed = true;
                    if (this.queue != null) {
                        try {
                            this.queue.close();
                            this.queue = null;
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            if (this.session == null) throw jMSException;
                            if (this.session.connection == null) throw jMSException;
                            this.session.connection.deliverExceptionCheck(jMSException);
                            throw jMSException;
                        }
                    }
                    if (this.session != null) {
                        this.session.setPlayNice(false);
                    }
                    this.session = null;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "close throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                if (this.session == null) throw jMSException;
                if (this.session.connection == null) throw jMSException;
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            Object var6_6 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeQ");
            throw throwable;
        }
        Trace.exit(this, "closeQ");
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (this.setForPTP) {
            this.setMessageListenerQ(messageListener);
        } else if (this.setForPubSub) {
            this.setMessageListenerT(messageListener);
        }
    }

    protected void setMessageListenerQ(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListenerQ");
        }
        this.checkConsumerOpen();
        try {
            if (this.closed || this.session == null) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS3033");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                if (this.session != null && this.session.connection != null) {
                    this.session.connection.deliverExceptionCheck((JMSException)((Object)illegalStateException));
                }
                throw illegalStateException;
            }
            if (messageListener != null && this.session.hasMessageListener()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                throw jMSException;
            }
            this.listener = messageListener;
            if (messageListener == null) {
                this.session.removeAsync(this);
            } else {
                this.session.addAsync(this);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageListenerQ");
            }
        }
    }

    protected void setMessageListenerT(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListenerT");
        }
        this.checkConsumerOpen();
        try {
            if (this.isClosed() || this.session == null) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS3034");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                throw illegalStateException;
            }
            if (messageListener != null && this.session.hasMessageListener()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                throw jMSException;
            }
            this.listener = messageListener;
            if (messageListener == null) {
                this.session.removeAsync(this);
            } else {
                this.session.addAsync(this);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageListenerT");
            }
        }
    }

    protected void finalizeT() throws Throwable {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "finalizeT");
            }
            try {
                this.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block4;
                Trace.trace(this, "calling close from finalize failed: " + (Object)((Object)jMSException));
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalizeT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void closeT() throws JMSException {
        boolean bl = true;
        if (Trace.isOn) {
            Trace.entry(this, "closeT");
        }
        try {
            try {
                if (this.session != null) {
                    this.session.setPlayNice(true);
                }
                this.closing = true;
                MQMessageConsumer mQMessageConsumer = this;
                synchronized (mQMessageConsumer) {
                    block32: {
                        if (this.listener != null) {
                            if (this.session != null) {
                                this.session.removeAsync(this);
                            }
                            this.listener = null;
                        }
                        this.closed = true;
                        try {
                            if (null != this.session && null != this.session.qm && !this.session.isClosed() && this.session.qm instanceof MQSPIQueueManager && ((MQSPIQueueManager)this.session.qm).spiSupportsInherited() && (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3)) {
                                this.session._acknowledgeInternal();
                            }
                        }
                        catch (MQException mQException) {
                            // empty catch block
                        }
                        if (!this.isDurable()) {
                            try {
                                this.subscription.close();
                                this.queue = null;
                            }
                            catch (JMSException jMSException) {
                                Exception exception = jMSException.getLinkedException();
                                if (exception instanceof MQException && ((MQException)((Object)exception)).reasonCode == 2055) {
                                    bl = false;
                                    if (Trace.isOn) {
                                        Trace.trace(this, "close ignoring MQException 2055");
                                    }
                                    break block32;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "close() ignoring exception " + (Object)((Object)jMSException));
                                    if (exception != null) {
                                        Trace.trace(this, "linked exception " + exception);
                                    }
                                }
                                this.queue = null;
                            }
                        } else if (this.queue != null) {
                            try {
                                this.subscription.close();
                                this.queue.close();
                                this.queue = null;
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", this.subscription.getQueueName());
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                if (this.session == null) throw jMSException;
                                if (this.session.connection == null) throw jMSException;
                                this.session.connection.deliverExceptionCheck(jMSException);
                                throw jMSException;
                            }
                        }
                    }
                    if (this.session != null && bl) {
                        this.session.removeConsumer(this);
                    }
                    if (this.session != null) {
                        this.session.setPlayNice(false);
                    }
                    this.session = null;
                    if (this.topicSpec instanceof MQTemporaryTopic) {
                        ((MQTemporaryTopic)this.topicSpec).usageDown();
                        this.topicSpec = null;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                if (this.session == null) throw jMSException;
                if (this.session.connection == null) throw jMSException;
                this.session.connection.deliverExceptionCheck(jMSException);
                throw jMSException;
            }
            Object var7_10 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeT");
            throw throwable;
        }
        Trace.exit(this, "closeT");
    }

    public void close() throws JMSException {
        if (this.setForPTP) {
            this.closeQ();
        } else if (this.setForPubSub) {
            this.closeT();
        }
    }

    public void finalize() throws Throwable {
        if (this.setForPTP) {
            this.finalizeQ();
        } else if (this.setForPubSub) {
            this.finalizeT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListener getMessageListener() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMessageListener");
            }
            this.checkConsumerOpen();
            MessageListener messageListener = this.listener;
            return messageListener;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMessageListener");
            }
        }
    }

    public Destination getDestination() throws JMSException {
        try {
            if (Trace.isOn()) {
                Trace.entry(this, "getDestination");
            }
            if (this.setForPTP) {
                return this.getQueue();
            }
            if (this.setForPubSub) {
                return this.getTopic();
            }
            String string = "MQJMS3037";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck((JMSException)((Object)illegalStateException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "MessageProducer is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn()) {
                Trace.exit(this, "getDestination");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
    }

    private int getSPIOptions(int n) throws JMSException {
        int n2;
        block29: {
            int n3;
            block27: {
                int n4;
                block28: {
                    if (Trace.isOn) {
                        Trace.entry(this, "getSPIOptions");
                    }
                    n3 = 0;
                    if (this.setForPubSub && this.session.supportsInherited()) break block27;
                    if (Trace.isOn) {
                        Trace.trace(this, "Not enabling SPI options.");
                    }
                    n4 = n3 = 0;
                    Object var5_7 = null;
                    if (!Trace.isOn) break block28;
                    Trace.trace(this, "Returning spiOptions = " + n3);
                    Trace.exit(this, "getSPIOptions");
                }
                return n4;
            }
            try {
                if (this.syncPoint != 3) {
                    if (Trace.isOn) {
                        String string = "";
                        switch (this.syncPoint) {
                            case 1: {
                                string = "SYNCPOINT";
                                break;
                            }
                            case 2: {
                                string = "SPIP";
                                break;
                            }
                            case 3: {
                                string = "NO_SYNCPOINT";
                                break;
                            }
                            default: {
                                string = "Invalid";
                            }
                        }
                        Trace.trace(this, "syncpoint = " + string + ", durable = " + this.durable);
                    }
                    n2 = this.session.getAcknowledgeMode();
                    switch (n2) {
                        case 1: 
                        case 3: {
                            if (!this.session.getCommitRequired()) break;
                            if (Trace.isOn) {
                                Trace.trace(this, "Commit required, using spiGETOPT_COMMIT");
                            }
                            n3 += 2;
                            if ((n2 != 3 || this.session.getOutcomeNotification()) && n <= 0) break;
                            if (Trace.isOn) {
                                Trace.trace(this, "DUPS_OK and outcomeNotification(false). Using spiGETOPT_COMMIT_ASYNC");
                            }
                            n3 += 8;
                            break;
                        }
                        case 0: 
                        case 2: {
                            if (this.session.getCommitRequired() || n <= 0) break;
                            if (Trace.isOn) {
                                Trace.trace(this, "No commit required by app and following an unwanted message. Using spiGETOPT_COMMIT_ASYNC");
                            }
                            n3 += 2;
                            n3 += 8;
                            break;
                        }
                    }
                    if (this.session.getProcessDuration() == 1) {
                        n3 += 16;
                        if (this.session.getReceiveIsolation() == 1) {
                            ++n3;
                        }
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "Not operating under syncpoint, no point in using spiGet");
                }
                n2 = n3;
                Object var5_8 = null;
                if (!Trace.isOn) break block29;
            }
            catch (JMSException jMSException) {
                try {
                    if (Trace.isOn) {
                        Trace.exception(this, "getSPIOptions", (Throwable)jMSException);
                        Trace.trace(this, "Leaving via Exception");
                    }
                    if (this.session != null && this.session.connection != null) {
                        this.session.connection.deliverExceptionCheck(jMSException);
                    }
                    throw jMSException;
                }
                catch (Throwable throwable) {
                    block30: {
                        Object var5_9 = null;
                        if (!Trace.isOn) break block30;
                        Trace.trace(this, "Returning spiOptions = " + n3);
                        Trace.exit(this, "getSPIOptions");
                    }
                    throw throwable;
                }
            }
            Trace.trace(this, "Returning spiOptions = " + n3);
            Trace.exit(this, "getSPIOptions");
        }
        return n2;
    }

    private boolean isLocalMessage() throws MQException, JMSException {
        boolean bl = false;
        RFH rFH = null;
        if (Trace.isOn) {
            Trace.entry(this, "isLocalMessage");
        }
        try {
            long l;
            try {
                l = this.baseMessage.getFormatAsLong();
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.exit(this, "getMessage (via Exception)");
                }
                throw jMSException;
            }
            String string = null;
            if (l == 5571313732235042848L || l == -3109514705039769536L) {
                if (Trace.isOn) {
                    Trace.trace(this, "Received message has RFH1 header");
                }
                try {
                    rFH = new RFH(this.baseMessage);
                    if (rFH != null) {
                        string = rFH.getValue("UNIQUE_CONNECTION_ID");
                    }
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "couldn't create an RFH from the incoming message");
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (l == 5571313732236222496L || l == -3109514705028104128L) {
                if (Trace.isOn) {
                    Trace.trace(this, "Received message has RFH2 header");
                }
                try {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    n = this.baseMessage.getEncoding();
                    this.baseMessage.skipReadingBytes(8);
                    n2 = this.baseMessage.readInt(n);
                    this.baseMessage.skipReadingBytes(20);
                    n3 = this.baseMessage.readInt(n);
                    if (Trace.isOn) {
                        Trace.trace(this, "nvCharSetAsInt = " + n3);
                    }
                    this.baseMessage.skipReadingBytes(4);
                    n4 = n2 - 40;
                    byte[] byArray = new byte[n4];
                    this.baseMessage.read(byArray);
                    String string2 = MQJMSMessage.getCharacterSetString(n3, n);
                    String string3 = new String(byArray, string2);
                    if (Trace.isOn) {
                        Trace.trace(this, "nameValueString is " + string3);
                    }
                    string = string3.substring(string3.indexOf("<UNIQUE_CONNECTION_ID>") + 22, string3.indexOf("</UNIQUE_CONNECTION_ID>"));
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                    if (Trace.isOn) {
                        Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            } else {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.exit(this, "getMessage (via Exception)");
                }
                throw jMSException;
            }
            if (string == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "No UNIQUE_CONNECTION_ID in message");
                }
            } else if (string.equals(this.session.getConnectionID())) {
                if (Trace.isOn) {
                    Trace.trace(this, "IDs match (" + string + ")" + ", therefore " + "the message is local, and needs to be " + "discarded. Setting retry=true");
                }
                bl = true;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "IDs don't match. Incoming=" + string + ", Connection=" + this.session.getConnectionID() + ". Message is non-local, therefore valid");
                }
                bl = false;
            }
            this.baseMessage.resetReadPosition();
            if (Trace.isOn) {
                Trace.trace(this, "isLocalMessage returning " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "isLocalMessage", (Throwable)jMSException);
                Trace.trace(this, "Leaving via JMSException");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "isLocalMessage", (Throwable)mQException);
                Trace.trace(this, "Leaving via MQException");
            }
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isLocalMessage");
            }
        }
    }

    private void commitIfRequired(boolean bl, boolean bl2) throws JMSException {
        block53: {
            try {
                Object object;
                if (Trace.isOn) {
                    Trace.entry(this, "commitIfRequired");
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Message is" + (bl ? " " : " not ") + "wanted");
                    Trace.trace(this, "commitIfRequired is called from" + (bl2 ? " getMessage " : " receiveAsync ") + "method");
                    object = "Not Applicable";
                    String string = "false";
                    switch (this.acknowledgeMode) {
                        case 1: {
                            object = "Session.AUTO_ACKNOWLEDGE";
                            break;
                        }
                        case 3: {
                            object = "Session.DUPS_OK_ACKNOWLEDGE";
                            break;
                        }
                        case 2: {
                            object = "Session.CLIENT_ACKNOWLEDGE";
                            break;
                        }
                        case 0: {
                            string = "true";
                            break;
                        }
                        default: {
                            object = "Invalid";
                            string = "false";
                        }
                    }
                    Trace.trace(this, "Session.acknowledgeMode = " + (String)object + " Transacted = " + string);
                }
                if ((this.session.usingAsyncMode() || this.session.hasMessageListener()) && bl2) {
                    if (this.setForPubSub) {
                        if (Trace.isOn) {
                            Trace.trace(this, "We are in PubSub async delivery mode");
                        }
                        this.session.setCommitRequired(true);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "We are in PTP async delivery mode");
                        }
                        if (bl) {
                            this.session.setCommitRequired(true);
                        } else {
                            this.session.setCommitRequired(false);
                        }
                    }
                    return;
                }
                if (this.session.supportsInherited() && this.setForPubSub) {
                    if (Trace.isOn) {
                        Trace.trace(this, "QueueManager supports ITX calls");
                    }
                    switch (this.acknowledgeMode) {
                        case 1: 
                        case 3: {
                            if (bl && !this.session.usingAsyncMode() && !this.session.hasMessageListener() && this.session.getProcessDuration() == 0) {
                                if (this.syncPoint == 2) {
                                    if (this.baseMessage.getPersistence() == 1) {
                                        this.session._acknowledgeInternal();
                                    }
                                } else if (this.syncPoint == 1) {
                                    this.session._acknowledgeInternal();
                                }
                                this.session.setCommitRequired(false);
                            } else {
                                this.session.setCommitRequired(true);
                            }
                            break block53;
                        }
                        case 0: 
                        case 2: {
                            break block53;
                        }
                        default: {
                            object = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                            if (Trace.isOn) {
                                Trace.exception(this, "commitIfRequired", (Throwable)object);
                            }
                            throw object;
                        }
                    }
                }
                if (this.session.getDistTransactionMode() == 0 || !this.session.getTransacted()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "QueueManager doesn't support ITX calls or we're in PTP mode");
                    }
                    switch (this.acknowledgeMode) {
                        case 1: 
                        case 3: {
                            if (this.syncPoint == 2) {
                                if (this.baseMessage.getPersistence() == 1) {
                                    this.session._acknowledgeInternal();
                                }
                            } else if (this.syncPoint == 1) {
                                this.session._acknowledgeInternal();
                            }
                            this.session.setCommitRequired(false);
                            break block53;
                        }
                        case 0: 
                        case 2: {
                            if (!bl && !this.session.getCommitRequired()) {
                                if (this.acknowledgeMode == 0) {
                                    this.session.commit();
                                } else {
                                    this.session._acknowledgeInternal();
                                }
                                this.session.setCommitRequired(false);
                            } else {
                                this.session.setCommitRequired(true);
                            }
                            break block53;
                        }
                        default: {
                            object = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                            if (Trace.isOn) {
                                Trace.exception(this, "commitIfRequired", (Throwable)object);
                            }
                            throw object;
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Session.getDistTransactionMode = " + this.session.getDistTransactionMode());
                    Trace.trace(this, "In a possible global transactional mode. Skipping any commit or acknowledge attempts.");
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Leaving via Exception");
                }
                if (this.session != null && this.session.connection != null) {
                    this.session.connection.deliverExceptionCheck(jMSException);
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "commitIfRequired");
                }
            }
        }
    }

    public Message receive() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "receive");
            }
            Message message = this.receiveInternal(-1L);
            return message;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "receive");
            }
        }
    }

    public Message receive(long l) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "receive", "timeout = " + l);
            }
            Message message = this.receiveInternal(l == 0L ? -1L : l);
            return message;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "receive");
            }
        }
    }

    public Message receiveNoWait() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "receiveNoWait");
            }
            Message message = this.receiveInternal(0L);
            return message;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "receiveNoWait");
            }
        }
    }

    private Message receiveInternal(long l) throws NoMsgListenerException, JMSException {
        try {
            long l2;
            JMSMessage jMSMessage = null;
            if (Trace.isOn) {
                Trace.entry(this, "receiveInternal", "timeout = " + l);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Performing initial validity checks");
            }
            if (this.isClosed() || this.session == null || this.session.isClosed()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is closed. Throwing new JMSException");
                }
                String string = this.setForPubSub ? ConfigEnvironment.getErrorMessage("MQJMS3034") : (this.setForPTP ? ConfigEnvironment.getErrorMessage("MQJMS3033") : ConfigEnvironment.getErrorMessage("MQJMS3038"));
                IllegalStateException illegalStateException = new IllegalStateException(string);
                throw illegalStateException;
            }
            if (this.queue == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Queue is null. Throwing new JMSException");
                }
                throw ConfigEnvironment.newException("MQJMS2001");
            }
            if (!this.session.callingFromOnMessage() && (this.session.usingAsyncMode() || this.session.hasMessageListener())) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is in async mode. Throwing new JMSException");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                throw jMSException;
            }
            if (l != -1L && (l > Integer.MAX_VALUE || l < 0L)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid timeOut. Throwing new JMSException");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1067");
                throw jMSException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Finished validity checks");
            }
            if (l == 0L && this.session.isStopped()) {
                if (Trace.isOn) {
                    Trace.trace(this, "early return. Session closed and timeOut = 0");
                }
                Message message = null;
                return message;
            }
            if (Trace.isOn) {
                Trace.trace(this, "receiveInternal - waiting for session start");
            }
            if (l == -1L) {
                this.session.waitForStart();
                l2 = -1L;
            } else {
                l2 = this.session.waitForStart(l);
            }
            if (Trace.isOn) {
                Trace.trace(this, "receiveInternal - session started");
            }
            if (l > 0L && l2 == 0L) {
                if (Trace.isOn) {
                    Trace.trace(this, "Out of time waiting for Session to start. Returning null");
                }
                Message message = null;
                return message;
            }
            if (!this.session.isStarted() || this.isClosed()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session stopped or closed while getting transation Lock. Returning null");
                }
                Message message = null;
                return message;
            }
            JMSMessage jMSMessage2 = jMSMessage = this.getMessage(l2);
            return jMSMessage2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "receiveInternal throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "receiveInternal");
            }
        }
    }

    synchronized boolean receiveAsync(long l) throws NoMsgListenerException, JMSException {
        boolean bl = false;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "receiveAsync", "timeOut = " + l);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Performing initial validity checks");
            }
            if (this.closed) {
                if (Trace.isOn) {
                    Trace.trace(this, "MessageConsumer is closed. Throwing new IllegalStateException");
                }
                String string = ConfigEnvironment.getErrorMessage("MQJMS3033");
                IllegalStateException illegalStateException = new IllegalStateException(string);
                throw illegalStateException;
            }
            if (this.listener == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "No registered MessageListener. Throwing new JMSException");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1012");
                throw jMSException;
            }
            if (this.queue == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Queue is null. Throwing new JMSException");
                }
                throw ConfigEnvironment.newException("MQJMS2001");
            }
            if (!this.setForPTP && !this.setForPubSub) {
                boolean bl3 = false;
                return bl3;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Validity checks passed.");
            }
            boolean bl4 = this.session.getTransacted();
            if (!this.session.isStarted()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Session is not started, returning immediately");
                }
                boolean bl5 = false;
                return bl5;
            }
            JMSMessage jMSMessage = this.getMessage(l);
            if (jMSMessage != null) {
                if (!bl4 && this.acknowledgeMode == 2) {
                    jMSMessage._setSession(this.session);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "entering async delivery block");
                }
                if (this.listener != null) {
                    bl2 = true;
                    int n = 0;
                    while (bl2) {
                        try {
                            bl2 = false;
                            ++n;
                            this.listener.onMessage((Message)jMSMessage);
                        }
                        catch (Throwable throwable) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Exception thrown from MessageListener.onMessage()");
                                Trace.exception(this, "receiveAsync", throwable);
                            }
                            try {
                                Logger.log(new LogMessage(2, "MQJMS1034", throwable.toString()));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            if ((this.acknowledgeMode == 1 || this.acknowledgeMode == 3) && n < this.maxAsyncAttempts) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "We will attempt to redeliver this message");
                                }
                                bl2 = true;
                                jMSMessage.setJMSRedelivered(true);
                                continue;
                            }
                            try {
                                if (this.backoutRetryQueue == null) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                                    if (Trace.isOn) {
                                        Trace.trace(this, "receiveAsync() no backout queue defined.");
                                    }
                                    throw jMSException;
                                }
                                boolean bl6 = true;
                                if (this.syncPoint == 3 || this.syncPoint == 2 && this.baseMessage.getPersistence() != 1) {
                                    bl6 = false;
                                }
                                this.session.redirectMessage(this.backoutRetryQueue, this.baseMessage, bl6);
                                if (this.syncPoint != 2 || this.baseMessage.getPersistence() == 1) continue;
                                this.session._acknowledgeInternal();
                            }
                            catch (JMSException jMSException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "failed to redirect message. Closing receiver");
                                }
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS1022"));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                this.close();
                                if (Trace.isOn) {
                                    Trace.exception(this, "receiveAsync", (Throwable)jMSException);
                                }
                                throw jMSException;
                            }
                        }
                    }
                } else {
                    NoMsgListenerException noMsgListenerException = new NoMsgListenerException("no message listener registered");
                    if (Trace.isOn) {
                        Trace.exception(this, "receiveAsync", (Throwable)((Object)noMsgListenerException));
                    }
                    throw noMsgListenerException;
                }
                this.commitIfRequired(true, false);
                if (this.session.getAcknowledgeMode() == 2 || this.session.getAcknowledgeMode() == 0) {
                    jMSMessage._setSession(this.session);
                }
                bl = true;
            }
            bl2 = bl;
            return bl2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "receiveAsync");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private JMSMessage getMessage(long var1_1) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP], 17[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getSyncPointOptions() throws IntErrorException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSyncPointOptions");
            }
            int n = 0;
            switch (this.syncPoint) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting for SYNCPOINT");
                    }
                    n |= 2;
                    n &= 0xFFFFFFFB;
                    n &= 0xFFFFEFFF;
                    break;
                }
                case 3: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting for NO_SYNCPOINT");
                    }
                    n |= 4;
                    n &= 0xFFFFFFFD;
                    n &= 0xFFFFEFFF;
                    break;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting for SPIP");
                    }
                    n |= 0x1000;
                    n &= 0xFFFFFFFB;
                    n &= 0xFFFFFFFD;
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Unrecognized syncPoint setting. About to log the error");
                    }
                    String string = ConfigEnvironment.getMessage("MQJMS1006", "syncPoint", String.valueOf(this.syncPoint));
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1016", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    String string2 = "MQJMS1016";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    IntErrorException intErrorException = new IntErrorException(string3, string2);
                    throw intErrorException;
                }
            }
            int n2 = n;
            return n2;
        }
        catch (IntErrorException intErrorException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
                Trace.exception(this, "getSyncPointOptions", (Throwable)((Object)intErrorException));
            }
            throw intErrorException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getSyncPointOptions");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNewPTPMessage() {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "isNewPTPMessage");
            }
            String string = null;
            string = this.getIDFromMessage(this.baseMessage);
            boolean bl2 = bl = string != null && this.prevGenSeenList.containsKey(string) && !this.nextGenSeenList.containsKey(string);
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "message found in seen list. Skipping.");
                }
                this.nextGenSeenList.put(string, this.nullValue);
                boolean bl3 = false;
                return bl3;
            }
            if (Trace.isOn) {
                Trace.trace(this, "isNewPTPMessage returning true");
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isNewPTPMessage");
            }
        }
    }

    JMSMessage isMessageSelected() throws JMSException {
        try {
            JMSMessage jMSMessage = null;
            if (Trace.isOn) {
                Trace.entry(this, "isMessageSelected");
            }
            try {
                jMSMessage = this.baseMessage.createJMSMessage(this.session);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "JMSException thrown creating JMSMessage");
                    Trace.exception(this, "getMessage", (Throwable)jMSException);
                }
                if (this.session != null && this.session.connection != null) {
                    this.session.connection.deliverExceptionCheck(jMSException);
                }
                throw jMSException;
            }
            catch (IOException iOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "IOException thrown creating JMSMessage, Wrapping in new JMSException");
                    Trace.exception(this, "getMessage", (Throwable)iOException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1000");
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            boolean bl = true;
            if (this.setForPTP && this.useBrowse || this.setForPubSub && this.selectorSet && this.subscription.getFilter() == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "About to check selector");
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "isMessageSelected just returning JMSMessage");
                }
                JMSMessage jMSMessage2 = jMSMessage;
                return jMSMessage2;
            }
            bl = this.messageSelector.isSelected(jMSMessage, this.baseMessage);
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "isMessageSelected true, returning JMSMessage");
                }
                JMSMessage jMSMessage3 = jMSMessage;
                return jMSMessage3;
            }
            if (Trace.isOn) {
                Trace.trace(this, "isMessageSelected false, returning null");
            }
            JMSMessage jMSMessage4 = null;
            return jMSMessage4;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception ");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "isMessageSelected");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBrowsedMessage(boolean bl) throws JMSException {
        try {
            boolean bl2;
            block23: {
                bl2 = true;
                if (Trace.isOn) {
                    Trace.entry(this, "removeBrowsedMessage");
                }
                int n = this.gmo.options;
                this.gmo.options = bl ? this.acceptOptions : this.deleteOptions;
                try {
                    if (this.backoutThreshold != 0 && this.baseMessage.getBackoutCount() >= this.backoutThreshold) {
                        this.gmo.options = this.acceptOptions;
                        this.gmo.options |= 0;
                        this.gmo.options |= this.getSyncPointOptions();
                        this.gmo.options &= 0xFFFFFFBF;
                        this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                        bl2 = true;
                    } else {
                        this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo, 1);
                        bl2 = true;
                    }
                }
                catch (MQException mQException) {
                    if (mQException.completionCode == 1 && mQException.reasonCode == 2079) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Accepted truncated message. Expected result");
                        }
                        bl2 = true;
                        break block23;
                    }
                    if (mQException.reasonCode == 2034) {
                        bl2 = false;
                        if (Trace.isOn) {
                            Trace.trace(this, "couldn't dequeue message - message expired or competing consumers?");
                        }
                        break block23;
                    }
                    if (mQException.reasonCode == 2033) {
                        bl2 = false;
                        if (Trace.isOn) {
                            Trace.trace(this, "couldn't dequeue message - message expired or competing consumers?");
                        }
                        break block23;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Caught Exception thrown from getMsg2()");
                        Trace.exception(this, "removeBrowsedMessage", (Throwable)mQException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                finally {
                    this.gmo.options = n;
                }
            }
            boolean bl3 = bl2;
            return bl3;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via JMSException");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeBrowsedMessage");
            }
        }
    }

    /*
     * Loose catch block
     */
    void backoutRequeue(MQJMSMessage mQJMSMessage) throws JMSException {
        block38: {
            JMSException jMSException;
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "backoutRequeue");
            }
            MQQueue mQQueue = null;
            if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                if (this.type == 0) {
                    this.type = Utils.inquireInt((MQManagedObject)this.queue, 20);
                }
                if (this.type == 3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Queue " + this.queue.name + "is an ALIAS queue.");
                    }
                    if (this.baseQueueName == null || this.baseQueueName.length() == 0) {
                        this.baseQueueName = Utils.inquireString((MQManagedObject)this.queue, 2002);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Attempting to read Backout Requeue Queue from underlying LOCAL queue " + this.baseQueueName);
                    }
                    try {
                        n = 8232;
                        jMSException = this.session.qm.accessQueue(this.baseQueueName, n);
                        this.backoutRetryQueue = Utils.inquireString((MQManagedObject)jMSException, 2019);
                        jMSException.close();
                    }
                    catch (MQException mQException) {
                        jMSException = ConfigEnvironment.newException("MQJMS2008");
                        if (Trace.isOn) {
                            Trace.trace(this, "Exception detected " + (Object)((Object)jMSException));
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                        }
                    }
                } else {
                    this.backoutRetryQueue = Utils.inquireString((MQManagedObject)this.queue, 2019);
                }
            }
            if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                JMSException jMSException2 = ConfigEnvironment.newException("MQJMS1080");
                throw jMSException2;
            }
            this.backoutRetryQueue = this.backoutRetryQueue.trim();
            if (Trace.isOn) {
                Trace.trace(this, "BORQ = <" + this.backoutRetryQueue + ">");
            }
            try {
                n = 8720;
                mQQueue = this.session.qm.accessQueue(this.backoutRetryQueue, n, this.session.qm.name, null, null);
                jMSException = new MQPutMessageOptions();
                ((MQPutMessageOptions)jMSException).options = 514;
                ((MQPutMessageOptions)jMSException).contextReference = this.queue;
                mQQueue.putMsg2((MQMsg2)mQJMSMessage, (MQPutMessageOptions)jMSException);
                if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "Unable to commit requeued message as session is transacted or Client Ack");
                    }
                } else {
                    if (Trace.isOn()) {
                        Trace.trace(this, "commiting requeued message");
                    }
                    this.session.qm.commit();
                }
            }
            catch (MQException mQException) {
                if (mQException.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Message to requeue has disappeared! Continue as normal");
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "Unable to requeue message");
                }
                jMSException = ConfigEnvironment.newException("MQJMS1081");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            Object var6_9 = null;
            try {
                if (mQQueue != null) {
                    mQQueue.close();
                }
            }
            catch (MQException mQException) {
                // empty catch block
            }
            if (Trace.isOn) {
                Trace.exit(this, "backoutRequeue");
            }
            break block38;
            {
                catch (JMSException jMSException3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException3));
                    }
                    if (this.session != null && this.session.connection != null) {
                        this.session.connection.deliverExceptionCheck(jMSException3);
                    }
                    throw jMSException3;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (mQQueue != null) {
                        mQQueue.close();
                    }
                }
                catch (MQException mQException) {
                    // empty catch block
                }
                if (Trace.isOn) {
                    Trace.exit(this, "backoutRequeue");
                }
                throw throwable;
            }
        }
    }

    private void deadLetter(MQJMSMessage mQJMSMessage, int n) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "deadLetter");
        }
        MQMessage mQMessage = null;
        String string = null;
        String string2 = null;
        MQQueue mQQueue = null;
        MQQueue mQQueue2 = null;
        try {
            if (this.mqDLQName == null) {
                this.mqDLQName = Utils.inquireString((MQManagedObject)this.session.qm, 2006);
            }
            if (Trace.isOn) {
                Trace.trace(this, "DLQ = <" + this.mqDLQName + ">");
            }
            if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unable to find DLQ name - is one defined?");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                throw jMSException;
            }
            if ((mQJMSMessage.getReport() & 0x7000000) != 0) {
                mQMessage = this.generateReport(mQJMSMessage, n);
                string = mQJMSMessage.getReplyToQueueName().trim();
                string2 = mQJMSMessage.getReplyToQueueManagerName().trim();
            }
            if (Trace.isOn) {
                Trace.trace(this, "Constructing DLH");
            }
            DLH dLH = new DLH();
            dLH.reason = n;
            dLH.destQName = this.queue.name;
            dLH.destQMgrName = this.session.qm.name;
            dLH.putApplType = 28;
            dLH.putApplName = "MQ JMS Message Consumer";
            object = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            dLH.putDate = Utils.getDate((GregorianCalendar)object);
            dLH.putTime = Utils.getTime((GregorianCalendar)object);
            MQMessage mQMessage2 = new MQMessage();
            dLH.write(mQMessage2, mQJMSMessage);
            int n2 = 8720;
            mQQueue = this.session.qm.accessQueue(this.mqDLQName, n2, this.session.qm.name, null, null);
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options = 514;
            mQPutMessageOptions.contextReference = this.queue;
            mQQueue.put(mQMessage2, mQPutMessageOptions);
            if (mQMessage != null) {
                try {
                    n2 = 8720;
                    mQQueue2 = this.session.qm.accessQueue(string, n2, string2, null, null);
                    mQPutMessageOptions = new MQPutMessageOptions();
                    mQPutMessageOptions.options = 514;
                    mQPutMessageOptions.contextReference = this.queue;
                    mQQueue2.put(mQMessage, mQPutMessageOptions);
                }
                catch (MQException mQException) {
                    dLH.destQName = string;
                    dLH.destQMgrName = string2;
                    dLH.reason = mQException.reasonCode;
                    dLH.write(mQMessage);
                    mQQueue.put(mQMessage, mQPutMessageOptions);
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to dead-letter has disappeared! Continue as normal");
                }
            }
            if (mQJMSMessage != null && mQJMSMessage.getPersistence() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                if (Trace.isOn()) {
                    Trace.trace(this, "backing out attempt to send Report message");
                }
                if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "Unable to backout Report message as session is transacted or Client Ack");
                    }
                } else {
                    if (Trace.isOn()) {
                        Trace.trace(this, "backing out Report message");
                    }
                    this.session.qm.backout();
                }
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.exit(this, "deadLetter");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)jMSException);
                Trace.exit(this, "deadLetter");
            }
            if (mQJMSMessage != null && mQJMSMessage.getPersistence() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                if (Trace.isOn()) {
                    Trace.trace(this, "backing out attempt to DLQ message");
                }
                if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "Unable to backout DLQ'd message as session is transacted or Client Ack");
                    }
                } else {
                    if (Trace.isOn()) {
                        Trace.trace(this, "backing out DLQ'd message");
                    }
                    this.session.qm.backout();
                }
            }
            catch (MQException mQException) {
                // empty catch block
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        try {
            if (mQQueue != null) {
                mQQueue.close();
            }
            if (mQQueue2 != null) {
                mQQueue2.close();
            }
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn()) {
                    Trace.trace(this, "Unable to commit requeued message as session is transacted or Client Ack");
                }
            } else {
                if (Trace.isOn()) {
                    Trace.trace(this, "commiting requeued message");
                }
                this.session.qm.commit();
            }
        }
        catch (MQException mQException) {
            object = ConfigEnvironment.newException("MQJMS1079");
            object.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)object);
                Trace.exception(this, "deadLetter - linked exception: ", (Throwable)mQException);
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck((JMSException)((Object)object));
            }
            throw object;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deadLetter");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQMessage generateReport(MQJMSMessage mQJMSMessage, int n) throws JMSException {
        MQMessage mQMessage;
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, "generateReport");
            }
            mQMessage = new MQMessage();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                mQMessage.report = 0;
                mQMessage.messageType = 4;
                mQMessage.expiry = -1;
                mQMessage.feedback = n;
                mQMessage.encoding = mQJMSMessage.getEncoding();
                mQMessage.characterSet = mQJMSMessage.getCharacterSet();
                mQMessage.format = mQJMSMessage.getFormat();
                mQMessage.priority = mQJMSMessage.getPriority();
                mQMessage.persistence = mQJMSMessage.getPersistence();
                if ((mQJMSMessage.getReport() & 0x80) == 128) {
                    mQMessage.messageId = mQJMSMessage.getMessageId();
                }
                mQMessage.correlationId = (mQJMSMessage.getReport() & 0x40) == 64 ? mQJMSMessage.getCorrelationId() : mQJMSMessage.getMessageId();
                mQMessage.backoutCount = 0;
                mQMessage.replyToQueueName = "";
                mQMessage.replyToQueueManagerName = this.session.qm.name;
                mQMessage.putApplicationType = 28;
                mQMessage.putApplicationName = "MQ JMS Message Consumer";
                if ((mQJMSMessage.getReport() & 0x7000000) == 0x7000000) {
                    byte[] byArray = new byte[mQJMSMessage.getMessageDataLength()];
                    byArray = mQJMSMessage.getMessageData();
                    mQMessage.write(byArray);
                    break block18;
                }
                if ((mQJMSMessage.getReport() & 0x3000000) != 0x3000000) break block18;
                boolean bl = false;
                String string = mQJMSMessage.getFormat();
                int n2 = mQJMSMessage.getCharacterSet();
                int n3 = mQJMSMessage.getEncoding();
                int n4 = 0;
                try {
                    if (string.startsWith("MQH")) {
                        mQJMSMessage.writeTo(dataOutputStream, n2, true);
                        n4 = dataOutputStream.size();
                        break block18;
                    }
                    if (string.equals("MQDEAD  ")) {
                        n4 = 172;
                        break block18;
                    }
                    if (string.equals("MQXMIT  ")) {
                        n4 = 428;
                    } else if (!string.equals("MQCICS  ")) {
                        // empty if block
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                jMSException.setLinkedException((Exception)iOException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + iOException);
                    Trace.exit(this, "generateReport");
                }
                if (this.session != null && this.session.connection != null) {
                    this.session.connection.deliverExceptionCheck(jMSException);
                }
                throw jMSException;
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    Trace.exit(this, "generateReport");
                }
                if (this.session != null && this.session.connection != null) {
                    this.session.connection.deliverExceptionCheck(jMSException);
                }
                throw jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "generateReport");
        }
        return mQMessage;
    }

    void removeBadMessage(MQJMSMessage mQJMSMessage, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeBadMessage");
        }
        try {
            if ((mQJMSMessage.getReport() & 0x8000000) == 0x8000000) {
                if (Trace.isOn) {
                    Trace.trace(this, "Discarding message as per MQMD.Report");
                }
                this.discard(mQJMSMessage, n);
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Dead-lettering message as per MQMD.Report");
                }
                this.deadLetter(mQJMSMessage, n);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeBadMessage");
            }
        }
    }

    private void discard(MQJMSMessage mQJMSMessage, int n) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "discard");
        }
        MQJMSMessage mQJMSMessage2 = mQJMSMessage;
        MQMessage mQMessage = null;
        try {
            if ((mQJMSMessage2.getReport() & 0x7000000) != 0) {
                mQMessage = this.generateReport(mQJMSMessage2, n);
                String string = mQJMSMessage2.getReplyToQueueName().trim();
                object = mQJMSMessage2.getReplyToQueueManagerName().trim();
                try {
                    int n2 = 8720;
                    MQQueue mQQueue = this.session.qm.accessQueue(string, n2, (String)object, null, null);
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    mQPutMessageOptions.options = 514;
                    mQPutMessageOptions.contextReference = this.queue;
                    mQQueue.put(mQMessage, mQPutMessageOptions);
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Could not put report message to replyToQ");
                        Trace.exception(this, "discard", (Throwable)mQException);
                        Trace.trace(this, "Attempting to put to DLQ instead");
                    }
                    if (this.mqDLQName == null) {
                        this.mqDLQName = Utils.inquireString((MQManagedObject)this.session.qm, 2006);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "DLQ = <" + this.mqDLQName + ">");
                    }
                    if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Unable to find DLQ name - is one defined?");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                        throw jMSException;
                    }
                    DLH dLH = new DLH();
                    dLH.reason = mQException.reasonCode;
                    dLH.destQName = string;
                    dLH.destQMgrName = object;
                    dLH.putApplType = 28;
                    dLH.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dLH.putDate = Utils.getDate(gregorianCalendar);
                    dLH.putTime = Utils.getTime(gregorianCalendar);
                    dLH.write(mQMessage);
                    int n3 = 8720;
                    MQQueue mQQueue = this.session.qm.accessQueue(this.mqDLQName, n3, this.session.qm.name, null, null);
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    mQPutMessageOptions.options = 514;
                    mQPutMessageOptions.contextReference = this.queue;
                    mQQueue.put(mQMessage, mQPutMessageOptions);
                    mQQueue.close();
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to discard has disappeared! Continue as normal");
                }
            }
            if (mQJMSMessage2 != null && mQJMSMessage2.getPersistence() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "Unable to backout the message as session is transacted or Client Ack");
                    }
                } else {
                    if (Trace.isOn()) {
                        Trace.trace(this, "backing out the message");
                    }
                    this.session.qm.backout();
                }
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1082");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)jMSException);
            }
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
            if (mQJMSMessage2 != null && mQJMSMessage2.getPersistence() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                    if (Trace.isOn()) {
                        Trace.trace(this, "Unable to backout the message as session is transacted or Client Ack");
                    }
                } else {
                    if (Trace.isOn()) {
                        Trace.trace(this, "backing out the message");
                    }
                    this.session.qm.backout();
                }
            }
            catch (MQException mQException) {
                // empty catch block
            }
            if (this.session != null && this.session.connection != null) {
                this.session.connection.deliverExceptionCheck(jMSException);
            }
            throw jMSException;
        }
        try {
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn()) {
                    Trace.trace(this, "Unable to commit the report message as session is transacted or Client Ack");
                }
            } else {
                if (Trace.isOn()) {
                    Trace.trace(this, "commiting the report message");
                }
                this.session.qm.commit();
            }
        }
        catch (MQException mQException) {
            object = ConfigEnvironment.newException("MQJMS1082");
            object.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + (Object)object);
                Trace.trace(this, "linked exception: " + (Object)((Object)mQException));
            }
            throw object;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
        }
    }

    static {
        String string;
        CHUNKTIME = 5000;
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, sccsid);
        }
        if ((string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.ChunkTime");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        })) != null) {
            try {
                CHUNKTIME = Integer.parseInt(string);
                if (CHUNKTIME < 5000) {
                    CHUNKTIME = 5000;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, "CHUNKTIME value set to = " + CHUNKTIME);
        }
    }
}

