/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.matching.MatchTarget;
import com.ibm.mq.jms.ConnectionBrowser;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.MessageReferenceHandler;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class MQConnectionBrowser
extends MatchTarget
implements ConnectionBrowser {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQConnectionBrowser.java, jms, j600, j600-202-070608 1.20.1.2 07/02/28 08:48:28";
    private MQConnection connection;
    private MQDestination dest;
    private MessageReferenceHandler mrh;
    private int quantityHint;
    private String mqQueueName;
    private MQMessageSelector messageSelector = new MQMessageSelector();
    private MQQueueAgent agent;
    private boolean qAgentActive = false;
    private Object qaLock = new Object();
    private boolean pubSub = false;
    private boolean isDurable = false;
    private byte[] correlId = null;
    private boolean correlIdAsIdentity = true;
    private MQTemporaryTopic tempTopic = null;
    private MQSubscription mqsub = null;
    ReceiverFlag receiveFlag = new ReceiverFlag();
    private JMSException jmsException;
    private static int matchTargetCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQConnectionBrowser(MQConnection mQConnection, MQDestination mQDestination, String string, MessageReferenceHandler messageReferenceHandler, int n) throws JMSException {
        super(4, "JMSND:browser" + Integer.toString(++matchTargetCount));
        try {
            if (Trace.isOn) {
                Trace.entry(this, "Constructor");
                Trace.trace(this, "Already returned from parent constructor.");
            }
            this.MQConnectionBrowserInit(mQConnection, mQDestination, string, messageReferenceHandler, n, null);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQConnectionBrowser(MQConnection mQConnection, MQDestination mQDestination, String string, MessageReferenceHandler messageReferenceHandler, int n, String string2) throws JMSException {
        super(4, "JMS:" + string2);
        try {
            if (Trace.isOn) {
                Trace.entry(this, "Constructor", "name ='" + (null == string2 ? "null" : string2) + "'");
                Trace.trace(this, "Already passed to parent constructor.");
            }
            this.MQConnectionBrowserInit(mQConnection, mQDestination, string, messageReferenceHandler, n, string2);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Constructor");
            }
        }
    }

    private void MQConnectionBrowserInit(MQConnection mQConnection, MQDestination mQDestination, String string, MessageReferenceHandler messageReferenceHandler, int n, String string2) throws JMSException {
        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.tuning.QATVersion");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (string3 != null && !string3.equals("1") && !string3.equals("2")) {
            if (Trace.isOn) {
                Trace.trace(this, "Invalid value set for QATVersion");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "QATVersion", string3);
            throw jMSException;
        }
        try {
            String string4 = "";
            if (mQConnection == null || mQDestination == null || messageReferenceHandler == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "null parameter passed to ConnectionBrowser constructor");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1093", this);
                throw jMSException;
            }
            try {
                if (string != null) {
                    this.messageSelector.setSelector(string);
                }
            }
            catch (SyntaxException syntaxException) {
                String string5 = "MQJMS0004";
                String string6 = ConfigEnvironment.getErrorMessage(string5);
                InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string6, string5);
                invalidSelectorException.setLinkedException((Exception)syntaxException);
                throw invalidSelectorException;
            }
            if (Trace.isOn) {
                Trace.entry(this, "MQConnectionBrowserInit", "conn = " + mQConnection + ",\ndestination = " + mQDestination.getStringFromDestination() + ",\nselector = '" + (string == null ? "null" : string) + "',\nmrh = " + messageReferenceHandler + "',\nQuantity = " + Integer.toString(n) + ",\nname = '" + (string2 == null ? "null" : string2) + "'");
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Sanity test 1. (Connection/Destination)");
                }
                if (mQConnection instanceof MQQueueConnection && mQDestination instanceof MQTopic || mQConnection instanceof MQTopicConnection && mQDestination instanceof MQQueue) {
                    throw ConfigEnvironment.newException("MQJMS1077");
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Sanity test 1. passed");
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Sanity test 2. (quantityHint)");
                }
                if (n < 0 || n > 2) {
                    throw ConfigEnvironment.newException("MQJMS1094");
                }
                if (Trace.isOn) {
                    Trace.trace(this, "sanity test 2. passed");
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    Trace.exit(this, "MQConnectionBrowserInit (via exception)");
                }
                throw jMSException;
            }
            try {
                this.connection = mQConnection;
                this.dest = mQDestination;
                this.mrh = messageReferenceHandler;
                this.quantityHint = n;
                if (mQDestination instanceof MQTopic) {
                    this.mqQueueName = this.pubSubSetup((MQTopic)mQDestination, this.messageSelector.getSelector(), string2);
                    if (Trace.isOn) {
                        Trace.trace(this, "Topic-based browser using queue '" + this.mqQueueName + "'");
                    }
                } else {
                    this.mqQueueName = ((MQQueue)mQDestination).getBaseQueueName();
                    this.correlIdAsIdentity = false;
                    if (Trace.isOn) {
                        Trace.trace(this, "Queue-based consumer using queue '" + this.mqQueueName + "'");
                    }
                }
                this.agent = MQQueueAgent.getQueueAgent(this.connection, mQDestination, this.mqQueueName, this.correlIdAsIdentity);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "MQConnectionBrowserInit", (Throwable)jMSException);
                }
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving by exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "MQConnectionBrowserInit");
            }
        }
    }

    private String pubSubSetup(MQTopic mQTopic, String string, String string2) throws JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "pubSubSetup");
            }
            this.pubSub = true;
            boolean bl = true;
            String string3 = mQTopic.getBaseTopicName();
            MQConnection mQConnection = this.connection;
            MQSubscriptionEngine mQSubscriptionEngine = mQConnection.getSubscriptionEngine();
            String string4 = null;
            if (string2 == null) {
                string4 = MQSubscriptionEngine.validateQueueName(mQConnection.getBrkCCSubQueue(), 0);
                if (Trace.isOn) {
                    Trace.trace(this, "Non-durable Browser on '" + string4 + "'");
                }
            } else {
                string4 = MQSubscriptionEngine.validateQueueName(mQTopic.getBrokerCCDurSubQueue(), 1);
                if (Trace.isOn) {
                    Trace.trace(this, "Durable Browser on '" + string4 + "'");
                }
            }
            if (string4.endsWith("*")) {
                bl = false;
                this.correlIdAsIdentity = false;
            } else {
                bl = true;
                this.correlIdAsIdentity = true;
            }
            if (mQTopic instanceof MQTemporaryTopic) {
                this.tempTopic = (MQTemporaryTopic)mQTopic;
                this.tempTopic.usageUp();
            }
            if (string2 == null) {
                this.isDurable = false;
                object = this.connection.getCBBrokerSession();
                this.mqsub = mQSubscriptionEngine.openSubscription((MQSession)object, mQTopic, string, false, bl, string4);
            } else {
                this.isDurable = true;
                object = this.connection.getCBBrokerSession();
                this.mqsub = mQSubscriptionEngine.openDurableSubscription((MQSession)object, mQTopic, string, false, bl, string4, string2);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Topic-based browser using queue '" + this.mqsub.getQueueName() + "'");
                Trace.trace(this, "This queue is" + (!bl ? " NOT" : "") + " SHARED");
                Trace.trace(this, "CorrelId '" + Utils.bytesToHex(this.mqsub.getCorrelationId()) + "'");
                Trace.trace(this, "The subscription is " + (!this.isDurable ? "NON-" : "") + "DURABLE");
            }
            object = this.mqsub.getQueueName();
            return object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "pubSubSetup throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "Linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "pubSubSetup");
            }
        }
    }

    public void update(MessageReference messageReference) throws JMSException {
        try {
            if (messageReference == null) {
                throw new JMSException("MQJMS1100");
            }
            if (Trace.isOn) {
                Trace.entry(this, "update", "mr = '" + messageReference + "'");
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "update");
            }
        }
    }

    void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "start");
        }
        this.jmsException = null;
        if (this.connection.getMessageRetention() == 1) {
            this.agent.addBrowser(this, true);
        } else {
            this.agent.addBrowser(this, false);
        }
        if (Trace.isOn) {
            Trace.exit(this, "start");
        }
    }

    void stop() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "stop");
            }
            this.agent.removeBrowser(this);
            this.checkException();
            this.endDeliver();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "stop");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateQueueAgent() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "activateQueueAgent");
            }
            boolean bl = false;
            Object object = this.qaLock;
            synchronized (object) {
                if (!this.qAgentActive) {
                    bl = true;
                    this.qAgentActive = true;
                }
            }
            if (bl) {
                this.agent.activate(this.connection);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "activateQueueAgent");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivateQueueAgent() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "deactivateQueueAgent");
        }
        boolean bl = false;
        Object object = this.qaLock;
        synchronized (object) {
            if (this.qAgentActive) {
                bl = true;
                this.qAgentActive = false;
            }
        }
        if (bl) {
            this.agent.deactivate();
        }
        if (Trace.isOn) {
            Trace.exit(this, "deactivateQueueAgent");
        }
    }

    public void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            this.deactivateQueueAgent();
            this.connection.removeBrowser(this);
            try {
                if (this.agent != null) {
                    this.agent.removeBrowser(this);
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "MQQueueAgentThread produced exception:");
                    Trace.exception(this, "close", (Throwable)jMSException);
                    if (this.jmsException != null) {
                        // empty if block
                    }
                }
                this.jmsException = jMSException;
            }
            if (this.pubSub) {
                try {
                    this.mqsub.close();
                }
                catch (JMSException jMSException) {
                    Trace.trace(this, "Exception thrown closing subscription");
                    throw jMSException;
                }
            }
            this.mrh.endDeliver();
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (Trace.isOn) {
                Trace.trace(this, "Connection = " + this.connection);
                Trace.trace(this, "Destination = " + this.dest);
                Trace.trace(this, "Selector = " + this.messageSelector.getSelector());
                Trace.trace(this, "Quantity = " + this.quantityHint);
            }
            stringBuffer.append("Connection to '");
            stringBuffer.append((null == this.connection.qmgrName ? "null" : this.connection.qmgrName) + "'\n");
            stringBuffer.append("Destination = '");
            stringBuffer.append(this.dest.getStringFromDestination() + "'\n");
            stringBuffer.append("Selector    = '");
            stringBuffer.append(this.messageSelector.getSelector() + "'\n");
            stringBuffer.append("Quantity    =  " + this.quantityHint);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.exception(this, "toString", (Throwable)exception);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deliver(MQMessageReference mQMessageReference) {
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "deliver", "messageRef =\n" + mQMessageReference.toString());
        }
        try {
            MQConnectionBrowser mQConnectionBrowser = this;
            synchronized (mQConnectionBrowser) {
                if (null == this.mrh && Trace.isOn) {
                    Trace.trace(this, "MRH is null!");
                }
                try {
                    this.mrh.handleMessageReference(mQMessageReference);
                }
                catch (RuntimeException runtimeException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Caught RuntimeException from MessageReferenceHandler: " + runtimeException);
                        Trace.exception(this, "deliver", (Throwable)runtimeException);
                        Trace.trace(this, "Not throwing exception. Message should be redelivered after timeout");
                    }
                    throw runtimeException;
                }
            }
            boolean bl2 = bl = true;
            return bl2;
        }
        catch (RuntimeException runtimeException) {
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deliver");
            }
        }
    }

    void setException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "setException");
        }
        this.jmsException = jMSException;
        if (Trace.isOn) {
            Trace.exit(this, "setException");
        }
    }

    JMSException getException() {
        return this.jmsException;
    }

    void checkException() throws JMSException {
        if (this.jmsException != null) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)this.jmsException));
            }
            throw this.jmsException;
        }
    }

    MQConnection getConnection() {
        return this.connection;
    }

    void endDeliver() {
        if (Trace.isOn) {
            Trace.entry(this, "endDeliver");
        }
        this.mrh.endDeliver();
        if (Trace.isOn) {
            Trace.exit(this, "endDeliver");
        }
    }

    boolean isPubSub() {
        return this.pubSub;
    }

    byte[] getCorrelId() {
        if (this.mqsub != null) {
            return this.mqsub.getCorrelationId();
        }
        return null;
    }

    void setSelectorString(String string) throws InvalidSelectorException {
        try {
            this.messageSelector.setSelector(string);
        }
        catch (SyntaxException syntaxException) {
            String string2 = "MQJMS0004";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string3, string2);
            invalidSelectorException.setLinkedException((Exception)syntaxException);
            throw invalidSelectorException;
        }
    }

    String getSelectorString() {
        return this.messageSelector.getSelector();
    }

    MQMessageSelector getMessageSelector() {
        return this.messageSelector;
    }

    MessageReferenceHandler getMessageReferenceHandler() {
        return this.mrh;
    }

    int getQuantityHint() {
        return this.quantityHint;
    }

    class ReceiverFlag {
        boolean receiving = false;

        ReceiverFlag() {
        }
    }
}

