/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.Cleanup;
import com.ibm.mq.jms.CleanupHandle;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQBrokerSubscription;
import com.ibm.mq.jms.MQBrokerSubscriptionList;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mqservices.MQInternalException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQBrokerSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQBrokerSubscriptionEngine.java, jms, j600, j600-201-070220 1.82.1.9 07/02/16 15:16:24";
    private int WSClone = 0;
    private static MQBrokerSubscriptionList localSubscriptions;
    private CleanupHandle cleanupHandle;
    private int SLEEPTIME = 3000;

    public MQBrokerSubscriptionEngine(MQConnection mQConnection, MQConnectionFactory mQConnectionFactory, String string) throws JMSException {
        super(mQConnection);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.WSClone = mQConnectionFactory.getCloneSupport();
        if (localSubscriptions == null && this.WSClone == 1) {
            localSubscriptions = new MQBrokerSubscriptionList();
        }
        Hashtable hashtable = mQConnection.mqProperties;
        this.cleanupHandle = CleanupHandle.createCleanupHandle(mQConnectionFactory, string, hashtable);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public MQSubscription openSubscription(MQSession mQSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2) throws JMSException {
        MQBrokerSubscription mQBrokerSubscription = null;
        MQQueue mQQueue = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = this.escapeString(this.getMQConnection().getClientID());
        String string4 = this.escapeString(string);
        int n = 65536;
        MQMsg2 mQMsg2 = new MQMsg2();
        MQBrokerMessage mQBrokerMessage = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription");
        }
        int n2 = 1;
        if (mQTopic != null) {
            n2 = mQTopic.getFailIfQuiesce();
        } else if (mQSession != null) {
            n2 = mQSession.getFailIfQuiesce();
        }
        try {
            if (bl2) {
                n |= 1;
            }
            mQBrokerSubscription = new MQBrokerSubscription(this, mQSession, false, bl2, mQSession.qm.name, string3, null, mQTopic, string, bl, string2, null, null);
            mQQueue = this.openSubscriberQueue(mQSession, string2, bl2, false, n2);
            mQBrokerSubscription.setSubscriberQueue(mQQueue);
            mQBrokerSubscription.setQueueName(mQQueue.name);
            try {
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions(true);
                if (bl2) {
                    mQPutMessageOptions.options += 128;
                }
                if (n2 == 1) {
                    mQPutMessageOptions.options |= 0x2000;
                }
                byArray = this.setDeferredMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, mQPutMessageOptions);
                byArray2 = mQMsg2.getMessageId();
                if (Trace.isOn) {
                    Trace.trace(this, "Put deferred message, correID = '" + Utils.bytesToHex(byArray) + "'");
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "openSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            try {
                mQMsg2 = new MQMsg2();
                mQBrokerSubscription.setCorrelationId(byArray);
                if (bl2) {
                    mQMsg2.setCorrelationId(byArray);
                    n |= 1;
                }
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                this.sendBrokerMessage(mQBrokerSubscription, "RegSub", n, mQMsg2, null);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "openSubscription", (Throwable)jMSException);
                }
                bl3 = false;
                bl4 = true;
                throw jMSException;
            }
            try {
                if (this.getMQConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH1 Message from broker");
                    }
                    mQBrokerMessage = new RFH1BrokerMessageImpl();
                    mQBrokerMessage = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH2 Message from broker");
                    }
                    mQBrokerMessage = new RFH2BrokerMessageImpl();
                    mQBrokerMessage = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                }
                int n3 = 0;
                String string5 = null;
                JMSException jMSException = null;
                switch (Integer.parseInt(mQBrokerMessage.get("MQPSCompCode"))) {
                    case 1: {
                        bl3 = true;
                        bl4 = true;
                        n3 = Integer.parseInt(mQBrokerMessage.get("MQPSReason"));
                        string5 = mQBrokerMessage.get("MQPSReasonText");
                        jMSException = new BrokerCommandFailedException("Broker command failed: " + string5 + " Reason code " + n3);
                        ((BrokerCommandFailedException)jMSException).setReason(n3);
                        if (Trace.isOn) {
                            Trace.exception(this, "openSubscription", (Throwable)jMSException);
                        }
                        throw jMSException;
                    }
                    case 2: {
                        bl3 = false;
                        bl4 = true;
                        n3 = Integer.parseInt(mQBrokerMessage.get("MQPSReason"));
                        string5 = mQBrokerMessage.get("MQPSReasonText");
                        BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string5 + " Reason code " + n3);
                        brokerCommandFailedException.setReason(n3);
                        if (Trace.isOn) {
                            Trace.exception(this, "openSubscription", (Throwable)((Object)brokerCommandFailedException));
                        }
                        if (n3 == 2035) {
                            // empty if block
                        }
                        throw brokerCommandFailedException;
                    }
                    case 0: {
                        if (Trace.isOn) {
                            Trace.trace(this, "non-durable RegSub command processed ok");
                        }
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    default: {
                        bl3 = true;
                        bl4 = true;
                        if (Trace.isOn) {
                            Trace.trace(this, "unrecognized completion code: " + mQBrokerMessage.get("MQPSCompCode"));
                        }
                        jMSException = ConfigEnvironment.newException("MQJMS1087", "MQRCCF: " + mQBrokerMessage.get("MQPSCompCode"));
                        if (Trace.isOn) {
                            Trace.exception(this, "openSubscription", (Throwable)jMSException);
                        }
                        throw jMSException;
                    }
                }
            }
            catch (NoBrokerResponseException noBrokerResponseException) {
                bl3 = true;
                bl4 = true;
                throw noBrokerResponseException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "openSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            mQBrokerSubscription.setDeferredMsgId(byArray2);
        }
        catch (JMSException jMSException) {
            if (bl3) {
                n = 1;
                mQMsg2.clearMessageData();
                this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
            }
            if (bl4) {
                this.cancelDeferredMessage(mQSession, byArray2);
            }
            if (mQQueue != null && mQQueue.isOpen()) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "deleting subscription queue");
                    }
                    if (!bl2) {
                        mQQueue.closeOptions = 2;
                    }
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "queue delete failed with " + (Object)((Object)mQException));
                    }
                    JMSException jMSException2 = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException2;
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "openSubscription");
            }
        }
        return mQBrokerSubscription;
    }

    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        int n = 0;
        MQMsg2 mQMsg2 = new MQMsg2();
        MQBrokerMessage mQBrokerMessage = null;
        MQQueue mQQueue = null;
        if (Trace.isOn) {
            Trace.entry(this, "closeSubscription");
        }
        try {
            if (!(mQSubscription instanceof MQBrokerSubscription)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
                throw jMSException;
            }
            MQBrokerSubscription mQBrokerSubscription = (MQBrokerSubscription)mQSubscription;
            if (mQBrokerSubscription.isClosed() || mQBrokerSubscription.getMQSession() == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "null or closed session. Subscription should already be closed. Returning");
                }
                return;
            }
            mQQueue = mQBrokerSubscription.getSubscriberQueue();
            n |= 0x10000;
            mQMsg2.setMessageType(1);
            mQMsg2.setReport(0);
            if (mQBrokerSubscription.isSharedQueue()) {
                ++n;
                mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
            }
            try {
                this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                if (mQBrokerSubscription.getMQSession() == null && Trace.isOn) {
                    Trace.trace(this, "session is null");
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "Error sending BrokerMessage: ", (Throwable)jMSException);
                }
                throw jMSException;
            }
            try {
                mQBrokerMessage = this.cleanupUnconsumedMessages(mQSubscription.getMQSession(), mQSubscription.isSharedQueue(), mQSubscription.getQueueName(), mQSubscription.getCorrelationId(), mQMsg2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "exception thrown dealing with broker response and subscriber queue cleanup");
                }
                throw jMSException;
            }
            if (mQSubscription.isSharedQueue() && mQQueue != null && mQQueue.isOpen()) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "closing subscription queue");
                    }
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "subscriber queue close failed with " + (Object)((Object)mQException));
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
            }
            try {
                this.cancelDeferredMessage(mQBrokerSubscription.getMQSession(), mQBrokerSubscription.getDeferredMsgId());
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "Error cancelling deferred MQPUT: ", (Throwable)jMSException);
                }
                throw jMSException;
            }
            return;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exit(this, "closeSubscription - via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeSubscription");
            }
        }
    }

    public MQSubscription openDurableSubscription(MQSession mQSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2, String string3) throws JMSException {
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        MQBrokerSubscription mQBrokerSubscription = null;
        MQBrokerSubscription mQBrokerSubscription2 = null;
        Object var16_16 = null;
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        int n = 0;
        MQMsg2 mQMsg2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        if (Trace.isOn) {
            Trace.entry(this, "openDurableSubscription");
            if (this.WSClone == 1) {
                Trace.trace(this, "WebSphere clones enabled");
            }
        }
        int n2 = 1;
        if (mQTopic != null) {
            n2 = mQTopic.getFailIfQuiesce();
        } else if (mQSession != null) {
            n2 = mQSession.getFailIfQuiesce();
        }
        try {
            String string15 = this.getMQConnection().getClientID();
            if (string15 == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                if (Trace.isOn) {
                    Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            mQBrokerSubscription = new MQBrokerSubscription(this, mQSession, true, bl2, mQSession.qm.name, string15, string3, mQTopic, string, bl, string2, null, null);
            string5 = this.escapeString(mQSession.qm.name);
            string6 = this.escapeString(this.getMQConnection().getClientID());
            string7 = this.escapeString(string3);
            string4 = "JMS:" + string5 + ":" + string6 + ":" + string7;
            if (Trace.isOn) {
                Trace.trace(this, "Fullname = '" + string4 + "'");
            }
            if (string != null && !string.trim().equals("")) {
                string8 = this.escapeString(string);
                string9 = "sel=\"" + string8 + "\"";
            } else {
                string9 = "";
            }
            try {
                String string16;
                if (Trace.isOn) {
                    Trace.trace(this, "Setting deferred message");
                }
                try {
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    mQBrokerMessage.set("MQPSCommand", "DeregSub");
                    mQBrokerMessage.set("MQPSTopic", mQTopic.getBaseTopicName());
                    mQBrokerMessage.setOption("MQPSRegOpts", "LeaveOnly");
                    mQBrokerMessage.setOption("MQPSRegOpts", "VariableUserId");
                    mQBrokerMessage.setOption("MQPSRegOpts", "FullResp");
                    mQBrokerMessage.setOption("MQPSRegOpts", "CorrelAsId");
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQSession.getSessionName()));
                    mQBrokerMessage.set("MQPSSubName", string4);
                    string16 = null;
                    string16 = mQBrokerSubscription.getFilter();
                    if (string16 != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting filter to " + string16);
                        }
                        mQBrokerMessage.set("MQPSFilter", string16);
                    }
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.exception(this, "openDurableSubscription - setting deferred message", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "creating put message options");
                }
                string16 = new MQPutMessageOptions(true);
                mQMsg2 = new MQMsg2();
                mQMsg2.setMessageType(8);
                ((MQPutMessageOptions)string16).options += 128;
                if (Trace.isOn) {
                    Trace.trace(this, "setting deferred message");
                }
                byArray = this.setDeferredMessage(mQSession, mQBrokerMessage, mQMsg2, (MQPutMessageOptions)string16, true, n2);
                byArray3 = mQMsg2.getMessageId();
                if (Trace.isOn) {
                    try {
                        Trace.trace(this, "got correlID = '" + byArray.toString() + "'");
                        Trace.dataTrace(1, this, byArray);
                        Trace.trace(this, "got MessgID  = '" + byArray3.toString() + "'");
                        Trace.dataTrace(1, this, byArray3);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "error putting deferred message", (Throwable)jMSException);
                }
                bl4 = false;
                bl5 = false;
                throw jMSException;
            }
            if (this.WSClone == 1) {
                try {
                    localSubscriptions.getSubscription(string4, mQSession);
                    bl7 = true;
                }
                catch (JMSException jMSException) {
                    bl4 = true;
                    bl5 = false;
                    bl6 = true;
                    throw jMSException;
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "attempting exclusive register");
                }
                n = 360448;
                ++n;
                mQBrokerSubscription.setCorrelationId(byArray);
                mQMsg2 = new MQMsg2();
                mQMsg2.setCorrelationId(byArray);
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                if (!bl2) {
                    mQBrokerSubscription.setQueueName("SYSTEM.JMS.D.SUBSCRIBER.QUEUE");
                    n |= 0x20;
                }
                this.sendBrokerMessage(mQBrokerSubscription, "RegSub", n, mQMsg2, null);
            }
            catch (JMSException jMSException) {
                bl4 = true;
                bl5 = false;
                bl6 = true;
                throw jMSException;
            }
            if (!bl2) {
                if (Trace.isOn) {
                    Trace.trace(this, "using dynamic queues. Checking initial broker response");
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "getting broker response");
                    }
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH1 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH2 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                    }
                }
                catch (JMSException jMSException) {
                    if (jMSException instanceof NoBrokerResponseException) {
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                    } else {
                        bl4 = true;
                        bl5 = false;
                        bl6 = false;
                    }
                    throw jMSException;
                }
                int n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                String string17 = mQBrokerMessage2.get("MQPSReasonText");
                if (n3 != 0 && (this.WSClone != 1 || n3 != 3155 && n3 != 3156)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "exclusive register failed");
                    }
                    bl4 = true;
                    bl5 = false;
                    bl6 = false;
                    n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                    string17 = mQBrokerMessage2.get("MQPSReasonText");
                    BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string17 + " Reason code " + n3);
                    brokerCommandFailedException.setReason(n3);
                    if (Trace.isOn) {
                        Trace.exception(this, "openDurableSubscription", (Throwable)((Object)brokerCommandFailedException));
                    }
                    throw brokerCommandFailedException;
                }
                string12 = mQBrokerMessage2.get("MQPSQName").trim();
                if (Trace.isOn) {
                    Trace.trace(this, "register succeeded to queue: " + string12);
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "attempting second exclusive register");
                    }
                    n = 327680;
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setCorrelationId(byArray);
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    if (string12.equals("SYSTEM.JMS.D.SUBSCRIBER.QUEUE")) {
                        mQBrokerSubscription.setSubscriberQueue(this.openSubscriberQueue(mQSession, string2, false, true, n2));
                        mQBrokerSubscription.setQueueName(mQBrokerSubscription.getSubscriberQueue().name.trim());
                        if (Trace.isOn) {
                            Trace.trace(this, "opened new dynamic queue: " + mQBrokerSubscription.getQueueName());
                        }
                        string2 = mQBrokerSubscription.getQueueName();
                    } else {
                        mQBrokerSubscription.setQueueName(string12);
                        string2 = mQBrokerSubscription.getQueueName();
                    }
                    this.sendBrokerMessage(mQBrokerSubscription, "RegSub", n, mQMsg2, null);
                }
                catch (JMSException jMSException) {
                    bl4 = true;
                    bl5 = false;
                    bl6 = true;
                    throw jMSException;
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "getting broker response");
                }
                if (this.getMQConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH1 Message from broker");
                    }
                    mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH2 Message from broker");
                    }
                    mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                }
            }
            catch (JMSException jMSException) {
                if (jMSException instanceof NoBrokerResponseException) {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                } else {
                    bl4 = true;
                    bl5 = false;
                    bl6 = false;
                }
                throw jMSException;
            }
            String string18 = mQBrokerMessage2.get("MQPSCorrelId");
            if (string18 != null) {
                byArray2 = Utils.hexToBytes(string18);
            }
            int n4 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
            String string19 = mQBrokerMessage2.get("MQPSReasonText");
            if (Trace.isOn) {
                Trace.trace(this, "got response from exclusive register");
            }
            switch (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"))) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "broker returned with warning");
                    }
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    if (n4 == 3157) {
                        if (!bl2) break;
                        bl5 = false;
                        bl4 = true;
                    } else {
                        bl5 = true;
                        bl4 = true;
                    }
                    bl6 = true;
                    BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string19 + " Reason code " + n4);
                    brokerCommandFailedException.setReason(n4);
                    if (Trace.isOn) {
                        Trace.exception(this, "Broker command returned warning: ", (Throwable)((Object)brokerCommandFailedException));
                    }
                    throw brokerCommandFailedException;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.trace(this, "broker command failed");
                    }
                    if (this.WSClone == 1 && (n4 == 3155 || n4 == 3156)) {
                        if (n4 == 3155) {
                            if (Trace.isOn) {
                                Trace.trace(this, "subscription already shared by another WebSphere clone");
                            }
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "subscription exclusively locked. Hopefully, this will change soon");
                            }
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Zzzzzzzzz");
                                }
                                Thread.sleep(this.SLEEPTIME);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Subscription in use by another clone.Re-trying with join shared");
                        }
                        mQBrokerSubscription.setCorrelationId(byArray2);
                        n = 229376;
                        if (bl2) {
                            ++n;
                        }
                        mQMsg2 = new MQMsg2();
                        mQMsg2.setCorrelationId(byArray);
                        mQMsg2.setMessageType(1);
                        mQMsg2.setReport(0);
                        this.sendBrokerMessage(mQBrokerSubscription, "RegSub", n, mQMsg2, null);
                        if (this.getMQConnection().getBrkVersion() == 0) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Receiving RFH1 Message from broker");
                            }
                            mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "Receiving RFH2 Message from broker");
                            }
                            mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                        }
                        int n5 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                        int n6 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                        if (n5 != 0 && (n5 != 1 || n6 != 3157)) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3050");
                            throw jMSException;
                        }
                        string10 = mQBrokerMessage2.get("MQPSSubName");
                        string11 = mQBrokerMessage2.get("MQPSQMgrName").trim();
                        string12 = mQBrokerMessage2.get("MQPSQName").trim();
                        string13 = mQBrokerMessage2.get("MQPSSubUserData");
                        if (string13 == null) {
                            string13 = "";
                        }
                        string13 = string13.trim();
                        string14 = mQBrokerMessage2.get("MQPSTopic").trim();
                        byArray2 = Utils.hexToBytes(mQBrokerMessage2.get("MQPSCorrelId"));
                        mQBrokerSubscription.setCorrelationId(byArray2);
                        if (Trace.isOn) {
                            Trace.trace(this, "subscription we are trying to join is:\n");
                            Trace.trace(this, string10);
                            Trace.trace(this, "Topic:    " + string14);
                            Trace.trace(this, "SubData:  " + string13);
                            Trace.trace(this, "QMgr:     " + string11);
                            Trace.trace(this, "Queue:    " + string12);
                            Trace.trace(this, "CorrelId: " + Utils.bytesToHex(byArray2));
                        }
                        if (!(mQSession.qm.name.equals(string11) && string2.equals(string12) && string9.equals(string13) && mQTopic.getBaseTopicName().equals(string14))) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3050");
                            if (Trace.isOn) {
                                Trace.trace(this, "subscription already in use by another clone and cannot beupdated");
                            }
                            bl4 = true;
                            bl5 = true;
                            bl6 = true;
                            throw jMSException;
                        }
                        mQBrokerSubscription2 = mQBrokerSubscription;
                        if (mQBrokerSubscription2.getSubscriberQueue() == null) {
                            mQBrokerSubscription2.setSubscriberQueue(this.openSubscriberQueue(mQSession, string2, bl2, true, n2));
                        }
                        mQBrokerSubscription2.setDeferredMsgId(byArray3);
                        if (Trace.isOn) {
                            Trace.trace(this, "got subscription with correlID '" + mQBrokerSubscription2.getCorrelationId().toString() + "'");
                        }
                        if (Trace.isOn) {
                            Trace.dataTrace(1, this, mQBrokerSubscription2.getCorrelationId());
                        }
                        MQBrokerSubscription mQBrokerSubscription3 = mQBrokerSubscription2;
                        return mQBrokerSubscription3;
                    }
                    bl4 = true;
                    bl5 = false;
                    bl6 = false;
                    n4 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                    string19 = mQBrokerMessage2.get("MQPSReasonText");
                    BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string19 + " Reason code " + n4);
                    brokerCommandFailedException.setReason(n4);
                    if (Trace.isOn) {
                        Trace.exception(this, "openDurableSubscription", (Throwable)((Object)brokerCommandFailedException));
                    }
                    throw brokerCommandFailedException;
                }
                case 0: {
                    if (!Trace.isOn) break;
                    Trace.trace(this, "got exclusive lock");
                    break;
                }
                default: {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    if (Trace.isOn) {
                        Trace.trace(this, "unrecognized completion code: " + mQBrokerMessage2.get("MQPSCompCode"));
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1087", "MQRCCF: " + mQBrokerMessage2.get("MQPSCompCode"));
                    if (Trace.isOn) {
                        Trace.exception(this, "unrecognized response", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
            }
            mQBrokerSubscription.setCorrelationId(byArray2);
            if (Trace.isOn) {
                try {
                    string10 = mQBrokerMessage2.get("MQPSSubName");
                }
                catch (Exception exception) {
                    Trace.trace(this, "Couldn't get subName: " + exception);
                }
                if (string10 == null) {
                    Trace.trace(this, "received null subName");
                } else {
                    string10 = string10.trim();
                    Trace.trace(this, "got subName         = '" + string10 + "'");
                }
                Trace.trace(this, "wanted subName      = '" + string4 + "'");
            }
            string11 = mQBrokerMessage2.get("MQPSQMgrName").trim();
            if (Trace.isOn) {
                Trace.trace(this, "got QueueManager    = '" + string11 + "'");
                Trace.trace(this, "wanted QueueManager = '" + string5 + "'");
            }
            string12 = mQBrokerMessage2.get("MQPSQName").trim();
            if (Trace.isOn) {
                Trace.trace(this, "got Queue           = '" + string12 + "'");
                Trace.trace(this, "wanted Queue        = '" + string2 + "'");
            }
            if ((string13 = mQBrokerMessage2.get("MQPSSubUserData")) == null) {
                string13 = "";
            }
            string13 = string13.trim();
            if (Trace.isOn) {
                Trace.trace(this, "got UserSubData      = '" + string13 + "'");
                Trace.trace(this, "wanted UserSubData   = '" + string9 + "'");
            }
            string14 = mQBrokerMessage2.get("MQPSTopic").trim();
            if (Trace.isOn) {
                Trace.trace(this, "got Topic            = '" + string14 + "'");
                Trace.trace(this, "wanted Topic         = '" + mQTopic.getBaseTopicName() + "'");
            }
            if (!mQSession.qm.name.equals(string11) || !string2.equals(string12)) {
                bl4 = true;
                bl5 = true;
                bl6 = true;
                String string20 = new String(mQSession.qm.name + ":" + string2);
                String string21 = new String(string11 + ":" + string12);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string20, string21);
                if (Trace.isOn) {
                    Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            if (!string9.equals(string13) || !mQTopic.getBaseTopicName().equals(string14)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Subscription exists, but requires updating");
                }
                try {
                    mQBrokerSubscription2 = this.updateDurableSubscription(mQBrokerSubscription, mQSession, mQTopic.getBaseTopicName(), string, false);
                }
                catch (JMSException jMSException) {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    throw jMSException;
                }
            } else if (mQBrokerMessage2.isOptionSet("MQPSRegOpts", 32)) {
                if (Trace.isOn) {
                    Trace.trace(this, "subscription needs to recover from previous update error");
                }
                try {
                    mQBrokerSubscription2 = this.updateDurableSubscription(mQBrokerSubscription, mQSession, mQTopic.getBaseTopicName(), string, true);
                }
                catch (JMSException jMSException) {
                    bl4 = true;
                    bl5 = true;
                    bl6 = true;
                    throw jMSException;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "subscription exists as requested.");
                }
                mQBrokerSubscription2 = mQBrokerSubscription;
            }
            if (this.WSClone == 1) {
                try {
                    n = 196608;
                    if (bl2) {
                        ++n;
                    }
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setCorrelationId(mQBrokerSubscription2.getCorrelationId());
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                }
                catch (Exception exception) {
                    JMSException jMSException;
                    if (exception instanceof JMSException) {
                        jMSException = (JMSException)((Object)exception);
                    } else {
                        jMSException = ConfigEnvironment.newException(exception.getMessage());
                        jMSException.setLinkedException(exception);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "error building  MQMsg2");
                        Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
                try {
                    this.sendBrokerMessage(mQBrokerSubscription2, "RegSub", n, mQMsg2, null);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error sending migrate to shared subscription message to broker");
                    }
                    throw jMSException;
                }
                mQBrokerMessage2 = this.getMQConnection().getBrkVersion() == 0 ? (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true) : (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, true);
                int n7 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                int n8 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                if (n7 != 0 && (n7 != 1 || n8 != 3157)) {
                    JMSException jMSException = ConfigEnvironment.newException(mQBrokerMessage2.get("MQPSReasonText"));
                    if (Trace.isOn) {
                        Trace.trace(this, "migrate to shared broker command failed" + mQBrokerMessage2.get("MQPSReasonText"));
                    }
                    throw jMSException;
                }
            }
            if (mQBrokerSubscription2.getSubscriberQueue() == null) {
                mQBrokerSubscription2.setSubscriberQueue(this.openSubscriberQueue(mQSession, string2, bl2, true, n2));
            }
            mQBrokerSubscription2.setDeferredMsgId(byArray3);
            if (Trace.isOn) {
                if (bl2) {
                    Trace.trace(this, "got subscription with correlID '" + mQBrokerSubscription2.getCorrelationId().toString() + "'");
                    Trace.dataTrace(1, this, mQBrokerSubscription2.getCorrelationId());
                } else {
                    Trace.trace(this, "got dynamic queue subscrpition");
                }
            }
            MQBrokerSubscription mQBrokerSubscription4 = mQBrokerSubscription2;
            return mQBrokerSubscription4;
        }
        catch (JMSException jMSException) {
            block180: {
                block179: {
                    if (Trace.isOn) {
                        Trace.trace(this, "cleaning up after exception");
                        Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                        if (bl4) {
                            Trace.trace(this, "must cancel deferred message");
                        }
                        if (bl5) {
                            Trace.trace(this, "must cancel register broker command");
                        }
                        if (!bl6) {
                            Trace.trace(this, "closing subscriber queue");
                        }
                    }
                    boolean bl8 = false;
                    if (bl5) {
                        try {
                            n = 524288;
                            mQMsg2.clearMessageData();
                            mQMsg2.setMessageType(8);
                            this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                        }
                        catch (JMSException jMSException2) {
                            if (Trace.isOn) {
                                Trace.exception(this, "openDurableSubscription - canceling register command", (Throwable)jMSException2);
                            }
                            bl8 = true;
                        }
                    }
                    if (bl4) {
                        try {
                            this.cancelDeferredMessage(mQSession, byArray3);
                        }
                        catch (JMSException jMSException3) {
                            if (Trace.isOn) {
                                Trace.exception(this, "openDurableSubscription - cancelling deferred message", (Throwable)jMSException3);
                            }
                            bl8 = true;
                        }
                    }
                    if (var16_16 != null && var16_16.isOpen() && !bl6) {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "deleting subscription queue");
                            }
                            if (!bl2) {
                                var16_16.closeOptions = 2;
                            }
                            var16_16.close();
                        }
                        catch (MQException mQException) {
                            if (!Trace.isOn) break block179;
                            Trace.exception(this, "queue delete failed with ", (Throwable)mQException);
                        }
                    }
                }
                if (this.WSClone == 1 && bl7) {
                    try {
                        localSubscriptions.removeSubscription(string4);
                    }
                    catch (Exception exception) {
                        if (!Trace.isOn) break block180;
                        Trace.trace(this, "error encountered while removing subscription entry from localSubscriptions table");
                        Trace.exception(this, "openDurableSubscription", (Throwable)exception);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "openDurableSubscription - from exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "openDurableSubscription");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        int n = 0;
        MQMsg2 mQMsg2 = new MQMsg2();
        MQQueue mQQueue = null;
        if (Trace.isOn) {
            Trace.entry(this, "closeDurableSubscription");
        }
        try {
            block23: {
                try {
                    try {
                        if (!(mQSubscription instanceof MQBrokerSubscription)) {
                            JMSException jMSException = new JMSException("MQJMS3049");
                            throw jMSException;
                        }
                        MQBrokerSubscription mQBrokerSubscription = (MQBrokerSubscription)mQSubscription;
                        n += 524288;
                        mQMsg2.setMessageType(8);
                        try {
                            this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.trace(this, "Error sending BrokerMessage: ");
                            throw jMSException;
                        }
                        try {
                            this.cancelDeferredMessage(mQBrokerSubscription.getMQSession(), mQBrokerSubscription.getDeferredMsgId());
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.trace(this, "Error cancelling deferred MQPUT: ");
                            throw jMSException;
                        }
                        mQQueue = mQBrokerSubscription.getSubscriberQueue();
                        if (mQQueue != null && mQQueue.isOpen()) {
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "closing subscription queue");
                                }
                                mQQueue.close();
                            }
                            catch (MQException mQException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "queue close failed with " + (Object)((Object)mQException));
                                }
                                jMSException = ConfigEnvironment.newException("MQJMS2000");
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                        }
                        Object var9_13 = null;
                        if (this.WSClone != 1) return;
                        if (!Trace.isOn) break block23;
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "exception thrown while attempting to close durable subscription");
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (this.WSClone != 1) throw throwable;
                    if (Trace.isOn) {
                        Trace.trace(this, "attempting to remove localSubscription entry");
                    }
                    localSubscriptions.removeSubscription(((MQBrokerSubscription)mQSubscription).getEscapedFullName());
                    throw throwable;
                }
                Trace.trace(this, "attempting to remove localSubscription entry");
            }
            localSubscriptions.removeSubscription(((MQBrokerSubscription)mQSubscription).getEscapedFullName());
            return;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exception(this, "closeDurableSubscription", (Throwable)jMSException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeDurableSubscription");
            }
        }
    }

    public void durableUnsubscribe(MQSession mQSession, String string) throws JMSException {
        int n = 0;
        MQMsg2 mQMsg2 = new MQMsg2();
        BrokerConnectionInfo brokerConnectionInfo = mQSession.getBrk();
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        boolean bl = false;
        byte[] byArray3 = null;
        String string6 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string7 = new String("JMS:SYS:Unknown");
        Object var21_21 = null;
        if (Trace.isOn) {
            Trace.entry(this, "durableUnsubscribe");
        }
        try {
            String string8;
            try {
                try {
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating new RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating new RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    string2 = "JMS:" + this.escapeString(mQSession.qm.name) + ":" + this.escapeString(this.getMQConnection().getClientID()) + ":" + this.escapeString(string);
                    mQBrokerMessage.set("MQPSCommand", "DeregSub");
                    mQBrokerMessage.set("MQPSSubName", string2);
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQSession.getSessionName()));
                    n = 589824;
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    if (mQSession.qm.name != null) {
                        mQBrokerMessage.set("MQPSQMgrName", mQSession.qm.name);
                    }
                    mQMsg2.setMessageType(8);
                    mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Couldn't construct brokerMessage:");
                    }
                    if (exception instanceof JMSException) {
                        throw (JMSException)((Object)exception);
                    }
                    JMSException jMSException = new JMSException("MQJMS3008");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    byArray = this.setDeferredMessage(mQSession, mQBrokerMessage, mQMsg2, null, true, 0);
                    byArray2 = mQMsg2.getMessageId();
                    if (byArray == null && Trace.isOn) {
                        Trace.trace(this, "Queue manager does not support deferred messages");
                    }
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Could not send brokerMessage with deferred MQPUT");
                    }
                    throw jMSException;
                }
            }
            catch (JMSException jMSException) {
                bl2 = false;
                bl3 = false;
                throw jMSException;
            }
            try {
                mQBrokerMessage.clear();
                mQBrokerMessage.set("MQPSCommand", "RegSub");
                mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQSession.getSessionName()));
                mQBrokerMessage.set("MQPSSubName", string2);
                mQBrokerMessage.set("MQPSTopic", string7);
                n = 360448;
                mQBrokerMessage.setOption("MQPSRegOpts", n);
                mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                if (mQSession.qm.name != null) {
                    mQBrokerMessage.set("MQPSQMgrName", mQSession.qm.name);
                }
                mQMsg2 = new MQMsg2();
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                this.sendBrokerMessage(mQSession, mQBrokerMessage, mQMsg2, null, true);
                try {
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH1 Message from broker");
                        }
                        mQBrokerMessage2 = new RFH1BrokerMessageImpl();
                        mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, false);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH2 Message from broker");
                        }
                        mQBrokerMessage2 = new RFH2BrokerMessageImpl();
                        mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQSession, mQMsg2, false);
                    }
                }
                catch (JMSException jMSException) {
                    if (jMSException instanceof NoBrokerResponseException) {
                        mQBrokerMessage2 = null;
                    } else {
                        bl2 = false;
                        bl3 = false;
                    }
                    throw jMSException;
                }
                string8 = "Broker did not respond";
                switch (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"))) {
                    case 1: {
                        string8 = mQBrokerMessage2.get("MQPSReasonText");
                        bl2 = true;
                        bl3 = true;
                        throw new JMSException("Broker Command warning: " + string8, mQBrokerMessage2.get("MQPSReason"));
                    }
                    case 2: {
                        bl3 = true;
                        bl2 = false;
                        string8 = mQBrokerMessage2.get("MQPSReasonText");
                        throw new JMSException("Broker Command failed: " + string8);
                    }
                    case 0: {
                        string3 = mQBrokerMessage2.get("MQPSTopic");
                        string4 = mQBrokerMessage2.get("MQPSFilter");
                        string5 = mQBrokerMessage2.get("MQPSStreamName");
                        if (Trace.isOn && null != brokerConnectionInfo.streamQ && !brokerConnectionInfo.streamQ.equals(string5)) {
                            Trace.trace(this, "This subscription is on stream '" + string5 + "'");
                            Trace.trace(this, "The deferred deregister message we sent uses stream '" + brokerConnectionInfo.streamQ + "'");
                            Trace.trace(this, "We may not be able to deregister if something goes wrong while we have this subscription");
                        }
                        if (null == string5) {
                            string5 = brokerConnectionInfo.streamQ;
                        }
                        break;
                    }
                    default: {
                        string8 = mQBrokerMessage2.get("MQPSReasonText");
                        throw ConfigEnvironment.newException("MQJMS3040", string8);
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof JMSException) {
                    throw (JMSException)((Object)exception);
                }
                JMSException jMSException = new JMSException(exception.getMessage());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            try {
                if (string3.equals(string7)) {
                    bl4 = true;
                }
                bl = mQBrokerMessage2.isOptionSet("MQPSRegOpts", 1);
                string6 = mQBrokerMessage2.get("MQPSQName");
                string8 = mQBrokerMessage2.get("MQPSCorrelId");
                if (string8 != null) {
                    byArray3 = Utils.hexToBytes(string8);
                }
                mQBrokerMessage.clear();
                mQBrokerMessage.set("MQPSCommand", "DeregSub");
                mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQSession.getSessionName()));
                mQBrokerMessage.set("MQPSSubName", string2);
                mQBrokerMessage.set("MQPSTopic", string3);
                n = 65536;
                mQBrokerMessage.setOption("MQPSRegOpts", n);
                mQBrokerMessage.set("MQPSStreamName", string5);
                if (mQSession.qm.name != null) {
                    mQBrokerMessage.set("MQPSQMgrName", mQSession.qm.name);
                }
                if (string4 != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "setting filter to " + string4);
                    }
                    mQBrokerMessage.set("MQPSFilter", string4);
                }
                mQMsg2 = new MQMsg2();
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                this.sendBrokerMessage(mQSession, mQBrokerMessage, mQMsg2, null, true);
            }
            catch (Exception exception) {
                if (exception instanceof JMSException) {
                    throw (JMSException)((Object)exception);
                }
                JMSException jMSException = new JMSException(exception.getMessage());
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            if (bl4) {
                if (Trace.isOn) {
                    Trace.trace(this, "No record found for '" + string + "'");
                }
                string8 = "MQJMS3018";
                String string9 = ConfigEnvironment.getErrorMessage(string8, string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                throw invalidDestinationException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "About to call cleanup to remove unconsumed messages");
            }
            try {
                mQBrokerMessage2 = this.cleanupUnconsumedMessages(mQSession, bl, string6, byArray3, mQMsg2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "exception thrown while attempting to cleanup subscriber queue");
                }
                throw jMSException;
            }
            try {
                this.cancelDeferredMessage(mQSession, byArray2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Exception thrown cancelling deferred deregister message. Ignoring");
                    Trace.exception(this, "durableUnsubscribe", (Throwable)jMSException);
                }
            }
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "durableUnsubscribe");
            }
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.cleanupHandle != null) {
            this.cleanupHandle.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    private MQBrokerSubscription updateDurableSubscription(MQBrokerSubscription mQBrokerSubscription, MQSession mQSession, String string, String string2, boolean bl) throws JMSException {
        Object var6_6 = null;
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        int n = 0;
        MQMsg2 mQMsg2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        String string4 = null;
        if (Trace.isOn) {
            Trace.entry(this, "updateDurableSubscription");
            if (bl) {
                Trace.trace(this, "Recovering broken subscription");
            }
        }
        try {
            String string5;
            block47: {
                byArray = mQBrokerSubscription.getMQSession().getSessionName();
                if (!bl) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting subscription to PubOnReqOnly");
                    }
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    mQBrokerMessage.set("MQPSCommand", "RegSub");
                    mQBrokerMessage.set("MQPSSubName", mQBrokerSubscription.getEscapedFullName());
                    mQBrokerMessage.set("MQPSTopic", mQBrokerSubscription.getTopic());
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
                    n = 65568;
                    if (mQBrokerSubscription.isSharedQueue()) {
                        ++n;
                    }
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    string4 = mQBrokerSubscription.getFilter();
                    if (string4 != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting filter to " + string4);
                        }
                        mQBrokerMessage.set("MQPSFilter", string4);
                    }
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    this.sendBrokerMessage(mQBrokerSubscription.getMQSession(), mQBrokerMessage, mQMsg2, null, true);
                    if (this.getMQConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH1 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQSession(), mQMsg2, true);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH2 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQSession(), mQMsg2, true);
                    }
                    if (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode")) != 0) {
                        throw new JMSException(mQBrokerMessage2.get("MQPSReasonText"));
                    }
                }
                try {
                    string3 = mQBrokerSubscription.getQueueName();
                    byArray2 = mQBrokerSubscription.getCorrelationId();
                    Cleanup.removeMessages(mQSession.qm, string3, byArray2);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block47;
                    Trace.trace(this, "Failed to clear messages from subscriber queue. CLeanup threw exception");
                    Trace.exception(this, "updateDurableSubscription", (Throwable)jMSException);
                }
            }
            if (string2 == null) {
                string2 = "";
            }
            String string6 = !string2.trim().equals("") ? "sel=\"" + this.escapeString(string2) + "\"" : "";
            String string7 = "";
            if (string2 != null && !string2.trim().equals("")) {
                string5 = this.escapeString(string2);
                string7 = "sel=\"" + string5 + "\"";
            }
            mQBrokerMessage.clear();
            if (string2 == null) {
                string2 = "";
            }
            mQBrokerMessage.unset("MQPSRegOpts");
            n = 327680;
            if (mQBrokerSubscription.isSharedQueue()) {
                ++n;
            }
            mQBrokerMessage.setOption("MQPSRegOpts", n);
            mQBrokerMessage.set("MQPSCommand", "RegSub");
            mQBrokerMessage.set("MQPSSubName", mQBrokerSubscription.getEscapedFullName());
            mQBrokerMessage.set("MQPSQName", mQBrokerSubscription.getQueueName());
            mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
            mQBrokerMessage.set("MQPSSubUserData", string6);
            mQBrokerMessage.set("MQPSTopic", string);
            string5 = mQBrokerSubscription.getMQTopic().getBrokerPubQueue();
            if (null != string5 && string5.length() > 0) {
                mQBrokerMessage.set("MQPSStreamName", string5);
            } else if (null != mQSession.getBrk().streamQ) {
                mQBrokerMessage.set("MQPSStreamName", mQSession.getBrk().streamQ);
            }
            String string8 = mQBrokerSubscription.getSelector();
            mQBrokerSubscription.setSelector(string2);
            string4 = mQBrokerSubscription.getFilter();
            if (string4 != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "setting filter to " + string4);
                }
                mQBrokerMessage.set("MQPSFilter", string4);
            }
            mQBrokerSubscription.setSelector(string8);
            mQMsg2 = new MQMsg2();
            mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
            mQMsg2.setMessageType(1);
            mQMsg2.setReport(0);
            this.sendBrokerMessage(mQBrokerSubscription.getMQSession(), mQBrokerMessage, mQMsg2, null, true);
            if (this.getMQConnection().getBrkVersion() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Receiving RFH1 Message from broker");
                }
                mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQSession(), mQMsg2, true);
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Receiving RFH2 Message from broker");
                }
                mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQSession(), mQMsg2, true);
            }
            int n2 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
            int n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
            if (n2 != 0 && (n2 != 1 || n3 != 3157)) {
                throw new JMSException(mQBrokerMessage2.get("MQPSReasonText"));
            }
            mQBrokerSubscription.setTopic(string);
            mQBrokerSubscription.setSelector(string2);
            MQBrokerSubscription mQBrokerSubscription2 = mQBrokerSubscription;
            return mQBrokerSubscription2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "updateDurableSubscription", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "updateDurableSubscription");
            }
        }
    }

    private byte[] sendBrokerMessageInternal(MQSession mQSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl, boolean bl2, int n) throws JMSException {
        MQQueue mQQueue = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Object var11_11 = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessageInternal(mqts, brkMsg, MQMsg2, pmo, deferred)");
        }
        try {
            BrokerConnectionInfo brokerConnectionInfo = mQSession.getBrk();
            try {
                MQConnection mQConnection = this.getMQConnection();
                if (mQBrokerMessage.get("MQPSCommand") == "RegSub" && mQConnection.getBrkOptLevel() > 0) {
                    if (!mQSession.persistenceFromMD && !bl2) {
                        mQBrokerMessage.setOption("MQPSRegOpts", "NonPers");
                    }
                    if (mQSession.acknowledgeMode == 3) {
                        mQBrokerMessage.setOption("MQPSRegOpts", "DupsOK");
                    }
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Exception thrown attempting to set nonPersistent and DupsOk options");
                    Trace.exception(this, "sendBrokerMessageInternal", (Throwable)jMSException);
                }
                throw jMSException;
            }
            try {
                Object object;
                try {
                    if (bl2) {
                        byArray = mQSession.getSessionName();
                        mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
                        mQBrokerMessage.setOption("MQPSRegOpts", "VariableUserId");
                        mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    }
                    mQBrokerMessage.writeToMessage(mQMsg2);
                    mQMsg2.setReplyToQueueManagerName("");
                    mQMsg2.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                    mQMsg2.setPersistence(1);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.exception(this, "sendBrokerMessageInternal", (Throwable)mQException);
                    }
                    JMSException jMSException = new JMSException("MQJMS1000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                try {
                    int n2 = 16;
                    object = mQSession.qm;
                    if (mQPutMessageOptions == null) {
                        mQPutMessageOptions = new MQPutMessageOptions();
                    }
                    if (n == 1) {
                        n2 |= 0x2000;
                        mQPutMessageOptions.options |= 0x2000;
                    }
                    if (bl) {
                        MQSPIQueueManager mQSPIQueueManager = (MQSPIQueueManager)object;
                        if (!mQSPIQueueManager.spiSupportsDeferred()) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3047");
                            throw jMSException;
                        }
                        mQQueue = mQSPIQueueManager.accessQueue(brokerConnectionInfo.controlQ, n2, brokerConnectionInfo.qmName, null, null);
                        ((MQSPIQueue)mQQueue).spiDeferredPut(mQMsg2, mQPutMessageOptions);
                    } else {
                        mQQueue = mQSession.qm.accessQueue(brokerConnectionInfo.controlQ, n2, brokerConnectionInfo.qmName, null, null);
                        mQQueue.putMsg2(mQMsg2, mQPutMessageOptions);
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", brokerConnectionInfo.controlQ);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Failed to MQPUT broker command due to: " + (Object)((Object)mQException));
                    }
                    throw jMSException;
                }
                byArray2 = mQMsg2.getCorrelationId();
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    object = ConfigEnvironment.newException("MQJMS2000");
                    object.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Failed to close broker queue");
                    }
                    throw object;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Failed to put message to broker queue");
                }
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerMessageInternal(mqts, brkMsg, MQMsg2)");
            }
        }
        return byArray2;
    }

    private byte[] sendBrokerMessageInternal(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        MQSession mQSession = null;
        String string2 = null;
        String string3 = null;
        byte[] byArray = null;
        String string4 = null;
        MQBrokerMessage mQBrokerMessage = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessageInternal");
        }
        try {
            mQSession = mQSubscription.getMQSession();
            BrokerConnectionInfo brokerConnectionInfo = mQSession.getBrk();
            string2 = mQSubscription.getSelector();
            string3 = string2 != null && !string2.trim().equals("") ? "sel=\"" + this.escapeString(string2) + "\"" : "";
            try {
                if (this.getMQConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating RFH1 Message");
                    }
                    mQBrokerMessage = new RFH1BrokerMessageImpl();
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating RFH2 Message");
                    }
                    mQBrokerMessage = new RFH2BrokerMessageImpl();
                }
                mQBrokerMessage.set("MQPSCommand", string);
                mQBrokerMessage.setOption("MQPSRegOpts", n);
                String string5 = mQSubscription.getMQTopic().getBrokerPubQueue();
                if (string5 == null || string5.equals("")) {
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                } else {
                    mQBrokerMessage.set("MQPSStreamName", string5);
                }
                mQBrokerMessage.set("MQPSTopic", mQSubscription.getTopic());
                if (null != mQSession.qm && mQSession.qm.name != null) {
                    mQBrokerMessage.set("MQPSQMgrName", mQSession.qm.name);
                }
                mQBrokerMessage.set("MQPSQName", mQSubscription.getQueueName());
                if (mQSubscription.isDurable()) {
                    mQBrokerMessage.set("MQPSSubName", ((MQBrokerSubscription)mQSubscription).getEscapedFullName());
                }
                if (!string.equals("DeregSub")) {
                    mQBrokerMessage.set("MQPSSubUserData", string3);
                } else {
                    mQBrokerMessage.unset("MQPSSubUserData");
                }
                string4 = mQSubscription.getFilter();
                if (string4 != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "setting filter to " + string4);
                    }
                    mQBrokerMessage.set("MQPSFilter", string4);
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Error constructing MQBrokerMessage");
                }
                throw jMSException;
            }
            try {
                if (mQMsg2 == null) {
                    mQMsg2 = new MQMsg2();
                }
                mQMsg2.setReplyToQueueManagerName("");
                mQMsg2.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Error detailing jmsMessage");
                }
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            int n2 = 1;
            if (mQSubscription.getMQTopic() != null) {
                n2 = mQSubscription.getMQTopic().getFailIfQuiesce();
            } else if (mQSession != null) {
                n2 = mQSession.getFailIfQuiesce();
            }
            byArray = this.sendBrokerMessageInternal(mQSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, bl, mQSubscription.isDurable(), n2);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "sendBrokerMessageInternal", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerMessageInternal");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendBrokerMessage(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessage(sub, cmd, regOpts, Msg, pmo)");
        }
        try {
            byte[] byArray = this.sendBrokerMessageInternal(mQSubscription, string, n, mQMsg2, mQPutMessageOptions, false);
            return byArray;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerMessage(sub, cmd, regOpts, Msg, pmo)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendBrokerMessage(MQSession mQSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessage(mqs, brkMsg, MQMsg2, pmo, durable)");
        }
        try {
            byte[] byArray = this.sendBrokerMessageInternal(mQSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, false, bl, mQSession.getFailIfQuiesce());
            return byArray;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "sendBrokerMessage(mqs, brkMsg, MQMsg2, pmo, durable)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] setDeferredMessage(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDeferredMessage(sub, cmd, regOpts, msg, pmo)");
        }
        try {
            byte[] byArray = null;
            byte[] byArray2 = byArray = this.sendBrokerMessageInternal(mQSubscription, string, n, mQMsg2, mQPutMessageOptions, true);
            return byArray2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setDeferredMessage(sub, cmd, regOpts, msg, pmo)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] setDeferredMessage(MQSession mQSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDeferredMessage(mqs, brokermsg, jmsMsg, pmo");
        }
        try {
            byte[] byArray = null;
            byte[] byArray2 = byArray = this.sendBrokerMessageInternal(mQSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, true, bl, n);
            return byArray2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setDeferredMessage(mqs, brokermsg, jmsMsg, pmo");
            }
        }
    }

    private void cancelDeferredMessage(MQSession mQSession, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "cancelDeferredMessage");
        }
        try {
            MQQueueManager mQQueueManager = mQSession.qm;
            if (!(mQQueueManager instanceof MQSPIQueueManager)) {
                JMSException jMSException = new JMSException("MQJMS3047");
                throw jMSException;
            }
            MQSPIQueueManager mQSPIQueueManager = (MQSPIQueueManager)mQQueueManager;
            if (!mQSPIQueueManager.spiSupportsDeferred()) {
                JMSException jMSException = new JMSException("MQJMS3047");
                throw jMSException;
            }
            mQSPIQueueManager.spiCancelDeferred(byArray);
            return;
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException(mQException.getMessage());
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "cancelDeferredMessage");
            }
        }
    }

    private MQBrokerMessage getBrokerResponse(MQSession mQSession, MQMsg2 mQMsg2, boolean bl) throws JMSException {
        MQBrokerMessage mQBrokerMessage;
        MQMsg2 mQMsg22 = null;
        MQQueue mQQueue = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerResponse");
        }
        try {
            mQMsg22 = new MQMsg2();
            mQMsg22.setCorrelationId(mQMsg2.getMessageId());
            try {
                mQQueue = mQSession.replyQ == null ? mQSession.getResponseQueue() : mQSession.replyQ;
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 1;
                mQGetMessageOptions.waitInterval = mQSession.getBrokerTimeout();
                if (this.connection.getFailIfQuiesce() == 1) {
                    mQGetMessageOptions.options |= 0x2000;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "setting broker timeout to " + mQSession.getBrokerTimeout());
                }
                mQQueue.getMsg2(mQMsg22, mQGetMessageOptions);
            }
            catch (MQException mQException) {
                String string = "MQJMS5053";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.exception(this, "error getting broker response: ", (Throwable)((Object)noBrokerResponseException));
                }
                throw noBrokerResponseException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "got broker response");
            }
            if (this.getMQConnection().getBrkVersion() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Creating RFH1 Message");
                }
                mQBrokerMessage = new RFH1BrokerMessageImpl();
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Creating RFH2 Message");
                }
                mQBrokerMessage = new RFH2BrokerMessageImpl();
            }
            mQBrokerMessage.initializeFromMessage(mQMsg22);
            if (bl) {
                if (Trace.isOn) {
                    Trace.trace(this, "requested full Response. Did we get it?");
                }
                if ((mQBrokerMessage.get("MQPSTopic") == null || mQBrokerMessage.get("MQPSTopic").equals("")) && Integer.parseInt(mQBrokerMessage.get("MQPSCompCode")) != 2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "No full response. Assume that this command failed");
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Get the original command");
                    }
                    if ((mQBrokerMessage2 = MQBrokerMessage.fromMessage(mQMsg2)).get("MQPSCommand").equals("RegSub")) {
                        boolean bl2 = mQBrokerMessage2.isOptionSet("MQPSRegOpts", "CorrelAsId");
                        this.cleanupUnwantedSubscription(mQSession, mQMsg2, bl2);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Full response didn't work, using workaround and setting fail");
                    }
                    mQBrokerMessage.set("MQPSCompCode", Integer.toString(2));
                    mQBrokerMessage.set("MQPSReason", Integer.toString(2337));
                    mQBrokerMessage.set("MQPSReasonText", "MQRC_RFH_PARM_ERROR");
                }
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "exception thrown getting broker response", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getBrokerResponse");
            }
        }
        return mQBrokerMessage;
    }

    /*
     * Loose catch block
     */
    byte[] createSessionName(MQSession mQSession) throws JMSException {
        byte[] byArray;
        block19: {
            MQQueue mQQueue;
            block18: {
                block17: {
                    byArray = null;
                    Object var3_3 = null;
                    MQQueueManager mQQueueManager = mQSession.qm;
                    mQQueue = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "createSessionName");
                    }
                    mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 8210);
                    MQMessage mQMessage = new MQMessage();
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    if (this.connection.getFailIfQuiesce() == 1) {
                        mQPutMessageOptions.options |= 0x2000;
                    }
                    try {
                        mQMessage.writeString("sessGen");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    mQMessage.expiry = 1;
                    mQMessage.persistence = 0;
                    mQQueue.put(mQMessage, mQPutMessageOptions);
                    byArray = mQMessage.messageId;
                    try {
                        mQQueue.get(mQMessage);
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2033) break block17;
                        throw mQException;
                    }
                }
                Object var10_12 = null;
                if (mQQueue == null) break block18;
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "createSessionName");
            }
            break block19;
            {
                catch (MQException mQException) {
                    JMSException jMSException = mQException.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.exception(this, "createSessionName", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        // empty catch block
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "createSessionName");
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String escapeString(String string) {
        String string2;
        block11: {
            String string3;
            char c;
            StringBuffer stringBuffer;
            block9: {
                String string4;
                block10: {
                    stringBuffer = new StringBuffer();
                    boolean bl = false;
                    c = '\u0000';
                    string3 = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "escapeString: " + string);
                    }
                    if (string != null) break block9;
                    string4 = "";
                    Object var9_8 = null;
                    if (!Trace.isOn) break block10;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                }
                return string4;
            }
            try {
                block6: for (int i = 0; i < string.length(); ++i) {
                    c = string.charAt(i);
                    switch (c) {
                        case '\"': 
                        case ':': 
                        case ';': 
                        case '\\': {
                            string3 = "0000" + Integer.toString(c, 16);
                            stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                            continue block6;
                        }
                        default: {
                            if (c < ' ' || c > '~') {
                                string3 = "0000" + Integer.toString(c, 16);
                                stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                                continue block6;
                            }
                            stringBuffer.append(c);
                        }
                    }
                }
                string2 = stringBuffer.toString();
                Object var9_9 = null;
                if (!Trace.isOn) break block11;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var9_10 = null;
                    if (!Trace.isOn) break block12;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                }
                throw throwable;
            }
            Trace.trace(this, "Returning string: " + stringBuffer.toString());
            Trace.exit(this, "escapeString");
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    private MQBrokerMessage cleanupUnconsumedMessages(MQSession mQSession, boolean bl, String string, byte[] byArray, MQMsg2 mQMsg2) throws JMSException {
        MQBrokerMessage mQBrokerMessage;
        MQQueue mQQueue;
        String string2;
        block50: {
            MQBrokerMessage mQBrokerMessage2;
            block49: {
                MQMsg2 mQMsg22;
                MQGetMessageOptions mQGetMessageOptions;
                int n;
                block47: {
                    MQBrokerMessage mQBrokerMessage3;
                    block48: {
                        string2 = new String("cleanupUnconsumedMessages");
                        int n2 = this.cleanupHandle.getCleanupLevel();
                        n = 0;
                        mQQueue = null;
                        mQGetMessageOptions = null;
                        mQMsg22 = null;
                        mQBrokerMessage2 = null;
                        if (Trace.isOn) {
                            Trace.entry(this, string2);
                        }
                        if (n2 != 0) break block47;
                        if (Trace.isOn) {
                            Trace.trace(this, "Cleanup level is NONE; skipping cleanup");
                        }
                        mQBrokerMessage3 = null;
                        Object var18_19 = null;
                        try {
                            if (mQQueue != null && mQQueue.isOpen()) {
                                mQQueue.close();
                            }
                        }
                        catch (MQException mQException) {
                            if (!Trace.isOn) break block48;
                            Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                            Trace.exception(this, string2, (Throwable)mQException);
                        }
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, string2);
                    }
                    return mQBrokerMessage3;
                }
                n = 10;
                if (this.connection.getFailIfQuiesce() == 1) {
                    n |= 0x2000;
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "opening report queue");
                    }
                    mQQueue = mQSession.qm.accessQueue("SYSTEM.JMS.REPORT.QUEUE", n);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "exception thrown opening report queue");
                    }
                    if (mQException.reasonCode == 2042) {
                        if ((n & 2) == 2) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.REPORT.QUEUE");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                try {
                    mQGetMessageOptions = new MQGetMessageOptions();
                    mQGetMessageOptions.options = 545;
                    mQGetMessageOptions.waitInterval = mQSession.getBrokerTimeout();
                    if (this.connection.getFailIfQuiesce() == 1) {
                        mQGetMessageOptions.options |= 0x2000;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "setting broker timeout to " + mQSession.getBrokerTimeout());
                    }
                    mQMsg22 = new MQMsg2();
                    mQMsg22.setCorrelationId(mQMsg2.getMessageId());
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting reponse correlationId = " + Utils.bytesToHex(mQMsg2.getMessageId()));
                    }
                    mQQueue.getMsg2(mQMsg22, mQGetMessageOptions);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "exception thrown getting response message from report queue");
                    }
                    String string3 = "MQJMS5053";
                    String string4 = ConfigEnvironment.getErrorMessage(string3);
                    NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string4);
                    noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                    throw noBrokerResponseException;
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "got MQ response message, converting to MQBrokerMessage");
                    }
                    mQBrokerMessage2 = MQBrokerMessage.fromMessage(mQMsg22);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "exception thrown while creating MQBrokerMessage");
                    }
                    throw jMSException;
                }
                int n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                if (n3 != 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "The broker deregister command failed. Abort cleanup and throw exception");
                    }
                    String string5 = mQBrokerMessage2.get("MQPSReasonText");
                    JMSException jMSException = new JMSException(string5);
                    throw jMSException;
                }
                try {
                    if (bl) {
                        if (Trace.isOn) {
                            Trace.trace(this, "shared queue, calling removeMessages");
                        }
                        Cleanup.removeMessages(mQSession.qm, string, byArray);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "dynamic queue, calling removeDynamicQueue");
                        }
                        Cleanup.removeDynamicQueue(mQSession.qm, string);
                    }
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "exception thrown while attempting to clean subscriber queue");
                    }
                    throw jMSException;
                }
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "Removing message");
                    }
                    mQGetMessageOptions.options = 320;
                    if (this.connection.getFailIfQuiesce() == 1) {
                        mQGetMessageOptions.options |= 0x2000;
                    }
                    mQQueue.getMsg2(mQMsg22, mQGetMessageOptions, 1);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2079) break block49;
                    String string6 = "Couldn't get locked message from queue (" + (Object)((Object)mQException) + ")";
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", string6);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
            }
            mQBrokerMessage = mQBrokerMessage2;
            Object var18_20 = null;
            try {
                if (mQQueue != null && mQQueue.isOpen()) {
                    mQQueue.close();
                }
            }
            catch (MQException mQException) {
                if (!Trace.isOn) break block50;
                Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                Trace.exception(this, string2, (Throwable)mQException);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, string2);
        }
        return mQBrokerMessage;
        catch (JMSException jMSException) {
            try {
                if (Trace.isOn) {
                    Trace.exception(this, string2, (Throwable)jMSException);
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                block52: {
                    block51: {
                        Object var18_21 = null;
                        try {
                            if (mQQueue != null && mQQueue.isOpen()) {
                                mQQueue.close();
                            }
                        }
                        catch (MQException mQException) {
                            if (!Trace.isOn) break block51;
                            Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                            Trace.exception(this, string2, (Throwable)mQException);
                        }
                    }
                    if (!Trace.isOn) break block52;
                    Trace.exit(this, string2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUnwantedSubscription(MQSession mQSession, MQMsg2 mQMsg2, boolean bl) {
        String string = "cleanupUnwantedSubscription";
        boolean bl2 = false;
        MQMsg2 mQMsg22 = new MQMsg2();
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        MQBrokerMessage mQBrokerMessage3 = null;
        Object var10_10 = null;
        if (Trace.isOn) {
            Trace.entry(this, string, "sentMessage=" + mQMsg2.toString() + ", sharedQueue=" + bl);
        }
        try {
            block31: {
                if (Trace.isOn) {
                    Trace.trace(this, "resetting read position");
                }
                try {
                    mQMsg2.resetReadPosition();
                }
                catch (MQInternalException mQInternalException) {
                    if (!Trace.isOn) break block31;
                    Trace.trace(this, "error resetting read position");
                    Trace.exception(this, "cleanupUnwantedSubscription", (Throwable)mQInternalException);
                }
            }
            mQBrokerMessage = MQBrokerMessage.fromMessage(mQMsg2);
            if (this.getMQConnection().getBrkVersion() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Composing new RFH1 message to deregister");
                }
                mQBrokerMessage2 = new RFH1BrokerMessageImpl();
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Composing new RFH2 message to deregister");
                }
                mQBrokerMessage2 = new RFH2BrokerMessageImpl();
            }
            if (Trace.isOn) {
                Trace.trace(this, "Setting command to deregister");
            }
            mQBrokerMessage2.set("MQPSCommand", "DeregSub");
            String string2 = mQBrokerMessage.get("MQPSStreamName");
            String string3 = mQBrokerMessage.get("MQPSQMgrName");
            String string4 = mQBrokerMessage.get("MQPSQName");
            if (string2 != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting stream name to '" + string2 + "'");
                }
                mQBrokerMessage2.set("MQPSStreamName", string2);
            }
            if (string3 != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting qMgr name to '" + string3 + "'");
                }
                mQBrokerMessage2.set("MQPSQMgrName", string3);
            }
            if (string4 != null) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting qName to '" + string4 + "'");
                }
                mQBrokerMessage2.set("MQPSQName", string4);
            }
            if (Trace.isOn && bl) {
                Trace.trace(this, "Shared queue, setting corelId as Id");
            }
            if (bl) {
                mQBrokerMessage2.setOption("MQPSRegOpts", 1);
            }
            mQBrokerMessage2.setOption("MQPSRegOpts", 64);
            mQBrokerMessage2.writeToMessage(mQMsg22);
            mQMsg22.setMessageType(1);
            mQMsg22.setReport(0);
            if (bl) {
                mQMsg22.setCorrelationId(mQMsg2.getCorrelationId());
            }
            try {
                this.sendBrokerMessage(mQSession, mQBrokerMessage2, mQMsg22, null, false);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "Error sending deregister unwanted subscription message: ", (Throwable)jMSException);
                }
                throw jMSException;
            }
            try {
                mQBrokerMessage3 = this.cleanupUnconsumedMessages(mQSession, bl, mQBrokerMessage.get("MQPSQName"), mQMsg2.getCorrelationId(), mQMsg22);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "exception thrown dealing with broker response and subscriber queue cleanup");
                }
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Problems encountered attempting to deal with an erroneously created subscription.");
                Trace.trace(this, "Subscription could still exist causing unwanted messages to be delivered");
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, string);
            }
        }
    }

    private Hashtable parseSubUserData(MQBrokerMessage mQBrokerMessage) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "parseSubUserData");
            }
            boolean bl = false;
            boolean bl2 = true;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string = mQBrokerMessage.get("MQPSSubUserData");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|\"=\u0000", true);
            String string2 = null;
            boolean bl3 = bl2;
            String string3 = null;
            Object v = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("\u0000")) {
                    if (bl3 == bl2) break;
                    String string4 = "UserSubData contained unparsable string";
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", string4);
                    throw jMSException;
                }
                if (stringTokenizer.equals("\"") || stringTokenizer.equals("=")) continue;
                if (bl3 == bl2) {
                    string3 = new String(string2);
                    bl3 = bl;
                    continue;
                }
                hashtable.put(string3, v);
                bl3 = bl2;
            }
            Hashtable<String, Object> hashtable2 = hashtable;
            return hashtable2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "parseSubUserData", (Throwable)jMSException);
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "parseSubUserData");
            }
        }
    }
}

