/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQPubSubServices;
import com.ibm.mq.jms.MQQueueServices;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.PublishSubscribeSetupException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import javax.jms.JMSException;
import javax.jms.Message;

public class JMSServicesMgr {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/JMSServicesMgr.java, jms, j600, j600-201-061220 1.13.1.1 05/05/25 15:52:36";
    private PublishSubscribeSetupException sme;
    private MQQueueServices queueServices = null;
    private MQPubSubServices pubSubServices = null;
    boolean pubSubSet = false;
    boolean queueSet = false;

    JMSServicesMgr() {
    }

    protected void setQueueServices(MQQueueServices mQQueueServices) {
        this.queueServices = mQQueueServices;
        this.queueSet = true;
    }

    protected void setPubSubServices(MQPubSubServices mQPubSubServices) {
        this.pubSubServices = mQPubSubServices;
        this.pubSubSet = true;
    }

    protected boolean isPubSub() {
        return this.pubSubSet;
    }

    protected boolean isPTP() {
        return this.queueSet;
    }

    void closePS(MQSession mQSession) throws JMSException {
        if (this.pubSubSet) {
            this.pubSubServices.closePubSub(mQSession);
        }
    }

    protected JMSException getQueueOpenException(MQException mQException) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.getQueueOpenException(mQException, "");
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    void checkQueueAccess(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        if (!this.queueSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            throw this.sme;
        }
        this.queueServices.checkQueueAccess(mQQueue, mQSession);
    }

    MQQueue getOutputQueue(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.getOutputQueue(mQQueue, mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    MQQueue getQueueForBrowse(com.ibm.mq.jms.MQQueue mQQueue, MQSession mQSession) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.getQueueForBrowse(mQQueue, mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    void getBrokerResponse(MQSession mQSession, MQMsg2 mQMsg2, boolean bl) throws NoBrokerResponseException, JMSException {
        if (this.pubSubSet) {
            this.pubSubServices.getBrokerResponse(mQSession, mQMsg2, bl);
        } else {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            throw this.sme;
        }
    }

    boolean checkForResponse(MQSession mQSession) throws JMSException {
        if (this.pubSubSet) {
            return this.pubSubServices.checkForResponse(mQSession);
        }
        return false;
    }

    boolean getSparseSubscriptions(MQSession mQSession) {
        if (this.pubSubSet) {
            return this.pubSubServices.getSparseSubscriptions(mQSession);
        }
        return false;
    }

    private void setBrokerTimeout(int n) throws JMSException {
        if (!this.pubSubSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            throw this.sme;
        }
        this.pubSubServices.setBrokerTimeout(n);
    }

    private int getBrokerTimeout() throws JMSException {
        if (this.pubSubSet) {
            return this.pubSubServices.getBrokerTimeout();
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    protected Message consume(MessageReference messageReference, MQSession mQSession) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.consume(messageReference, mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1112").getMessage());
        throw this.sme;
    }

    protected Message consume(byte[] byArray, MQSession mQSession) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.consume(byArray, mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1112").getMessage());
        throw this.sme;
    }

    void redirectMessage(String string, MQMsg2 mQMsg2, boolean bl, MQSession mQSession) throws JMSException {
        if (!this.queueSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            throw this.sme;
        }
        this.queueServices.redirectMessage(string, mQMsg2, bl, mQSession);
    }

    protected MessageReference recreateMessageReference(byte[] byArray, MQSession mQSession) throws JMSException {
        if (this.queueSet) {
            return this.queueServices.recreateMessageReference(byArray, mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl, boolean bl2, MQSession mQSession) throws JMSException {
        if (this.pubSubSet) {
            this.pubSubServices.sendCommand(string, n, string2, byArray, bl, bl2, mQSession);
        } else {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            throw this.sme;
        }
    }

    boolean requestResponse(MQSession mQSession) throws JMSException {
        if (this.pubSubSet) {
            return this.pubSubServices.requestResponse(mQSession);
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        throw this.sme;
    }

    MQQueue getResponseQueue(MQSession mQSession) throws JMSException {
        if (this.pubSubSet) {
            return this.pubSubServices.getResponseQueue(mQSession);
        }
        return null;
    }

    void initialisePubSub(MQSession mQSession, boolean bl, int n) throws JMSException {
        if (this.pubSubSet) {
            this.pubSubServices.initialisePubSub(mQSession.connection, bl, n, mQSession);
        }
    }
}

