/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/BytesMessageImpl.java, disthub, j600, j600-201-061220 1.28.1.1 05/05/25 15:42:12";
    private static final DebugObject debug = new DebugObject("BytesMessageImpl");
    private static final long serialVersionUID = -1457018201401185578L;
    private static final int BYTE_OUTPUT_STREAM_SIZE = 1024;
    ByteArrayInputStream bais;
    DataInputStream dis;
    byte[] body;
    private boolean bodyNeeded = false;
    private long lastKnownLength = -1L;
    ByteArrayOutputStream baos;
    DataOutputStream dos;
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private boolean markInUse = false;

    public BytesMessageImpl(MessageHandle messageHandle, ConnectionImpl connectionImpl) {
        super(messageHandle, connectionImpl);
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl", (Object)messageHandle, (Object)connectionImpl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"BytesMessageImpl");
        }
    }

    public BytesMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl");
        }
        this.messageClass = "jms_bytes";
        this.baos = new ByteArrayOutputStream(1024);
        this.dos = new DataOutputStream(this.baos);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"BytesMessageImpl");
        }
    }

    private void obtainBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"obtainBody");
        }
        try {
            this.body = this.getBytesBody();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        }
        catch (Exception exception) {
            Assert.failure((Exception)exception);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"obtainBody");
        }
    }

    void prepareMessage() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"prepareMessage");
        }
        if (!this.readOnly) {
            this.setBytesBody(this.baos.toByteArray());
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"prepareMessage");
        }
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.lastKnownLength = -1L;
        if (this.readOnly) {
            this.readOnly = false;
            if (this.body == null) {
                this.obtainBody();
            }
            this.bais.reset();
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream(1024);
                this.dos = new DataOutputStream(this.baos);
            } else {
                this.baos.reset();
            }
        } else {
            this.baos.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
    }

    public boolean readBoolean() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBoolean");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        boolean bl = false;
        try {
            bl = this.dis.readBoolean();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBoolean", (Object)new Boolean(bl));
        }
        return bl;
    }

    public byte readByte() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readByte");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        byte by = 0;
        try {
            by = this.dis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readByte", (Object)new Byte(by));
        }
        return by;
    }

    public int readUnsignedByte() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUnsignedByte");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUnsignedByte", (Object)new Integer(n));
        }
        return n;
    }

    public short readShort() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readShort");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        short s = 0;
        try {
            s = this.dis.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readShort", (Object)new Short(s));
        }
        return s;
    }

    public int readUnsignedShort() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUnsignedShort");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUnsignedShort", (Object)new Integer(n));
        }
        return n;
    }

    public char readChar() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readChar");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        char c = '\u0000';
        try {
            c = this.dis.readChar();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readChar", (Object)new Character(c));
        }
        return c;
    }

    public int readInt() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readInt");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readInt", (Object)new Integer(n));
        }
        return n;
    }

    public long readLong() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readLong");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        long l = 0L;
        try {
            l = this.dis.readLong();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readLong", (Object)new Long(l));
        }
        return l;
    }

    public float readFloat() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readFloat");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        float f = 0.0f;
        try {
            f = this.dis.readFloat();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readFloat", (Object)new Double(f));
        }
        return f;
    }

    public double readDouble() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readDouble");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        double d = 0.0;
        try {
            d = this.dis.readDouble();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readDouble", (Object)new Double(d));
        }
        return d;
    }

    public String readUTF() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUTF");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        int n = this.integerEncoding;
        if (this.body == null) {
            this.obtainBody();
        }
        String string = null;
        try {
            string = this.dis.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUTF", (Object)string);
        }
        return string;
    }

    public int readBytes(byte[] byArray) throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBytes");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.read(byArray);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBytes", (Object)new Integer(n));
        }
        return n;
    }

    public int readBytes(byte[] byArray, int n) throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl.readBytes", (Object)new Integer(n));
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n2 = 0;
        try {
            n2 = this.dis.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBytes", (Object)new Integer(n2));
        }
        return n2;
    }

    public void writeBoolean(boolean bl) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBoolean", (Object)new Boolean(bl));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBoolean");
        }
    }

    public void writeByte(byte by) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeByte", (Object)new Byte(by));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeByte(by);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeByte");
        }
    }

    public void writeShort(short s) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeShort", (Object)new Short(s));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeShort(s);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeShort");
        }
    }

    public void writeChar(char c) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeChar", (Object)new Character(c));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeChar(c);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeChar");
        }
    }

    public void writeInt(int n) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeInt", (Object)new Integer(n));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeInt(n);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeInt");
        }
    }

    public void writeLong(long l) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeLong", (Object)new Long(l));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeLong(l);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeLong");
        }
    }

    public void writeFloat(float f) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeFloat", (Object)new Float(f));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeFloat");
        }
    }

    public void writeDouble(double d) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeDouble", (Object)new Double(d));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeDouble");
        }
    }

    public void writeUTF(String string) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeUTF", (Object)string);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeUTF");
        }
    }

    public void writeBytes(byte[] byArray) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes");
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes", (Object)new Integer(n), (Object)new Integer(n2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        try {
            this.dos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
    }

    public void writeObject(Object object) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeObject", object);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeObject");
        }
    }

    public void reset() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"reset");
        }
        if (!this.readOnly) {
            this.prepareMessage();
            this.readOnly = true;
            this.body = this.baos.toByteArray();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        } else if (this.bais != null) {
            this.bais.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"reset");
        }
    }

    public long getBodyLength() throws JMSException, MessageNotReadableException {
        long l;
        long l2 = 0L;
        byte[] byArray = new byte[4000];
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBodyLength");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
        }
        if (this.lastKnownLength != -1L) {
            return this.lastKnownLength;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        try {
            int n;
            while ((n = this.dis.read(byArray)) >= 0) {
                l2 += (long)n;
            }
            l = l2;
            Object var8_6 = null;
            this.lastKnownLength = l2;
        }
        catch (IOException iOException) {
            try {
                throw new JMSWrappedException(iOException);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_7 = null;
                    this.lastKnownLength = l2;
                    if (!debug.debugIt(64)) break block10;
                    debug.debug(-153415734321212L, (Object)("Returning length : " + l2));
                    debug.debug(-142394261359015L, (Object)"getBodyLength");
                }
                throw throwable;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-153415734321212L, (Object)("Returning length : " + l2));
            debug.debug(-142394261359015L, (Object)"getBodyLength");
        }
        return l;
    }
}

