/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.StreamMessage;

public class JMSStreamMessage
extends JMSMessage
implements StreamMessage {
    static final long serialVersionUID = -3015681339377486635L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSStreamMessage.java, jms, j600, j600-202-070608 1.29.1.3 07/03/01 07:08:25";
    private static final String STREAM_BODY_NAME = "stream";
    private static final String STREAM_ELT_NAME = "elt";
    private StringBuffer dataWritten;
    private String streamBody;
    private transient StringTokenizer dataToBeRead;
    private transient Object currentField;
    private transient boolean retrying = false;
    private transient int readPos = 0;
    boolean readOnly = false;

    public JMSStreamMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_stream";
        this.jmsStrings = jMSStringResources;
        this.clearBody();
        if (bTraceIsOn) {
            trace.exit(this, "constructor");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_exportBody");
        }
        try {
            this.reset();
            byte[] byArray = this.streamBody.getBytes(string);
            Object var6_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_exportBody");
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (!bTraceIsOn) break block6;
                    trace.exit(this, "_exportBody");
                }
                throw throwable;
            }
        }
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_importBody");
        }
        try {
            try {
                this.streamBody = new String(byArray, n, byArray.length - n, string);
                this.readOnly = true;
                this.reset();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            Object var8_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.dataToBeRead = null;
        this.streamBody = null;
        this.dataWritten = new StringBuffer("<stream>");
        if (bTraceIsOn) {
            trace.exit(this, "clearBody");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readBoolean");
        }
        try {
            boolean bl = this.toBoolean(this.readField());
            this.retrying = false;
            boolean bl2 = bl;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readBoolean");
            }
            return bl2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readBoolean");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readByte");
        }
        try {
            byte by = this.toByte(this.readField());
            this.retrying = false;
            byte by2 = by;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readByte");
            }
            return by2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readByte");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) throws JMSException {
        byte[] byArray2;
        block16: {
            int n;
            block15: {
                block14: {
                    block13: {
                        byArray2 = null;
                        if (bTraceIsOn) {
                            trace.entry(this, "readBytes");
                        }
                        try {
                            byArray2 = this.toBytes(this.readField());
                            if (byArray2 != null) break block13;
                            this.retrying = false;
                            int n2 = -1;
                            Object var6_6 = null;
                            if (bTraceIsOn) {
                                trace.exit(this, "readBytes");
                            }
                            return n2;
                        }
                        catch (Throwable throwable) {
                            block17: {
                                Object var6_11 = null;
                                if (!bTraceIsOn) break block17;
                                trace.exit(this, "readBytes");
                            }
                            throw throwable;
                        }
                    }
                    if (byArray2.length != 0) break block14;
                    if (byArray.length > 0) {
                        this.retrying = false;
                    }
                    int n3 = 0;
                    Object var6_7 = null;
                    if (bTraceIsOn) {
                        trace.exit(this, "readBytes");
                    }
                    return n3;
                }
                n = byArray2.length - this.readPos;
                if (n != 0) break block15;
                this.retrying = false;
                this.readPos = 0;
                int n4 = -1;
                Object var6_8 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readBytes");
                }
                return n4;
            }
            if (byArray.length <= n) break block16;
            System.arraycopy(byArray2, this.readPos, byArray, 0, n);
            this.retrying = false;
            this.readPos = 0;
            int n5 = n;
            Object var6_9 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readBytes");
            }
            return n5;
        }
        System.arraycopy(byArray2, this.readPos, byArray, 0, byArray.length);
        this.readPos += byArray.length;
        int n = byArray.length;
        Object var6_10 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readBytes");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readChar");
        }
        try {
            char c = this.toChar(this.readField());
            this.retrying = false;
            char c2 = c;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readChar");
            }
            return c2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readChar");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readDouble");
        }
        try {
            double d = this.toDouble(this.readField());
            this.retrying = false;
            double d2 = d;
            Object var6_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readDouble");
            }
            return d2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readDouble");
            }
            throw throwable;
        }
    }

    private Object readField() throws JMSException {
        Object object;
        block26: {
            String string;
            String string2;
            block24: {
                Object object2;
                block25: {
                    block22: {
                        Object object3;
                        block23: {
                            boolean bl;
                            String string3;
                            block20: {
                                Object var10_19;
                                block21: {
                                    block18: {
                                        Object object4;
                                        block19: {
                                            if (bTraceIsOn) {
                                                trace.entry(this, "readField");
                                            }
                                            if (!this.readOnly) {
                                                throw this.newMessageNotReadableException();
                                            }
                                            if (!this.retrying) break block18;
                                            object4 = this.currentField;
                                            Object var12_4 = null;
                                            if (!bTraceIsOn) break block19;
                                            trace.exit(this, "readField");
                                        }
                                        return object4;
                                    }
                                    string3 = this.dataToBeRead.nextToken();
                                    if (string3.equals("/stream")) {
                                        throw this.newMessageEOFException();
                                    }
                                    this.currentField = null;
                                    this.retrying = true;
                                    int n = 0;
                                    boolean bl2 = false;
                                    bl = false;
                                    if (string3.charAt(string3.length() - 1) == '/') {
                                        bl = true;
                                    }
                                    if ((n = string3.indexOf(" xsi:nil")) == -1) break block20;
                                    int n2 = 0;
                                    n2 = string3.indexOf(" ");
                                    string3 = string3.substring(0, n2);
                                    if (!bl) {
                                        String string4 = this.dataToBeRead.nextToken();
                                        if (string4.charAt(0) != '/') {
                                            string4 = this.dataToBeRead.nextToken();
                                        }
                                        if (string4.charAt(0) != '/') {
                                            throw this.newMessageFormatException(1012);
                                        }
                                    }
                                    var10_19 = null;
                                    Object var12_5 = null;
                                    if (!bTraceIsOn) break block21;
                                    trace.exit(this, "readField");
                                }
                                return var10_19;
                            }
                            int n = string3.indexOf(" dt=");
                            if (n != -1) {
                                string2 = string3.substring(n + 4);
                                string3 = string3.substring(0, n);
                            } else {
                                string2 = "'string'";
                            }
                            if (!bl) break block22;
                            object3 = this.currentField = this.deformatElement(string2, "");
                            Object var12_6 = null;
                            if (!bTraceIsOn) break block23;
                            trace.exit(this, "readField");
                        }
                        return object3;
                    }
                    string = this.dataToBeRead.nextToken();
                    if (string.charAt(0) != '/') break block24;
                    object2 = this.currentField = this.deformatElement(string2, "");
                    Object var12_7 = null;
                    if (!bTraceIsOn) break block25;
                    trace.exit(this, "readField");
                }
                return object2;
            }
            try {
                String string5 = this.dataToBeRead.nextToken();
                if (string5.charAt(0) != '/') {
                    throw this.newMessageFormatException(1010);
                }
                object = this.currentField = this.deformatElement(string2, string);
                Object var12_8 = null;
                if (!bTraceIsOn) break block26;
            }
            catch (NoSuchElementException noSuchElementException) {
                try {
                    throw this.newMessageEOFException();
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var12_9 = null;
                        if (!bTraceIsOn) break block27;
                        trace.exit(this, "readField");
                    }
                    throw throwable;
                }
            }
            trace.exit(this, "readField");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readFloat() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readFloat");
        }
        try {
            float f = this.toFloat(this.readField());
            this.retrying = false;
            float f2 = f;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readFloat");
            }
            return f2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readFloat");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readInt");
        }
        try {
            int n = this.toInt(this.readField());
            this.retrying = false;
            int n2 = n;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readInt");
            }
            return n2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readInt");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readLong");
        }
        try {
            long l = this.toLong(this.readField());
            this.retrying = false;
            long l2 = l;
            Object var6_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readLong");
            }
            return l2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readLong");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readObject");
        }
        try {
            Object object = this.readField();
            this.retrying = false;
            Object object2 = object;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readObject");
            }
            return object2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readObject");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readShort");
        }
        try {
            short s = this.toShort(this.readField());
            this.retrying = false;
            short s2 = s;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readShort");
            }
            return s2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "readShort");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws JMSException {
        Object object;
        block7: {
            if (bTraceIsOn) {
                trace.entry(this, "readString");
            }
            try {
                object = this.readField();
                if (object instanceof byte[]) {
                    throw this.newMessageFormatException(1011);
                }
                this.retrying = false;
                if (object != null) break block7;
                String string = null;
                Object var4_4 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readString");
                }
                return string;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_6 = null;
                    if (!bTraceIsOn) break block8;
                    trace.exit(this, "readString");
                }
                throw throwable;
            }
        }
        String string = object.toString();
        Object var4_5 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readString");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "reset");
        }
        try {
            if (!this.readOnly) {
                this.dataWritten.append("</stream>");
                this.streamBody = this.dataWritten.toString();
                this.dataWritten = null;
                this.readOnly = true;
            }
            this.dataToBeRead = new StringTokenizer(this.streamBody, "<>");
            this.retrying = false;
            if (!this.dataToBeRead.nextToken().equals(STREAM_BODY_NAME)) {
                throw this.newMessageFormatException(1010);
            }
            Object var2_1 = null;
            if (bTraceIsOn) {
                trace.exit(this, "reset");
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "reset");
            }
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        if (this.readOnly) {
            stringBuffer.append(this.streamBody);
        } else {
            stringBuffer.append((Object)this.dataWritten);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(boolean bl) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeBoolean");
        }
        try {
            this.writeObject(new Boolean(bl));
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBoolean");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(byte by) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeByte");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i1'", String.valueOf(by), this.dataWritten);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeByte");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeByte");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeBytes");
        }
        try {
            this.writeObject(byArray);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeBytes");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.dataWritten.append("<elt dt='bin.hex'>");
            JMSStreamMessage.binToHex(byArray, n, n2, this.dataWritten);
            this.dataWritten.append("</elt>");
            Object var5_4 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChar(char c) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeChar");
        }
        try {
            this.writeObject(new Character(c));
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeChar");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeChar");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDouble(double d) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeDouble");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'r8'", String.valueOf(d), this.dataWritten);
            Object var4_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeDouble");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeDouble");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFloat(float f) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeFloat");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'r4'", String.valueOf(f), this.dataWritten);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeFloat");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeFloat");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int n) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeInt");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i4'", String.valueOf(n), this.dataWritten);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeInt");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeInt");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long l) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeLong");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i8'", String.valueOf(l), this.dataWritten);
            Object var4_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeLong");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeLong");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object object) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeObject");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!(object == null || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
                throw this.newMessageFormatException(1018, object.getClass());
            }
            this.formatElement(STREAM_ELT_NAME, object, this.dataWritten);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(short s) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeShort");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i2'", String.valueOf(s), this.dataWritten);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeShort");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeShort");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeString(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeString");
        }
        try {
            this.writeObject(string);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeString");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeString");
            }
            throw throwable;
        }
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.messageClass.equals("jms_stream")) {
            this.messageClass = "jms_stream";
        }
        if (this.readOnly) {
            this.currentField = null;
            this.retrying = false;
            this.readPos = 0;
            this.dataToBeRead = new StringTokenizer(this.streamBody, "<>");
        }
    }
}

