/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSAcknowledgePoint;
import com.ibm.jms.JMSDestination;
import com.ibm.jms.JMSDestinationFactory;
import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.jms.JMSTrace;
import com.ibm.mq.MQCcsidTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

public abstract class JMSMessage
implements Message,
Serializable {
    static final long serialVersionUID = -4436266789041169376L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2002, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSMessage.java, jms, j600, j600-202-070608 1.114.1.14 07/04/10 13:43:34";
    String messageClass = "jms_none";
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    private static final String MCD_CLASS_NONE = "<mcd><Msd>jms_none</Msd></mcd>";
    private static final String MCD_CLASS_TEXT = "<mcd><Msd>jms_text</Msd></mcd>";
    private static final String MCD_CLASS_OBJECT = "<mcd><Msd>jms_object</Msd></mcd>";
    private static final String MCD_CLASS_MAP = "<mcd><Msd>jms_map</Msd></mcd>";
    private static final String MCD_CLASS_STREAM = "<mcd><Msd>jms_stream</Msd></mcd>";
    private static final String MCD_CLASS_BYTES = "<mcd><Msd>jms_bytes</Msd></mcd>";
    private static final String MCD_CLASS_TEXT_NULL_MSG = "<mcd><Msd>jms_text</Msd><msgbody xsi:nil=\"true\"></msgbody></mcd>";
    private static final byte[] OPEN_MCDMSD = "<mcd><Msd>".getBytes();
    private static final byte[] CLOSE_MSDMCD = "</Msd></mcd>".getBytes();
    private static final byte[] BYTES_NONE = "jms_none".getBytes();
    private static final byte[] BYTES_TEXT = "jms_text".getBytes();
    private static final byte[] BYTES_BYTES = "jms_bytes".getBytes();
    private static final byte[] BYTES_MAP = "jms_map".getBytes();
    private static final byte[] BYTES_STREAM = "jms_stream".getBytes();
    private static final byte[] BYTES_OBJECT = "jms_object".getBytes();
    static final StringBuffer NULL = new StringBuffer("<null>");
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final String CHARSET_PROPERTY = "JMS_IBM_Character_Set";
    private static final char[] BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private transient JMSAcknowledgePoint session = null;
    private boolean gotByConsume = false;
    static JMSTrace trace = null;
    transient JMSStringResources jmsStrings = null;
    private String jmsStringResourcesClassName;
    boolean propertiesReadOnly = false;
    protected Hashtable properties = new Hashtable();
    private String correlationId = null;
    private byte[] nativeCorrelId = null;
    private int deliveryMode = 2;
    private static final int NO_DELIVERY_MODE = -2;
    private static final int DELIVERY_MODE_UNKNOWN = -3;
    private boolean hideDeliveryMode = false;
    private long expiration = 0L;
    private long timeToLive = 0L;
    private int priority = 4;
    private boolean redelivered = false;
    private long timestamp = 0L;
    private String type = null;
    private transient JMSDestinationFactory destinationFactory = null;
    private Destination destination = null;
    private transient String destinationString = null;
    private Destination replyTo = null;
    private transient String replyToString = null;
    private String messageId = null;
    private byte[] nativeMessageId = null;
    private String msDomain = null;
    private String msFormat = null;
    private String msSet = null;
    private String msType = null;
    private String psTopic = null;
    private String psConnID = null;
    boolean isNullMessage = true;
    private static Object HELD_INTERNAL = "JMSMessage.HELD_INTERNAL";
    private transient byte[] userIDAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putApplNameAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putDateAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putTimeAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private transient int deliveryCountAsInt;
    private transient int msgTypeAsInt;
    private transient int groupSeqAsInt;
    private transient int putApplTypeAsInt;
    private transient int feedbackAsInt;
    private transient int reportExceptionAsInt;
    private transient int reportExpirationAsInt;
    private transient int reportCOAAsInt;
    private transient int reportCODAsInt;
    private transient int reportPANAsInt;
    private transient int reportNANAsInt;
    private transient int passCorrelIDAsInt;
    private transient int reportMsgIDAsInt;
    private transient int reportDiscardAsInt;
    private transient boolean lastMsgInGroupAsBool;
    private int ccsidForStrings;
    private boolean ccsidForStringsIsAscii;
    private boolean stringsNeedCcsidConversion;
    private String cachedCcsidAsStr = null;
    private int cachedCcsid;
    private String armCorrelator = null;
    private String wrmCorrelator = null;
    static boolean bTraceIsOn = false;

    private String convertBytesToString(byte[] byArray, boolean bl) throws JMSException {
        String string = null;
        boolean bl2 = false;
        if (this.stringsNeedCcsidConversion) {
            if (this.ccsidForStringsIsAscii) {
                if (bl) {
                    bl2 = true;
                } else {
                    bl2 = true;
                    for (int i = 0; i < byArray.length && bl2; ++i) {
                        bl2 = byArray[i] >= 0;
                    }
                }
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            String string2 = "";
            for (int i = 0; i < byArray.length; ++i) {
                string2 = string2 + (char)byArray[i];
            }
            string = string2;
        } else {
            if (this.cachedCcsidAsStr == null) {
                String string3 = String.valueOf(this.ccsidForStrings);
                this.cachedCcsidAsStr = MQCcsidTable.lookup((String)string3);
                if (this.cachedCcsidAsStr == null) {
                    this.cachedCcsidAsStr = string3;
                }
                this.cachedCcsid = this.ccsidForStrings;
            }
            try {
                string = new String(byArray, this.cachedCcsidAsStr);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.cachedCcsidAsStr = null;
                throw this.newJMSException(1001);
            }
        }
        return string;
    }

    public void _setCcsidForStrings(int n, boolean bl, boolean bl2) {
        this.ccsidForStrings = n;
        this.ccsidForStringsIsAscii = bl;
        this.stringsNeedCcsidConversion = bl2;
    }

    private Object getInternalPropForName(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getInternalPropForName");
        }
        Object object = null;
        if (string.equals("JMSXUserID")) {
            object = this.convertBytesToString(this.userIDAsBytes, false);
        } else if (string.equals("JMSXAppID")) {
            object = this.convertBytesToString(this.putApplNameAsBytes, false);
        } else if (string.equals("JMS_IBM_PutDate")) {
            object = this.convertBytesToString(this.putDateAsBytes, true);
        } else if (string.equals("JMS_IBM_PutTime")) {
            object = this.convertBytesToString(this.putTimeAsBytes, true);
        } else if (string.equals("JMSXDeliveryCount")) {
            object = new Integer(this.deliveryCountAsInt);
        } else if (string.equals("JMS_IBM_MsgType")) {
            object = new Integer(this.msgTypeAsInt);
        } else if (string.equals("JMSXGroupSeq")) {
            object = new Integer(this.groupSeqAsInt);
        } else if (string.equals("JMS_IBM_PutApplType")) {
            object = new Integer(this.putApplTypeAsInt);
        } else if (string.equals("JMS_IBM_Feedback")) {
            object = new Integer(this.feedbackAsInt);
        } else if (string.equals("JMS_IBM_Report_Exception")) {
            object = new Integer(this.reportExceptionAsInt);
        } else if (string.equals("JMS_IBM_Report_Expiration")) {
            object = new Integer(this.reportExpirationAsInt);
        } else if (string.equals("JMS_IBM_Report_COA")) {
            object = new Integer(this.reportCOAAsInt);
        } else if (string.equals("JMS_IBM_Report_COD")) {
            object = new Integer(this.reportCODAsInt);
        } else if (string.equals("JMS_IBM_Report_PAN")) {
            object = new Integer(this.reportPANAsInt);
        } else if (string.equals("JMS_IBM_Report_NAN")) {
            object = new Integer(this.reportNANAsInt);
        } else if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            object = new Integer(this.passCorrelIDAsInt);
        } else if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            object = new Integer(this.reportMsgIDAsInt);
        } else if (string.equals("JMS_IBM_Report_Discard_Msg")) {
            object = new Integer(this.reportDiscardAsInt);
        } else if (string.equals("JMS_IBM_Last_Msg_In_Group")) {
            object = new Boolean(this.lastMsgInGroupAsBool);
        } else if (string.equals("JMS_IBM_ArmCorrelator")) {
            object = this._getJMSIBMArmCorrelator();
        } else if (string.equals("JMS_IBM_RMCorrelator")) {
            object = this._getJMSIBMWrmCorrelator();
        } else {
            if (bTraceIsOn) {
                trace.exit(this, "getInternalPropForName via Exception");
            }
            throw this.newJMSException(1001);
        }
        if (bTraceIsOn) {
            trace.exit(this, "getInternalPropForName");
        }
        return object;
    }

    public void _setJMSXUserIDFromBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSXUserIDFromBytes");
        }
        if (byArray.length != 12) {
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSXUserIDFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.userIDAsBytes, 0, 12);
        this.properties.put("JMSXUserID", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSXUserIDFromBytes");
        }
    }

    public void _setJMSXPutAppIDFromBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSXPutAppIDFromBytes");
        }
        if (byArray.length != 28) {
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSXPutAppIDFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putApplNameAsBytes, 0, 28);
        this.properties.put("JMSXAppID", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSXPutAppIDFromBytes");
        }
    }

    public void _setJMSXDeliveryCountFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSXDeliveryCountFromInt");
        }
        this.deliveryCountAsInt = n;
        this.properties.put("JMSXDeliveryCount", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSXDeliveryCountFromInt");
        }
    }

    public void _setJMSIBMMsgTypeFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMMsgTypeFromInt");
        }
        this.msgTypeAsInt = n;
        this.properties.put("JMS_IBM_MsgType", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMMsgTypeFromInt");
        }
    }

    public int _getJMSIBMMsgTypeAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMMsgTypeAsInt");
        }
        int n = this.properties.get("JMS_IBM_MsgType") == HELD_INTERNAL ? this.msgTypeAsInt : this.getIntProperty("JMS_IBM_MsgType");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMMsgTypeAsInt");
        }
        return n;
    }

    public void _setJMSXGroupSeqFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSXGroupSeqFromInt");
        }
        this.groupSeqAsInt = n;
        this.properties.put("JMSXGroupSeq", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSXGroupSeqFromInt");
        }
    }

    public int _getJMSXGroupSeqAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSXGroupSeqAsInt");
        }
        int n = this.properties.get("JMSXGroupSeq") == HELD_INTERNAL ? this.groupSeqAsInt : this.getIntProperty("JMSXGroupSeq");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSXGroupSeqAsInt");
        }
        return n;
    }

    public void _setJMSIBMPutDateFromBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMPutDateFromBytes");
        }
        if (byArray.length != 8) {
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSIBMPutDateFromBytes via Exception");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putDateAsBytes, 0, 8);
        this.properties.put("JMS_IBM_PutDate", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMPutDateFromBytes");
        }
    }

    public void _setJMSIBMPutTimeFromBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMPutTimeFromBytes");
        }
        if (byArray.length != 8) {
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSIBMPutTimeFromBytes");
            }
            throw this.newJMSException(1001);
        }
        System.arraycopy(byArray, 0, this.putTimeAsBytes, 0, 8);
        this.properties.put("JMS_IBM_PutTime", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMPutTimeFromBytes");
        }
    }

    public void _setJMSIBMPutApplTypeFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMPutApplTypeFromInt");
        }
        this.putApplTypeAsInt = n;
        this.properties.put("JMS_IBM_PutApplType", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMPutApplTypeFromInt");
        }
    }

    public void _setJMSIBMFeedbackFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMFeedbackFromInt");
        }
        this.feedbackAsInt = n;
        this.properties.put("JMS_IBM_Feedback", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMFeedbackFromInt");
        }
    }

    public int _getJMSIBMFeedbackAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMFeedbackAsInt");
        }
        int n = this.properties.get("JMS_IBM_Feedback") == HELD_INTERNAL ? this.feedbackAsInt : this.getIntProperty("JMS_IBM_Feedback");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMFeedbackAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportExceptionFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportExceptionFromInt");
        }
        this.reportExceptionAsInt = n;
        this.properties.put("JMS_IBM_Report_Exception", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportExceptionFromInt");
        }
    }

    public int _getJMSIBMReportExceptionAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportExceptionAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Exception") == HELD_INTERNAL ? this.reportExceptionAsInt : this.getIntProperty("JMS_IBM_Report_Exception");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportExceptionAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportExpirationFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportExpirationFromInt");
        }
        this.reportExpirationAsInt = n;
        this.properties.put("JMS_IBM_Report_Expiration", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportExpirationFromInt");
        }
    }

    public int _getJMSIBMReportExpirationAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportExpirationAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Expiration") == HELD_INTERNAL ? this.reportExpirationAsInt : this.getIntProperty("JMS_IBM_Report_Expiration");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportExpirationAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportCOAFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportCOAFromInt");
        }
        this.reportCOAAsInt = n;
        this.properties.put("JMS_IBM_Report_COA", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportCOAFromInt");
        }
    }

    public int _getJMSIBMReportCOAAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportCOAAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_COA") == HELD_INTERNAL ? this.reportCOAAsInt : this.getIntProperty("JMS_IBM_Report_COA");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportCOAAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportCODFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportCODFromInt");
        }
        this.reportCODAsInt = n;
        this.properties.put("JMS_IBM_Report_COD", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportCODFromInt");
        }
    }

    public int _getJMSIBMReportCODAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportCODAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_COD") == HELD_INTERNAL ? this.reportCODAsInt : this.getIntProperty("JMS_IBM_Report_COD");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportCODAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportPANFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportPANFromInt");
        }
        this.reportPANAsInt = n;
        this.properties.put("JMS_IBM_Report_PAN", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportPANFromInt");
        }
    }

    public int _getJMSIBMReportPANAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportPANAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_PAN") == HELD_INTERNAL ? this.reportPANAsInt : this.getIntProperty("JMS_IBM_Report_PAN");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportPANAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportNANFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportNANFromInt");
        }
        this.reportNANAsInt = n;
        this.properties.put("JMS_IBM_Report_NAN", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportNANFromInt");
        }
    }

    public int _getJMSIBMReportNANAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportNANAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_NAN") == HELD_INTERNAL ? this.reportNANAsInt : this.getIntProperty("JMS_IBM_Report_NAN");
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportNANAsInt");
        }
        return n;
    }

    public void _setJMSIBMPassCorrelIDFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMPassCorrelIDFromInt");
        }
        this.passCorrelIDAsInt = n;
        this.properties.put("JMS_IBM_Report_Pass_Correl_ID", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMPassCorrelIDFromInt");
        }
    }

    public int _getJMSIBMPassCorrelIDAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMPassCorrelIDAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Pass_Correl_ID") == HELD_INTERNAL ? this.passCorrelIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Correl_ID");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMPassCorrelIDAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportMsgIDFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportMsgIDFromInt");
        }
        this.reportMsgIDAsInt = n;
        this.properties.put("JMS_IBM_Report_Pass_Msg_ID", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportMsgIDFromInt");
        }
    }

    public int _getJMSIBMReportMsgIDAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportMsgIDAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Pass_Msg_ID") == HELD_INTERNAL ? this.reportMsgIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Msg_ID");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportMsgIDAsInt");
        }
        return n;
    }

    public void _setJMSIBMReportDiscardFromInt(int n) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMReportDiscardFromInt");
        }
        this.reportDiscardAsInt = n;
        this.properties.put("JMS_IBM_Report_Discard_Msg", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMReportDiscardFromInt");
        }
    }

    public int _getJMSIBMReportDiscardAsInt() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMReportDiscardAsInt");
        }
        int n = this.properties.get("JMS_IBM_Report_Discard_Msg") == HELD_INTERNAL ? this.reportDiscardAsInt : this.getIntProperty("JMS_IBM_Report_Discard_Msg");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMReportDiscardAsInt");
        }
        return n;
    }

    public void _setJMSIBMLastMsgInGroupFromBool(boolean bl) {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSIBMLastMsgInGroupFromBool");
        }
        this.lastMsgInGroupAsBool = bl;
        this.properties.put("JMS_IBM_Last_Msg_In_Group", HELD_INTERNAL);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSIBMLastMsgInGroupFromBool");
        }
    }

    public boolean _getJMSIBMLastMsgInGroupAsBool() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMLastMsgInGroupAsBool");
        }
        boolean bl = this.properties.get("JMS_IBM_Last_Msg_In_Group") == HELD_INTERNAL ? this.lastMsgInGroupAsBool : this.getBooleanProperty("JMS_IBM_Last_Msg_In_Group");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMLastMsgInGroupAsBool");
        }
        return bl;
    }

    public JMSMessage() {
        if (bTraceIsOn) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
            trace.exit(this, "constructor");
        }
    }

    public static JMSMessage _copyFromMessage(Session session, Message message) throws JMSException {
        Object object;
        TextMessage textMessage;
        JMSMessage jMSMessage = null;
        if (bTraceIsOn) {
            trace.entry("com.ibm.jms.JMSMessage", "_copyFromMessage");
        }
        if (message instanceof TextMessage) {
            textMessage = session.createTextMessage();
            textMessage.setText(((TextMessage)message).getText());
            jMSMessage = (JMSMessage)textMessage;
        } else if (message instanceof BytesMessage) {
            int n;
            textMessage = session.createBytesMessage();
            ((BytesMessage)message).reset();
            object = new byte[4000];
            while ((n = ((BytesMessage)message).readBytes((byte[])object)) >= 0) {
                textMessage.writeBytes((byte[])object, 0, n);
            }
            jMSMessage = (JMSMessage)textMessage;
        } else if (message instanceof MapMessage) {
            textMessage = session.createMapMessage();
            object = ((MapMessage)message).getMapNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                textMessage.setObject(string, ((MapMessage)message).getObject(string));
            }
            jMSMessage = (JMSMessage)textMessage;
        } else if (message instanceof StreamMessage) {
            textMessage = session.createStreamMessage();
            ((StreamMessage)message).reset();
            try {
                while (true) {
                    textMessage.writeObject(((StreamMessage)message).readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                jMSMessage = (JMSMessage)textMessage;
            }
        } else if (message instanceof ObjectMessage) {
            textMessage = session.createObjectMessage();
            textMessage.setObject(((ObjectMessage)message).getObject());
            jMSMessage = (JMSMessage)textMessage;
        } else {
            jMSMessage = (JMSMessage)session.createMessage();
        }
        jMSMessage.setJMSType(message.getJMSType());
        jMSMessage.setJMSCorrelationID(message.getJMSCorrelationID());
        textMessage = message.getJMSReplyTo();
        if (textMessage instanceof JMSDestination) {
            jMSMessage.setJMSReplyTo((Destination)textMessage);
        }
        object = message.getPropertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            try {
                jMSMessage.setObjectProperty(string, message.getObjectProperty(string));
            }
            catch (Exception exception) {
                if (!bTraceIsOn) continue;
                trace.trace("com.ibm.jms.JMSMessage", "warning: property " + string + " discarded");
            }
        }
        if (bTraceIsOn) {
            trace.exit("com.ibm.jms.JMSMessage", "_copyFromMessage");
        }
        return jMSMessage;
    }

    public abstract byte[] _exportBody(int var1, String var2) throws JMSException;

    public String _getJmsFolder(boolean bl) throws JMSException {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSFolder");
        }
        stringBuffer.append("<jms>");
        String string = this._getJMSDestinationAsString();
        if (string == null) {
            if (bTraceIsOn) {
                trace.exit(this, "getJMSFolder via Exception");
            }
            throw this.newJMSException(1001);
        }
        this.formatElement("Dst", string, stringBuffer);
        String string2 = this._getJMSReplyToAsString();
        if (string2 != null) {
            this.formatElement("Rto", string2, stringBuffer);
        }
        if (this.timestamp != 0L) {
            stringBuffer.append("<Tms>");
            stringBuffer.append(String.valueOf(this.timestamp));
            stringBuffer.append("</Tms>");
        }
        if (this.expiration != 0L) {
            stringBuffer.append("<Exp>");
            stringBuffer.append(String.valueOf(this.expiration));
            stringBuffer.append("</Exp>");
        }
        if (this.correlationId != null && !this.correlationId.startsWith("ID:")) {
            this.formatElement("Cid", this.correlationId, stringBuffer);
        }
        if (this.priority != 4) {
            stringBuffer.append("<Pri>");
            stringBuffer.append(this.priority);
            stringBuffer.append("</Pri>");
        }
        if (!bl && !this.hideDeliveryMode || bl && this.deliveryMode != 2) {
            stringBuffer.append("<Dlv>");
            stringBuffer.append(this.deliveryMode);
            stringBuffer.append("</Dlv>");
        }
        if (this.destination instanceof Topic) {
            Object object;
            Object object2 = this.getObjectProperty("JMSXGroupID");
            if (object2 instanceof String) {
                this.formatElement("Gid", object2, stringBuffer);
            }
            if ((object = this.getObjectProperty("JMSXGroupSeq")) instanceof Integer) {
                this.formatElement("Seq", "", object.toString(), stringBuffer);
            }
        }
        stringBuffer.append("</jms>");
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSFolder");
        }
        return stringBuffer.toString();
    }

    public String _getMcdFolder() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getMcdFolder");
        }
        if (this.msDomain == null && this.type == null) {
            if (bTraceIsOn) {
                trace.exit(this, "_getMcdFolder");
            }
            if (this.messageClass == CLASS_TEXT && this.isNullMessage) {
                return MCD_CLASS_TEXT_NULL_MSG;
            }
            if (this.messageClass == CLASS_TEXT && !this.isNullMessage) {
                return MCD_CLASS_TEXT;
            }
            if (this.messageClass == CLASS_BYTES) {
                return MCD_CLASS_BYTES;
            }
            if (this.messageClass == CLASS_NONE) {
                return MCD_CLASS_NONE;
            }
            if (this.messageClass == CLASS_OBJECT) {
                return MCD_CLASS_OBJECT;
            }
            if (this.messageClass == CLASS_MAP) {
                return MCD_CLASS_MAP;
            }
            if (this.messageClass == CLASS_STREAM) {
                return MCD_CLASS_STREAM;
            }
            if (bTraceIsOn) {
                trace.trace(this, "Unhandled message class type in _getMcdFolder() - " + this.messageClass);
            }
            throw this.newJMSException(1001);
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("<mcd><Msd>");
        if (this.msDomain != null) {
            stringBuffer.append(this.msDomain);
            stringBuffer.append("</Msd>");
            if (this.msSet != null && this.msSet.length() > 0) {
                this.formatElement("Set", this.msSet, stringBuffer);
            }
            if (this.msType != null && this.msType.length() > 0) {
                this.formatElement("Type", this.msType, stringBuffer);
            }
            if (this.msFormat != null && this.msFormat.length() > 0) {
                this.formatElement("Fmt", this.msFormat, stringBuffer);
            }
        } else {
            stringBuffer.append(this.messageClass);
            stringBuffer.append("</Msd>");
            if (this.type != null) {
                this.formatElement("Type", this.type, stringBuffer);
            }
        }
        if (this.messageClass == CLASS_TEXT && this.isNullMessage) {
            stringBuffer.append("<msgbody xsi:nil=\"true\"></msgbody>");
        }
        stringBuffer.append("</mcd>");
        if (bTraceIsOn) {
            trace.exit(this, "_getMcdFolder");
        }
        return stringBuffer.toString();
    }

    public String _getPscFolder() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getPscFolder");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.psTopic == null || this.psConnID == null) {
            stringBuffer.append("<psc></psc>");
        } else {
            stringBuffer.append("<psc><Command>Publish</Command><PubOpt>None</PubOpt>");
            stringBuffer.append("<Topic>");
            this.backReference(stringBuffer, this.psTopic);
            stringBuffer.append("</Topic>");
            stringBuffer.append("<UNIQUE_CONNECTION_ID>" + this.psConnID + "</UNIQUE_CONNECTION_ID></psc>");
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getPscFolder");
        }
        return stringBuffer.toString();
    }

    public long _getTimeToLive() {
        if (bTraceIsOn) {
            trace.entry(this, "_getTimeToLive");
            trace.exit(this, "_getTimeToLive");
        }
        return this.timeToLive;
    }

    public String _getUsrFolder() throws JMSException {
        StringBuffer stringBuffer = new StringBuffer(40);
        if (bTraceIsOn) {
            trace.entry(this, "_getUsrFolder");
        }
        Enumeration enumeration = this.properties.keys();
        stringBuffer.append("<usr>");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("JMS")) continue;
            Object object = this.getObjectProperty(string);
            this.formatElement(string, object, stringBuffer);
        }
        stringBuffer.append("</usr>");
        if (bTraceIsOn) {
            trace.exit(this, "_getUsrFolder");
        }
        return stringBuffer.toString();
    }

    public String _getMQExtFolder() throws JMSException {
        StringBuffer stringBuffer = null;
        if (bTraceIsOn) {
            trace.entry(this, "_getMQExtFolder");
        }
        String string = this._getJMSIBMArmCorrelator();
        String string2 = this._getJMSIBMWrmCorrelator();
        if (string != null || string2 != null) {
            stringBuffer = new StringBuffer(40);
            stringBuffer.append("<mqext>");
            if (string != null) {
                this.formatElement("Arm", string, stringBuffer);
            }
            if (string2 != null) {
                this.formatElement("Wrm", string2, stringBuffer);
            }
            stringBuffer.append("</mqext>");
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getMQExtFolder");
        }
        return stringBuffer != null ? stringBuffer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _idToString(byte[] byArray) {
        if (bTraceIsOn) {
            trace.entry("com.ibm.jms.JMSMessage", "idToString");
        }
        try {
            if (byArray == null) {
                String string = null;
                return string;
            }
            int n = byArray.length;
            char[] cArray = new char[3 + 2 * n];
            cArray[0] = 73;
            cArray[1] = 68;
            cArray[2] = 58;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 += 256;
                }
                n2 += n3;
                cArray[2 * i + 3] = BIN2HEX[n3 / 16];
                cArray[2 * i + 4] = BIN2HEX[n3 % 16];
            }
            if (n2 == 0) {
                String string = null;
                return string;
            }
            String string = new String(cArray);
            return string;
        }
        finally {
            if (bTraceIsOn) {
                trace.exit("com.ibm.jms.JMSMessage", "idToString");
            }
        }
    }

    public abstract void _importBody(byte[] var1, int var2, int var3, String var4) throws JMSException;

    public void _parseJmsFolder(JMSDestinationFactory jMSDestinationFactory, String string, boolean bl) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_parseJmsFolder");
        }
        this.deliveryMode = -2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        if (!stringTokenizer.nextToken().equals("jms")) {
            throw this.newJMSException(1001);
        }
        String string2 = "";
        while (!string2.equals("/jms")) {
            String string3;
            stringTokenizer.nextToken("<");
            String string4 = stringTokenizer.nextToken("<");
            int n = string4.indexOf(">");
            string2 = string4.substring(0, n);
            String string5 = string4.substring(n + 1);
            if (string2.charAt(0) == '/') continue;
            if (string2.startsWith("Cid")) {
                this.setJMSCorrelationID((String)this.deformatElement("'string'", string5));
            } else if (string2.startsWith("Tms")) {
                this.timestamp = Long.parseLong(string5);
            } else if (string2.startsWith("Exp")) {
                this.expiration = Long.parseLong(string5);
            } else if (string2.startsWith("Rto")) {
                string3 = (String)this.deformatElement("'string'", string5);
                this._setJMSReplyToAsString(jMSDestinationFactory, string3);
            } else if (string2.startsWith("Dst")) {
                string3 = (String)this.deformatElement("'string'", string5);
                this._setJMSDestinationAsString(jMSDestinationFactory, string3);
            } else if (!bl && string2.startsWith("Dlv")) {
                this.deliveryMode = Integer.parseInt(string5);
            } else if (string2.startsWith("Gid")) {
                this.setObjectProperty("JMSXGroupID", this.deformatElement("'string'", string5));
            } else if (string2.startsWith("Seq")) {
                this.setObjectProperty("JMSXGroupSeq", this.deformatElement("'i4'", string5));
            }
            if ((string4 = stringTokenizer.nextToken(">")).charAt(1) == '/') continue;
            throw this.newMessageFormatException(1012);
        }
        if (bTraceIsOn) {
            trace.exit(this, "_parseJmsFolder");
        }
    }

    public void _parseJmsFolderUtf8(byte[] byArray, int n, int n2, JMSDestinationFactory jMSDestinationFactory, boolean bl) throws JMSException {
        try {
            int n3;
            if (bTraceIsOn) {
                trace.entry(this, "_parseJmsFolderUtf8");
            }
            this.deliveryMode = -2;
            while (byArray[n + (n2 - 1)] != 62) {
                --n2;
            }
            byte[] byArray2 = new byte[]{60, 106, 109, 115, 62};
            byte[] byArray3 = new byte[]{60, 47, 106, 109, 115, 62};
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                if (byArray[n + n3] == byArray2[n3]) continue;
                trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
                throw this.newMessageFormatException(1012);
            }
            n3 = n + n2 - byArray3.length;
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray[n3] != byArray3[i]) {
                    trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
                    throw this.newMessageFormatException(1012);
                }
                ++n3;
            }
            int n4 = n + byArray2.length;
            int n5 = n + n2 - byArray3.length;
            block16: while (n4 < n5) {
                int n6;
                while (byArray[n4] != 60) {
                    ++n4;
                }
                ++n4;
                int n7 = 0;
                boolean bl2 = false;
                while (byArray[n4] != 62) {
                    if (byArray[n4] == 32) {
                        bl2 = true;
                    }
                    if (!bl2) {
                        n6 = (char)byArray[n4];
                        if (n6 < 0) {
                            n6 = (char)(n6 + 256);
                        }
                        n7 = (n7 << 8) + n6;
                    }
                    ++n4;
                }
                n6 = ++n4;
                while (byArray[n4] != 62) {
                    ++n4;
                }
                int n8 = n4;
                while (byArray[n8] != 60) {
                    --n8;
                }
                int n9 = n8 - n6;
                while (byArray[n4] != 60) {
                    ++n4;
                }
                switch (n7) {
                    case 0x447374: {
                        String string = this.safeUTF8ToString(byArray, n6, n9);
                        this._setJMSDestinationAsString(jMSDestinationFactory, string);
                        continue block16;
                    }
                    case 5533043: {
                        this.timestamp = this.utf8ToLong(byArray, n6, n9);
                        continue block16;
                    }
                    case 4552816: {
                        this.expiration = this.utf8ToLong(byArray, n6, n9);
                        continue block16;
                    }
                    case 5272169: {
                        continue block16;
                    }
                    case 4484214: {
                        if (bl) continue block16;
                        this.deliveryMode = this.utf8ToInt(byArray, n6, n9);
                        continue block16;
                    }
                    case 4417892: {
                        String string = this.unsafeUTF8ToString(byArray, n6, n9);
                        this.setJMSCorrelationID(string);
                        continue block16;
                    }
                    case 5403759: {
                        String string = this.safeUTF8ToString(byArray, n6, n9);
                        this._setJMSReplyToAsString(jMSDestinationFactory, string);
                        continue block16;
                    }
                    case 4680036: {
                        String string = this.safeUTF8ToString(byArray, n6, n9);
                        this.setObjectProperty("JMSXGroupID", string);
                        continue block16;
                    }
                    case 5465457: {
                        int n10 = this.utf8ToInt(byArray, n6, n9);
                        this.setObjectProperty("JMSXGroupSeq", new Integer(n10));
                        continue block16;
                    }
                }
                String string = "unknown element name in jms folder: " + Integer.toHexString(n7);
                if (!bTraceIsOn) continue;
                trace.trace(this, string);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (bTraceIsOn) {
                trace.trace(3, this, "" + arrayIndexOutOfBoundsException);
            }
            if (bTraceIsOn) {
                trace.exit(this, "_parseJmsFolderUtf8 (via exception)");
            }
            throw this.newMessageFormatException(1012);
        }
        if (bTraceIsOn) {
            trace.exit(this, "_parseJmsFolderUtf8");
        }
    }

    public void _parseMQExtFolder(String string) throws JMSException {
        StringTokenizer stringTokenizer;
        if (bTraceIsOn) {
            trace.entry(this, "_parseMQExtFolder");
        }
        if (!(stringTokenizer = new StringTokenizer(string, "<>")).nextToken().equals("mqext")) {
            throw this.newJMSException(1001);
        }
        String string2 = stringTokenizer.nextToken();
        while (!string2.equals("/mqext")) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.charAt(0) == '/' ? "" : string3;
            if (string2.startsWith("Arm")) {
                this._setJMSIBMArmCorrelator((String)this.deformatElement("'string'", string4));
            } else if (string2.startsWith("Wrm")) {
                this._setJMSIBMWrmCorrelator((String)this.deformatElement("'string'", string4));
            }
            if (string3.charAt(0) != '/') {
                string3 = stringTokenizer.nextToken();
            }
            if (string3.charAt(0) != '/') {
                throw this.newMessageFormatException(1012);
            }
            string2 = stringTokenizer.nextToken();
        }
        if (bTraceIsOn) {
            trace.exit(this, "_parseMQExtFolder");
        }
    }

    public void _parseMQExtFolderUtf8(byte[] byArray, int n, int n2) throws JMSException {
        try {
            int n3;
            if (bTraceIsOn) {
                trace.entry(this, "_parseMQExtFolderUtf8");
            }
            while (byArray[n + (n2 - 1)] != 62) {
                --n2;
            }
            byte[] byArray2 = new byte[]{60, 109, 113, 101, 120, 116, 62};
            byte[] byArray3 = new byte[]{60, 47, 109, 113, 101, 120, 116, 62};
            for (n3 = 0; n3 < byArray2.length; ++n3) {
                if (byArray[n + n3] == byArray2[n3]) continue;
                trace.exit(this, "_parseMQExtFolderUtf8 (via exception)");
                throw this.newMessageFormatException(1012);
            }
            n3 = n + n2 - byArray3.length;
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray[n3] != byArray3[i]) {
                    trace.exit(this, "_parseMQExtFolderUtf8 (via exception)");
                    throw this.newMessageFormatException(1012);
                }
                ++n3;
            }
            int n4 = n + byArray2.length;
            int n5 = n + n2 - byArray3.length;
            block9: while (n4 < n5) {
                int n6;
                while (byArray[n4] != 60) {
                    ++n4;
                }
                ++n4;
                int n7 = 0;
                boolean bl = false;
                while (byArray[n4] != 62) {
                    if (byArray[n4] == 32) {
                        bl = true;
                    }
                    if (!bl) {
                        n6 = (char)byArray[n4];
                        if (n6 < 0) {
                            n6 = (char)(n6 + 256);
                        }
                        n7 = (n7 << 8) + n6;
                    }
                    ++n4;
                }
                n6 = ++n4;
                while (byArray[n4] != 62) {
                    ++n4;
                }
                int n8 = n4;
                while (byArray[n8] != 60) {
                    --n8;
                }
                int n9 = n8 - n6;
                while (byArray[n4] != 60) {
                    ++n4;
                }
                switch (n7) {
                    case 4289133: {
                        String string = this.safeUTF8ToString(byArray, n6, n9);
                        this._setJMSIBMArmCorrelator(string);
                        continue block9;
                    }
                    case 5730925: {
                        String string = this.safeUTF8ToString(byArray, n6, n9);
                        this._setJMSIBMWrmCorrelator(string);
                        continue block9;
                    }
                }
                String string = "unknown element name in mqext folder: " + Integer.toHexString(n7);
                if (!bTraceIsOn) continue;
                trace.trace(this, string);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (bTraceIsOn) {
                trace.trace(3, this, "" + arrayIndexOutOfBoundsException);
            }
            if (bTraceIsOn) {
                trace.exit(this, "_parseMQExtFolderUtf8 (via exception)");
            }
            throw this.newMessageFormatException(1012);
        }
        if (bTraceIsOn) {
            trace.exit(this, "_parseMQExtFolderUtf8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String safeUTF8ToString(byte[] byArray, int n, int n2) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "safeUTF8ToString");
        }
        try {
            char[] cArray = new char[n2];
            int n3 = n;
            int n4 = 0;
            boolean bl = false;
            int n5 = 0;
            while (n3 - n < n2) {
                byte by = byArray[n3];
                if (bl) {
                    if (by == 59) {
                        bl = false;
                        switch (n5) {
                            case 6385008: {
                                cArray[n4] = 38;
                                break;
                            }
                            case 26484: {
                                cArray[n4] = 62;
                                break;
                            }
                            case 27764: {
                                cArray[n4] = 60;
                                break;
                            }
                            case 1634758515: {
                                cArray[n4] = 39;
                                break;
                            }
                            case 1903521652: {
                                cArray[n4] = 34;
                                break;
                            }
                            default: {
                                if (bTraceIsOn) {
                                    trace.exit(this, "safeUTF8ToString (via exception)");
                                }
                                throw this.newMessageFormatException(1012);
                            }
                        }
                        ++n4;
                    } else {
                        if (by < 0) {
                            by = (byte)(by + 256);
                        }
                        n5 <<= 8;
                        n5 += by;
                    }
                } else if (by == 38) {
                    bl = true;
                    n5 = 0;
                } else {
                    cArray[n4] = (char)byArray[n3];
                    ++n4;
                }
                ++n3;
            }
            String string = new String(cArray, 0, n4);
            Object var16_11 = null;
            if (bTraceIsOn) {
                trace.exit(this, "safeUTF8ToString");
            }
            return string;
        }
        catch (Throwable throwable) {
            block20: {
                Object var16_12 = null;
                if (!bTraceIsOn) break block20;
                trace.exit(this, "safeUTF8ToString");
            }
            throw throwable;
        }
    }

    private String unsafeUTF8ToString(byte[] byArray, int n, int n2) throws JMSException {
        try {
            if (bTraceIsOn) {
                trace.entry(this, "unsafeUTF8ToString");
            }
            for (int i = 0; i < n2; ++i) {
                if (byArray[i + n] >= 0) continue;
                if (bTraceIsOn) {
                    trace.exit(this, "unsafeUTF8ToString");
                }
                return this.expandRefs(new String(byArray, n, n2, "UTF8"));
            }
            if (bTraceIsOn) {
                trace.exit(this, "unsafeUTF8ToString");
            }
            return this.safeUTF8ToString(byArray, n, n2);
        }
        catch (JMSException jMSException) {
            trace.exit(this, "unsafeUTF8ToString (via exception)");
            throw jMSException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (bTraceIsOn) {
                trace.exit(this, "unsafeUTF8ToString (via exception)");
            }
            throw this.newMessageFormatException(1012);
        }
    }

    private int utf8ToInt(byte[] byArray, int n, int n2) {
        int n3 = n2 + n;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            int n5 = byArray[i] - 48;
            if (n5 < 0 || n5 >= 10) {
                char[] cArray = new char[n2];
                for (int j = 0; j < n2; ++j) {
                    cArray[j] = (char)byArray[n + j];
                }
                String string = new String(cArray);
                return Integer.parseInt(string);
            }
            n4 = n4 * 10 + n5;
        }
        return n4;
    }

    private long utf8ToLong(byte[] byArray, int n, int n2) {
        int n3 = n2 + n;
        long l = 0L;
        for (int i = n; i < n3; ++i) {
            int n4 = byArray[i] - 48;
            if (n4 < 0 || n4 >= 10) {
                char[] cArray = new char[n2];
                for (int j = 0; j < n2; ++j) {
                    cArray[j] = (char)byArray[n + j];
                }
                String string = new String(cArray);
                return Long.parseLong(string);
            }
            l = l * 10L + (long)n4;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JMSMessage _parseMcdFolder(Session session, JMSStringResources jMSStringResources, String string, String string2) throws JMSException {
        StringTokenizer stringTokenizer;
        JMSMessage jMSMessage = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        if (bTraceIsOn) {
            trace.entry("com.ibm.jms.JMSMessage", "_parseMcdFolder");
        }
        if (!(stringTokenizer = new StringTokenizer(string, "<>")).nextToken().equals("mcd")) {
            jMSMessage = new JMSNullMessage(jMSStringResources);
            throw jMSMessage.newMessageFormatException(1012);
        }
        String string7 = stringTokenizer.nextToken();
        while (!string7.equals("/mcd")) {
            String string8;
            String string9;
            boolean bl2;
            block41: {
                block49: {
                    boolean bl3;
                    block40: {
                        block43: {
                            block48: {
                                block47: {
                                    block46: {
                                        block45: {
                                            block44: {
                                                block42: {
                                                    bl2 = false;
                                                    bl3 = false;
                                                    string9 = stringTokenizer.nextToken();
                                                    if (!string7.startsWith("msgbody")) break block42;
                                                    bl3 = true;
                                                    if (string7.indexOf("xsi:nil=\"true\"") != -1) {
                                                        bl = true;
                                                    }
                                                    break block40;
                                                }
                                                if (!string7.equals("Msd")) break block43;
                                                if (!string9.equals(CLASS_NONE)) break block44;
                                                jMSMessage = (JMSMessage)session.createMessage();
                                                break block40;
                                            }
                                            if (!string9.equals(CLASS_TEXT)) break block45;
                                            jMSMessage = (JMSMessage)session.createTextMessage();
                                            jMSMessage.isNullMessage = false;
                                            break block40;
                                        }
                                        if (!string9.equals(CLASS_BYTES)) break block46;
                                        jMSMessage = (JMSMessage)session.createBytesMessage();
                                        break block40;
                                    }
                                    if (!string9.equals(CLASS_MAP)) break block47;
                                    jMSMessage = (JMSMessage)session.createMapMessage();
                                    break block40;
                                }
                                if (!string9.equals(CLASS_STREAM)) break block48;
                                jMSMessage = (JMSMessage)session.createStreamMessage();
                                break block40;
                            }
                            if (string9.equals(CLASS_OBJECT)) {
                                jMSMessage = (JMSMessage)session.createObjectMessage();
                                break block40;
                            } else {
                                string4 = string9;
                                if (string2 == CLASS_TEXT) {
                                    jMSMessage = (JMSMessage)session.createTextMessage();
                                    jMSMessage.isNullMessage = false;
                                    break block40;
                                } else {
                                    if (string2 != CLASS_BYTES) {
                                        jMSMessage = new JMSNullMessage(jMSStringResources);
                                        throw jMSMessage.newMessageFormatException(1014);
                                    }
                                    jMSMessage = (JMSMessage)session.createBytesMessage();
                                }
                            }
                            break block40;
                        }
                        if (string7.equals("Type")) {
                            if (string9.equals("/Type")) {
                                string3 = "";
                                bl2 = true;
                            } else {
                                string3 = string9;
                            }
                        } else if (string7.equals("Set")) {
                            if (string9.equals("/Set")) {
                                string5 = "";
                                bl2 = true;
                            } else {
                                string5 = string9;
                            }
                        } else if (string7.equals("Fmt")) {
                            if (string9.equals("/Fmt")) {
                                string6 = "";
                                bl2 = true;
                            } else {
                                string6 = string9;
                            }
                        }
                    }
                    if (!bl3) break block49;
                    if (string7.charAt(string7.length() - 1) == '/') {
                        bl2 = true;
                        string8 = string9;
                        break block41;
                    } else if (string9.equals("/msgbody")) {
                        bl2 = true;
                        string8 = stringTokenizer.nextToken();
                        break block41;
                    } else {
                        string8 = stringTokenizer.nextToken();
                    }
                    break block41;
                }
                string8 = stringTokenizer.nextToken();
            }
            if (bl2) {
                if (string8.equals("/Type") || string8.equals("/Set") || string8.equals("/Fmt")) {
                    if (string8.equals("/Type")) {
                        string3 = string9;
                    } else if (string8.equals("/Set")) {
                        string5 = string9;
                    } else if (string8.equals("/Fmt")) {
                        string6 = string9;
                    }
                    string7 = stringTokenizer.nextToken();
                    continue;
                }
                string7 = string8;
                continue;
            }
            if (string8.charAt(0) != '/') {
                jMSMessage = new JMSNullMessage(jMSStringResources);
                throw jMSMessage.newMessageFormatException(1012);
            }
            string7 = stringTokenizer.nextToken();
        }
        if (string4 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("mcd://");
            stringBuffer.append(string4);
            if (string5 != null) {
                stringBuffer.append('/');
                stringBuffer.append(string5);
            }
            if (string3 != null) {
                if (string5 == null) {
                    stringBuffer.append('/');
                }
                stringBuffer.append('/');
                stringBuffer.append(string3);
            }
            if (string6 != null) {
                stringBuffer.append("?format=");
                stringBuffer.append(string6);
            }
            jMSMessage.setJMSType(stringBuffer.toString());
        } else if (string3 != null) {
            jMSMessage.setJMSType((String)jMSMessage.deformatElement("'string'", string3));
        }
        jMSMessage.isNullMessage = bl;
        if (bTraceIsOn) {
            trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolder");
        }
        return jMSMessage;
    }

    public static JMSMessage _parseMcdFolderUtf8(Session session, JMSStringResources jMSStringResources, String string, byte[] byArray, int n, int n2) throws JMSException {
        if (bTraceIsOn) {
            trace.entry("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8");
        }
        boolean bl = false;
        JMSMessage jMSMessage = null;
        while (byArray[n + (n2 - 1)] != 62) {
            --n2;
        }
        int n3 = n + n2 - 1;
        if (n3 < OPEN_MCDMSD.length + CLOSE_MSDMCD.length) {
            bl = true;
        } else if (byArray[n + 0] == 60 && byArray[n + 1] == 109 && byArray[n + 2] == 99 && byArray[n + 3] == 100 && byArray[n + 4] == 62 && byArray[n + 5] == 60 && byArray[n + 6] == 77 && byArray[n + 7] == 115 && byArray[n + 8] == 100 && byArray[n + 9] == 62 && byArray[n + 10] == 106 && byArray[n + 11] == 109 && byArray[n + 12] == 115 && byArray[n + 13] == 95 && byArray[n3 - 11] == 60 && byArray[n3 - 10] == 47 && byArray[n3 - 9] == 77 && byArray[n3 - 8] == 115 && byArray[n3 - 7] == 100 && byArray[n3 - 6] == 62 && byArray[n3 - 5] == 60 && byArray[n3 - 4] == 47 && byArray[n3 - 3] == 109 && byArray[n3 - 2] == 99 && byArray[n3 - 1] == 100) {
            if (byArray[n + 14] == 110 && byArray[n + 15] == 111 && byArray[n + 16] == 110 && byArray[n + 17] == 101 && n3 == n + MCD_CLASS_NONE.length() - 1) {
                jMSMessage = (JMSMessage)session.createMessage();
            } else if (byArray[n + 14] == 116 && byArray[n + 15] == 101 && byArray[n + 16] == 120 && byArray[n + 17] == 116 && n3 == n + MCD_CLASS_TEXT.length() - 1) {
                jMSMessage = (JMSMessage)session.createTextMessage();
                jMSMessage.isNullMessage = false;
            } else if (byArray[n + 14] == 111 && byArray[n + 15] == 98 && byArray[n + 16] == 106 && byArray[n + 17] == 101 && byArray[n + 18] == 99 && byArray[n + 19] == 116 && n3 == n + MCD_CLASS_OBJECT.length() - 1) {
                jMSMessage = (JMSMessage)session.createObjectMessage();
            } else if (byArray[n + 14] == 109 && byArray[n + 15] == 97 && byArray[n + 16] == 112 && n3 == n + MCD_CLASS_MAP.length() - 1) {
                jMSMessage = (JMSMessage)session.createMapMessage();
            } else if (byArray[n + 14] == 115 && byArray[n + 15] == 116 && byArray[n + 16] == 114 && byArray[n + 17] == 101 && byArray[n + 18] == 97 && byArray[n + 19] == 109 && n3 == n + MCD_CLASS_STREAM.length() - 1) {
                jMSMessage = (JMSMessage)session.createStreamMessage();
            } else if (byArray[n + 14] == 98 && byArray[n + 15] == 121 && byArray[n + 16] == 116 && byArray[n + 17] == 101 && byArray[n + 18] == 115 && n3 == n + MCD_CLASS_BYTES.length() - 1) {
                jMSMessage = (JMSMessage)session.createBytesMessage();
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            String string2 = null;
            try {
                string2 = new String(byArray, n, n2, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (bTraceIsOn) {
                    trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8 (via exception)");
                }
                int n4 = 1012;
                throw new MessageFormatException(jMSStringResources.getErrorMessage(n4), jMSStringResources.getNativeKey(n4));
            }
            jMSMessage = JMSMessage._parseMcdFolder(session, jMSStringResources, string2, string);
        }
        if (bTraceIsOn) {
            trace.exit("com.ibm.jms.JMSMessage", "_parseMcdFolderUtf8");
        }
        return jMSMessage;
    }

    public void _parseUsrFolder(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_parseUsrFolder");
        }
        try {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
                if (!stringTokenizer.nextToken().equals("usr")) {
                    throw this.newJMSException(1001);
                }
                String string2 = stringTokenizer.nextToken();
                while (!string2.equals("/usr")) {
                    String string3;
                    boolean bl = false;
                    int n = 0;
                    try {
                        n = string2.indexOf(" xsi:nil");
                        bl = n != -1;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (bl) {
                        this.setObjectProperty(string2.substring(0, n), null);
                        if (string2.charAt(string2.length() - 1) != '/') {
                            string3 = stringTokenizer.nextToken();
                            if (string3.charAt(0) != '/') {
                                string3 = stringTokenizer.nextToken();
                            }
                            if (string3.charAt(0) != '/') {
                                throw this.newMessageFormatException(1012);
                            }
                        }
                    } else if (!bl) {
                        String string4;
                        boolean bl2 = string2.charAt(string2.length() - 1) == '/';
                        int n2 = string2.indexOf(" dt=");
                        if (n2 != -1) {
                            string4 = string2.substring(n2 + 4, string2.length() - (bl2 ? 1 : 0));
                            string2 = string2.substring(0, n2);
                        } else {
                            if (bl2) {
                                string2 = string2.substring(0, string2.length() - 1);
                            }
                            string4 = "'string'";
                        }
                        if (bl2) {
                            this.setObjectProperty(string2, this.deformatElement(string4, ""));
                        } else {
                            String string5;
                            string3 = stringTokenizer.nextToken();
                            if (string3.startsWith('/' + string2) && !string3.equals('/' + string2)) {
                                if (bTraceIsOn) {
                                    trace.trace(this, "startsWith /: " + string2 + " Type : " + string4 + " value : " + string3);
                                }
                                this.setObjectProperty(string2, this.deformatElement(string4, string3));
                                string5 = stringTokenizer.nextToken();
                                if (string5.charAt(0) != '/') {
                                    throw this.newMessageFormatException(1012);
                                }
                            } else if (string3.startsWith('/' + string2)) {
                                if (bTraceIsOn) {
                                    trace.trace(this, "startsWith / 2 ");
                                }
                                this.setObjectProperty(string2, this.deformatElement(string4, ""));
                            } else {
                                if (bTraceIsOn) {
                                    trace.trace(this, "!!startsWith ");
                                }
                                this.setObjectProperty(string2, this.deformatElement(string4, string3));
                                string5 = stringTokenizer.nextToken();
                                if (string5.charAt(0) != '/') {
                                    throw this.newMessageFormatException(1012);
                                }
                            }
                        }
                    }
                    string2 = stringTokenizer.nextToken();
                }
                Object var12_14 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "_parseUsrFolder");
                }
            }
            catch (Exception exception) {
                JMSException jMSException = this.newMessageFormatException(1012);
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_parseUsrFolder");
            }
            throw throwable;
        }
    }

    public void _setJMSMessageIDAsBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSMessageIDAsBytes");
        }
        this.messageId = null;
        this.nativeMessageId = byArray;
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSMessageIDAsBytes");
        }
    }

    public void _setJMSXObjectProperty(String string, Object object) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSXObjectProperty");
        }
        this.properties.put(string, object);
        if (bTraceIsOn) {
            trace.exit(this, "_setJMSXObjectProperty");
        }
    }

    public void _setReadOnly() {
        this.propertiesReadOnly = true;
        this._setBodyReadOnly();
    }

    abstract void _setBodyReadOnly();

    public void _setSession(JMSAcknowledgePoint jMSAcknowledgePoint) {
        if (bTraceIsOn) {
            trace.entry(this, "MQMessage setSession");
        }
        this.session = jMSAcknowledgePoint;
        if (bTraceIsOn) {
            trace.exit(this, "MQMessage setSession");
        }
    }

    public void _setTimeToLive(long l, long l2) {
        if (bTraceIsOn) {
            trace.entry(this, "_setTimeToLive");
        }
        this.expiration = l2 == 0L ? 0L : l2 + l;
        this.timeToLive = l2;
        if (bTraceIsOn) {
            trace.exit(this, "_setTimeToLive");
        }
    }

    public static void _setTrace(JMSTrace jMSTrace) {
        if (jMSTrace == null) {
            bTraceIsOn = false;
        } else {
            trace = jMSTrace;
            bTraceIsOn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] _stringToId(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_stringToId");
        }
        try {
            byte[] byArray = this.hexToBin(string, 3);
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_stringToId");
            }
            return byArray;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block4;
                trace.exit(this, "_stringToId");
            }
            throw throwable;
        }
    }

    public void acknowledge() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "acknowledge");
        }
        if (this.session == null) {
            if (bTraceIsOn) {
                trace.trace(this, "acknowledge() not valid for this session type");
            }
            if (bTraceIsOn) {
                trace.exit(this, "acknowledge");
            }
        } else {
            this.session._acknowledge(this.gotByConsume);
        }
        if (bTraceIsOn) {
            trace.exit(this, "acknowledge");
        }
    }

    void backReference(StringBuffer stringBuffer, String string) throws JMSException {
        char c;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (!(c == '&' | c == '\"' | c == '\'' | c == '<' | c == '>')) continue;
            ++n2;
        }
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&apos;");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n3;
                if (n + 1 >= string.length()) {
                    String string2 = Integer.toHexString(c) + " ?";
                    throw this.newJMSException(1015, string2);
                }
                if (56320 > (n3 = string.charAt(++n)) || n3 >= 57344) {
                    String string3 = Integer.toHexString(c) + " " + Integer.toHexString(n3);
                    throw this.newJMSException(1015, string3);
                }
                n3 = (c - 55296 << 10) + n3 - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n3));
                stringBuffer.append(";");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    static int binToHex(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4 = byArray[i];
            if (n4 < 0) {
                n4 += 256;
            }
            n3 += n4;
            stringBuffer.append(BIN2HEX[n4 / 16]);
            stringBuffer.append(BIN2HEX[n4 % 16]);
        }
        return n3;
    }

    public abstract void clearBody() throws JMSException;

    public void clearProperties() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "clearProperties");
        }
        this.propertiesReadOnly = false;
        this.properties.clear();
        if (bTraceIsOn) {
            trace.exit(this, "clearProperties");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object deformatElement(String string, String string2) throws JMSException {
        Character c;
        block31: {
            Boolean bl;
            block30: {
                Boolean bl2;
                block29: {
                    byte[] byArray;
                    block28: {
                        byte[] byArray2;
                        block27: {
                            Double d;
                            block26: {
                                Float f;
                                block25: {
                                    Byte by;
                                    block24: {
                                        Long l;
                                        block23: {
                                            Short s;
                                            block22: {
                                                Integer n;
                                                block21: {
                                                    String string3;
                                                    block20: {
                                                        if (bTraceIsOn) {
                                                            trace.entry(this, "deformatElement:");
                                                            if (string2 == null) {
                                                                trace.trace(this, "type is " + string + " value is " + string2);
                                                            } else if (string2.length() <= 50) {
                                                                trace.trace(this, "type is " + string + " value is " + string2);
                                                            } else {
                                                                trace.trace(this, "type is " + string + " value starts " + string2.substring(0, 50));
                                                            }
                                                        }
                                                        try {
                                                            char c2 = string.charAt(0);
                                                            if (c2 != '\'' && c2 != '\"') {
                                                                throw this.newMessageFormatException();
                                                            }
                                                            String string4 = string.substring(1, string.indexOf(c2, 1));
                                                            if (string4.equals("string")) {
                                                                if (string2 == null) {
                                                                    Object var5_5 = null;
                                                                    Object var7_18 = null;
                                                                    if (!bTraceIsOn) return var5_5;
                                                                    trace.exit(this, "deformatElement");
                                                                    return var5_5;
                                                                }
                                                                string3 = this.expandRefs(string2);
                                                                break block20;
                                                            }
                                                            if (string4.equals("i4")) {
                                                                n = new Integer(string2);
                                                                break block21;
                                                            }
                                                            if (string4.equals("i2")) {
                                                                s = new Short(string2);
                                                                break block22;
                                                            }
                                                            if (string4.equals("i8")) {
                                                                l = new Long(string2);
                                                                break block23;
                                                            }
                                                            if (string4.equals("i1")) {
                                                                by = new Byte(string2);
                                                                break block24;
                                                            }
                                                            if (string4.equals("r4")) {
                                                                f = new Float(string2);
                                                                break block25;
                                                            }
                                                            if (string4.equals("r8")) {
                                                                d = new Double(string2);
                                                                break block26;
                                                            }
                                                            if (string4.equals("bin.hex")) {
                                                                if (string2.length() == 0) {
                                                                    byArray2 = new byte[]{};
                                                                    break block27;
                                                                }
                                                                byArray = this.hexToBin(string2, 0);
                                                                break block28;
                                                            }
                                                            if (string4.equals("boolean")) {
                                                                if (string2.equals("1")) {
                                                                    bl2 = new Boolean(true);
                                                                    break block29;
                                                                }
                                                                if (!string2.equals("0")) throw this.newMessageFormatException();
                                                                bl = new Boolean(false);
                                                                break block30;
                                                            }
                                                            if (!string4.equals("char")) throw this.newMessageFormatException(1018, string4);
                                                            c = new Character(this.expandRefs(string2).charAt(0));
                                                            break block31;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var7_31 = null;
                                                            if (!bTraceIsOn) throw throwable;
                                                            trace.exit(this, "deformatElement");
                                                            throw throwable;
                                                        }
                                                    }
                                                    Object var7_19 = null;
                                                    if (!bTraceIsOn) return string3;
                                                    trace.exit(this, "deformatElement");
                                                    return string3;
                                                }
                                                Object var7_20 = null;
                                                if (!bTraceIsOn) return n;
                                                trace.exit(this, "deformatElement");
                                                return n;
                                            }
                                            Object var7_21 = null;
                                            if (!bTraceIsOn) return s;
                                            trace.exit(this, "deformatElement");
                                            return s;
                                        }
                                        Object var7_22 = null;
                                        if (!bTraceIsOn) return l;
                                        trace.exit(this, "deformatElement");
                                        return l;
                                    }
                                    Object var7_23 = null;
                                    if (!bTraceIsOn) return by;
                                    trace.exit(this, "deformatElement");
                                    return by;
                                }
                                Object var7_24 = null;
                                if (!bTraceIsOn) return f;
                                trace.exit(this, "deformatElement");
                                return f;
                            }
                            Object var7_25 = null;
                            if (!bTraceIsOn) return d;
                            trace.exit(this, "deformatElement");
                            return d;
                        }
                        Object var7_26 = null;
                        if (!bTraceIsOn) return byArray2;
                        trace.exit(this, "deformatElement");
                        return byArray2;
                    }
                    Object var7_27 = null;
                    if (!bTraceIsOn) return byArray;
                    trace.exit(this, "deformatElement");
                    return byArray;
                }
                Object var7_28 = null;
                if (!bTraceIsOn) return bl2;
                trace.exit(this, "deformatElement");
                return bl2;
            }
            Object var7_29 = null;
            if (!bTraceIsOn) return bl;
            trace.exit(this, "deformatElement");
            return bl;
        }
        Object var7_30 = null;
        if (!bTraceIsOn) return c;
        trace.exit(this, "deformatElement");
        return c;
    }

    String expandRefs(String string) throws JMSException {
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('&' == c) {
                String string2 = string.substring(i + 1, i + 4);
                if (string2.equals("lt;")) {
                    stringBuffer.append('<');
                    i += 3;
                    continue;
                }
                if (string2.equals("gt;")) {
                    stringBuffer.append('>');
                    i += 3;
                    continue;
                }
                if (string.substring(i + 1, i + 5).equals("amp;")) {
                    stringBuffer.append("&");
                    i += 4;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("apos;")) {
                    stringBuffer.append("'");
                    i += 5;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("quot;")) {
                    stringBuffer.append('\"');
                    i += 5;
                    continue;
                }
                throw this.newMessageFormatException(1016, "&" + string2);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void formatElement(String string, Object object, StringBuffer stringBuffer) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "formatElement");
        }
        try {
            boolean bl = false;
            stringBuffer.append("<");
            stringBuffer.append(string);
            if (object instanceof String) {
                stringBuffer.append(">");
                this.backReference(stringBuffer, (String)object);
                bl = true;
            } else if (object instanceof Integer) {
                stringBuffer.append(" dt='i4'>");
            } else if (object instanceof Short) {
                stringBuffer.append(" dt='i2'>");
            } else if (object instanceof Byte) {
                stringBuffer.append(" dt='i1'>");
            } else if (object instanceof Long) {
                stringBuffer.append(" dt='i8'>");
            } else if (object instanceof Float) {
                stringBuffer.append(" dt='r4'>");
            } else if (object instanceof Double) {
                stringBuffer.append(" dt='r8'>");
            } else if (object instanceof byte[]) {
                stringBuffer.append(" dt='bin.hex'>");
                JMSMessage.binToHex((byte[])object, 0, ((byte[])object).length, stringBuffer);
                bl = true;
            } else if (object instanceof Boolean) {
                stringBuffer.append(" dt='boolean'>");
                object = ((Boolean)object).booleanValue() ? "1" : "0";
            } else if (object instanceof Character) {
                stringBuffer.append(" dt='char'>");
                this.backReference(stringBuffer, ((Character)object).toString());
                bl = true;
            } else if (object == null || object == NULL) {
                stringBuffer.append(" xsi:nil='true'>");
                stringBuffer.append("</");
                stringBuffer.append(string);
                stringBuffer.append(">");
                Object var6_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "formatElement");
                }
                return;
            }
            if (!bl) {
                stringBuffer.append(object.toString());
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bTraceIsOn) {
                trace.exit(this, "formatElement");
            }
            throw throwable;
        }
        Object var6_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "formatElement");
        }
    }

    void formatElement(String string, String string2, String string3, StringBuffer stringBuffer) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "formatElement");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (string2 != "") {
            stringBuffer.append(" dt=" + string2);
        }
        stringBuffer.append(">");
        stringBuffer.append(string3);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        if (bTraceIsOn) {
            trace.exit(this, "formatElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBooleanProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getBooleanProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            boolean bl = this.toBoolean(this._getProperty(string));
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getBooleanProperty");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getBooleanProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByteProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getByteProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            byte by = this.toByte(this._getProperty(string));
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getByteProperty");
            }
            return by;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getByteProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDoubleProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getDoubleProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            double d = this.toDouble(this._getProperty(string));
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getDoubleProperty");
            }
            return d;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getDoubleProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloatProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getFloatProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            float f = this.toFloat(this._getProperty(string));
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getFloatProperty");
            }
            return f;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getFloatProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getIntProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            int n = this.toInt(this._getProperty(string));
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getIntProperty");
            }
            return n;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getIntProperty");
            }
            throw throwable;
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSCorrelationID");
        }
        if (this.correlationId == null && this.nativeCorrelId != null) {
            this.correlationId = JMSMessage._idToString(this.nativeCorrelId);
        }
        if (bTraceIsOn) {
            trace.exit(this, "getJMSCorrelationID");
        }
        return this.correlationId;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSCorrelationID");
        }
        try {
            if (this.nativeCorrelId == null && this.correlationId != null) {
                this.nativeCorrelId = this.correlationId.getBytes("UTF8");
            }
            byte[] byArray = this.nativeCorrelId;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getJMSCorrelationIDXX - " + this.nativeCorrelId);
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                JMSException jMSException = this.newJMSException(1022);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                if (bTraceIsOn) {
                    trace.exit(this, "setJMSCorrelationID, via Exception");
                }
                throw jMSException;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_4 = null;
                    if (!bTraceIsOn) break block8;
                    trace.exit(this, "getJMSCorrelationIDXX - " + this.nativeCorrelId);
                }
                throw throwable;
            }
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSDeliveryMode");
            trace.exit(this, "getJMSDeliveryMode");
        }
        return this.deliveryMode;
    }

    public Destination getJMSDestination() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSDestination");
        }
        if (this.destination == null && this.destinationString != null) {
            if (this.destinationFactory == null) {
                if (bTraceIsOn) {
                    trace.trace(this, "destinationFactory unexpectedly null");
                }
            } else {
                this.destination = this.destinationFactory.createDestination(this.destinationString);
                if (this.replyTo != null || this.replyToString == null) {
                    this.destinationFactory = null;
                }
            }
        }
        if (bTraceIsOn) {
            trace.exit(this, "getJMSDestination");
        }
        return this.destination;
    }

    public long getJMSExpiration() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSExpiration");
            trace.exit(this, "getJMSExpiration");
        }
        return this.expiration;
    }

    public String getJMSMessageID() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSMessageID");
        }
        if (this.messageId == null && this.nativeMessageId != null) {
            this.messageId = JMSMessage._idToString(this.nativeMessageId);
            this.nativeMessageId = null;
        }
        if (bTraceIsOn) {
            trace.exit(this, "getJMSMessageID");
        }
        return this.messageId;
    }

    public int getJMSPriority() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSPriority");
            trace.exit(this, "getJMSPriority");
        }
        return this.priority;
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSRedelivered");
            trace.exit(this, "getJMSRedelivered");
        }
        return this.redelivered;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSReplyTo");
        }
        if (this.replyTo == null && this.replyToString != null) {
            if (this.destinationFactory == null) {
                if (bTraceIsOn) {
                    trace.trace(this, "destinationFactory unexpectedly null");
                }
            } else {
                this.replyTo = this.destinationFactory.createDestination(this.replyToString);
                if (this.destination != null || this.destinationString == null) {
                    this.destinationFactory = null;
                }
            }
        }
        if (bTraceIsOn) {
            trace.exit(this, "getJMSReplyTo");
        }
        return this.replyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSTimestamp");
            trace.exit(this, "getJMSTimestamp");
        }
        return this.timestamp;
    }

    public String getJMSType() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getJMSType");
            trace.exit(this, "getJMSType");
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getLongProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            long l = this.toLong(this._getProperty(string));
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getLongProperty");
            }
            return l;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getLongProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectProperty(String string) throws JMSException {
        Object object;
        block7: {
            if (bTraceIsOn) {
                trace.entry(this, "getObjectProperty");
            }
            try {
                if (string == null) {
                    throw this.newJMSException(1003, string);
                }
                object = this._getProperty(string);
                if (object != null && object != NULL) break block7;
                Object var3_3 = null;
                Object var5_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "getObjectProperty");
                }
                return var3_3;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_7 = null;
                    if (!bTraceIsOn) break block8;
                    trace.exit(this, "getObjectProperty");
                }
                throw throwable;
            }
        }
        Object object2 = object;
        Object var5_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "getObjectProperty");
        }
        return object2;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getPropertyNames");
            trace.exit(this, "getPropertyNames");
        }
        return this.properties.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShortProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "getShortProperty");
        }
        try {
            if (string == null) {
                throw this.newJMSException(1003, string);
            }
            short s = this.toShort(this._getProperty(string));
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "getShortProperty");
            }
            return s;
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block5;
                trace.exit(this, "getShortProperty");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringProperty(String string) throws JMSException {
        Object object;
        block7: {
            if (bTraceIsOn) {
                trace.entry(this, "getStringProperty");
            }
            try {
                if (string == null) {
                    throw this.newJMSException(1003, string);
                }
                object = this._getProperty(string);
                if (object != null && object != NULL) break block7;
                String string2 = null;
                Object var5_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "getStringProperty");
                }
                return string2;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_7 = null;
                    if (!bTraceIsOn) break block8;
                    trace.exit(this, "getStringProperty");
                }
                throw throwable;
            }
        }
        String string3 = object.toString();
        Object var5_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "getStringProperty");
        }
        return string3;
    }

    byte[] hexToBin(String string, int n) throws JMSException {
        int n2 = string.length() - n;
        if (bTraceIsOn) {
            trace.trace(3, "JMSMessage", "Converting hex to Binary " + string.substring(n));
        }
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 < 0 || n2 % 2 != 0) {
            throw this.newJMSException(1006, string.substring(n));
        }
        byte[] byArray = new byte[n2 /= 2];
        for (int i = 0; i < n2; ++i) {
            int n3 = Character.digit(string.charAt(2 * i + n), 16) << 4;
            int n4 = Character.digit(string.charAt(2 * i + n + 1), 16);
            if (n3 < 0 || n4 < 0) {
                throw this.newJMSException(1006, string.substring(n));
            }
            byArray[i] = (byte)(n3 + n4);
        }
        return byArray;
    }

    private boolean isSettablePropertyName(String string) {
        if (bTraceIsOn) {
            trace.trace(this, "Checking property name " + string + "for validity");
        }
        if (string == null) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        if (string.startsWith("JMS")) {
            return this.jmsStrings.getJMS_IBM_names().containsKey(string) || string.equals("JMSXGroupID") || string.equals("JMSXGroupSeq") || string.equals("JMSXUserID") || string.equals("JMSXAppID") || string.equals("JMSXDeliveryCount") || string.equals("JMSXState") || string.equals("JMSXProducerTXID") || string.equals("JMSXConsumerTXID") || string.equals("JMSXRcvTimestamp");
        }
        return true;
    }

    JMSException newJMSException(int n) {
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newJMSException(int n, Object object) {
        String string = this.jmsStrings.getErrorMessage(n, object);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newJMSException(int n, Object object, Object object2) {
        String string = this.jmsStrings.getErrorMessage(n, object, object2);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing JMS Exception " + string);
        }
        return new JMSException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageEOFException() {
        int n = 5;
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageEOFException " + string);
        }
        return new MessageEOFException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException() {
        int n = 6;
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException(int n) {
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageFormatException(int n, Object object) {
        String string = this.jmsStrings.getErrorMessage(n, object);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageFormatException " + string);
        }
        return new MessageFormatException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageNotReadableException() {
        int n = 7;
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageNotReadable Exception " + string);
        }
        return new MessageNotReadableException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newMessageNotWriteableException() {
        int n = 8;
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing MessageNotWriteableException " + string);
        }
        return new MessageNotWriteableException(string, this.jmsStrings.getNativeKey(n));
    }

    JMSException newResourceAllocationException() {
        int n = 9;
        String string = this.jmsStrings.getErrorMessage(n);
        if (bTraceIsOn) {
            trace.trace(0, this, "Throwing ResourceAllocationException " + string);
        }
        return new ResourceAllocationException(string, this.jmsStrings.getNativeKey(n));
    }

    public boolean propertyExists(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "propertyExists");
        }
        if (string == null) {
            if (bTraceIsOn) {
                trace.exit(this, "propertyExists (via Exception)");
            }
            throw this.newJMSException(1003, string);
        }
        boolean bl = this.properties.containsKey(string);
        if (bTraceIsOn) {
            trace.exit(this, "propertyExists");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProperty(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "removeProperty");
        }
        try {
            this.properties.remove(string);
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "removeProperty");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "removeProperty");
            }
            throw throwable;
        }
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setBooleanProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setBooleanProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setBooleanProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Boolean(bl));
        if (bTraceIsOn) {
            trace.exit(this, "setBooleanProperty");
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setByteProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setByteProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setByteProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Byte(by));
        if (bTraceIsOn) {
            trace.exit(this, "setByteProperty");
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setDoubleProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setDoubleProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setDoubleProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Double(d));
        if (bTraceIsOn) {
            trace.exit(this, "setDoubleProperty");
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setFloatProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setFloatProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setFloatProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Float(f));
        if (bTraceIsOn) {
            trace.exit(this, "setFloatProperty");
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setIntProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setIntProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setIntProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Integer(n));
        if (bTraceIsOn) {
            trace.exit(this, "setIntProperty");
        }
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSCorrelationID");
        }
        this.nativeCorrelId = (byte[])(string == null ? null : (byte[])(string.startsWith("ID:") ? this._stringToId(string) : null));
        this.correlationId = string;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSCorrelationID");
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSCorrelationIDAsBytes");
        }
        if (byArray == null) {
            this.nativeCorrelId = null;
            this.correlationId = null;
        } else {
            this.nativeCorrelId = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.nativeCorrelId, 0, byArray.length);
            this.correlationId = null;
        }
        if (bTraceIsOn) {
            trace.exit(this, "setJMSCorrelationIDAsBytes");
        }
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSDeliveryMode");
        }
        if (n == -2) {
            this.deliveryMode = 2;
            this.hideDeliveryMode = true;
        } else if (n == -3) {
            this.deliveryMode = -2;
            this.hideDeliveryMode = true;
        } else {
            this.deliveryMode = n;
            this.hideDeliveryMode = false;
        }
        if (bTraceIsOn) {
            trace.exit(this, "setJMSDeliveryMode");
        }
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSDestination");
        }
        this.destination = destination;
        this.destinationString = null;
        if (this.replyTo != null || this.replyToString == null) {
            this.destinationFactory = null;
        }
        if (bTraceIsOn) {
            trace.exit(this, "setJMSDestination");
        }
    }

    public void setJMSExpiration(long l) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSExpiration");
        }
        this.expiration = l;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSExpiration");
        }
    }

    public void setJMSMessageID(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSMessageID");
        }
        this.messageId = string;
        this.nativeMessageId = null;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSMessageID");
        }
    }

    public void setJMSPriority(int n) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSPriority");
        }
        this.priority = n;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSPriority");
        }
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSRedelivered");
        }
        this.redelivered = bl;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSRedelivered");
        }
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSReplyTo");
        }
        this.replyTo = destination;
        this.replyToString = null;
        if (this.destination != null || this.destinationString == null) {
            this.destinationFactory = null;
        }
        if (bTraceIsOn) {
            trace.exit(this, "setJMSReplyTo");
        }
    }

    public void setJMSTimestamp(long l) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSTimestamp");
        }
        this.timestamp = l;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSTimestamp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJMSType(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setJMSType");
        }
        try {
            if (string == null || !string.startsWith("mcd://")) {
                this.type = string;
                this.msDomain = null;
                this.msSet = null;
                this.msType = null;
                this.msFormat = null;
                Object var11_2 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "setJMSType");
                }
                return;
            }
            if (this.messageClass != CLASS_TEXT && this.messageClass != CLASS_BYTES) {
                throw this.newJMSException(1028, "JMSType", string);
            }
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = 6;
            int n2 = string.indexOf(63, n);
            String string6 = n2 == -1 ? string : string.substring(0, n2);
            int n3 = string6.indexOf(47, n);
            if (n3 == -1) {
                if (string6.length() <= 6) {
                    throw this.newJMSException(1028, "JMSType", string);
                }
                string2 = string6.substring(n);
            } else {
                if (n3 == n) {
                    throw this.newJMSException(1028, "JMSType", string);
                }
                string2 = string6.substring(n, n3);
                n = n3 + 1;
                if ((n3 = string6.indexOf(47, n)) == -1) {
                    string3 = string6.substring(n);
                } else {
                    string3 = string6.substring(n, n3);
                    n = n3 + 1;
                    if ((n3 = string6.indexOf(47, n)) != -1) {
                        throw this.newJMSException(1028, "JMSType", string);
                    }
                    string4 = string6.substring(n);
                }
            }
            if (n2 > 0) {
                if (string.regionMatches(true, n2, "?format=", 0, 8)) {
                    string5 = string.substring(n2 + 8);
                    if (string5.indexOf(38) != -1) {
                        throw this.newJMSException(1028, "JMSType", string);
                    }
                } else {
                    throw this.newJMSException(1028, "JMSType", string);
                }
            }
            this.type = string;
            this.msDomain = string2;
            this.msSet = string3;
            this.msType = string4;
            this.msFormat = string5;
        }
        catch (Throwable throwable) {
            Object var11_4 = null;
            if (bTraceIsOn) {
                trace.exit(this, "setJMSType");
            }
            throw throwable;
        }
        Object var11_3 = null;
        if (bTraceIsOn) {
            trace.exit(this, "setJMSType");
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setLongProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setLongProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setLongProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Long(l));
        if (bTraceIsOn) {
            trace.exit(this, "setLongProperty");
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setObjectProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setObjectProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setObjectProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        if (object == null) {
            this.properties.put(string, NULL);
        } else if (object instanceof byte[]) {
            this.properties.put(string, "");
        } else {
            if (!(object instanceof String || object instanceof Number || object instanceof Boolean)) {
                if (bTraceIsOn) {
                    trace.exit(this, "setObjectProperty (via Exception)");
                }
                throw new MessageFormatException("Invalid Object type");
            }
            this.properties.put(string, object);
        }
        if (bTraceIsOn) {
            trace.exit(this, "setObjectProperty");
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setShortProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setShortProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string2 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string2);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setShortProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        this.properties.put(string, new Short(s));
        if (bTraceIsOn) {
            trace.exit(this, "setShortProperty");
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setStringProperty");
        }
        if (this.propertiesReadOnly) {
            if (bTraceIsOn) {
                trace.exit(this, "setStringProperty (via Exception)");
            }
            throw this.newMessageNotWriteableException();
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = this.jmsStrings.getErrorMessage(1020, string);
            throw new IllegalArgumentException(string3);
        }
        if (!this.isSettablePropertyName(string)) {
            if (bTraceIsOn) {
                trace.exit(this, "setStringProperty (via Exception)");
            }
            throw this.newMessageFormatException(1020, string);
        }
        if (string2 == null) {
            this.properties.put(string, NULL);
        } else {
            this.properties.put(string, string2);
        }
        if (bTraceIsOn) {
            trace.exit(this, "setStringProperty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setJMSDestinationAsString(JMSDestinationFactory jMSDestinationFactory, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSDestinationAsString");
        }
        try {
            if (string == null) {
                this.destination = null;
                this.destinationString = null;
                if (this.replyTo != null || this.replyToString == null) {
                    this.destinationFactory = null;
                }
            } else {
                if (jMSDestinationFactory == null || this.destinationFactory != null && jMSDestinationFactory != this.destinationFactory) {
                    if (bTraceIsOn) {
                        trace.trace(this, "Internal error: Invalid destination factory, or did not match existing df");
                    }
                    throw this.newJMSException(1001);
                }
                this.destination = null;
                this.destinationString = string;
                this.destinationFactory = jMSDestinationFactory;
            }
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSDestinationAsString");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSDestinationAsString");
            }
            throw throwable;
        }
    }

    private String _getJMSDestinationAsString() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSDestinationAsString");
        }
        if (this.destinationString == null && this.destination != null) {
            this.destinationString = ((JMSDestination)this.destination).getStringFromDestination();
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSDestinationAsString");
        }
        return this.destinationString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setJMSReplyToAsString(JMSDestinationFactory jMSDestinationFactory, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_setJMSReplyToAsString");
        }
        try {
            if (string == null) {
                this.replyTo = null;
                this.replyToString = null;
                if (this.destination != null || this.destinationString == null) {
                    this.destinationFactory = null;
                }
            } else {
                if (jMSDestinationFactory == null || this.destinationFactory != null && jMSDestinationFactory != this.destinationFactory) {
                    if (bTraceIsOn) {
                        trace.trace(this, "Internal error: Invalid destination factory, or did not match existing df");
                    }
                    throw this.newJMSException(1001);
                }
                this.replyTo = null;
                this.replyToString = string;
                this.destinationFactory = jMSDestinationFactory;
            }
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSReplyToAsString");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_setJMSReplyToAsString");
            }
            throw throwable;
        }
    }

    private String _getJMSReplyToAsString() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSReplyToAsString");
        }
        if (this.replyToString == null && this.replyTo != null) {
            this.replyToString = ((JMSDestination)this.replyTo).getStringFromDestination();
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSReplyToAsString");
        }
        return this.replyToString;
    }

    public boolean _hasJMSReplyTo() {
        return this.replyToString != null || this.replyTo != null;
    }

    private Object _getProperty(String string) throws JMSException {
        Object object;
        if (bTraceIsOn) {
            trace.entry(this, "_getProperty");
        }
        if ((object = this.properties.get(string)) == HELD_INTERNAL) {
            object = this.getInternalPropForName(string);
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getProperty");
        }
        return object;
    }

    boolean toBoolean(Object object) throws JMSException {
        if (object == null || object == NULL) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    byte toByte(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    byte[] toBytes(Object object) throws JMSException {
        if (object == null || object == NULL) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    char toChar(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    double toDouble(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    float toFloat(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NullPointerException();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    int toInt(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    long toLong(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).longValue();
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    short toShort(Object object) throws JMSException {
        if (object == null || object == NULL) {
            throw new NumberFormatException();
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Byte) {
            return ((Byte)object).shortValue();
        }
        if (object instanceof String) {
            return Short.valueOf((String)object);
        }
        throw this.newMessageFormatException(1017, object.getClass());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\n" + this.jmsStrings.getMessage(1013) + ": " + this.messageClass);
            stringBuffer.append("\n  JMSType:         " + this.type);
            stringBuffer.append("\n  JMSDeliveryMode: " + this.deliveryMode);
            stringBuffer.append("\n  JMSExpiration:   " + this.expiration);
            stringBuffer.append("\n  JMSPriority:     " + this.priority);
            stringBuffer.append("\n  JMSMessageID:    " + this.getJMSMessageID());
            stringBuffer.append("\n  JMSTimestamp:    " + this.timestamp);
            stringBuffer.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            stringBuffer.append("\n  JMSDestination:  " + this.getJMSDestination());
            stringBuffer.append("\n  JMSReplyTo:      " + this.getJMSReplyTo());
            stringBuffer.append("\n  JMSRedelivered:  " + this.redelivered);
            Enumeration enumeration = this.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n  " + string + ":" + this.getObjectProperty(string));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.jmsStrings != null) {
            this.jmsStringResourcesClassName = this.jmsStrings.getClass().getName();
        }
        try {
            this.getJMSDestination();
            this.getJMSReplyTo();
        }
        catch (JMSException jMSException) {
            throw new IOException(jMSException.getMessage());
        }
        String[] stringArray = new String[]{"JMSXUserID", "JMSXAppID", "JMS_IBM_PutDate", "JMS_IBM_PutTime", "JMSXDeliveryCount", "JMS_IBM_MsgType", "JMSXGroupSeq", "JMS_IBM_PutApplType", "JMS_IBM_Feedback", "JMS_IBM_Report_Exception", "JMS_IBM_Report_Expiration", "JMS_IBM_Report_COA", "JMS_IBM_Report_COD", "JMS_IBM_Report_PAN", "JMS_IBM_Report_NAN", "JMS_IBM_Report_Pass_Correl_ID", "JMS_IBM_Report_Pass_Msg_ID", "JMS_IBM_Report_Discard_Msg", "JMS_IBM_Last_Msg_In_Group"};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (this.properties.get(string) != HELD_INTERNAL) continue;
                this.properties.put(string, this.getInternalPropForName(string));
            }
        }
        catch (JMSException jMSException) {
            throw new IOException(jMSException.getMessage());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.jmsStringResourcesClassName != null) {
            try {
                Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(JMSMessage.this.jmsStringResourcesClassName);
                            return clazz;
                        }
                        catch (AccessControlException accessControlException) {
                            if (bTraceIsOn) {
                                trace.trace(3, this, accessControlException.getMessage());
                            }
                            return null;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (bTraceIsOn) {
                                trace.trace(this, "String resources not found");
                            }
                            return null;
                        }
                    }
                });
                this.jmsStrings = (JMSStringResources)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("unable to recreate JMSStringResources from " + this.jmsStringResourcesClassName);
            }
        }
        if (this.userIDAsBytes == null) {
            this.userIDAsBytes = new byte[12];
            Arrays.fill(this.userIDAsBytes, (byte)32);
        }
        if (this.putApplNameAsBytes == null) {
            this.putApplNameAsBytes = new byte[28];
            Arrays.fill(this.userIDAsBytes, (byte)32);
        }
        if (this.putDateAsBytes == null) {
            this.putDateAsBytes = new byte[8];
            Arrays.fill(this.putDateAsBytes, (byte)32);
        }
        if (this.putTimeAsBytes == null) {
            this.putTimeAsBytes = new byte[8];
            Arrays.fill(this.putTimeAsBytes, (byte)32);
        }
    }

    public void setPSCTopic(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setPSCTopic");
        }
        this.psTopic = string;
        if (bTraceIsOn) {
            trace.exit(this, "setPSCTopic");
        }
    }

    public void setPSCConnID(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "setPSCConnID");
        }
        this.psConnID = string;
        if (bTraceIsOn) {
            trace.exit(this, "setPSCConnID");
        }
    }

    public String _getJMSIBMArmCorrelator() {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMArmCorrelator");
        }
        String string = null;
        if (this.properties.get("JMS_IBM_ArmCorrelator") == HELD_INTERNAL) {
            string = this.armCorrelator;
        } else {
            try {
                string = this.getStringProperty("JMS_IBM_ArmCorrelator");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMArmCorrelator");
        }
        return string;
    }

    public String _getJMSIBMWrmCorrelator() {
        if (bTraceIsOn) {
            trace.entry(this, "_getJMSIBMWrmCorrelator");
        }
        String string = null;
        if (this.properties.get("JMS_IBM_RMCorrelator") == HELD_INTERNAL) {
            string = this.wrmCorrelator;
        } else {
            try {
                string = this.getStringProperty("JMS_IBM_RMCorrelator");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (bTraceIsOn) {
            trace.exit(this, "_getJMSIBMWrmCorrelator");
        }
        return string;
    }

    public void _setJMSIBMArmCorrelator(String string) {
        this.armCorrelator = string;
        this.properties.put("JMS_IBM_ArmCorrelator", HELD_INTERNAL);
    }

    public void _setJMSIBMWrmCorrelator(String string) {
        this.wrmCorrelator = string;
        this.properties.put("JMS_IBM_RMCorrelator", HELD_INTERNAL);
    }

    public void setGotByConsume(boolean bl) {
        this.gotByConsume = bl;
    }

    public boolean setGotByConsume() {
        return this.gotByConsume;
    }
}

