/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMS390FloatSupport;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;

public class JMSBytesMessage
extends JMSMessage
implements BytesMessage {
    static final long serialVersionUID = -8017520360760128818L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSBytesMessage.java, jms, j600, j600-202-070608 1.48.1.2 07/03/01 07:06:51";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private transient ByteArrayOutputStream _writeBytes;
    private transient DataOutputStream writeStream;
    private static final int ARRAY_SIZE = 20;
    private int integer_count;
    private int[] integer_offsets;
    private int[] integer_sizes;
    private Vector integers = new Vector();
    private Vector float_offsets = new Vector();
    private Vector float_values = new Vector();
    private boolean populated_by_client = true;
    private byte[] dataBuffer;
    private int dataStart;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private transient ByteArrayInputStream readStream;
    private transient ByteArrayInputStream readLengthStream;
    private boolean lengthCheck = false;
    private boolean markInUse = false;
    boolean readOnly = false;

    public JMSBytesMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_bytes";
        this.jmsStrings = jMSStringResources;
        this.clearBody();
        if (bTraceIsOn) {
            trace.exit(this, "constructor");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        Object object;
        block28: {
            if (bTraceIsOn) {
                trace.entry(this, "_exportBody");
            }
            this.reset();
            if (this.populated_by_client) {
                int n2;
                Object object2;
                int n3 = n & 0xF;
                int n4 = n & 0xF00;
                if (this.integerEncoding <= 1 && n3 == 2 || this.integerEncoding == 2 && n3 <= 1) {
                    int n5;
                    for (n5 = 0; n5 < this.integers.size(); n5 += 2) {
                        object = (int[])this.integers.elementAt(n5);
                        object2 = (int[])this.integers.elementAt(n5 + 1);
                        for (n2 = 0; n2 < 20; ++n2) {
                            this.reverse(this.dataBuffer, (int)object[n2], (int)object2[n2]);
                        }
                    }
                    for (n5 = 0; n5 < this.integer_count; ++n5) {
                        this.reverse(this.dataBuffer, this.integer_offsets[n5], this.integer_sizes[n5]);
                    }
                    this.integerEncoding = n3;
                }
                if (this.floatEncoding != n4) {
                    object = new ByteArrayOutputStream(8);
                    object2 = new DataOutputStream((OutputStream)object);
                    for (n2 = 0; n2 < this.float_offsets.size(); ++n2) {
                        ((ByteArrayOutputStream)object).reset();
                        Object e = this.float_values.elementAt(n2);
                        int n6 = (Integer)this.float_offsets.elementAt(n2);
                        if (e instanceof Float) {
                            float f = ((Float)e).floatValue();
                            switch (n4) {
                                case 256: 
                                case 512: {
                                    ((DataOutputStream)object2).writeInt(Float.floatToIntBits(f));
                                    break;
                                }
                                case 768: {
                                    ((DataOutputStream)object2).writeInt(JMS390FloatSupport.floatToS390IntBits(f));
                                    break;
                                }
                                default: {
                                    if (bTraceIsOn) {
                                        trace.trace(2, this, "Invalid encoding : " + n4);
                                    }
                                    throw this.newJMSException(1005);
                                }
                            }
                            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                            if (n4 == 512) {
                                this.reverse(byArray, 0, 4);
                            }
                            System.arraycopy(byArray, 0, this.dataBuffer, n6, 4);
                            continue;
                        }
                        if (!(e instanceof Double)) continue;
                        double d = (Double)e;
                        switch (n4) {
                            case 256: 
                            case 512: {
                                ((DataOutputStream)object2).writeLong(Double.doubleToLongBits(d));
                                break;
                            }
                            case 768: {
                                ((DataOutputStream)object2).writeLong(JMS390FloatSupport.doubleToS390LongBits(d));
                                break;
                            }
                            default: {
                                if (bTraceIsOn) {
                                    trace.trace(2, this, "Invalid encoding : " + n4);
                                }
                                throw this.newJMSException(1005);
                            }
                        }
                        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                        if (n4 == 512) {
                            this.reverse(byArray, 0, 8);
                        }
                        System.arraycopy(byArray, 0, this.dataBuffer, n6, 8);
                    }
                    this.floatEncoding = n4;
                }
                break block28;
            }
            byte[] byArray = new byte[this.dataBuffer.length - this.dataStart];
            System.arraycopy(this.dataBuffer, this.dataStart, byArray, 0, this.dataBuffer.length - this.dataStart);
            byte[] byArray2 = byArray;
            Object var14_19 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_exportBody");
            }
            return byArray2;
        }
        try {
            byte[] byArray = this.dataBuffer;
            Object var14_20 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_exportBody");
            }
            return byArray;
        }
        catch (IOException iOException) {
            try {
                object = this.newResourceAllocationException();
                object.setLinkedException((Exception)iOException);
                throw object;
            }
            catch (Throwable throwable) {
                block29: {
                    Object var14_21 = null;
                    if (!bTraceIsOn) break block29;
                    trace.exit(this, "_exportBody");
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "_importBody");
        }
        try {
            this.dataBuffer = byArray;
            this.dataStart = n;
            this.integerEncoding = n2 & 0xF;
            this.floatEncoding = n2 & 0xF00;
            this.populated_by_client = false;
            this._setJMSXObjectProperty("JMS_IBM_Encoding", new Integer(n2));
            String string2 = string;
            if (string.startsWith("Cp")) {
                try {
                    string2 = Integer.toString(Integer.parseInt(string.substring(2)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._setJMSXObjectProperty("JMS_IBM_Character_Set", string2);
            this.readOnly = true;
            this.reset();
            Object var8_7 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (bTraceIsOn) {
                trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.dataBuffer = null;
        this.dataStart = 0;
        this.readStream = null;
        this.readLengthStream = null;
        this._writeBytes = new ByteArrayOutputStream();
        this.writeStream = new DataOutputStream(this._writeBytes);
        this.populated_by_client = true;
        this.removeProperty("JMS_IBM_Encoding");
        this.removeProperty("JMS_IBM_Character_Set");
        this.integerEncoding = 1;
        this.floatEncoding = 256;
        this.integer_count = 0;
        this.integer_offsets = new int[20];
        this.integer_sizes = new int[20];
        this.integers.removeAllElements();
        this.float_offsets.removeAllElements();
        this.float_values.removeAllElements();
        if (bTraceIsOn) {
            trace.exit(this, "clearBody");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readBoolean");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            boolean bl = n != 0;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readBoolean");
            }
            return bl;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block6;
                trace.exit(this, "readBoolean");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readByte");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            byte by = (byte)n;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readByte");
            }
            return by;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block6;
                trace.exit(this, "readByte");
            }
            throw throwable;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray, int n) throws JMSException {
        block8: {
            if (bTraceIsOn) {
                trace.entry(this, "readBytes");
            }
            try {
                if (!this.readOnly) {
                    throw this.newMessageNotReadableException();
                }
                if (byArray.length < n || n < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.readStream != null) break block8;
                int n2 = -1;
                Object var6_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readBytes");
                }
                return n2;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_7 = null;
                    if (!bTraceIsOn) break block9;
                    trace.exit(this, "readBytes");
                }
                throw throwable;
            }
        }
        int n3 = this.readStream.read(byArray, 0, n);
        Object var6_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readBytes");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar() throws JMSException {
        int n;
        int n2;
        block9: {
            if (bTraceIsOn) {
                trace.entry(this, "readChar");
            }
            try {
                if (!this.readOnly) {
                    throw this.newMessageNotReadableException();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw this.newMessageEOFException();
                }
                if (this.integerEncoding != 2) break block9;
                char c = (char)((n << 8) + n2);
                Object var5_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readChar");
                }
                return c;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!bTraceIsOn) break block10;
                    trace.exit(this, "readChar");
                }
                throw throwable;
            }
        }
        char c = (char)((n2 << 8) + n);
        Object var5_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readChar");
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double readDouble() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readDouble");
        }
        int n = this.integerEncoding;
        switch (this.floatEncoding) {
            case 256: {
                this.integerEncoding = 1;
                double d = Double.longBitsToDouble(this.readLong());
                Object var5_6 = null;
                this.integerEncoding = n;
                if (!bTraceIsOn) return d;
                trace.exit(this, "readDouble");
                return d;
            }
            case 512: {
                this.integerEncoding = 2;
                double d = Double.longBitsToDouble(this.readLong());
                Object var5_7 = null;
                this.integerEncoding = n;
                if (!bTraceIsOn) return d;
                trace.exit(this, "readDouble");
                return d;
            }
            case 768: {
                this.integerEncoding = 1;
                double d = JMS390FloatSupport.longS390BitsToDouble(this.readLong());
                Object var5_8 = null;
                this.integerEncoding = n;
                if (!bTraceIsOn) return d;
                trace.exit(this, "readDouble");
                return d;
            }
        }
        try {
            try {
                if (!bTraceIsOn) throw this.newJMSException(1005);
                trace.trace(2, this, "Invalid encoding : " + this.floatEncoding);
                throw this.newJMSException(1005);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newMessageFormatException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.integerEncoding = n;
            if (!bTraceIsOn) throw throwable;
            trace.exit(this, "readDouble");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float readFloat() throws JMSException {
        float f;
        int n;
        block11: {
            float f2;
            if (bTraceIsOn) {
                trace.entry(this, "readFloat");
            }
            n = this.integerEncoding;
            try {
                try {
                    switch (this.floatEncoding) {
                        case 256: {
                            this.integerEncoding = 1;
                            float f3 = Float.intBitsToFloat(this.readInt());
                            Object var5_6 = null;
                            this.integerEncoding = n;
                            if (!bTraceIsOn) return f3;
                            trace.exit(this, "readFloat");
                            return f3;
                        }
                        case 512: {
                            this.integerEncoding = 2;
                            f2 = Float.intBitsToFloat(this.readInt());
                            break;
                        }
                        case 768: {
                            this.integerEncoding = 1;
                            f = JMS390FloatSupport.intS390BitsToFloat(this.readInt());
                            break block11;
                        }
                        default: {
                            if (!bTraceIsOn) throw this.newJMSException(1005);
                            trace.trace(2, this, "Invalid encoding : " + this.floatEncoding);
                            throw this.newJMSException(1005);
                        }
                    }
                }
                catch (IOException iOException) {
                    JMSException jMSException = this.newMessageFormatException();
                    jMSException.setLinkedException((Exception)iOException);
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.integerEncoding = n;
                if (!bTraceIsOn) throw throwable;
                trace.exit(this, "readFloat");
                throw throwable;
            }
            Object var5_7 = null;
            this.integerEncoding = n;
            if (!bTraceIsOn) return f2;
            trace.exit(this, "readFloat");
            return f2;
        }
        Object var5_8 = null;
        this.integerEncoding = n;
        if (!bTraceIsOn) return f;
        trace.exit(this, "readFloat");
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws JMSException {
        int n;
        int n2;
        int n3;
        int n4;
        block9: {
            if (bTraceIsOn) {
                trace.entry(this, "readInt");
            }
            try {
                if (!this.readOnly) {
                    throw this.newMessageNotReadableException();
                }
                if (!this.markInUse) {
                    this.readStream.mark(4);
                }
                n4 = this.readStream.read();
                n3 = this.readStream.read();
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw this.newMessageEOFException();
                }
                if (this.integerEncoding != 2) break block9;
                int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + n4;
                Object var7_7 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readInt");
                }
                return n5;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var7_9 = null;
                    if (!bTraceIsOn) break block10;
                    trace.exit(this, "readInt");
                }
                throw throwable;
            }
        }
        int n6 = (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
        Object var7_8 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readInt");
        }
        return n6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JMSException {
        long l;
        long l2;
        block7: {
            if (bTraceIsOn) {
                trace.entry(this, "readLong");
            }
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            try {
                this.readStream.mark(8);
                this.markInUse = true;
                l2 = (long)this.readInt() & 0xFFFFFFFFL;
                l = (long)this.readInt() & 0xFFFFFFFFL;
                if (this.integerEncoding != 2) break block7;
                long l3 = (l << 32) + l2;
                Object var8_5 = null;
                this.markInUse = false;
                if (bTraceIsOn) {
                    trace.exit(this, "readLong");
                }
                return l3;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var8_7 = null;
                    this.markInUse = false;
                    if (!bTraceIsOn) break block8;
                    trace.exit(this, "readLong");
                }
                throw throwable;
            }
        }
        long l4 = (l2 << 32) + l;
        Object var8_6 = null;
        this.markInUse = false;
        if (bTraceIsOn) {
            trace.exit(this, "readLong");
        }
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws JMSException {
        int n;
        int n2;
        block9: {
            if (bTraceIsOn) {
                trace.entry(this, "readShort");
            }
            try {
                if (!this.readOnly) {
                    throw this.newMessageNotReadableException();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw this.newMessageEOFException();
                }
                if (this.integerEncoding != 2) break block9;
                short s = (short)((n << 8) + n2);
                Object var5_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readShort");
                }
                return s;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!bTraceIsOn) break block10;
                    trace.exit(this, "readShort");
                }
                throw throwable;
            }
        }
        short s = (short)((n2 << 8) + n);
        Object var5_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readShort");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readUnsignedByte() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readUnsignedByte");
        }
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            int n = this.readStream.read();
            if (n < 0) {
                throw this.newMessageEOFException();
            }
            int n2 = n;
            Object var4_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readUnsignedByte");
            }
            return n2;
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_4 = null;
                if (!bTraceIsOn) break block6;
                trace.exit(this, "readUnsignedByte");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readUnsignedShort() throws JMSException {
        int n;
        int n2;
        block9: {
            if (bTraceIsOn) {
                trace.entry(this, "readUnsignedShort");
            }
            try {
                if (!this.readOnly) {
                    throw this.newMessageNotReadableException();
                }
                if (!this.markInUse) {
                    this.readStream.mark(2);
                }
                n2 = this.readStream.read();
                n = this.readStream.read();
                if (n < 0) {
                    this.readStream.reset();
                    throw this.newMessageEOFException();
                }
                if (this.integerEncoding != 2) break block9;
                int n3 = (n << 8) + n2;
                Object var5_5 = null;
                if (bTraceIsOn) {
                    trace.exit(this, "readUnsignedShort");
                }
                return n3;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_7 = null;
                    if (!bTraceIsOn) break block10;
                    trace.exit(this, "readUnsignedShort");
                }
                throw throwable;
            }
        }
        int n4 = (n2 << 8) + n;
        Object var5_6 = null;
        if (bTraceIsOn) {
            trace.exit(this, "readUnsignedShort");
        }
        return n4;
    }

    public String readUTF() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "readUTF");
        }
        int n = this.integerEncoding;
        try {
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (this.readStream == null) {
                throw this.newMessageEOFException();
            }
            this.readStream.mark(8);
            this.markInUse = true;
            this.integerEncoding = 1;
            int n2 = this.readUnsignedShort();
            byte[] byArray = new byte[n2];
            if (this.readBytes(byArray, n2) != n2) {
                this.readStream.reset();
                throw this.newMessageEOFException();
            }
            String string = new String(byArray, 0, n2, "UTF8");
            Object var6_7 = null;
            this.integerEncoding = n;
            this.markInUse = false;
            if (bTraceIsOn) {
                trace.exit(this, "readUTF");
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                JMSException jMSException = this.newMessageFormatException();
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_8 = null;
                    this.integerEncoding = n;
                    this.markInUse = false;
                    if (!bTraceIsOn) break block9;
                    trace.exit(this, "readUTF");
                }
                throw throwable;
            }
        }
    }

    private void recordInteger(int n, int n2) {
        if (bTraceIsOn) {
            trace.entry(this, "recordInteger");
        }
        if (this.integer_count == 20) {
            this.integers.addElement(this.integer_offsets);
            this.integers.addElement(this.integer_sizes);
            this.integer_offsets = new int[20];
            this.integer_sizes = new int[20];
            this.integer_count = 0;
        }
        this.integer_offsets[this.integer_count] = n;
        this.integer_sizes[this.integer_count++] = n2;
        if (bTraceIsOn) {
            trace.exit(this, "recordInteger");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "reset");
        }
        try {
            if (!this.readOnly) {
                this.dataBuffer = this._writeBytes.toByteArray();
                this.dataStart = 0;
                this.writeStream = null;
                this._writeBytes = null;
                this.readOnly = true;
            }
            if (this.dataBuffer == null) {
                this.dataBuffer = new byte[0];
            }
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.readLengthStream = new ByteArrayInputStream(this.dataBuffer);
            this.readStream.skip(this.dataStart);
            this.readLengthStream.skip(this.dataStart);
            Object var2_1 = null;
            if (bTraceIsOn) {
                trace.exit(this, "reset");
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "reset");
            }
            throw throwable;
        }
    }

    private void reverse(byte[] byArray, int n, int n2) {
        if (bTraceIsOn) {
            trace.entry(this, "reverse");
            trace.trace(3, this, "length = " + n2 + " data follows: ");
            trace.dataTrace(3, this, byArray);
        }
        for (int i = 0; i < n2 / 2; ++i) {
            byte by = byArray[n + i];
            byArray[n + i] = byArray[n + (n2 - 1) - i];
            byArray[n + (n2 - 1) - i] = by;
        }
        if (bTraceIsOn) {
            trace.exit(this, "reverse");
        }
    }

    public String toString() {
        int n = 10;
        int n2 = 40;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append(this.jmsStrings.getMessage(1027, new Integer(this.integerEncoding), new Integer(this.floatEncoding)));
        stringBuffer.append("\n");
        if (!this.readOnly) {
            this.dataBuffer = this._writeBytes.toByteArray();
        }
        if (this.dataBuffer != null) {
            int n3 = this.dataStart;
            for (int i = 0; i < n; ++i) {
                if (this.dataBuffer.length <= n3 + n2) {
                    JMSBytesMessage.binToHex(this.dataBuffer, n3, this.dataBuffer.length - n3, stringBuffer);
                    n3 = this.dataBuffer.length;
                    stringBuffer.append("\n");
                    break;
                }
                JMSBytesMessage.binToHex(this.dataBuffer, n3, n2, stringBuffer);
                stringBuffer.append("\n");
                n3 += n2;
            }
            if (n3 != this.dataBuffer.length) {
                stringBuffer.append("...\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(boolean bl) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeBoolean");
        }
        try {
            this.writeByte((byte)(bl ? 1 : 0));
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBoolean");
            }
            throw throwable;
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeByte");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeByte(by);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeByte");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeByte");
            }
            throw throwable;
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeBytes");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var7_4 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    public void writeChar(char c) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeChar");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeChar(c);
                this.recordInteger(this.writeStream.size() - 2, 2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeChar");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeChar");
            }
            throw throwable;
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeDouble");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeLong(Double.doubleToLongBits(d));
                this.float_values.addElement(new Double(d));
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 8));
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var6_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeDouble");
            }
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeDouble");
            }
            throw throwable;
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeFloat");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeInt(Float.floatToIntBits(f));
                this.float_values.addElement(new Float(f));
                this.float_offsets.addElement(new Integer(this.writeStream.size() - 4));
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeFloat");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeFloat");
            }
            throw throwable;
        }
    }

    public void writeInt(int n) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeInt");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeInt(n);
                this.recordInteger(this.writeStream.size() - 4, 4);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeInt");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeInt");
            }
            throw throwable;
        }
    }

    public void writeLong(long l) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeLong");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeLong(l);
                this.recordInteger(this.writeStream.size() - 8, 8);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var6_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeLong");
            }
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeLong");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object object) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeObject");
        }
        try {
            if (object instanceof byte[]) {
                this.writeBytes((byte[])object);
            } else if (object instanceof String) {
                this.writeUTF((String)object);
            } else if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof Character) {
                this.writeChar(((Character)object).charValue());
            } else if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
            } else {
                if (object == null) {
                    if (bTraceIsOn) {
                        trace.trace(0, this, "Throwing NullPointerException");
                    }
                    throw new NullPointerException();
                }
                throw this.newMessageFormatException();
            }
            Object var3_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    public void writeShort(short s) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeShort");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeShort(s);
                this.recordInteger(this.writeStream.size() - 2, 2);
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeShort");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeShort");
            }
            throw throwable;
        }
    }

    public void writeUTF(String string) throws JMSException {
        if (bTraceIsOn) {
            trace.entry(this, "writeUTF");
        }
        try {
            try {
                if (this.readOnly) {
                    throw this.newMessageNotWriteableException();
                }
                this.writeStream.writeUTF(string);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                JMSException jMSException = this.newMessageFormatException();
                jMSException.setLinkedException((Exception)uTFDataFormatException);
                throw jMSException;
            }
            catch (IOException iOException) {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            Object var5_2 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeUTF");
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeUTF");
            }
            throw throwable;
        }
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
        try {
            this.reset();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            try {
                if (bTraceIsOn) {
                    trace.entry(this, "writeObject");
                }
                try {
                    this.reset();
                }
                catch (JMSException jMSException) {
                    if (bTraceIsOn) {
                        trace.trace(this, "failed to reset message because of " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null) {
                            trace.trace(this, "linked exception: " + exception);
                        }
                    }
                    throw new IOException("failed to reset BytesMessage for serialization");
                }
                objectOutputStream.defaultWriteObject();
            }
            catch (IOException iOException) {
                if (bTraceIsOn) {
                    trace.trace(this, "throwing " + iOException);
                }
                throw iOException;
            }
            Object var5_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bTraceIsOn) {
                trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            block12: {
                try {
                    if (bTraceIsOn) {
                        trace.entry(this, "readObject");
                    }
                    objectInputStream.defaultReadObject();
                    try {
                        this.reset();
                    }
                    catch (JMSException jMSException) {
                        if (bTraceIsOn) {
                            trace.trace(this, "failed to reset message because of " + (Object)((Object)jMSException));
                            Exception exception = jMSException.getLinkedException();
                            if (exception != null) {
                                trace.trace(this, "linked exception: " + exception);
                            }
                        }
                        throw new IOException("failed to reset BytesMessage for serialisation");
                    }
                    if (!this.messageClass.equals("jms_bytes")) break block12;
                    this.messageClass = "jms_bytes";
                }
                catch (IOException iOException) {
                    if (bTraceIsOn) {
                        trace.trace(this, "throwing " + iOException);
                    }
                    throw iOException;
                }
            }
            Object var5_5 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readObject");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readObject");
            }
            throw throwable;
        }
    }

    public long getBodyLength() throws JMSException, MessageNotReadableException {
        long l = 0L;
        byte[] byArray = new byte[4000];
        if (bTraceIsOn) {
            trace.entry(this, "getBodyLength");
        }
        try {
            int n;
            if (!this.readOnly) {
                throw this.newMessageNotReadableException();
            }
            if (!this.lengthCheck) {
                this.readLengthStream.mark(0);
                this.lengthCheck = true;
            } else {
                this.readLengthStream.reset();
            }
            while ((n = this.readLengthStream.read(byArray)) >= 0) {
                l += (long)n;
            }
            if (bTraceIsOn) {
                trace.trace(this, "Return body length of " + l);
            }
            long l2 = l;
            Object var8_6 = null;
            if (bTraceIsOn) {
                trace.exit(this, "readBodyLength");
            }
            return l2;
        }
        catch (IOException iOException) {
            try {
                JMSException jMSException = this.newResourceAllocationException();
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var8_7 = null;
                    if (!bTraceIsOn) break block11;
                    trace.exit(this, "readBodyLength");
                }
                throw throwable;
            }
        }
    }
}

