/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.ase;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.ase.Ase16TriggerTemplate;
import org.jumpmind.symmetric.db.ase.AseTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;

public class AseSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "drop function dbo.$(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(object_name(object_id('$(functionName)')))";
    static final String SQL_PAGE_SIZE = "select @@maxpagesize";
    static final String SQL_NOCOUNT = "select @@OPTIONS & 512";
    private int pageSize = 2048;
    private int noCount = 0;

    public AseSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        try {
            this.pageSize = platform.getSqlTemplate().queryForInt(SQL_PAGE_SIZE, new Object[0]);
            this.log.info("Page size is {}", (Object)this.pageSize);
        }
        catch (Exception e) {
            this.log.debug("Unable to query page size", (Throwable)e);
        }
        try {
            this.noCount = platform.getSqlTemplate().queryForInt(SQL_NOCOUNT, new Object[0]);
        }
        catch (Exception se) {
            this.log.warn("Unable to query nocount", (Throwable)se);
        }
        if (this.noCount != 0) {
            throw new SymmetricException("Incompatible setting for nocount detected.  Add the following to your\r\nengine properties file: db.init.sql=set nocount off", new Object[0]);
        }
        this.triggerTemplate = this.getMajorVersion() >= 16 ? new Ase16TriggerTemplate(this) : new AseTriggerTemplate(this);
    }

    public Database readSymmetricSchemaFromXml() {
        Database database = super.readSymmetricSchemaFromXml();
        if (this.pageSize == 2048) {
            String prefix = this.parameterService.getTablePrefix() + "_";
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_snapshot", "file_name", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "relative_dir", "55");
            this.reconfigureTableColumn(database, prefix, "file_incoming", "file_name", "55");
            Table table = database.findTable(prefix + "registration_request");
            if (table != null) {
                table.removeIndex(0);
            }
        }
        return database;
    }

    protected void reconfigureTableColumn(Database database, String prefix, String tableName, String columnName, String size) {
        Column column;
        Table table = database.findTable(prefix + tableName);
        if (table != null && (column = table.findColumn(columnName)) != null) {
            column.setSize(size);
        }
    }

    public boolean createOrAlterTablesIfNecessary(String ... tableNames) {
        boolean alteredTables = super.createOrAlterTablesIfNecessary(tableNames);
        boolean alteredIdentityGap = this.alterTableIdentityGapIfNecessary();
        boolean alteredLockingScheme = this.alterTableLockingSchemeIfNecessary();
        return alteredTables || alteredIdentityGap || alteredLockingScheme;
    }

    public boolean alterTableIdentityGapIfNecessary() {
        boolean altered = false;
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        String prefix = this.getTablePrefix();
        try {
            int changeIdentityGap = this.parameterService.getInt("sybase.change.identity.gap.on.runtime.tables", 1000);
            if (changeIdentityGap > 0) {
                String dataTable = TableConstants.getTableName((String)prefix, (String)"data").toLowerCase();
                String sql = "select max(i.identitygap) from sysindexes i inner join sysobjects t on t.id = i.id where t.name = ?";
                long identityGap = sqlTemplate.queryForLong(sql, new Object[]{dataTable});
                if (identityGap != (long)changeIdentityGap) {
                    this.log.info("Changing identity gap for {} to {}", (Object)dataTable, (Object)changeIdentityGap);
                    sqlTemplate.update("sp_chgattribute " + dataTable + ", 'identity_gap', " + changeIdentityGap, new Object[0]);
                    altered = true;
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to alter identity gap: {}", (Object)e.getMessage());
            this.log.debug("", (Throwable)e);
        }
        return altered;
    }

    public boolean alterTableLockingSchemeIfNecessary() {
        boolean altered = false;
        ISqlTemplate sqlTemplate = this.platform.getSqlTemplate();
        String prefix = this.getTablePrefix();
        try {
            if (this.parameterService.is("sybase.allow.only.row.level.locks.on.runtime.tables", true)) {
                List<String> tables = this.getTableNamesRequiringDatarowLockingScheme(prefix);
                String sql = "select case (sysstat2 & 57344) when 32768 then 1 else 0 end from sysobjects where name = ?";
                for (String table : tables) {
                    if (sqlTemplate.queryForInt(sql, new Object[]{table}) != 0) continue;
                    this.log.info("Altering {} for row-level locking", (Object)table);
                    sqlTemplate.update("alter table " + table + " lock datarows", new Object[0]);
                    altered = true;
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to alter row-level locking: {}", (Object)e.getMessage());
            this.log.debug("", (Throwable)e);
        }
        return altered;
    }

    public List<String> getTableNamesRequiringDatarowLockingScheme(String prefix) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(TableConstants.getTableName((String)prefix, (String)"data").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"data_event").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"outgoing_batch").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"incoming_batch").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"monitor_event").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"extract_request").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"node").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"node_security").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"node_host").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"lock").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"job").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"file_snapshot").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"table_reload_request").toLowerCase());
        tables.add(TableConstants.getTableName((String)prefix, (String)"table_reload_status").toLowerCase());
        return tables;
    }

    public void dropRequiredDatabaseObjects() {
    }

    public void removeTrigger(StringBuilder sqlBuffer, final String catalogName, String schemaName, final String triggerName, String tableName, ISqlTransaction transaction) {
        schemaName = schemaName == null ? "" : (String)schemaName + ".";
        final String sql = "drop trigger " + (String)schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && sqlBuffer == null) {
            this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            ((JdbcSqlTransaction)transaction).executeCallback((IConnectionCallback)new IConnectionCallback<Boolean>(){

                public Boolean execute(Connection con) throws SQLException {
                    String previousCatalog = con.getCatalog();
                    try (Statement stmt = con.createStatement();){
                        if (catalogName != null) {
                            con.setCatalog(catalogName);
                        }
                        stmt.execute(sql);
                    }
                    catch (Exception e) {
                        AseSymmetricDialect.this.log.warn("Error removing {}: {}", (Object)triggerName, (Object)e.getMessage());
                        throw e;
                    }
                    finally {
                        if (catalogName != null) {
                            con.setCatalog(previousCatalog);
                        }
                    }
                    return Boolean.FALSE;
                }
            });
        }
    }

    protected String switchCatalogForTriggerInstall(String catalog, ISqlTransaction transaction) {
        if (catalog != null) {
            Connection c = ((JdbcSqlTransaction)transaction).getConnection();
            try {
                String previousCatalog = c.getCatalog();
                c.setCatalog(catalog);
                return previousCatalog;
            }
            catch (SQLException e) {
                throw new SqlException((Throwable)e);
            }
        }
        return null;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, final String catalogName, String schema, String tableName, final String triggerName) {
        return (Boolean)((JdbcSqlTemplate)this.platform.getSqlTemplate()).execute((IConnectionCallback)new IConnectionCallback<Boolean>(){

            /*
             * Exception decompiling
             */
            public Boolean execute(Connection con) throws SQLException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        if (nodeId == null) {
            nodeId = "";
        }
        transaction.prepareAndExecute("set clientapplname 'SymmetricDS'", new Object[0]);
        transaction.prepareAndExecute("set clientname '" + nodeId + "'", new Object[0]);
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set clientapplname null", new Object[0]);
        transaction.prepareAndExecute("set clientname null", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "@clientapplname <> 'SymmetricDS'";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "bintostr(xactkey) from master.dbo.systransactions where spid = @@spid";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isTransactionIdOverrideSupported() {
        return true;
    }

    public void cleanDatabase() {
        this.platform.getSqlTemplate().update("dump transaction " + this.platform.getDefaultCatalog() + " with no_log", new Object[0]);
    }

    public boolean needsToSelectLobData() {
        return true;
    }

    public int getMaxTriggerNameLength() {
        return 28;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    static /* synthetic */ Logger access$100(AseSymmetricDialect x0) {
        return x0.log;
    }

    static /* synthetic */ Logger access$200(AseSymmetricDialect x0) {
        return x0.log;
    }

    static /* synthetic */ Logger access$300(AseSymmetricDialect x0) {
        return x0.log;
    }
}

