/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(67),
    UNKNOWNRULEPARAMETERLIST(65),
    UNKNOWNRULEBODY(66),
    STYLERULE(42),
    IMPORTRULE(16),
    PAGERULE(53),
    MEDIARULE(49),
    FONTFACERULE(54),
    SELECTOR(37),
    STYLEDECLARATIONLIST(41),
    STYLEDECLARATION(40),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(34),
    HOST(28),
    HOSTCONTEXT(29),
    SLOTTED(30),
    NEGATION(35),
    PSEUDO_HAS(31),
    PSEUDO_IS(32),
    PSEUDO_WHERE(33),
    ATTRIB(26),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    SELECTORCOMBINATOR(36),
    NTH(27),
    PROPERTY(38),
    IMPORTANT(39),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    CALC(9),
    CALCSUMOPERATOR(8),
    CALCPRODUCT(7),
    CALCPRODUCTOPERATOR(6),
    CALCUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(48),
    MEDIUM(44),
    MEDIAQUERY(47),
    MEDIAMODIFIER(43),
    MEDIAEXPR(46),
    MEDIAFEATURE(45),
    PSEUDOPAGE(-1),
    PAGESELECTOR(50),
    PAGEMARGINSYMBOL(51),
    PAGERULEBLOCK(52),
    KEYFRAMESRULE(58),
    KEYFRAMESIDENTIFIER(55),
    KEYFRAMESSELECTOR(57),
    SINGLEKEYFRAMESELECTOR(56),
    VIEWPORTRULE(59),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(64),
    SUPPORTSCONDITION(63),
    SUPPORTSCONDITIONOPERATOR(62),
    SUPPORTSNEGATION(61),
    SUPPORTSCONDITIONINPARENS(60),
    ERROR_SKIPTO(1);

    private static final Logger LOGGER;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + String.valueOf((Object)eCSSVersion));
    }

    public boolean isNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return cSSNode.getNodeType() == this.getParserNodeType(eCSSVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + String.valueOf((Object)eCSSVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode, eCSSVersion)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode, eCSSVersion);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName(eCSSVersion);
        }
        LOGGER.warn("Unsupported node type " + cSSNode.getNodeType() + " in version " + String.valueOf((Object)eCSSVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode, eCSSVersion));
        if (cSSNode.hasText()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, eCSSVersion, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, eCSSVersion, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return ERROR_SKIPTO.isNode(cSSNode, eCSSVersion);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

