/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    public static SQLException unwrapSqlException(Throwable e) {
        List exs = org.apache.commons.lang3.exception.ExceptionUtils.getThrowableList((Throwable)e);
        for (Throwable throwable : exs) {
            if (!(throwable instanceof SQLException)) continue;
            return (SQLException)throwable;
        }
        return null;
    }

    public static String getRootMessage(Throwable ex) {
        Throwable cause = org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)ex);
        if (cause == null) {
            cause = ex;
        }
        return cause.getMessage();
    }

    public static Throwable getRootCause(Throwable ex) {
        Throwable cause = org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)ex);
        if (cause == null) {
            cause = ex;
        }
        return cause;
    }

    public static boolean is(Throwable e, Class<?> ... exceptions) {
        if (e != null) {
            Throwable cause = ExceptionUtils.getRootCause(e);
            for (Class<?> ex : exceptions) {
                if (!ex.isInstance(e) && !ex.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static String unwrapMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        while (e != null) {
            sb.append(e.getClass().getSimpleName());
            if (!StringUtils.isBlank((CharSequence)e.getMessage())) {
                sb.append(": ").append(e.getMessage());
            }
            if ((e = e.getCause()) == null) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

