/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(LogSqlBuilder.class);
    public static final int MAX_FIELD_SIZE_TO_PRINT_TO_LOG = 8000;
    protected BinaryEncoding encoding = BinaryEncoding.HEX;
    protected boolean useJdbcTimestampFormat = true;
    protected int logSlowSqlThresholdMillis = 20000;
    protected int consoleLogSlowSqlThresholdMillis = 5000;
    protected boolean logSqlParametersInline = true;

    public void logSql(Logger loggerArg, String sql, Object[] args, int[] types, long executionTimeMillis) {
        this.logSql(loggerArg, null, sql, args, types, executionTimeMillis);
    }

    public void logSql(Logger loggerArg, String message, String sql, Object[] args, int[] types, long executionTimeMillis) {
        boolean longRunning = false;
        if ("gui".equals(MDC.get((String)"engineName"))) {
            longRunning = executionTimeMillis >= (long)this.consoleLogSlowSqlThresholdMillis;
        } else {
            boolean bl = longRunning = executionTimeMillis >= (long)this.logSlowSqlThresholdMillis;
        }
        if (loggerArg.isDebugEnabled() || longRunning) {
            StringBuilder logEntry = new StringBuilder();
            if (longRunning) {
                logEntry.append("Long Running: ");
            }
            logEntry.append("(" + executionTimeMillis + "ms.) ");
            if (message != null) {
                logEntry.append(message).append(" ");
            }
            if (this.logSqlParametersInline) {
                logEntry.append(this.buildDynamicSqlForLog(sql, args, types));
            } else {
                logEntry.append(sql);
            }
            if (loggerArg.isTraceEnabled()) {
                logEntry.append("\r\n");
            }
            if (longRunning) {
                loggerArg.info(logEntry.toString());
            } else {
                loggerArg.debug(logEntry.toString());
            }
            if (!this.logSqlParametersInline && args != null && args.length > 0) {
                if (longRunning) {
                    loggerArg.info("sql args: {}", (Object)Arrays.toString(args));
                } else {
                    loggerArg.debug("sql args: {}", (Object)Arrays.toString(args));
                }
            }
        }
    }

    public SQLException logSqlAfterException(Logger loggerArg, String sql, Object[] args, SQLException e) {
        String msg = "SQL caused exception: [" + sql + "] ";
        if (args != null && args.length > 0) {
            msg = msg + "sql args: " + Arrays.toString(args) + " ";
        }
        loggerArg.debug(msg + String.valueOf(e));
        return e;
    }

    public String buildDynamicSqlForLog(String sql, Object[] args, int[] types) {
        boolean endsWithPlacholder = sql.endsWith("?");
        Object[] parts = sql.split("\\?");
        if (endsWithPlacholder) {
            parts = (String[])ArrayUtils.addAll((Object[])parts, (Object[])new String[]{""});
        }
        if (parts.length == 1 || args == null || args.length == 0) {
            return sql;
        }
        StringBuilder dynamicSql = new StringBuilder(256);
        for (int i = 0; i < parts.length; ++i) {
            dynamicSql.append((String)parts[i]);
            if (args.length <= i) continue;
            int type = types != null && types.length > i ? types[i] : 1111;
            dynamicSql.append(this.formatValue(args[i], type));
        }
        return dynamicSql.toString();
    }

    public String formatValue(Object object, int type) {
        if (object == null) {
            return "null";
        }
        if (TypeMap.isTextType(type)) {
            return StringUtils.abbreviate((String)this.formatStringValue(object), (int)8000);
        }
        if (TypeMap.isDateTimeType(type)) {
            return this.formatDateTimeValue(object, type);
        }
        if (TypeMap.isBinaryType(type) || object instanceof byte[] || object instanceof Blob) {
            return StringUtils.abbreviate((String)this.formatBinaryValue(object), (int)8000);
        }
        return StringUtils.abbreviate((String)this.formatUnknownType(object), (int)8000);
    }

    protected String formatUnknownType(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof BigDecimal || object instanceof Boolean || object instanceof Short || object instanceof Float || object instanceof Double) {
            return object.toString();
        }
        if (object instanceof Date) {
            return this.formatDateTimeValue(object, 93);
        }
        return this.formatStringValue(object);
    }

    protected String formatStringValue(Object object) {
        String value = object.toString();
        value = value.replace("'", "''");
        return "'" + value + "'";
    }

    protected String formatDateTimeValue(Object object, int type) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else {
            try {
                date = FormatUtils.parseDate((String)object.toString(), (String[])((String[])ArrayUtils.addAll((Object[])FormatUtils.TIMESTAMP_PATTERNS, (Object[])FormatUtils.TIME_PATTERNS)));
            }
            catch (Exception ex) {
                try {
                    date = FormatUtils.parseTimestampWithTimezone((String)(object == null ? "" : object.toString()));
                }
                catch (Exception e) {
                    log.debug("Failed to parse argument as a date " + String.valueOf(object) + " " + String.valueOf(ex));
                    return "'" + String.valueOf(object) + "'";
                }
            }
        }
        if (object instanceof Timestamp) {
            if (type == 92) {
                return (this.useJdbcTimestampFormat ? "{t " : "") + "'" + FormatUtils.TIME9_FORMATTER.format(((Timestamp)object).toInstant()) + "'" + (this.useJdbcTimestampFormat ? "}" : "");
            }
            return (this.useJdbcTimestampFormat ? "{ts " : "") + "'" + FormatUtils.TIMESTAMP9_FORMATTER.format(((Timestamp)object).toInstant()) + "'" + (this.useJdbcTimestampFormat ? "}" : "");
        }
        if (object instanceof Time) {
            return (this.useJdbcTimestampFormat ? "{t " : "") + "'" + FormatUtils.TIME9_FORMATTER.format(new Date(((Time)object).getTime()).toInstant()) + "'" + (this.useJdbcTimestampFormat ? "}" : "");
        }
        return (this.useJdbcTimestampFormat ? "{ts " : "") + "'" + FormatUtils.TIMESTAMP_FORMATTER.format(date) + "'" + (this.useJdbcTimestampFormat ? "}" : "");
    }

    protected String formatBinaryValue(Object object) {
        byte[] bytes = null;
        if (object instanceof byte[]) {
            bytes = (byte[])object;
        } else if (object instanceof Blob) {
            try {
                bytes = IOUtils.toByteArray((InputStream)((Blob)object).getBinaryStream());
            }
            catch (Exception ex) {
                log.debug("Failed to convert to byte array " + String.valueOf(object) + " " + String.valueOf(ex));
                return "'" + String.valueOf(object) + "'";
            }
        } else {
            return "'" + String.valueOf(object) + "'";
        }
        if (this.encoding == BinaryEncoding.BASE64) {
            return "'" + new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset()) + "'";
        }
        if (this.encoding == BinaryEncoding.HEX) {
            return "'" + new String(Hex.encodeHex((byte[])bytes)) + "'";
        }
        return "'" + String.valueOf(object) + "'";
    }

    public boolean isUseJdbcTimestampFormat() {
        return this.useJdbcTimestampFormat;
    }

    public void setUseJdbcTimestampFormat(boolean useJdbcTimestampFormat) {
        this.useJdbcTimestampFormat = useJdbcTimestampFormat;
    }

    public int getLogSlowSqlThresholdMillis() {
        return this.logSlowSqlThresholdMillis;
    }

    public void setLogSlowSqlThresholdMillis(int logSlowSqlThresholdMillis) {
        this.logSlowSqlThresholdMillis = logSlowSqlThresholdMillis;
    }

    public int getConsoleLogSlowSqlThresholdMillis() {
        return this.consoleLogSlowSqlThresholdMillis;
    }

    public void setConsoleLogSlowSqlThresholdMillis(int consoleLogSlowSqlThresholdMillis) {
        this.consoleLogSlowSqlThresholdMillis = consoleLogSlowSqlThresholdMillis;
    }

    public boolean isLogSqlParametersInline() {
        return this.logSqlParametersInline;
    }

    public void setLogSqlParametersInline(boolean logSqlParametersInline) {
        this.logSqlParametersInline = logSqlParametersInline;
    }
}

