/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.DmlStatementOptions;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmlStatement {
    private static final Logger log = LoggerFactory.getLogger(DmlStatement.class);
    protected static final String QUESTION_MARK = "<!QUESTION_MARK!>";
    protected String catalogName;
    protected String schemaName;
    protected String tableName;
    protected DmlType dmlType;
    protected String sql;
    protected boolean namedParameters;
    protected int[] types;
    protected String quote;
    protected DatabaseInfo databaseInfo;
    protected Column[] keys;
    protected Column[] columns;
    protected boolean[] nullKeyValues;
    protected String textColumnExpression;

    public DmlStatement(DmlStatementOptions options) {
        this.init(options.getDmlType(), options.getCatalogName(), options.getSchemaName(), options.getTableName(), options.getKeys(), options.getColumns(), options.getNullKeyValues(), options.getDatabaseInfo(), options.useQuotedIdentifiers(), options.getTextColumnExpression(), options.isNamedParameters());
    }

    protected final void init(DmlType type, String catalogName, String schemaName, String tableName, Column[] keysColumns, Column[] columns, boolean[] nullKeyValues, DatabaseInfo databaseInfo, boolean useQuotedIdentifiers, String textColumnExpression, boolean namedParameters) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.namedParameters = namedParameters;
        this.databaseInfo = databaseInfo;
        this.columns = columns;
        this.textColumnExpression = textColumnExpression;
        if (nullKeyValues == null || keysColumns == null || nullKeyValues.length != keysColumns.length) {
            this.keys = keysColumns;
            this.nullKeyValues = keysColumns == null ? null : new boolean[keysColumns.length];
        } else {
            ArrayList<Column> cols = new ArrayList<Column>(keysColumns.length);
            for (int i = 0; i < keysColumns.length; ++i) {
                if (nullKeyValues[i]) continue;
                cols.add(keysColumns[i]);
            }
            this.keys = cols.toArray(new Column[cols.size()]);
            this.nullKeyValues = nullKeyValues;
        }
        String string = this.quote = databaseInfo.getDelimiterToken() == null || !useQuotedIdentifiers ? "" : databaseInfo.getDelimiterToken();
        if (type == DmlType.INSERT) {
            this.sql = this.buildInsertSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns, columns);
        } else if (type == DmlType.UPDATE) {
            this.sql = this.buildUpdateSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns, columns);
        } else if (type == DmlType.DELETE) {
            this.sql = this.buildDeleteSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns);
        } else if (type == DmlType.UPSERT) {
            this.sql = this.buildUpsertSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns, columns);
        } else if (type == DmlType.COUNT) {
            this.sql = this.buildCountSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns);
        } else if (type == DmlType.FROM) {
            this.sql = this.buildFromSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns);
        } else if (type == DmlType.WHERE) {
            this.sql = this.buildWhereSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns);
        } else if (type == DmlType.SELECT) {
            this.sql = this.buildSelectSql(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns, columns);
        } else if (type == DmlType.SELECT_ALL) {
            this.sql = this.buildSelectSqlAll(Table.getFullyQualifiedTableName(catalogName, schemaName, tableName, this.quote, databaseInfo.getCatalogSeparator(), databaseInfo.getSchemaSeparator()), keysColumns, columns);
        } else {
            throw new NotImplementedException("Unimplemented SQL type: " + String.valueOf((Object)type));
        }
        this.dmlType = type;
        this.types = this.buildTypes(this.keys, columns, databaseInfo.isDateOverridesToTimestamp());
    }

    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        switch (this.dmlType) {
            case UPDATE: {
                int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
                int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
                return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
            }
            case INSERT: {
                return this.buildTypes(columns, isDateOverrideToTimestamp);
            }
            case DELETE: {
                return this.buildTypes(keys, isDateOverrideToTimestamp);
            }
            case COUNT: 
            case SELECT: {
                return this.buildTypes(keys, isDateOverrideToTimestamp);
            }
        }
        return null;
    }

    protected int getTypeCode(Column column, boolean isDateOverrideToTimestamp) {
        int type = column.getMappedTypeCode();
        if (type == 91 && isDateOverrideToTimestamp) {
            type = 93;
        } else if (type == 6 || type == 8 || type == 7) {
            type = 3;
        }
        return type;
    }

    protected int[] buildTypes(Column[] columns, boolean isDateOverrideToTimestamp) {
        if (columns != null) {
            ArrayList<Integer> list = new ArrayList<Integer>(columns.length);
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                list.add(this.getTypeCode(columns[i], isDateOverrideToTimestamp));
            }
            int[] types = new int[list.size()];
            for (int index = 0; index < list.size(); ++index) {
                types[index] = (Integer)list.get(index);
            }
            return types;
        }
        return null;
    }

    protected String buildInsertSql(String tableName, Column[] keys, Column[] columns) {
        StringBuilder sql = new StringBuilder("insert into " + tableName + " (");
        this.appendColumns(sql, columns, false);
        sql.append(") values (");
        this.appendColumnParameters(sql, columns);
        sql.append(")");
        return sql.toString();
    }

    protected String buildUpsertSql(String tableName, Column[] keyColumns, Column[] columns) {
        throw new NotImplementedException("Unimplemented SQL type: " + String.valueOf((Object)DmlType.UPSERT));
    }

    protected String buildUpdateSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("update ").append(tableName).append(" set ");
        this.appendColumnsEquals(sql, columns, ", ");
        if (keyColumns != null && keyColumns.length > 0) {
            sql.append(" where ");
            this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        }
        return sql.toString();
    }

    protected String buildDeleteSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("delete from ").append(tableName).append(" where ");
        this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildFromSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder(" from ").append(tableName).append(" where ");
        this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildWhereSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("where ");
        this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildCountSql(String tableName, Column[] keyColumns) {
        StringBuilder sql = new StringBuilder("select count(*) from ").append(tableName);
        if (keyColumns != null && keyColumns.length > 0) {
            sql.append(" where ");
            this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        }
        return sql.toString();
    }

    protected String buildSelectSql(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumns(sql, columns, true);
        sql.append(" from ").append(tableName).append(" where ");
        this.appendColumnsEquals(sql, keyColumns, this.nullKeyValues, " and ");
        return sql.toString();
    }

    protected String buildSelectSqlAll(String tableName, Column[] keyColumns, Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns != null && columns.length > 0) {
            this.appendColumns(sql, columns, true);
        } else {
            sql.append("*");
        }
        sql.append(" from ").append(tableName);
        return sql.toString();
    }

    protected void appendColumnsEquals(StringBuilder sql, Column[] columns, String separator) {
        this.appendColumnsEquals(sql, columns, new boolean[columns.length], separator);
    }

    protected void appendColumnsEquals(StringBuilder sql, Column[] columns, boolean[] nullColumns, String separator) {
        int existingCount = 0;
        if (columns != null) {
            for (int i = 0; i < columns.length && i < nullColumns.length; ++i) {
                if (columns[i] == null) continue;
                if (existingCount++ > 0) {
                    sql.append(separator);
                }
                if (!nullColumns[i]) {
                    this.appendColumnEquals(sql, columns[i]);
                    continue;
                }
                sql.append(this.quote).append(columns[i].getName()).append(this.quote).append(" is NULL");
            }
        }
    }

    protected void appendColumnEquals(StringBuilder sql, Column column) {
        boolean textType = TypeMap.isTextType(column.getMappedTypeCode());
        Object parameter = "?";
        if (this.namedParameters) {
            parameter = ":" + column.getName();
        }
        if (textType && StringUtils.isNotBlank((CharSequence)this.textColumnExpression)) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append(this.textColumnExpression.replace("$(columnName)", (CharSequence)parameter));
        } else {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append((String)parameter);
        }
    }

    protected int appendColumns(StringBuilder sql, Column[] columns, boolean select) {
        int existingCount = 0;
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                if (existingCount++ > 0) {
                    sql.append(", ");
                }
                this.appendColumnNameForSql(sql, columns[i], select);
            }
        }
        return existingCount;
    }

    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        sql.append(this.quote).append(columnName).append(this.quote);
    }

    protected void appendColumnParameters(StringBuilder sql, Column[] columns) {
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                this.appendColumnParameter(sql, columns[i]);
            }
            if (columns.length > 0) {
                sql.replace(sql.length() - 1, sql.length(), "");
            }
        }
    }

    protected void appendColumnParameter(StringBuilder sql, Column column) {
        boolean textType = TypeMap.isTextType(column.getMappedTypeCode());
        Object parameter = "?";
        if (this.namedParameters) {
            parameter = ":" + column.getName();
        }
        if (textType && StringUtils.isNotBlank((CharSequence)this.textColumnExpression)) {
            sql.append(this.textColumnExpression.replace("$(columnName)", (CharSequence)parameter)).append(",");
        } else {
            sql.append((String)parameter).append(",");
        }
    }

    public String getColumnsSql(Column[] columns) {
        StringBuilder sql = new StringBuilder("select ");
        this.appendColumns(sql, columns, true);
        sql.append(this.getSql());
        return sql.toString();
    }

    public String getSql() {
        return this.sql;
    }

    public String getSql(boolean allowIgnoreOnConflict) {
        return this.sql;
    }

    public DmlType getDmlType() {
        return this.dmlType;
    }

    public int[] getTypes() {
        return this.types;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Column[] getColumnKeyMetaData() {
        return (Column[])ArrayUtils.addAll((Object[])this.columns, (Object[])this.keys);
    }

    public Column[] getMetaData() {
        switch (this.dmlType) {
            case UPDATE: 
            case UPSERT: {
                return this.getColumnKeyMetaData();
            }
            case INSERT: {
                return this.getColumns();
            }
            case DELETE: {
                return this.getKeys();
            }
        }
        return null;
    }

    public Column[] getKeys() {
        return this.keys;
    }

    public <T> T[] getValueArray(T[] columnValues, T[] keyValues) {
        switch (this.dmlType) {
            case UPDATE: 
            case UPSERT: {
                return ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
            }
            case INSERT: {
                return columnValues;
            }
            case DELETE: {
                return keyValues;
            }
        }
        return null;
    }

    public Object[] getValueArray(Map<String, Object> params) {
        Object[] args = null;
        if (params != null) {
            int index = 0;
            switch (this.dmlType) {
                case INSERT: {
                    args = new Object[this.columns.length];
                    for (Column column : this.columns) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                case UPDATE: 
                case UPSERT: {
                    args = new Object[this.columns.length + this.keys.length];
                    for (Column column : this.columns) {
                        args[index++] = params.get(column.getName());
                    }
                    for (Column column : this.keys) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                case DELETE: 
                case COUNT: 
                case SELECT: {
                    args = new Object[this.keys.length];
                    for (Column column : this.keys) {
                        args[index++] = params.get(column.getName());
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return args;
    }

    public String buildDynamicSql(BinaryEncoding encoding, Row row, boolean useVariableDates, boolean useJdbcTimestampFormat, Column[] columns) {
        String newSql = this.getSql(false);
        String quote = this.databaseInfo.getValueQuoteToken();
        String binaryQuoteStart = this.databaseInfo.getBinaryQuoteStart();
        String binaryQuoteEnd = this.databaseInfo.getBinaryQuoteEnd();
        String regex = "\\?";
        ArrayList<Column> columnsToProcess = new ArrayList<Column>();
        columnsToProcess.addAll(Arrays.asList(columns));
        for (int i = 0; i < columnsToProcess.size(); ++i) {
            Column column = (Column)columnsToProcess.get(i);
            String name = column.getName();
            int type = column.getMappedTypeCode();
            log.debug("Building where clause for column=" + name + ", type=" + type);
            if (row.get(name) != null) {
                String value;
                if (column.isOfTextType()) {
                    try {
                        value = row.getString(name);
                        value = this.escapeText(value);
                        newSql = newSql.replaceFirst(regex, quote + Matcher.quoteReplacement(value) + quote);
                        continue;
                    }
                    catch (RuntimeException ex) {
                        log.error("Failed to replace ? in {" + this.sql + "} with " + name + "=" + row.getString(name));
                        throw ex;
                    }
                }
                if (column.isTimestampWithTimezone()) {
                    newSql = newSql.replaceFirst(regex, quote + row.getString(name) + quote);
                    continue;
                }
                if (type == 91 || type == 93 || type == 92) {
                    Date date = row.getDateTime(name);
                    if (useVariableDates) {
                        long diff = date.getTime() - System.currentTimeMillis();
                        newSql = newSql.replaceFirst(regex, "${curdate" + diff + "}");
                        continue;
                    }
                    if (type == 92) {
                        newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{t " : "") + quote + FormatUtils.TIME_FORMATTER.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                        continue;
                    }
                    if (type == 91) {
                        newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{d " : "") + quote + FormatUtils.DATE_FORMATTER.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                        continue;
                    }
                    newSql = newSql.replaceFirst(regex, (useJdbcTimestampFormat ? "{ts " : "") + quote + FormatUtils.TIMESTAMP_FORMATTER.format(date) + quote + (useJdbcTimestampFormat ? "}" : ""));
                    continue;
                }
                if (column.isOfBinaryType()) {
                    byte[] bytes = row.getBytes(name);
                    if (encoding == BinaryEncoding.NONE) {
                        newSql = newSql.replaceFirst(regex, quote + row.getString(name) + quote);
                        continue;
                    }
                    if (encoding == BinaryEncoding.BASE64) {
                        newSql = newSql.replaceFirst(regex, quote + new String(Base64.encodeBase64((byte[])bytes), Charset.defaultCharset()) + quote);
                        continue;
                    }
                    if (encoding != BinaryEncoding.HEX) continue;
                    newSql = newSql.replaceFirst(regex, binaryQuoteStart + new String(Hex.encodeHex((byte[])bytes)) + binaryQuoteEnd);
                    continue;
                }
                if (type == -7) {
                    value = row.getString(name);
                    newSql = newSql.replaceFirst(regex, value != null && value.toLowerCase().equals("true") ? "1" : "0");
                    continue;
                }
                newSql = newSql.replaceFirst(regex, row.getString(name));
                continue;
            }
            newSql = DmlType.INSERT.equals((Object)this.dmlType) || DmlType.UPDATE.equals((Object)this.dmlType) && i < columns.length - this.keys.length ? newSql.replaceFirst(regex, "null") : newSql.replaceFirst("\\= " + regex, "is null");
        }
        newSql = newSql.replace(QUESTION_MARK, "?");
        log.debug("Final SQL " + newSql);
        return newSql + this.databaseInfo.getSqlCommandDelimiter();
    }

    public String buildDynamicDeleteSql(BinaryEncoding encoding, Row row, boolean useVariableDates, boolean useJdbcTimestampFormat) {
        return this.buildDynamicSql(encoding, row, useVariableDates, useJdbcTimestampFormat, this.keys);
    }

    public String buildDynamicSql(BinaryEncoding encoding, Row row, boolean useVariableDates, boolean useJdbcTimestampFormat) {
        return this.buildDynamicSql(encoding, row, useVariableDates, useJdbcTimestampFormat, (Column[])ArrayUtils.addAll((Object[])this.columns, (Object[])this.keys));
    }

    public boolean isUpsertSupported() {
        return false;
    }

    public boolean isNamedParameters() {
        return this.namedParameters;
    }

    public String[] getLookupKeyData(Map<String, String> lookupDataMap) {
        Column[] lookupColumns = this.getKeys();
        if (lookupColumns != null && lookupColumns.length > 0 && lookupDataMap != null && lookupDataMap.size() > 0) {
            String[] keyDataAsArray = new String[lookupColumns.length];
            int index = 0;
            for (Column keyColumn : lookupColumns) {
                keyDataAsArray[index++] = lookupDataMap.get(keyColumn.getName());
            }
            return keyDataAsArray;
        }
        return null;
    }

    protected String escapeText(String value) {
        value = value.replace("?", QUESTION_MARK);
        value = value.replace("'", "''");
        return value;
    }

    public void updateCteExpression(String value) {
        this.sql = this.sql.replaceAll("SymmetricDS:", "SymmetricDS:" + value);
    }

    public static String updateCteExpression(String sql, String value) {
        return sql.replaceAll("SymmetricDS:", "SymmetricDS:" + value);
    }

    public static boolean[] getNullKeyValues(Object[] values) {
        boolean[] nullKeyValues = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            nullKeyValues[i] = values == null;
        }
        return nullKeyValues;
    }

    public static enum DmlType {
        INSERT,
        UPDATE,
        DELETE,
        UPSERT,
        COUNT,
        FROM,
        WHERE,
        SELECT,
        SELECT_ALL,
        UNKNOWN;

    }
}

