/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class PostgreSqlDmlStatement
extends DmlStatement {
    protected boolean allowIgnoreOnConflict = true;

    public PostgreSqlDmlStatement(DmlStatementOptions options) {
        super(options);
    }

    @Override
    public String buildInsertSql(String tableName, Column[] keyColumns, Column[] columns) {
        if (keyColumns != null && keyColumns.length > 0 && keyColumns[0] != null) {
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(tableName);
            sql.append("(");
            this.appendColumns(sql, columns, false);
            sql.append(") (select ");
            this.appendColumnParameters(sql, columns);
            sql.append(" where (select distinct 1 from ");
            sql.append(tableName);
            sql.append(" where  ");
            if (keyColumns == null || keyColumns.length == 0) {
                sql.append("1 != 1");
            } else {
                this.appendColumnsEquals(sql, keyColumns, " and ");
            }
            sql.append(") is null)");
            return sql.toString();
        }
        return super.buildInsertSql(tableName, keyColumns, columns);
    }

    @Override
    public String getSql(boolean allowIgnoreOnConflict) {
        this.allowIgnoreOnConflict = allowIgnoreOnConflict;
        if (allowIgnoreOnConflict) {
            return this.sql;
        }
        return super.buildInsertSql(this.tableName, this.keys, this.columns);
    }

    @Override
    public Column[] getMetaData() {
        if (this.dmlType == DmlStatement.DmlType.INSERT && this.allowIgnoreOnConflict) {
            return this.getColumnKeyMetaData();
        }
        return super.getMetaData();
    }

    @Override
    public <T> T[] getValueArray(T[] columnValues, T[] keyValues) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
        }
        return super.getValueArray(columnValues, keyValues);
    }

    @Override
    public Object[] getValueArray(Map<String, Object> params) {
        Object[] args = null;
        int index = 0;
        if (params != null) {
            if (this.dmlType == DmlStatement.DmlType.INSERT) {
                args = new Object[this.columns.length + this.keys.length];
                for (Column column : this.columns) {
                    args[index++] = params.get(column.getName());
                }
                for (Column column : this.keys) {
                    args[index++] = params.get(column.getName());
                }
            } else {
                args = super.getValueArray(params);
            }
        }
        return args;
    }

    @Override
    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
            int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
            return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
        }
        return super.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }

    @Override
    protected void appendColumnParameter(StringBuilder sql, Column column) {
        String typeToCast = this.getTypeToCast(column);
        if (typeToCast != null) {
            sql.append("cast(? as ").append(typeToCast).append(")").append(",");
        } else if (column.getJdbcTypeName() != null && (column.getJdbcTypeName().toUpperCase().contains("GEOMETRY") || column.getJdbcTypeName().toUpperCase().contains("GEOGRAPHY"))) {
            sql.append("ST_GEOMFROMTEXT(?)").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    @Override
    protected void appendColumnEquals(StringBuilder sql, Column column) {
        String typeToCast = this.getTypeToCast(column);
        if (typeToCast != null) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = cast(? as ").append(typeToCast).append(")");
        } else if (column.getJdbcTypeName() != null && (column.getJdbcTypeName().toUpperCase().contains("GEOMETRY") || column.getJdbcTypeName().toUpperCase().contains("GEOGRAPHY"))) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ST_GEOMFROMTEXT(?)");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }

    private String getTypeToCast(Column column) {
        Object typeToCast = null;
        if (column.isTimestampWithTimezone()) {
            typeToCast = "timestamp with time zone";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("UUID")) {
            typeToCast = "uuid";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("VARBIT")) {
            typeToCast = "bit varying";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("INTERVAL")) {
            typeToCast = "interval";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("TSVECTOR")) {
            typeToCast = "tsvector";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("JSONB")) {
            typeToCast = "json";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("JSON")) {
            typeToCast = "json";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("INET")) {
            typeToCast = "inet";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("CIDR")) {
            typeToCast = "cidr";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("MACADDR8")) {
            typeToCast = "macaddr8";
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("MACADDR")) {
            typeToCast = "macaddr";
        }
        if (typeToCast != null && column.getMappedType() != null && column.getMappedType().equals("ARRAY")) {
            typeToCast = (String)typeToCast + "[]";
        }
        return typeToCast;
    }

    @Override
    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        if (select && column.isTimestampWithTimezone()) {
            sql.append("   case                                                                                                                                    when extract(timezone_hour from ").append(this.quote).append(columnName).append(this.quote).append(") < 0 then                                      to_char(").append(this.quote).append(columnName).append(this.quote).append(", 'YYYY-MM-DD HH24:MI:SS.US ')||'-'||                                 lpad(cast(abs(extract(timezone_hour from ").append(this.quote).append(columnName).append(this.quote).append(")) as varchar),2,'0')||':'||         lpad(cast(extract(timezone_minute from ").append(this.quote).append(columnName).append(this.quote).append(") as varchar), 2, '0')               else                                                                                                                                      to_char(").append(this.quote).append(columnName).append(this.quote).append(", 'YYYY-MM-DD HH24:MI:SS.US ')||'+'||                                 lpad(cast(extract(timezone_hour from ").append(this.quote).append(columnName).append(this.quote).append(") as varchar),2,'0')||':'||              lpad(cast(extract(timezone_minute from ").append(this.quote).append(columnName).append(this.quote).append(") as varchar), 2, '0')               end as ").append(columnName);
        } else {
            super.appendColumnNameForSql(sql, column, select);
        }
    }
}

