/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.oracle;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;
import org.jumpmind.db.platform.oracle.Oracle23DdlBuilder;

public class OracleDdlBuilder
extends AbstractDdlBuilder {
    protected static final String PREFIX_TRIGGER = "TRG";
    protected static final String PREFIX_SEQUENCE = "SEQ";
    protected static final String ROWID_TYPE = "ROWID";
    protected static final String DATE_TYPE = "DATE";

    public OracleDdlBuilder() {
        super("oracle");
        this.databaseInfo.setMaxIdentifierLength(30);
        this.databaseInfo.setIdentityStatusReadingSupported(false);
        this.databaseInfo.addNativeTypeMapping(2003, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-5, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(-2, "RAW", -3);
        this.databaseInfo.addNativeTypeMapping(-7, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(91, DATE_TYPE, 93);
        this.databaseInfo.addNativeTypeMapping(3, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(2001, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE PRECISION");
        this.databaseInfo.addNativeTypeMapping(6, "FLOAT", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-4, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-1, "CLOB", 2005);
        this.databaseInfo.addNativeTypeMapping(0, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(4, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(1111, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2006, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(5, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(2002, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(92, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(-103, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(93, "TIMESTAMP");
        this.databaseInfo.addNativeTypeMapping(-6, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping(-3, "RAW");
        this.databaseInfo.addNativeTypeMapping(12, "VARCHAR2");
        this.databaseInfo.addNativeTypeMapping(16, "NUMBER", 2);
        this.databaseInfo.addNativeTypeMapping("DATALINK", "BLOB", "BLOB");
        this.databaseInfo.addNativeTypeMapping(-9, "NVARCHAR2", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "NVARCHAR2", 12);
        this.databaseInfo.addNativeTypeMapping(-101, "TIMESTAMP WITH TIME ZONE");
        this.databaseInfo.addNativeTypeMapping(-102, "TIMESTAMP WITH LOCAL TIME ZONE");
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setDefaultSize(93, 6);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setMaxSize("TIMESTAMP", 9);
        this.databaseInfo.setMaxSize("TIMESTAMP WITH TIME ZONE", 9);
        this.databaseInfo.setMaxSize("TIMESTAMP WITH LOCAL TIME ZONE", 9);
        this.databaseInfo.setPrimaryKeyEmbedded(false);
        this.databaseInfo.setDateOverridesToTimestamp(true);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(true);
        this.databaseInfo.setTriggersCreateOrReplaceSupported(true);
        this.databaseInfo.setBinaryQuoteStart("0x");
        this.databaseInfo.setBinaryQuoteEnd("");
        this.databaseInfo.setFunctionalIndicesSupported(true);
        this.databaseInfo.setCanTriggerExistWithoutTable(true);
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        String newValue = super.mapDefaultValue(defaultValue, column);
        if (this.databaseInfo.getDefaultValuesToTranslate().containsKey(defaultValue.toString())) {
            return newValue;
        }
        int typeCode = column.getMappedTypeCode();
        if (typeCode == 93 || typeCode == -101 || typeCode == -102) {
            if (newValue.startsWith("(") && newValue.endsWith(")")) {
                newValue = newValue.substring(1, newValue.length() - 1);
            }
            if (!column.allPlatformColumnNamesContain("oracle")) {
                String uppercaseValue = newValue.trim().toUpperCase();
                if (uppercaseValue.startsWith("SYSDATE(")) {
                    newValue = "SYSDATE";
                } else if (uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("CURRENT TIMESTAMP") || uppercaseValue.startsWith("GETDATE(") || uppercaseValue.startsWith("SYSDATETIME") || uppercaseValue.startsWith("NOW(") || uppercaseValue.startsWith("LOCALTIME") || uppercaseValue.startsWith("TRANSACTION_TIMESTAMP(") || uppercaseValue.startsWith("STATEMENT_TIMESTAMP(") || uppercaseValue.startsWith("CLOCK_TIMESTAMP(")) {
                    newValue = "SYSTIMESTAMP";
                } else if (uppercaseValue.startsWith("GETUTCDATE(") || uppercaseValue.startsWith("SYSUTCDATETIME(") || uppercaseValue.startsWith("UTC_TIMESTAMP")) {
                    newValue = "SYS_EXTRACT_UTC(SYSTIMESTAMP)";
                }
            }
        }
        return newValue;
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("SYSTIMESTAMP") && !defaultValueStr.trim().toUpperCase().startsWith("SYS_EXTRACT_UTC(") && !defaultValueStr.trim().toUpperCase().startsWith("SYS_GUID") && !defaultValueStr.trim().toUpperCase().startsWith("SYS_CONTEXT") && !defaultValueStr.trim().toUpperCase().startsWith("NVL");
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        int idx;
        Column[] columns = table.getAutoIncrementColumns();
        if (!temporary && !recreate) {
            for (idx = 0; idx < columns.length; ++idx) {
                this.createAutoIncrementSequence(table, columns[idx], ddl);
            }
        }
        super.createTable(table, ddl, temporary, recreate);
        if (!temporary) {
            for (idx = 0; idx < columns.length; ++idx) {
                this.createAutoIncrementTrigger(table, columns[idx], ddl);
            }
        }
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (!temporary && !recreate) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.dropAutoIncrementTrigger(table, columns[idx], ddl);
                this.dropAutoIncrementSequence(table, columns[idx], ddl);
            }
        }
        ddl.append("DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" CASCADE CONSTRAINTS PURGE");
        this.printEndOfStatement(ddl);
    }

    protected void createAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        ddl.append("CREATE SEQUENCE ");
        this.printIdentifier(this.getConstraintName(PREFIX_SEQUENCE, table, column.getName(), null), ddl);
        ddl.append(" CACHE 1000 ORDER");
        this.printEndOfStatement(ddl);
    }

    protected void createAutoIncrementTrigger(Table table, Column column, StringBuilder ddl) {
        String columnName = this.getColumnName(column);
        String triggerName = this.getConstraintName(PREFIX_TRIGGER, table, column.getName(), null);
        if (this.scriptModeOn) {
            ddl.append("CREATE OR REPLACE TRIGGER ");
            this.printlnIdentifier(triggerName, ddl);
            ddl.append("BEFORE INSERT ON ");
            ddl.append(this.getFullyQualifiedTableNameShorten(table));
            ddl.append("FOR EACH ROW WHEN (new.");
            this.printIdentifier(columnName, ddl);
            this.println(" IS NULL)", ddl);
            this.println("BEGIN", ddl);
            ddl.append("  SELECT ");
            this.printIdentifier(this.getConstraintName(PREFIX_SEQUENCE, table, column.getName(), null), ddl);
            ddl.append(".nextval INTO :new.");
            this.printIdentifier(columnName, ddl);
            ddl.append(" FROM dual");
            this.println(this.databaseInfo.getSqlCommandDelimiter(), ddl);
            ddl.append("END");
            this.println(this.databaseInfo.getSqlCommandDelimiter(), ddl);
            this.println("/", ddl);
            this.println(ddl);
        } else {
            ddl.append("CREATE OR REPLACE TRIGGER ");
            this.printIdentifier(triggerName, ddl);
            ddl.append(" BEFORE INSERT ON ");
            ddl.append(this.getFullyQualifiedTableNameShorten(table));
            ddl.append(" FOR EACH ROW WHEN (new.");
            this.printIdentifier(columnName, ddl);
            this.println(" IS NULL)", ddl);
            ddl.append("BEGIN SELECT ");
            this.printIdentifier(this.getConstraintName(PREFIX_SEQUENCE, table, column.getName(), null), ddl);
            ddl.append(".nextval INTO :new.");
            this.printIdentifier(columnName, ddl);
            ddl.append(" FROM dual");
            ddl.append(this.databaseInfo.getSqlCommandDelimiter());
            ddl.append(" END");
            ddl.append(this.databaseInfo.getSqlCommandDelimiter());
            this.printEndOfStatement(ddl);
        }
    }

    protected void dropAutoIncrementSequence(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP SEQUENCE ");
        this.printIdentifier(this.getConstraintName(PREFIX_SEQUENCE, table, column.getName(), null), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void dropAutoIncrementTrigger(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP TRIGGER ");
        this.printIdentifier(this.getConstraintName(PREFIX_TRIGGER, table, column.getName(), null), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public void dropExternalForeignKeys(Table table, StringBuilder ddl) {
    }

    @Override
    protected String getFullyQualifiedIndexNameShorten(Table table, IIndex index) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            sb.append(this.getDelimitedIdentifier(table.getSchema())).append(this.databaseInfo.getSchemaSeparator());
        }
        sb.append(this.getDelimitedIdentifier(this.getIndexName(index)));
        return sb.toString();
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getMappedTypeCode(), 5);
        }
        if (column.getMappedTypeCode() == 91) {
            if (Pattern.matches("\\d{4}\\-\\d{2}\\-\\d{2}", column.getDefaultValue())) {
                return "TO_DATE('" + column.getDefaultValue() + "', 'YYYY-MM-DD')";
            }
        } else if (column.getMappedTypeCode() == 92) {
            if (Pattern.matches("\\d{2}:\\d{2}:\\d{2}", column.getDefaultValue())) {
                return "TO_DATE('" + column.getDefaultValue() + "', 'HH24:MI:SS')";
            }
        } else if (column.getMappedTypeCode() == 93 && Pattern.matches("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}:\\d{2}:\\d{2}[\\.\\d{1,8}]?", column.getDefaultValue())) {
            return "TO_DATE('" + column.getDefaultValue() + "', 'YYYY-MM-DD HH24:MI:SS')";
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length > 0) {
            StringBuilder result = new StringBuilder();
            result.append("SELECT ");
            for (int idx = 0; idx < columns.length; ++idx) {
                if (idx > 0) {
                    result.append(",");
                }
                result.append(this.getDelimitedIdentifier(this.getConstraintName(PREFIX_SEQUENCE, table, columns[idx].getName(), null)));
                result.append(".currval");
            }
            result.append(" FROM dual");
            return result.toString();
        }
        return null;
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnSizeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" MODIFY ");
        Column column = change.getChangedColumn();
        column.setSizeAndScale(change.getNewSize(), change.getNewScale());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" ");
        ddl.append(this.getSqlType(column));
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        PrimaryKeyChange pkChange;
        TableChange change;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                if (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null) continue;
                return;
            }
            if (change instanceof ColumnSizeChange) {
                this.processChange(currentModel, desiredModel, (ColumnSizeChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnDefaultValueChange) {
                this.processChange(currentModel, desiredModel, (ColumnDefaultValueChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnRequiredChange) {
                this.processChange(currentModel, desiredModel, (ColumnRequiredChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof ColumnAutoIncrementChange) || !this.processChange(currentModel, desiredModel, (ColumnAutoIncrementChange)change, ddl)) continue;
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof RemovePrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            pkChange = (PrimaryKeyChange)change;
            RemovePrimaryKeyChange removePkChange = new RemovePrimaryKeyChange(pkChange.getChangedTable(), pkChange.getOldPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, removePkChange, ddl);
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof AddColumnChange) {
                this.processChange(currentModel, desiredModel, (AddColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof CopyColumnValueChange)) continue;
            CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
            this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            pkChange = (PrimaryKeyChange)change;
            AddPrimaryKeyChange addPkChange = new AddPrimaryKeyChange(pkChange.getChangedTable(), pkChange.getNewPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, addPkChange, ddl);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnDefaultValueChange change, StringBuilder ddl) {
        boolean changeNeeded = true;
        String newValue = change.getNewDefaultValue();
        String oldValue = change.getChangedColumn().getDefaultValue();
        if (oldValue == null && "NULL".equals(newValue) || newValue == null && "NULL".equals(oldValue)) {
            changeNeeded = false;
        }
        if (changeNeeded) {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" MODIFY (");
            Column column = change.getChangedColumn();
            column.setDefaultValue(change.getNewDefaultValue());
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(change.getChangedTable(), column, ddl);
            ddl.append(" )");
            this.printEndOfStatement(ddl);
        }
    }

    protected boolean processChange(Database currentModel, Database desiredModel, ColumnAutoIncrementChange change, StringBuilder ddl) {
        boolean autoIncrement;
        boolean bl = autoIncrement = !change.getColumn().isAutoIncrement();
        if (!autoIncrement) {
            this.dropAutoIncrementTrigger(change.getChangedTable(), change.getColumn(), ddl);
            this.dropAutoIncrementSequence(change.getChangedTable(), change.getColumn(), ddl);
            return true;
        }
        return false;
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnRequiredChange change, StringBuilder ddl) {
        boolean required = !change.getChangedColumn().isRequired();
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" MODIFY (");
        Column column = change.getChangedColumn();
        this.printIdentifier(this.getColumnName(column), ddl);
        if (required) {
            ddl.append(" NOT NULL ");
        } else {
            ddl.append(" NULL ");
        }
        ddl.append(" )");
        this.printEndOfStatement(ddl);
    }

    @Override
    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append("MODIFY (");
        Column column = change.getChangedColumn();
        column.setTypeCode(change.getNewTypeCode());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" ");
        ddl.append(this.getSqlType(column));
        ddl.append(")");
        this.printEndOfStatement(ddl);
        return true;
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        if (change.getNewColumn().isAutoIncrement()) {
            this.createAutoIncrementSequence(change.getChangedTable(), change.getNewColumn(), ddl);
            this.createAutoIncrementTrigger(change.getChangedTable(), change.getNewColumn(), ddl);
        }
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        if (change.getColumn().isAutoIncrement()) {
            this.dropAutoIncrementTrigger(change.getChangedTable(), change.getColumn(), ddl);
            this.dropAutoIncrementSequence(change.getChangedTable(), change.getColumn(), ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    public String getSqlType(Column column) {
        if (column.getMappedTypeCode() == 12 && column.getSizeAsInt() > 4000) {
            return "VARCHAR(4000)";
        }
        if (column.getMappedTypeCode() == 1 && column.getSizeAsInt() > 2000) {
            return "CHAR(2000)";
        }
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (platformColumn != null && platformColumn.getType() != null) {
            if (platformColumn.getType().equals(ROWID_TYPE)) {
                return ROWID_TYPE;
            }
            if (platformColumn.getType().equals(DATE_TYPE)) {
                return DATE_TYPE;
            }
        }
        if (column.getJdbcTypeCode() == -101 || column.getMappedTypeCode() == -101) {
            return "TIMESTAMP(" + column.getSizeAsInt() + ") WITH TIME ZONE";
        }
        if (column.getJdbcTypeCode() == -102 || column.getMappedTypeCode() == -102) {
            return "TIMESTAMP(" + column.getSizeAsInt() + ") WITH LOCAL TIME ZONE";
        }
        if (column.getMappedTypeCode() == 16 && this instanceof Oracle23DdlBuilder) {
            return "BOOLEAN";
        }
        if ((column.getMappedTypeCode() == -5 || column.getMappedTypeCode() == 4 || column.getMappedTypeCode() == 5 || column.getMappedTypeCode() == -6 || column.getMappedTypeCode() == -7 || column.getMappedTypeCode() == 16) && column.getSizeAsInt() > 0 && column.getSizeAsInt() < 39) {
            return super.getSqlType(column) + "(" + column.getSizeAsInt() + ")";
        }
        return super.getSqlType(column);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        if (key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.CASCADE || key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.SETNULL) {
            super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        }
    }
}

