/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ingres;

import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class IngresDdlBuilder
extends AbstractDdlBuilder {
    public IngresDdlBuilder() {
        super("ingres");
        this.databaseInfo.setMaxIdentifierLength(256);
        this.databaseInfo.setRequiresAutoCommitForDdl(false);
        this.databaseInfo.addNativeTypeMapping(-1, "LONG VARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(-4, "LONG BYTE", -4);
        this.databaseInfo.addNativeTypeMapping(8, "FLOAT", 8);
        this.databaseInfo.addNativeTypeMapping(-7, "BOOLEAN");
        this.databaseInfo.addNativeTypeMapping(-101, "TIMESTAMP WITH TIME ZONE");
        this.databaseInfo.addNativeTypeMapping(-102, "TIMESTAMP WITH LOCAL TIME ZONE");
        this.databaseInfo.addNativeTypeMapping(92, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(-103, "TIMESTAMP", 93);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setMaxSize("TIMESTAMP", 9);
        this.databaseInfo.setMaxSize("TIMESTAMP WITH TIME ZONE", 9);
        this.databaseInfo.setMaxSize("TIMESTAMP WITH LOCAL TIME ZONE", 9);
        this.databaseInfo.setNonPKIdentityColumnsSupported(true);
        this.databaseInfo.setDefaultValueUsedForIdentitySpec(false);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setDelimiterToken("");
        this.databaseInfo.setDelimitedIdentifiersSupported(false);
        this.delimitedIdentifierModeOn = false;
    }

    public static boolean isUsePseudoSequence() {
        return "true".equalsIgnoreCase(System.getProperty("org.jumpmind.symmetric.ddl.use.table.seq", "false"));
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append(" GENERATED BY DEFAULT AS IDENTITY ");
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("DROP CONSTRAINT ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey), ddl);
        ddl.append(" CASCADE ");
        this.printEndOfStatement(ddl);
    }

    @Override
    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        this.writeTableAlterStmt(change.getChangedTable(), ddl);
        ddl.append(" ALTER COLUMN ");
        Column column = change.getChangedColumn();
        column.setTypeCode(change.getNewTypeCode());
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" TYPE ");
        ddl.append(this.getSqlType(column));
        this.printEndOfStatement(ddl);
        return true;
    }
}

