/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.firebird;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.firebird.FirebirdDdlBuilder;

public class FirebirdDialect1DdlBuilder
extends FirebirdDdlBuilder {
    public FirebirdDialect1DdlBuilder() {
        this.databaseInfo.addNativeTypeMapping(-5, "NUMERIC(18)", 2);
        this.databaseInfo.addNativeTypeMapping(92, "TIMESTAMP", 93);
        this.databaseName = "firebird_dialect1";
        this.databaseInfo.setDelimitedIdentifiersSupported(false);
        this.databaseInfo.setDelimiterToken("");
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Collection<IModelChange> changes, StringBuilder ddl) {
        Iterator<IModelChange> iter = changes.iterator();
        while (iter.hasNext()) {
            ColumnDefaultValueChange defaultValueChange;
            IModelChange change = iter.next();
            if (change instanceof ColumnDataTypeChange) {
                ColumnDataTypeChange dataTypeChange = (ColumnDataTypeChange)change;
                if (dataTypeChange.getNewTypeCode() != -5 || dataTypeChange.getChangedColumn().getMappedTypeCode() != 8) continue;
                iter.remove();
                continue;
            }
            if (!(change instanceof ColumnDefaultValueChange) || (defaultValueChange = (ColumnDefaultValueChange)change).getChangedColumn().getMappedTypeCode() != 8 || new BigDecimal(defaultValueChange.getNewDefaultValue()).compareTo(new BigDecimal(defaultValueChange.getChangedColumn().getDefaultValue())) != 0) continue;
            iter.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, changes, ddl);
    }
}

