/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.http;

import com.onelogin.saml2.http.HttpRequest;

public class HttpRequestUtils {
    private HttpRequestUtils() {
    }

    public static String getSelfURLhost(HttpRequest request) {
        String hostUrl = "";
        int serverPort = request.getServerPort();
        hostUrl = serverPort == 80 || serverPort == 443 || serverPort == 0 ? String.format("%s://%s", request.getScheme(), request.getServerName()) : String.format("%s://%s:%s", request.getScheme(), request.getServerName(), serverPort);
        return hostUrl;
    }

    public static String getSelfURL(HttpRequest request) {
        String url = HttpRequestUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        if (null != queryString && !queryString.isEmpty()) {
            url = url + '?' + queryString;
        }
        return url;
    }

    public static String getSelfURLNoQuery(HttpRequest request) {
        return request.getRequestURL();
    }

    public static String getSelfRoutedURLNoQuery(HttpRequest request) {
        String url = HttpRequestUtils.getSelfURLhost(request);
        String requestUri = request.getRequestURI();
        if (null != requestUri && !requestUri.isEmpty()) {
            url = url + requestUri;
        }
        return url;
    }
}

