/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.unix;

import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.unix.UnixUser;
import java.io.File;
import java.util.ArrayList;

public class UnixUsers
extends ArrayList<UnixUser> {
    private static final long serialVersionUID = -4804842346742194981L;

    public UnixUsers() {
        this.fromUsersArrayList(UnixUsers.getEtcPasswdUsersAsArrayList());
        this.fromUsersArrayList(UnixUsers.getYpPasswdUsersAsArrayList());
    }

    public ArrayList<UnixUser> getUsersWithValidShells() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        for (int idx = 0; idx < this.size(); ++idx) {
            UnixUser user = (UnixUser)this.get(idx);
            if (user.getShell() == null || !user.getShell().trim().endsWith("sh")) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<UnixUser> getUsersWithValidShellsAndExistingHomes() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        ArrayList<UnixUser> usersWithValidShells = this.getUsersWithValidShells();
        for (UnixUser user : usersWithValidShells) {
            if (user.getHome() == null || !new File(user.getHome().trim()).exists()) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<UnixUser> _getUsersWithValidShellsExistingHomesAndDesktops() {
        ArrayList<UnixUser> result = new ArrayList<UnixUser>();
        ArrayList<UnixUser> usersWithValidShellsAndExistingHomes = this.getUsersWithValidShellsAndExistingHomes();
        for (UnixUser user : usersWithValidShellsAndExistingHomes) {
            if (user.getHome() == null || !new File(user.getXdgDesktopfolder()).exists()) continue;
            result.add(user);
        }
        return result;
    }

    public ArrayList<String> getValidUsersDesktopFolders() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<UnixUser> validUserDesktops = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        for (UnixUser user : validUserDesktops) {
            File DesktopFolder;
            if (user.getHome() == null || !(DesktopFolder = new File(user.getXdgDesktopfolder())).exists() || !DesktopFolder.isDirectory()) continue;
            result.add(DesktopFolder.toString());
        }
        return result;
    }

    public static ArrayList<UnixUser> getUsersWithValidShellsExistingHomesAndDesktops() {
        UnixUsers users = new UnixUsers();
        return users._getUsersWithValidShellsExistingHomesAndDesktops();
    }

    private void fromUsersArrayList(ArrayList<String> anUsersArrayList) {
        for (String anAnUsersArrayList : anUsersArrayList) {
            this.add(new UnixUser().fromEtcPasswdLine(anAnUsersArrayList));
        }
    }

    public static ArrayList<String> getEtcPasswdUsersAsArrayList() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> etcPasswdArray = UnixHelper.getEtcPasswdArray();
        for (String line : etcPasswdArray) {
            result.add(line);
        }
        return result;
    }

    public static ArrayList<String> getYpPasswdUsersAsArrayList() {
        return UnixHelper.getYpPasswdArray();
    }

    public static String getUsersColonString() {
        ArrayList<String> usersArrayList = UnixUsers.getEtcPasswdUsersAsArrayList();
        String retValue = "";
        for (String userline : usersArrayList) {
            retValue = retValue + userline.substring(0, userline.indexOf(":")) + ":";
        }
        if (retValue.endsWith(":")) {
            retValue = retValue.substring(0, retValue.length() - 1);
        }
        return retValue;
    }

    public static void main(String[] args) {
        System.out.println("UnixUsers:");
        UnixUsers users = new UnixUsers();
        for (Object user : users) {
            System.out.println(((UnixUser)user).getName());
        }
        System.out.println(StringTool.listToString(UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops()));
    }
}

