/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.event.AbstractUninstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SymmetricUninstallerListener
extends AbstractUninstallerListener {
    File symAdmin;
    File enginesDirectory;

    @Override
    public void initialise() {
        String jar = System.getProperty("self.mod.jar");
        if (jar != null && jar.length() > 28) {
            String installPath = jar.substring(0, jar.length() - 28);
            SymmetricIzPackHelper.openLog(installPath);
        }
        this.log("Starting UNINSTALL");
    }

    @Override
    public void afterDelete(File file) {
        this.log("Removed " + file.getPath());
    }

    @Override
    public void beforeDelete(List<File> files) {
        File exeFile = null;
        for (File file : files) {
            String name = file.getName();
            if (exeFile == null && (name.equals("sym_service") || name.equals("sym_service.bat"))) {
                exeFile = file;
                this.log("Found sym_service at " + exeFile.getPath() + " [read=" + exeFile.canRead() + ", execute=" + exeFile.canExecute() + "]");
            } else if (this.symAdmin == null && (name.equals("symadmin") || name.equals("symadmin.bat"))) {
                this.symAdmin = file;
                this.log("Found symadmin at " + this.symAdmin.getPath() + " [read=" + this.symAdmin.canRead() + ", execute=" + this.symAdmin.canExecute() + "]");
            } else if (file.getAbsolutePath().contains("engines") && file.isDirectory()) {
                this.enginesDirectory = file;
                this.log("Found engines directory at " + this.enginesDirectory.getPath());
            }
            if (exeFile == null || this.symAdmin == null || this.enginesDirectory == null) continue;
            break;
        }
        if (exeFile != null) {
            this.log("Stopping service");
            try {
                SymmetricIzPackHelper.runCommand(new String[]{exeFile.getCanonicalPath(), "stop"});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.log("Uninstalling service");
            try {
                SymmetricIzPackHelper.runCommand(new String[]{exeFile.getCanonicalPath(), "uninstall"});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.log("Unable to find sym_service to execute stop and uninstall");
        if (this.symAdmin != null) {
            String isUninstallNodes = System.getProperty("sym.uninstall.nodes");
            if (isUninstallNodes != null) {
                this.log("Property sym.uninstall.nodes=" + isUninstallNodes);
                if (isUninstallNodes.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    this.uninstallNodes();
                }
            } else {
                this.log("Prompting user about uninstalling nodes");
                SymmetricUninstallerFrame frame = new SymmetricUninstallerFrame();
                frame.setVisible(true);
                while (frame.isVisible()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else {
            this.log("Unable to find symadmin to optionally execute uninstall");
        }
    }

    protected void uninstallNodes() {
        try {
            this.log("Uninstalling nodes");
            if (this.enginesDirectory != null) {
                File[] files = this.enginesDirectory.listFiles();
                this.log("Found " + files.length + " engine files");
                for (File engineFile : files) {
                    SymmetricIzPackHelper.runCommand(new String[]{this.symAdmin.getCanonicalPath(), "uninstall", "-p", engineFile.getAbsolutePath()});
                }
            } else {
                SymmetricIzPackHelper.runCommand(new String[]{this.symAdmin.getCanonicalPath(), "uninstall"});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void afterDelete(List<File> files, ProgressListener listener) {
        this.log("Ending UNINSTALL");
        this.log("");
    }

    private boolean isTrace() {
        String traceProp = System.getProperty("TRACE");
        return traceProp != null && traceProp.equalsIgnoreCase("true");
    }

    private void log(String message) {
        SymmetricIzPackHelper.log(message);
        if (this.isTrace()) {
            System.out.println("[SymmetricUninstallerListener] " + message);
        }
    }

    public class SymmetricUninstallerFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;

        public SymmetricUninstallerFrame() {
            super("Uninstall Node");
            this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            this.setSize(470, 140);
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            Dimension frameSize = this.getSize();
            this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel("Would you like to also uninstall the nodes from the database?");
            GridBagConstraints gbConstraints = new GridBagConstraints();
            this.buildConstraints(gbConstraints, 0, 0, 2, 1.0);
            gbConstraints.insets = new Insets(5, 5, 5, 5);
            gbConstraints.fill = 2;
            gbConstraints.anchor = 23;
            panel.add((Component)label, gbConstraints);
            JButton yesButton = new JButton("Yes");
            yesButton.addActionListener(event -> {
                try {
                    SymmetricUninstallerListener.this.uninstallNodes();
                }
                finally {
                    this.setVisible(false);
                }
            });
            this.buildConstraints(gbConstraints, 0, 1, 1, 0.5);
            gbConstraints.fill = 0;
            gbConstraints.anchor = 25;
            panel.add((Component)yesButton, gbConstraints);
            JButton noButton = new JButton("No");
            noButton.addActionListener(event -> this.setVisible(false));
            this.buildConstraints(gbConstraints, 1, 1, 1, 0.5);
            gbConstraints.anchor = 26;
            panel.add((Component)noButton, gbConstraints);
            this.add(panel);
        }

        private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, double wx) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.weightx = wx;
        }
    }
}

