/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.IOException;
import java.net.ServerSocket;

public class SymmetricPortValidator
implements DataValidator {
    private String errorMessage;

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessage;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        boolean httpEnabled = Boolean.parseBoolean(idata.getVariable("select.install.httpEnabled"));
        boolean httpsEnabled = Boolean.parseBoolean(idata.getVariable("select.install.httpsEnabled"));
        boolean jmxAgentEnabled = Boolean.parseBoolean(idata.getVariable("select.install.jmxAgentEnabled"));
        int hPort = -1;
        int sPort = -1;
        int aPort = -1;
        if (!httpEnabled && !httpsEnabled) {
            this.errorMessage = "Either HTTP or HTTPS must be enabled.";
            return DataValidator.Status.ERROR;
        }
        if (httpEnabled) {
            String httpPort = idata.getVariable("select.install.httpPort");
            if (httpPort == null || httpPort.isEmpty() || !httpPort.matches("[0-9]{1,5}")) {
                this.errorMessage = "HTTP Port is not a valid port number.";
                return DataValidator.Status.ERROR;
            }
            hPort = Integer.valueOf(httpPort.trim());
            if (!SymmetricPortValidator.portAvailable(hPort)) {
                this.errorMessage = hPort < 1024 ? "The selected HTTP port (" + httpPort + ") is unavailable. \nDoes your user have permission to ports under 1024?" : "The selected HTTP port (" + httpPort + ") is unavailable. \nPlease select another port.";
                return DataValidator.Status.ERROR;
            }
        }
        if (httpsEnabled) {
            String httpsPort = idata.getVariable("select.install.httpsPort");
            if (httpsPort == null || httpsPort.isEmpty() || !httpsPort.matches("[0-9]{1,5}")) {
                this.errorMessage = "HTTPS Port is not a valid port number.";
                return DataValidator.Status.ERROR;
            }
            hPort = Integer.valueOf(httpsPort.trim());
            if (!SymmetricPortValidator.portAvailable(hPort)) {
                this.errorMessage = hPort < 1024 ? "The selected HTTPS port (" + httpsPort + ") is unavailable. \nDoes your user have permission to ports under 1024?" : "The selected HTTPS port (" + httpsPort + ") is unavailable. \nPlease select another port.";
                return DataValidator.Status.ERROR;
            }
            if (httpEnabled && sPort == hPort) {
                this.errorMessage = "The selected HTTP port and HTTPS ports cannot share the same port.";
                return DataValidator.Status.ERROR;
            }
        }
        if (jmxAgentEnabled) {
            String jmxPort = idata.getVariable("select.install.jmxAgentPort");
            if (jmxPort == null || jmxPort.isEmpty() || !jmxPort.matches("[0-9]*")) {
                this.errorMessage = "JMX Port is not a valid port number.";
                return DataValidator.Status.ERROR;
            }
            aPort = Integer.valueOf(jmxPort.trim());
            if (!SymmetricPortValidator.portAvailable(aPort)) {
                this.errorMessage = aPort < 1024 ? "The selected JMX port (" + jmxPort + ") is unavailable. \nDoes your user have permission to ports under 1024?" : "The selected JMX port (" + jmxPort + ") is unavailable. \nPlease select another port.";
                return DataValidator.Status.ERROR;
            }
            if (httpEnabled && aPort == hPort) {
                this.errorMessage = "The selected HTTP port and JMX ports cannot share the same port.";
                return DataValidator.Status.ERROR;
            }
            if (httpsEnabled && aPort == sPort) {
                this.errorMessage = "The selected SSL port and JMX ports cannot share the same port.";
                return DataValidator.Status.ERROR;
            }
            idata.setVariable("enable.jmx.agent", "");
        } else {
            idata.setVariable("enable.jmx.agent", "#");
        }
        return DataValidator.Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean portAvailable(int port) {
        if (port < 1 || port > 65535) {
            return false;
        }
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

