/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.signature;

import com.anfcorp.stores.signature.JavaPosSignature;
import com.anfcorp.stores.signature.PosSignature;
import com.anfcorp.stores.signature.SigSignature;
import com.anfcorp.stores.signature.SignatureInterface;
import com.anfcorp.stores.signature.ThreeByteAsciiSignature;
import com.anfcorp.stores.signature.UnknownSignatureTypeException;
import com.anfcorp.stores.signature.element.Line;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.FileOutputStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureFactory {
    private static final JavaPosSignature jps = new JavaPosSignature();
    private static final ThreeByteAsciiSignature tbs = new ThreeByteAsciiSignature();
    private static final SigSignature sbs = new SigSignature();

    public static final SignatureInterface getInstance(String signature) throws UnknownSignatureTypeException {
        PosSignature sInterface = null;
        if (jps.isValid(signature)) {
            sInterface = new JavaPosSignature();
        } else if (tbs.isValid(signature)) {
            sInterface = new ThreeByteAsciiSignature();
        } else if (sbs.isValid(signature)) {
            sInterface = new SigSignature();
        } else {
            throw new UnknownSignatureTypeException("Unknown signature type");
        }
        return sInterface;
    }

    public static final String convert(String signature, Class<?> toClass) throws UnknownSignatureTypeException {
        Point dest;
        Point src;
        String ret = null;
        SignatureInterface sInterface = SignatureFactory.getInstance(signature);
        if (toClass.getName().equals(sInterface.getClass().getName())) {
            return signature;
        }
        Vector<Line> v = sInterface.buildSignatureVector(signature);
        sInterface.calculateBounds(v);
        float widthScale = new Float(PosSignature.defaultConvertWidth.intValue()).floatValue() / (float)(sInterface.getMaxX() - sInterface.getMinX());
        float heightScale = new Float(PosSignature.defaultConvertHeight.intValue()).floatValue() / (float)(sInterface.getMaxY() - sInterface.getMinY());
        AffineTransform t = AffineTransform.getScaleInstance(widthScale, heightScale);
        for (Line line : v) {
            src = line.getBeginPoint();
            dest = new Point(src);
            t.transform(src, dest);
            line.setBeginPoint(dest);
            src = line.getEndPoint();
            dest = new Point(src);
            t.transform(src, dest);
            line.setEndPoint(dest);
        }
        if (sInterface instanceof JavaPosSignature) {
            sInterface.calculateBounds(v);
            t = AffineTransform.getScaleInstance(1.0, -1.0);
            t.translate(0.0, -sInterface.getMaxY());
            for (Line line : v) {
                src = line.getBeginPoint();
                dest = new Point(src);
                t.transform(src, dest);
                line.setBeginPoint(dest);
                src = line.getEndPoint();
                dest = new Point(src);
                t.transform(src, dest);
                line.setEndPoint(dest);
            }
            sInterface.calculateBounds(v);
            t = AffineTransform.getScaleInstance(1.0, 1.0);
            t.translate(-sInterface.getMinX(), -sInterface.getMinY());
            for (Line line : v) {
                src = line.getBeginPoint();
                dest = new Point(src);
                t.transform(src, dest);
                line.setBeginPoint(dest);
                src = line.getEndPoint();
                dest = new Point(src);
                t.transform(src, dest);
                line.setEndPoint(dest);
            }
            sInterface.calculateBounds(v);
        }
        if (toClass.getName().equals(ThreeByteAsciiSignature.class.getName())) {
            ThreeByteAsciiSignature tbas = new ThreeByteAsciiSignature();
            ret = tbas.convert(v);
        }
        return ret;
    }

    public static void main(String[] args) throws UnknownSignatureTypeException {
        String b64String = "x65535y65535x79y119x80y119x81y119x81y118x81y118x82y118x82y118x82y118x82y118x83y118x83y117x83y117x82y117x83y117x83y117x83y117x82y117x82y117x82y117x82y117x82y117x82y117x82y117x82y117x81y117x81y117x80y117x79y117x77y117x76y117x75y117x73y117x72y117x71y117x69y118x68y118x67y119x67y120x66y122x65y123x65y124x65y126x65y127x66y128x66y128x68y128x70y128x72y128x74y127x77y126x80y125x82y124x84y123x86y122x87y121x87y120x87y120x87y121x87y122x87y123x87y124x86y125x86y126x87y127x87y128x87y128x88y128x89y129x89y128x90y128x91y127x91y126x92y125x92y124x93y123x93y122x93y122x93y122x93y123x93y124x93y125x93y126x93y127x94y128x95y128x96y128x98y128x100y127x101y126x103y125x105y123x106y122x108y120x109y119x109y118x109y118x109y118x109y119x108y120x108y122x108y123x108y125x108y126x108y128x109y129x110y129x111y129x112y129x113y128x114y127x116y125x117y123x119y121x121y119x65535y65535x132y116x129y118x127y120x126y122x125y123x124y125x123y126x123y127x121y129x121y130x121y131x123y131x125y130x127y129x130y126x136y123x141y119x147y116x152y113x156y110x159y110x159y111x159y115x156y120x153y125x149y130x146y135x142y139x141y141x142y141x144y139x146y137x149y135x153y132x65535y65535x188y114x188y114x188y114x188y114x188y115x188y115x188y116x188y117x188y119x188y121x188y123x188y124x188y126x188y128x188y129x188y130x188y131x188y131x188y132x188y132x188y132x188y132x188y131x188y129x188y128x189y126x189y123x65535y65535x198y113x199y114x199y115x200y115x200y116x199y117x199y118x198y118x198y120x197y121x196y123x195y124x195y125x194y126x195y126x196y126x198y125x201y124x204y123x207y121x210y120x213y119x215y118x216y118x217y118x216y118x215y118x213y120x210y121x207y123x204y124x201y126x65535y65535x205y130x208y129x211y129x212y129x214y128x215y127x216y126x217y125x220y123x222y122x224y120x225y119x226y118x65535y65535x220y125x220y126x221y127x221y127x221y127x222y128x222y128x223y128x224y128x225y128x226y127x228y127x229y126x231y125x232y124x232y123x233y122x234y121x235y121x235y122x236y123x237y124x238y125x239y126x241y127x242y127x244y128x246y127x248y127x250y126x251y125x252y124x253y123x254y122x253y122x253y122x253y123x253y123x253y124x253y125x253y126x254y127x255y128x256y128x257y129x258y129x259y129x260y129x262y128x263y127x263y126x264y125x264y124x265y123x265y121x266y120x266y119x266y118x266y118x267y117x267y117x267y117x267y117x267y118x267y118x267y120x267y121x267y123x268y124x269y126x269y127x271y127x272y128x274y128x275y127x277y126x279y124x282y121x284y117x286y114x65535y65535x303y127x304y128x306y128x309y128x311y129x312y128x314y128x315y128x318y127x320y125x65535y65535x328y118x329y119x334y120x337y122x339y122x340y123x342y123x344y123x349y123x353y122x354y121x354y120x65535y65535x354y116x360y116x65535y65535";
        String signatureText = SignatureFactory.convert(b64String, ThreeByteAsciiSignature.class);
        try {
            FileOutputStream fos = new FileOutputStream("PhilMarzullo.b64");
            fos.write(signatureText.getBytes());
            fos.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

