/*
 * Decompiled with CFR 0.152.
 */
package com.anfcorp.stores.signature;

import com.anfcorp.stores.signature.SignatureInterface;
import com.anfcorp.stores.signature.element.Line;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PosSignature
implements SignatureInterface {
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private HashMap<String, Object> imageVariables = null;
    private static HashMap<String, Object> defaultImageVariables = new HashMap();
    protected static final Integer defaultWidth = new Integer(300);
    protected static final Integer defaultHeight = new Integer(100);
    protected static final Integer defaultConvertWidth = new Integer(2000);
    protected static final Integer defaultConvertHeight = new Integer(300);
    protected static final Color defaultBackgroundColor = Color.white;
    protected static final Color defaultForegroundColor = Color.black;
    public static final String ATTRIBUTE_WIDTH = "width";
    public static final String ATTRIBUTE_HEIGHT = "height";
    public static final String ATTRIBUTE_IMAGE_BACKGROUND_COLOR = "backgroundColor";
    public static final String ATTRIBUTE_IMAGE_FOREGROUND_COLOR = "foreGroundColor";

    @Override
    public abstract Vector<Line> buildSignatureVector(String var1);

    protected abstract float getStrokeAdjustmentFactor();

    @Override
    public abstract String convert(Vector<Line> var1);

    private void initialize() {
        this.imageVariables = new HashMap<String, Object>(defaultImageVariables);
    }

    protected PosSignature() {
        this.initialize();
    }

    @Override
    public int getMaxX() {
        return this.maxX;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getWidth() {
        return (Integer)this.imageVariables.get(ATTRIBUTE_WIDTH) < this.maxX - this.minX ? (Integer)this.imageVariables.get(ATTRIBUTE_WIDTH) : this.maxX - this.minX;
    }

    @Override
    public int getHeight() {
        return (Integer)this.imageVariables.get(ATTRIBUTE_HEIGHT) < this.maxY - this.minY ? (Integer)this.imageVariables.get(ATTRIBUTE_HEIGHT) : this.maxY - this.minY;
    }

    protected Color getBackgroundColor() {
        return (Color)this.imageVariables.get(ATTRIBUTE_IMAGE_BACKGROUND_COLOR);
    }

    protected Color getForegroundColor() {
        return (Color)this.imageVariables.get(ATTRIBUTE_IMAGE_FOREGROUND_COLOR);
    }

    @Override
    public abstract boolean isValid(String var1);

    @Override
    public final BufferedImage getImage(String s) {
        Vector<Line> v = this.buildSignatureVector(s);
        this.calculateBounds(v);
        return this.buildSignatureImage(v);
    }

    @Override
    public void calculateBounds(Vector<Line> v) {
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        for (Line line : v) {
            this.maxX = Math.max(this.maxX, line.getBeginXCoord());
            this.maxX = Math.max(this.maxX, line.getEndXCoord());
            this.maxY = Math.max(this.maxY, line.getBeginYCoord());
            this.maxY = Math.max(this.maxY, line.getEndYCoord());
            this.minX = Math.min(this.minX, line.getBeginXCoord());
            this.minX = Math.min(this.minX, line.getEndXCoord());
            this.minY = Math.min(this.minY, line.getBeginYCoord());
            this.minY = Math.min(this.minY, line.getEndYCoord());
        }
    }

    protected BufferedImage buildSignatureImage(Vector<Line> vectorOfLines) {
        float widthScale = new Float(this.getWidth()).floatValue() / (float)(this.maxX - this.minX);
        float heightScale = new Float(this.getHeight()).floatValue() / (float)(this.maxY - this.minY);
        BufferedImage bi = new BufferedImage(this.maxX - this.minX, this.maxY - this.minY, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setBackground(this.getBackgroundColor());
        g2.setColor(this.getBackgroundColor());
        g2.fillRect(0, 0, this.maxX - this.minX, this.maxY - this.minY);
        g2.translate(-this.minX, -this.minY);
        g2.setColor(this.getForegroundColor());
        g2.setStroke(new BasicStroke(1.0f / widthScale * this.getStrokeAdjustmentFactor()));
        for (Line line : vectorOfLines) {
            g2.drawLine(line.getBeginXCoord(), line.getBeginYCoord(), line.getEndXCoord(), line.getEndYCoord());
        }
        AffineTransform t = AffineTransform.getScaleInstance(widthScale, heightScale);
        AffineTransformOp op = new AffineTransformOp(t, 1);
        bi = op.filter(bi, new BufferedImage(this.getWidth(), this.getHeight(), 1));
        return bi;
    }

    static {
        defaultImageVariables.put(ATTRIBUTE_WIDTH, defaultWidth);
        defaultImageVariables.put(ATTRIBUTE_HEIGHT, defaultHeight);
        defaultImageVariables.put(ATTRIBUTE_IMAGE_BACKGROUND_COLOR, defaultBackgroundColor);
        defaultImageVariables.put(ATTRIBUTE_IMAGE_FOREGROUND_COLOR, defaultForegroundColor);
    }
}

