/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import java.util.stream.Stream;
import org.vaadin.tatu.TwinColSelect;

public class TwinColSelectDataView<T>
extends AbstractDataView<T> {
    private SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback;

    public TwinColSelectDataView(SerializableSupplier<DataProvider<T, ?>> dataProviderSupplier, TwinColSelect<T> twinColSelect) {
        super(dataProviderSupplier, twinColSelect);
    }

    public TwinColSelectDataView(SerializableSupplier<DataProvider<T, ?>> dataProviderSupplier, TwinColSelect<T> twinColSelect, SerializableConsumer<IdentifierProvider<T>> identifierChangedCallback) {
        super(dataProviderSupplier, twinColSelect);
        this.identifierChangedCallback = identifierChangedCallback;
    }

    public T getItem(int index) {
        int dataSize = ((DataProvider)this.dataProviderSupplier.get()).size(DataViewUtils.getQuery((Component)this.component));
        if (dataSize == 0) {
            throw new IndexOutOfBoundsException(String.format("Requested index %d on empty data.", index));
        }
        if (index < 0 || index >= dataSize) {
            throw new IndexOutOfBoundsException(String.format("Given index %d is outside of the accepted range '0 - %d'", index, dataSize - 1));
        }
        return this.getItems().skip(index).findFirst().orElse(null);
    }

    public Stream<T> getItems() {
        return ((DataProvider)this.dataProviderSupplier.get()).fetch(DataViewUtils.getQuery((Component)this.component));
    }

    protected Class<?> getSupportedDataProviderType() {
        return DataProvider.class;
    }

    public void setIdentifierProvider(IdentifierProvider<T> identifierProvider) {
        super.setIdentifierProvider(identifierProvider);
        if (this.identifierChangedCallback != null) {
            this.identifierChangedCallback.accept(identifierProvider);
        }
    }
}

