/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.tatu;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Direction;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.component.dnd.DropEffect;
import com.vaadin.flow.component.dnd.DropTarget;
import com.vaadin.flow.component.dnd.EffectAllowed;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.tatu.SelectItem;
import org.vaadin.tatu.TwinColSelectDataView;
import org.vaadin.tatu.TwinColSelectListDataView;
import org.vaadin.tatu.TwinColSelectVariant;

@Tag(value="twin-col-select")
@CssImport(value="./twincolselect.css")
public class TwinColSelect<T>
extends AbstractField<TwinColSelect<T>, Set<T>>
implements HasItemComponents<T>,
HasSize,
HasValidation,
HasTheme,
MultiSelect<TwinColSelect<T>, T>,
HasListDataView<T, TwinColSelectListDataView<T>>,
HasDataView<T, Void, TwinColSelectDataView<T>> {
    private static final String VALUE = "keyId";
    private final KeyMapper<T> keyMapper = new KeyMapper(this::getItemId);
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    VerticalLayout list1 = new VerticalLayout();
    VerticalLayout list2 = new VerticalLayout();
    VerticalLayout buttons = new VerticalLayout();
    private String errorMessage = "";
    private Div errorLabel = new Div();
    private NativeLabel label = new NativeLabel();
    private final AtomicReference<DataProvider<T, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;
    private Random rand = new Random();
    private ItemLabelGenerator<T> itemLabelGenerator = String::valueOf;
    static final String LIST_BORDER = "1px var(--lumo-primary-color) solid";
    static final String LIST_BORDER_RADIUS = "var(--lumo-border-radius)";
    static final String LIST_BORDER_ERROR = "1px var(--lumo-error-color) solid";
    static final String LIST_BORDER_READONLY = "1px dashed var(--lumo-contrast-30pct)";
    static final String LIST_BACKGROUND_ERROR = "var(--lumo-error-color-10pct)";
    static final String LIST_BACKGROUND = "var(--lumo-contrast-10pct)";
    static final String LIST_BACKGROUND_DROP = "var(--lumo-contrast-30pct)";
    static final String LIST_BACKGROUND_READONLY = "transparent";
    private Registration dataProviderListenerRegistration;
    private boolean clearTicksOnSelect = false;
    private Button allButton;
    private Button addButton;
    private Button removeButton;
    private Button clearButton;
    private Button recycleButton;
    private TwinColSelectI18n i18n;
    private boolean requiredIndicatorVisible;
    private PickMode pickMode = PickMode.DOUBLE;
    private TwinColSelectItem<T> check = null;
    private FilterMode filterMode = FilterMode.ITEMS;
    private TwinColSelectItem<T> anchorItem = null;
    private SerializableFunction<T, String> tooltipGenerator;

    void markRange(VerticalLayout list, Component anchor, Component checkBoxItem) {
        boolean marking = false;
        for (Component i : list.getChildren().filter(c -> ((SelectItem)((Object)c)).isEnabled()).collect(Collectors.toList())) {
            if (i == anchor || i == checkBoxItem) {
                marking = !marking;
                ((TwinColSelectItem)i).setValue(true);
                continue;
            }
            if (!marking) continue;
            ((TwinColSelectItem)i).setValue(true);
        }
    }

    void clearAnchor() {
        this.anchorItem = null;
    }

    TwinColSelectItem<T> getAnchor() {
        return this.anchorItem;
    }

    public TwinColSelect() {
        this(Collections.emptySet());
    }

    protected TwinColSelect(Set<T> initialValue) {
        super(initialValue);
        if (initialValue != null) {
            this.setModelValue(initialValue, false);
            this.setPresentationValue(initialValue);
        }
        this.getElement().getStyle().set("display", "flex");
        this.getElement().getStyle().set("flex-direction", "column");
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidthFull();
        layout.setClassName("twincolselect-container");
        this.setErrorLabelStyles();
        this.errorLabel.setVisible(false);
        this.errorLabel.setId(this.randomId("twincolselect-error", 5));
        this.errorLabel.getElement().setAttribute("role", "alert");
        this.label.setId(this.randomId("twincolselect-label", 5));
        this.label.setVisible(false);
        this.label.getElement().getStyle().set("--tcs-required-dot-opacity", "0");
        this.setLabelStyles((HasStyle)this.label);
        this.setSizeFull();
        this.list2.getElement().setAttribute("aria-describedby", (String)this.errorLabel.getId().get());
        this.list1.addClassName("options");
        this.list1.getElement().setAttribute("aria-describedby", (String)this.label.getId().get());
        this.list2.addClassName("value");
        this.list2.getElement().setAttribute("aria-live", "assertive");
        this.setupList(this.list1);
        this.setupList(this.list2);
        this.allButton = new Button((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
        this.allButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.list1.getChildren().forEach(comp -> {
                SelectItem checkbox = (SelectItem)((Object)((Object)((Object)comp)));
                if (checkbox.isEnabled()) {
                    this.list1.remove(new Component[]{checkbox});
                    this.list2.add(new Component[]{checkbox});
                }
            });
            this.updateButtons();
            this.setModelValue(this.getSelectedItems(), true);
        });
        this.allButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.addButton = new Button((Component)VaadinIcon.ANGLE_RIGHT.create());
        this.addButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.moveItems(this.list1, this.list2);
            this.setModelValue(this.getSelectedItems(), true);
            if (this.clearTicksOnSelect) {
                this.clearTicks(ColType.RIGHT);
            }
        });
        this.addButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.removeButton = new Button((Component)VaadinIcon.ANGLE_LEFT.create());
        this.removeButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.moveItems(this.list2, this.list1);
            this.setModelValue(this.getSelectedItems(), true);
            if (this.clearTicksOnSelect) {
                this.clearTicks(ColType.LEFT);
            }
        });
        this.removeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.clearButton = new Button((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
        this.clearButton.addClickListener((ComponentEventListener & Serializable)event -> {
            this.clear();
            this.updateButtons();
        });
        this.clearButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.recycleButton = new Button((Component)VaadinIcon.RECYCLE.create());
        this.recycleButton.addClickListener((ComponentEventListener & Serializable)event -> {
            boolean any2 = this.list2.getChildren().anyMatch(c -> (Boolean)((SelectItem)((Object)((Object)((Object)c)))).getValue());
            this.list2.getChildren().forEach(comp -> {
                SelectItem checkbox = (SelectItem)((Object)((Object)((Object)comp)));
                if (checkbox.isEnabled()) {
                    checkbox.setValue(!any2);
                }
            });
            boolean any1 = this.list1.getChildren().anyMatch(c -> (Boolean)((SelectItem)((Object)((Object)((Object)c)))).getValue());
            this.list1.getChildren().forEach(comp -> {
                SelectItem checkbox = (SelectItem)((Object)((Object)((Object)comp)));
                if (checkbox.isEnabled()) {
                    checkbox.setValue(!any1);
                }
            });
        });
        this.recycleButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.buttons.setWidth("15%");
        this.buttons.setHeight("100%");
        this.buttons.addClassName("buttons");
        this.buttons.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.buttons.setAlignItems(FlexComponent.Alignment.CENTER);
        this.buttons.add(new Component[]{this.allButton, this.addButton, this.removeButton, this.clearButton, this.recycleButton});
        layout.setFlexGrow(1.0, new HasElement[]{this.list1, this.list2});
        layout.add(new Component[]{this.list1, this.buttons, this.list2});
        this.updateButtons();
        this.add(new Component[]{this.label, layout, this.errorLabel});
    }

    private void detectDirection() {
        this.getUI().ifPresent(ui -> ui.getPage().executeJs("return document.dir;", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)value -> {
            if (value.equals(Direction.RIGHT_TO_LEFT.getClientName())) {
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
                this.clearButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
                this.allButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
            } else {
                this.removeButton.setIcon((Component)VaadinIcon.ANGLE_LEFT.create());
                this.clearButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create());
                this.addButton.setIcon((Component)VaadinIcon.ANGLE_RIGHT.create());
                this.allButton.setIcon((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create());
            }
        }));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.detectDirection();
        if (this.getDataProvider() != null && this.dataProviderListenerRegistration == null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        this.requiredIndicatorVisible = requiredIndicatorVisible;
        if (requiredIndicatorVisible) {
            this.label.getElement().getStyle().set("--tcs-required-dot-opacity", "1");
            this.list1.getElement().setAttribute("aria-required", "true");
        } else {
            this.label.getElement().getStyle().set("--tcs-required-dot-opacity", "0");
            this.list1.getElement().removeAttribute("aria-required");
        }
    }

    public boolean isRequiredIndicatorVisible() {
        return this.requiredIndicatorVisible;
    }

    private void moveItems(VerticalLayout list1, VerticalLayout list2) {
        list1.getChildren().forEach(comp -> {
            SelectItem checkbox = (SelectItem)((Object)comp);
            if (((Boolean)checkbox.getValue()).booleanValue()) {
                list1.remove(new Component[]{checkbox});
                list2.add(new Component[]{checkbox});
                if (!checkbox.isEnabled()) {
                    checkbox.setValue(false);
                }
            }
        });
        DataProvider<T, ?> dp = this.getDataProvider();
        if (dp instanceof InMemoryDataProvider && DataViewUtils.getComponentSortComparator((Component)this).isPresent()) {
            InMemoryDataProvider dataProvider = (InMemoryDataProvider)dp;
            this.sortDestinationList(list2, dataProvider);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.addButton != null) {
            if (this.list1.getComponentCount() == 0) {
                this.addButton.setEnabled(false);
                this.allButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
                this.allButton.setEnabled(true);
            }
            if (this.list2.getComponentCount() == 0) {
                this.removeButton.setEnabled(false);
                this.clearButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
                this.clearButton.setEnabled(true);
            }
            this.addButton.setTooltipText(this.i18n != null ? this.i18n.getAddToSelected() : null);
            this.allButton.setTooltipText(this.i18n != null ? this.i18n.getAddAllToSelected() : null);
            this.removeButton.setTooltipText(this.i18n != null ? this.i18n.getRemoveFromSelected() : null);
            this.clearButton.setTooltipText(this.i18n != null ? this.i18n.getRemoveAllFromSelected() : null);
            this.recycleButton.setTooltipText(this.i18n != null ? this.i18n.getToggleSelection() : null);
            this.addButton.addThemeName("icon");
            this.allButton.addThemeName("icon");
            this.removeButton.addThemeName("icon");
            this.clearButton.addThemeName("icon");
            this.list1.getElement().setAttribute("aria-label", this.i18n != null ? this.i18n.getOptions() : "Options");
            this.list2.getElement().setAttribute("aria-label", this.i18n != null ? this.i18n.getSelected() : "Selected");
        }
    }

    private void setAnchor(Component checkBoxItem) {
        this.anchorItem = (TwinColSelectItem)checkBoxItem;
    }

    private void sortDestinationList(VerticalLayout list2, InMemoryDataProvider<T> dataProvider) {
        SerializablePredicate filter = dataProvider.getFilter();
        Query query = DataViewUtils.getQuery((Component)this);
        dataProvider.clearFilters();
        Stream sorted = dataProvider.fetch(query);
        ArrayList sortedBoxes = new ArrayList();
        sorted.forEach(item -> {
            boolean match = list2.getChildren().anyMatch(comp -> {
                this.check = (TwinColSelectItem)((Object)((Object)comp));
                return this.check.getItem().equals(item);
            });
            if (match) {
                sortedBoxes.add(this.check);
            }
        });
        list2.removeAll();
        sortedBoxes.forEach(check -> list2.add(new Component[]{check}));
        dataProvider.setFilter(filter);
    }

    private void setupList(VerticalLayout list) {
        list.getElement().setAttribute("role", "listbox");
        list.getElement().setAttribute("tabindex", "0");
        list.setSpacing(false);
        list.setPadding(false);
        list.getStyle().set("border", LIST_BORDER);
        list.getStyle().set("border-radius", LIST_BORDER_RADIUS);
        list.getStyle().set("background", LIST_BACKGROUND);
        DropTarget dropTarget = DropTarget.create((Component)list);
        dropTarget.setDropEffect(DropEffect.MOVE);
        dropTarget.setActive(true);
        dropTarget.addDropListener((ComponentEventListener & Serializable)event -> event.getDragSourceComponent().ifPresent(component -> {
            if (component instanceof TwinColSelectItem && (component.getParent().get() == this.list1 || component.getParent().get() == this.list2)) {
                Component checkBox = component;
                VerticalLayout otherList = (VerticalLayout)checkBox.getParent().get();
                if (otherList != list) {
                    this.moveItems(otherList, list);
                }
                this.setModelValue(this.getSelectedItems(), true);
            }
        }));
    }

    public void setLabel(String label) {
        if (label != null) {
            this.label.setText(label);
            this.label.setVisible(true);
        } else {
            this.label.setVisible(false);
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    private void setLabelStyles(HasStyle label) {
        label.addClassName("twincolselect-label-styles");
    }

    private void setErrorLabelStyles() {
        this.errorLabel.addClassName("twincolselect-errorlabel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(boolean refresh) {
        if (this.filterMode == FilterMode.RESETVALUE && !refresh) {
            super.clear();
        }
        this.keyMapper.removeAll();
        this.list1.removeAll();
        AtomicReference<DataProvider<T, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            AtomicInteger itemCounter = new AtomicInteger(0);
            List selection = this.getSelectedCheckboxItems().collect(Collectors.toList());
            this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).map(item -> this.createCheckBox(item)).forEach(checkbox -> {
                TwinColSelectItem checkBoxItem = (TwinColSelectItem)((Object)((Object)checkbox));
                if (!selection.stream().anyMatch(selected -> checkBoxItem.getItem().equals(selected.getItem()))) {
                    this.list1.add(new Component[]{checkBoxItem});
                }
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
            this.updateButtons();
        }
    }

    public void setItemLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.reset(true);
    }

    public void setTooltipGenerator(SerializableFunction<T, String> tooltipGenerator) {
        this.tooltipGenerator = tooltipGenerator;
        this.reset(true);
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.refreshCheckboxes();
    }

    public ItemLabelGenerator<T> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public SerializableFunction<T, String> getTooltipGenerator() {
        return this.tooltipGenerator;
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    private Stream<TwinColSelectItem<T>> getCheckboxItems() {
        Stream<Component> all = Stream.concat(this.list1.getChildren(), this.list2.getChildren());
        return all.filter(TwinColSelectItem.class::isInstance).map(child -> (TwinColSelectItem)((Object)child));
    }

    private Stream<TwinColSelectItem<T>> getSelectedCheckboxItems() {
        return this.list2.getChildren().filter(TwinColSelectItem.class::isInstance).map(child -> (TwinColSelectItem)((Object)child));
    }

    private void refreshCheckboxes() {
        this.getCheckboxItems().forEach(this::updateCheckbox);
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    private void updateEnabled(TwinColSelectItem<T> checkbox) {
        boolean disabled = this.isDisabledBoolean() || !this.getItemEnabledProvider().test(checkbox.getItem());
        Serializable rawValue = checkbox.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            checkbox.getElement().setProperty("disabled", disabled ? Boolean.TRUE.toString() : null);
        } else {
            checkbox.setEnabled(!disabled);
        }
    }

    private void updateCheckbox(TwinColSelectItem<T> checkbox) {
        checkbox.setLabel(this.getItemLabelGenerator().apply(checkbox.getItem()));
        checkbox.setTooltipText(this.getTooltipGenerator() != null ? (String)this.getTooltipGenerator().apply(checkbox.getItem()) : null);
        this.updateEnabled(checkbox);
    }

    private TwinColSelectItem<T> createCheckBox(T item) {
        TwinColSelectItem<T> checkbox = new TwinColSelectItem<T>(this.keyMapper.key(item), item);
        checkbox.setWidth("100%");
        checkbox.setTabIndex(0);
        this.updateCheckbox(checkbox);
        return checkbox;
    }

    public Set<T> getEmptyValue() {
        return new HashSet();
    }

    public Element getElement() {
        return super.getElement();
    }

    public void setInvalid(boolean invalid) {
        if (invalid) {
            this.list2.getStyle().set("border", LIST_BORDER_ERROR);
            this.list2.getStyle().set("background", LIST_BACKGROUND_ERROR);
            this.list2.getElement().setAttribute("aria-invalid", "true");
            this.list1.getElement().setAttribute("aria-invalid", "true");
            this.errorLabel.setVisible(true);
        } else {
            this.list2.getStyle().set("border", LIST_BORDER);
            this.list2.getStyle().set("background", LIST_BACKGROUND);
            this.list2.getElement().removeAttribute("aria-invalid");
            this.list1.getElement().removeAttribute("aria-invalid");
            this.errorLabel.setVisible(false);
        }
    }

    public void clear() {
        super.clear();
        this.list2.getChildren().forEach(comp -> {
            SelectItem checkbox = (SelectItem)((Object)comp);
            if (checkbox.isEnabled()) {
                checkbox.setValue(false);
                this.list2.remove(new Component[]{checkbox});
                this.list1.add(new Component[]{checkbox});
            }
        });
        this.setModelValue(this.getSelectedItems(), true);
    }

    public void clearTicks(ColType column) {
        if (column == ColType.LEFT || column == ColType.BOTH) {
            this.list1.getChildren().forEach(comp -> {
                SelectItem checkbox = (SelectItem)((Object)comp);
                checkbox.setValue(false);
            });
        }
        if (column == ColType.RIGHT || column == ColType.BOTH) {
            this.list2.getChildren().forEach(comp -> {
                SelectItem checkbox = (SelectItem)((Object)comp);
                checkbox.setValue(false);
            });
        }
        this.setAnchor(null);
    }

    public void setClearTicks(boolean clearTicksOnSelect) {
        this.clearTicksOnSelect = clearTicksOnSelect;
    }

    public boolean isClearTicksOnSelect() {
        return this.clearTicksOnSelect;
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value, "Cannot set a null value to twincolselect. Use the clear-method to reset the component's value to an empty set.");
        super.setValue(value);
    }

    public boolean isInvalid() {
        return this.errorLabel.isVisible();
    }

    @Deprecated
    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider.set(dataProvider);
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.reset(true);
        this.setupDataProviderListener(dataProvider);
    }

    private void setupDataProviderListener(DataProvider<T, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                Object otherItem = ((DataChangeEvent.DataRefreshEvent)event).getItem();
                this.getCheckboxItems().filter(item -> Objects.equals(this.getItemId(item.item), this.getItemId(otherItem))).findFirst().ifPresent(this::updateCheckbox);
            } else {
                this.reset(false);
            }
        });
    }

    public void addThemeVariants(TwinColSelectVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(TwinColSelectVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(TwinColSelectVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(TwinColSelectVariant::getVariantName).collect(Collectors.toList()));
    }

    public Set<T> getSelectedItems() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.list2.getChildren().map(comp -> ((TwinColSelectItem)((Object)comp)).getItem()).collect(Collectors.toList())));
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        LinkedHashSet<T> value = new LinkedHashSet<T>((Collection)this.getValue());
        value.removeAll(removedItems);
        value.addAll(addedItems);
        this.setValue(value);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorLabel.setText(errorMessage);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Registration addSelectionListener(MultiSelectionListener<TwinColSelect<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    protected void setPresentationValue(Set<T> newPresentationValue) {
        if (this.dataProvider.get() instanceof InMemoryDataProvider) {
            this.getListDataView().removeFilters();
        }
        this.list2.getChildren().forEach(comp -> {
            SelectItem checkbox = (SelectItem)((Object)comp);
            checkbox.setValue(false);
            this.list2.remove(new Component[]{checkbox});
            this.list1.add(new Component[]{checkbox});
        });
        newPresentationValue.forEach(item -> this.list1.getChildren().forEach(comp -> {
            TwinColSelectItem checkbox = (TwinColSelectItem)((Object)((Object)comp));
            if (checkbox.getItem().equals(item)) {
                checkbox.setValue(true);
            }
        }));
        this.moveItems(this.list1, this.list2);
    }

    @Deprecated
    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider.get();
    }

    private Object getItemId(T item) {
        if (this.getDataProvider() == null) {
            return item;
        }
        return this.getDataProvider().getId(item);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.updateReadOnlyStyles(readOnly, this.list1);
        this.updateReadOnlyStyles(readOnly, this.list2);
        if (readOnly) {
            this.list1.getElement().setAttribute("role", "list");
            this.list2.getElement().setAttribute("role", "list");
            this.addButton.setEnabled(false);
            this.allButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.recycleButton.setEnabled(false);
        } else {
            this.list1.getElement().setAttribute("role", "listbox");
            this.list2.getElement().setAttribute("role", "listbox");
            this.updateButtons();
            this.recycleButton.setEnabled(true);
        }
    }

    private void updateReadOnlyStyles(boolean readOnly, VerticalLayout list) {
        if (readOnly) {
            list.getStyle().set("background", LIST_BACKGROUND_READONLY);
            list.getStyle().set("border", LIST_BORDER_READONLY);
        } else {
            list.getStyle().set("background", LIST_BACKGROUND);
            list.getStyle().set("border", LIST_BORDER);
        }
        list.getChildren().forEach(comp -> {
            SelectItem checkBox = (SelectItem)((Object)comp);
            checkBox.setEnabled(!readOnly);
        });
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public void setAllButtonCaption(String text) {
        this.allButton.setText(text);
    }

    public void setAllButtonIcon(Component icon) {
        this.allButton.setIcon(icon);
    }

    public void setClearButtonCaption(String text) {
        this.clearButton.setText(text);
    }

    public void setClearButtonIcon(Component icon) {
        this.clearButton.setIcon(icon);
    }

    public void setRecycleButtonCaption(String text) {
        this.recycleButton.setText(text);
    }

    public void setRecycleButtonIcon(Component icon) {
        this.recycleButton.setIcon(icon);
    }

    public void setRemoveButtonCaption(String text) {
        this.removeButton.setText(text);
    }

    public void setRemoveButtonIcon(Component icon) {
        this.removeButton.setIcon(icon);
    }

    public void setAddButtonCaption(String text) {
        this.addButton.setText(text);
    }

    public void setAddButtonIcon(Component icon) {
        this.addButton.setIcon(icon);
    }

    public TwinColSelectDataView<T> getGenericDataView() {
        return new TwinColSelectDataView(this::getDataProvider, this, this::identifierProviderChanged);
    }

    public TwinColSelectDataView<T> setItems(DataProvider<T, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public TwinColSelectDataView<T> setItems(InMemoryDataProvider<T> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<T, Void, SerializablePredicate<T>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<T> getFilter(Query<T, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<T, Void>)convertedDataProvider);
    }

    public TwinColSelectListDataView<T> getListDataView() {
        return new TwinColSelectListDataView(this::getDataProvider, this, this::identifierProviderChanged, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.reset(true));
    }

    public TwinColSelectListDataView<T> setItems(ListDataProvider<T> dataProvider) {
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
        return this.getListDataView();
    }

    public void setItems(Stream<T> streamOfItems) {
        this.setItems((ListDataProvider<T>)DataProvider.fromStream(streamOfItems));
    }

    protected boolean valueEquals(Set<T> value1, Set<T> value2) {
        assert (value1 != null && value2 != null);
        if (value1.size() != value2.size()) {
            return false;
        }
        if (this.getDataProvider() == null) {
            return super.valueEquals(value1, value2);
        }
        IdentifierProvider<T> identifierProvider = this.getIdentifierProvider();
        Set ids1 = value1.stream().map(identifierProvider).collect(Collectors.toSet());
        Set ids2 = value2.stream().map(identifierProvider).collect(Collectors.toSet());
        return ids1.equals(ids2);
    }

    private IdentifierProvider<T> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject == null) {
            DataProvider<T, ?> dataProvider = this.getDataProvider();
            if (dataProvider != null) {
                return arg_0 -> dataProvider.getId(arg_0);
            }
            return IdentifierProvider.identity();
        }
        return identifierProviderObject;
    }

    private void identifierProviderChanged(IdentifierProvider<T> identifierProvider) {
        this.keyMapper.setIdentifierGetter(identifierProvider);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    public void setPickMode(PickMode pickMode) {
        this.pickMode = pickMode;
    }

    private String randomId(String prefix, int chars) {
        int limit = (int)(Math.pow(10.0, chars) - 1.0);
        Object key = "" + this.rand.nextInt(limit);
        key = String.format("%" + chars + "s", key).replace(' ', '0');
        return prefix + "-" + (String)key;
    }

    public void setI18n(TwinColSelectI18n i18n) {
        this.i18n = i18n;
        this.updateButtons();
    }

    public TwinColSelectI18n getI18n() {
        return this.i18n;
    }

    private class TwinColSelectItem<T>
    extends SelectItem
    implements HasItemComponents.ItemComponent<T> {
        private final T item;
        private DragSource<TwinColSelectItem<T>> dragSource;

        private TwinColSelectItem(String id, T item) {
            this.addClassName("twincolselect-item");
            this.item = item;
            this.getElement().setProperty(TwinColSelect.VALUE, id);
            this.dragSource = DragSource.create((Component)this);
            this.dragSource.setDraggable(true);
            this.dragSource.setEffectAllowed(EffectAllowed.MOVE);
            this.dragSource.addDragStartListener((ComponentEventListener & Serializable)event -> {
                this.setValue(true);
                if (this.getParent().get() == TwinColSelect.this.list1) {
                    TwinColSelect.this.list2.getStyle().set("background", TwinColSelect.LIST_BACKGROUND_DROP);
                } else {
                    TwinColSelect.this.list1.getStyle().set("background", TwinColSelect.LIST_BACKGROUND_DROP);
                }
            });
            this.dragSource.addDragEndListener((ComponentEventListener & Serializable)event -> {
                String background = TwinColSelect.LIST_BACKGROUND;
                if (TwinColSelect.this.isInvalid()) {
                    background = TwinColSelect.LIST_BACKGROUND_ERROR;
                }
                TwinColSelect.this.list1.getStyle().set("background", TwinColSelect.LIST_BACKGROUND);
                TwinColSelect.this.list2.getStyle().set("background", background);
            });
            DomListenerRegistration reg = this.getElement().addEventListener("keydown", (DomEventListener & Serializable)event -> {
                if (event.getEventData().getNumber("event.keyCode") == 40.0) {
                    this.focusNext();
                } else if (event.getEventData().getNumber("event.keyCode") == 38.0) {
                    this.focusPrevious();
                } else if (event.getEventData().getNumber("event.keyCode") == 13.0) {
                    this.doSwapItems();
                }
            });
            reg.addEventData("event.keyCode");
            reg.addEventData("([40, 38, 13].includes(event.keyCode)) ? event.preventDefault() : undefined");
            reg.setFilter("[40, 38, 13].includes(event.keyCode)");
            this.addClickListener((ComponentEventListener & Serializable)click -> {
                if (TwinColSelect.this.pickMode == PickMode.DOUBLE && click.getClickCount() == 2 || TwinColSelect.this.pickMode == PickMode.SINGLE && !click.isCtrlKey() && !click.isShiftKey()) {
                    this.setValue(true);
                    this.doSwapItems();
                } else {
                    TwinColSelectItem anchor = TwinColSelect.this.getAnchor();
                    if (click.isShiftKey() && anchor != null) {
                        if (anchor != null) {
                            if (anchor.getParent().get() == TwinColSelect.this.list1) {
                                if (this.getParent().get() == TwinColSelect.this.list1) {
                                    TwinColSelect.this.markRange(TwinColSelect.this.list1, (Component)anchor, (Component)this);
                                }
                            } else if (this.getParent().get() == TwinColSelect.this.list2) {
                                TwinColSelect.this.markRange(TwinColSelect.this.list2, (Component)anchor, (Component)this);
                            }
                        }
                        TwinColSelect.this.setAnchor(null);
                    } else {
                        TwinColSelect.this.setAnchor((Component)this);
                    }
                }
            });
        }

        private void doSwapItems() {
            SelectItem next = this.getNextCheckbox();
            SelectItem previous = this.getPreviousCheckbox();
            this.swapItems();
            if (next != null) {
                next.focus();
            } else if (previous != null) {
                previous.focus();
            }
        }

        private void focusNext() {
            SelectItem c = this.getNextCheckbox();
            if (c != null) {
                c.focus();
            }
        }

        private void focusPrevious() {
            SelectItem c = this.getPreviousCheckbox();
            if (c != null) {
                c.focus();
            }
        }

        private SelectItem getPreviousCheckbox() {
            SelectItem c = null;
            VerticalLayout list = (VerticalLayout)this.getParent().get();
            int index = list.indexOf((Component)this);
            while (index > 0 && !(c = (SelectItem)list.getComponentAt(--index)).isEnabled()) {
            }
            return c;
        }

        private SelectItem getNextCheckbox() {
            SelectItem c = null;
            VerticalLayout list = (VerticalLayout)this.getParent().get();
            int index = list.indexOf((Component)this);
            while (index < list.getComponentCount() - 1 && !(c = (SelectItem)list.getComponentAt(++index)).isEnabled()) {
            }
            return c;
        }

        private void swapItems() {
            if (this.getParent().get() == TwinColSelect.this.list1) {
                TwinColSelect.this.moveItems(TwinColSelect.this.list1, TwinColSelect.this.list2);
            } else {
                TwinColSelect.this.moveItems(TwinColSelect.this.list2, TwinColSelect.this.list1);
            }
            TwinColSelect.this.setModelValue(TwinColSelect.this.getSelectedItems(), true);
        }

        public T getItem() {
            return this.item;
        }
    }

    public static enum PickMode {
        SINGLE,
        DOUBLE;

    }

    public static enum FilterMode {
        ITEMS,
        RESETVALUE;

    }

    public static class TwinColSelectI18n
    implements Serializable {
        private String addAllToSelected;
        private String removeAllFromSelected;
        private String toggleSelection;
        private String addToSelected;
        private String removeFromSelected;
        private String selected;
        private String options;

        public String getAddAllToSelected() {
            return this.addAllToSelected;
        }

        public void setAddAllToSelected(String addAllToSelected) {
            this.addAllToSelected = addAllToSelected;
        }

        public String getRemoveAllFromSelected() {
            return this.removeAllFromSelected;
        }

        public void setRemoveAllFromSelected(String removeAllFromSelected) {
            this.removeAllFromSelected = removeAllFromSelected;
        }

        public String getToggleSelection() {
            return this.toggleSelection;
        }

        public void setToggleSelection(String toggleSelection) {
            this.toggleSelection = toggleSelection;
        }

        public String getAddToSelected() {
            return this.addToSelected;
        }

        public void setAddToSelected(String addToSelected) {
            this.addToSelected = addToSelected;
        }

        public String getRemoveFromSelected() {
            return this.removeFromSelected;
        }

        public void setRemoveFromSelected(String removeFromSelected) {
            this.removeFromSelected = removeFromSelected;
        }

        public String getOptions() {
            return this.options;
        }

        public void setOptions(String options) {
            this.options = options;
        }

        public String getSelected() {
            return this.selected;
        }

        public void setSelected(String selected) {
            this.selected = selected;
        }

        public static TwinColSelectI18n getDefault() {
            TwinColSelectI18n english = new TwinColSelectI18n();
            english.setToggleSelection("Toggle selection");
            english.setRemoveAllFromSelected("Remove all from selected");
            english.setRemoveFromSelected("Remove from selected");
            english.setAddToSelected("Add to selected");
            english.setAddAllToSelected("Add all to selected");
            english.setSelected("Selected");
            english.setOptions("Options");
            return english;
        }
    }

    public static enum ColType {
        LEFT,
        RIGHT,
        BOTH;

    }
}

