/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.InputStreamReaderFactory;
import com.github.davidmoten.bigsorter.NonClosingInputStream;
import com.github.davidmoten.bigsorter.OutputStreamWriterFactory;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Util;
import com.github.davidmoten.bigsorter.Writer;
import com.github.davidmoten.bigsorter.internal.ArrayList;
import com.github.davidmoten.bigsorter.internal.ReaderFromIterator;
import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Sorter<T> {
    private final List<Supplier<? extends Reader<? extends T>>> inputs;
    private final Serializer<T> serializer;
    private final File output;
    private final Comparator<? super T> comparator;
    private final int maxFilesPerMerge;
    private final int maxItemsPerPart;
    private final Consumer<? super String> log;
    private final int bufferSize;
    private final File tempDirectory;
    private final boolean unique;
    private final boolean initialSortInParallel;
    private final Optional<OutputStreamWriterFactory<T>> outputWriterFactory;
    private long count = 0L;

    Sorter(List<Supplier<? extends Reader<? extends T>>> inputs, Serializer<T> serializer, File output, Comparator<? super T> comparator, int maxFilesPerMerge, int maxItemsPerFile, Consumer<? super String> log, int bufferSize, File tempDirectory, boolean unique, boolean initialSortInParallel, Optional<OutputStreamWriterFactory<T>> outputWriterFactory) {
        Preconditions.checkNotNull(inputs, (String)"inputs cannot be null");
        Preconditions.checkNotNull(serializer, (String)"serializer cannot be null");
        Preconditions.checkNotNull((Object)output, (String)"output cannot be null");
        Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
        Preconditions.checkNotNull(outputWriterFactory, (String)"outputWriterFactory cannot be null");
        this.inputs = inputs;
        this.serializer = serializer;
        this.output = output;
        this.comparator = comparator;
        this.maxFilesPerMerge = maxFilesPerMerge;
        this.maxItemsPerPart = maxItemsPerFile;
        this.log = log;
        this.bufferSize = bufferSize;
        this.tempDirectory = tempDirectory;
        this.unique = unique;
        this.initialSortInParallel = initialSortInParallel;
        this.outputWriterFactory = outputWriterFactory;
    }

    public static <T> Builder<T> serializer(Serializer<T> serializer) {
        Preconditions.checkNotNull(serializer, (String)"serializer cannot be null");
        return new Builder<T>(serializer);
    }

    public static <T> Builder<String> serializerLinesUtf8() {
        return Sorter.serializer(Serializer.linesUtf8());
    }

    public static <T> Builder<String> serializerLines(Charset charset) {
        return Sorter.serializer(Serializer.lines(charset));
    }

    public static <T> Builder2<String> lines(Charset charset) {
        return Sorter.serializer(Serializer.lines(charset)).comparator(Comparator.naturalOrder());
    }

    public static <T> Builder2<String> linesUtf8() {
        return Sorter.serializer(Serializer.linesUtf8()).comparator(Comparator.naturalOrder());
    }

    private static <T> List<Supplier<? extends Reader<? extends T>>> inputs(Builder<T> b) {
        return b.inputs.stream().map(source -> {
            if (source.type == SourceType.SUPPLIER_INPUT_STREAM) {
                return () -> (Reader)b.transform.apply(Sorter.inputStreamReader(b, source));
            }
            return () -> (Reader)b.transform.apply(((Supplier)source.source).get());
        }).collect(Collectors.toList());
    }

    private static <T> Reader<T> inputStreamReader(Builder<T> b, Source source) {
        InputStreamReaderFactory rf = ((Builder)b).inputReaderFactory.orElse(((Builder)b).serializer);
        return rf.createReader((InputStream)((Supplier)source.source).get());
    }

    static InputStream openFile(File file, int bufferSize) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file), bufferSize);
    }

    private void log(String msg, Object ... objects) {
        if (this.log != null) {
            String s = String.format(msg, objects);
            this.log.accept(s);
        }
    }

    private File sort() throws IOException {
        this.tempDirectory.mkdirs();
        long time = System.currentTimeMillis();
        this.count = 0L;
        ArrayList<File> files = new ArrayList<File>();
        this.log("starting sort", new Object[0]);
        this.log("unique = " + this.unique, new Object[0]);
        int i = 0;
        ArrayList<T> list = new ArrayList<T>();
        for (Supplier<Reader<T>> supplier : this.inputs) {
            Reader<T> reader = supplier.get();
            Throwable throwable = null;
            try {
                T t;
                do {
                    if ((t = reader.read()) != null) {
                        list.add(t);
                        ++i;
                    }
                    if (t != null && i != this.maxItemsPerPart) continue;
                    i = 0;
                    if (list.size() <= 0) continue;
                    File f = this.sortAndWriteToFile(list);
                    files.add(f);
                    list.clear();
                } while (t != null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        this.log("completed initial split and sort, starting merge, elapsed time=" + (double)(System.currentTimeMillis() - time) / 1000.0 + "s", new Object[0]);
        File result = this.merge(files);
        if (this.outputWriterFactory.isPresent()) {
            Util.convert(result, this.serializer, this.output, this.outputWriterFactory.get(), x -> x);
        } else {
            Files.move(result.toPath(), this.output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.log("sort of " + this.count + " records completed in " + (double)(System.currentTimeMillis() - time) / 1000.0 + "s", new Object[0]);
        return this.output;
    }

    @VisibleForTesting
    File merge(List<File> files) {
        try {
            File result;
            while (files.size() > 1) {
                ArrayList<File> nextRound = new ArrayList<File>();
                for (int i = 0; i < files.size(); i += this.maxFilesPerMerge) {
                    File merged = this.mergeGroup(files.subList(i, Math.min(files.size(), i + this.maxFilesPerMerge)));
                    nextRound.add(merged);
                }
                files = nextRound;
            }
            if (files.isEmpty()) {
                this.output.delete();
                this.output.createNewFile();
                result = this.output;
            } else {
                result = files.get(0);
            }
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private File mergeGroup(List<File> list) throws IOException {
        this.log("merging %s files", list.size());
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<State<T>> states = new ArrayList<State<T>>();
        for (File f : list) {
            State<T> st = this.createState(f);
            states.add(st);
        }
        File output = this.nextTempFile();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output), this.bufferSize);
             Writer writer = this.serializer.createWriter(out);){
            PriorityQueue<State> q = new PriorityQueue<State>((x, y) -> this.comparator.compare(x.value, y.value));
            q.addAll(states);
            Object last = null;
            while (!q.isEmpty()) {
                State state = (State)q.poll();
                if (!this.unique || last == null || this.comparator.compare(state.value, last) != 0) {
                    writer.write(state.value);
                    last = state.value;
                }
                state.value = state.reader.readAutoClosing();
                if (state.value != null) {
                    q.offer(state);
                    continue;
                }
                state.file.delete();
            }
        }
        return output;
    }

    private State<T> createState(File f) throws IOException {
        InputStream in = Sorter.openFile(f, this.bufferSize);
        Reader reader = this.serializer.createReader(in);
        Object t = reader.readAutoClosing();
        return new State(f, reader, t);
    }

    private File sortAndWriteToFile(ArrayList<T> list) throws FileNotFoundException, IOException {
        File file = this.nextTempFile();
        long t = System.currentTimeMillis();
        if (this.initialSortInParallel) {
            list.parallelSort(this.comparator);
        } else {
            list.sort(this.comparator);
        }
        this.writeToFile(list, file);
        DecimalFormat df = new DecimalFormat("0.000");
        this.count += (long)list.size();
        this.log("total=%s, sorted %s records to file %s in %ss", this.count, list.size(), file.getName(), df.format((double)(System.currentTimeMillis() - t) / 1000.0));
        return file;
    }

    private void writeToFile(List<T> list, File f) throws FileNotFoundException, IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f), this.bufferSize);
             Writer<T> writer = this.serializer.createWriter(out);){
            Object last = null;
            for (T t : list) {
                if (this.unique && last != null && this.comparator.compare(t, last) == 0) continue;
                writer.write(t);
                last = t;
            }
        }
    }

    private File nextTempFile() throws IOException {
        return Sorter.nextTempFile(this.tempDirectory);
    }

    private static File nextTempFile(File tempDirectory) throws IOException {
        return Files.createTempFile(tempDirectory.toPath(), "big-sorter", "", new FileAttribute[0]).toFile();
    }

    private static final class State<T> {
        final File file;
        Reader<T> reader;
        T value;

        State(File file, Reader<T> reader, T value) {
            this.file = file;
            this.reader = reader;
            this.value = value;
        }
    }

    @FunctionalInterface
    private static interface CloseAction {
        public void close() throws IOException;
    }

    public static final class Builder5<T>
    extends Builder4Base<T, Builder5<T>> {
        Builder5(Builder<T> b) {
            super(b);
        }

        public Stream<T> sort() {
            try {
                this.b.output = Sorter.nextTempFile(this.b.tempDirectory);
                Sorter sorter = new Sorter(Sorter.inputs(this.b), this.b.serializer, this.b.output, this.b.comparator, this.b.maxFilesPerMerge, this.b.maxItemsPerFile, this.b.logger, this.b.bufferSize, this.b.tempDirectory, this.b.unique, this.b.initialSortInParallel, this.b.outputWriterFactory);
                sorter.sort();
                return (Stream)this.b.serializer.createReader(this.b.output).stream().onClose(() -> this.b.output.delete());
            }
            catch (Throwable e) {
                this.b.output.delete();
                throw Util.toRuntimeException(e);
            }
        }
    }

    public static final class Builder4<T>
    extends Builder4Base<T, Builder4<T>> {
        Builder4(Builder<T> b) {
            super(b);
        }

        public <S> Builder4<T> outputMapper(OutputStreamWriterFactory<? super S> writerFactory, Function<? super T, ? extends S> mapper) {
            Preconditions.checkArgument((!this.b.outputWriterFactory.isPresent() ? 1 : 0) != 0);
            OutputStreamWriterFactory factory = out -> writerFactory.createWriter(out).map(mapper);
            this.b.outputWriterFactory = Optional.of(factory);
            return this;
        }

        public void sort() {
            Sorter sorter = new Sorter(Sorter.inputs(this.b), this.b.serializer, this.b.output, this.b.comparator, this.b.maxFilesPerMerge, this.b.maxItemsPerFile, this.b.logger, this.b.bufferSize, this.b.tempDirectory, this.b.unique, this.b.initialSortInParallel, this.b.outputWriterFactory);
            try {
                sorter.sort();
            }
            catch (IOException e) {
                this.b.output.delete();
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class Builder4Base<T, S extends Builder4Base<T, S>> {
        protected final Builder<T> b;

        Builder4Base(Builder<T> b) {
            this.b = b;
        }

        public S maxFilesPerMerge(int value) {
            Preconditions.checkArgument((value > 1 ? 1 : 0) != 0, (String)"maxFilesPerMerge must be greater than 1");
            ((Builder)this.b).maxFilesPerMerge = value;
            return (S)this;
        }

        public S maxItemsPerFile(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"maxItemsPerFile must be greater than 0");
            ((Builder)this.b).maxItemsPerFile = value;
            return (S)this;
        }

        public S unique(boolean value) {
            ((Builder)this.b).unique = value;
            return (S)this;
        }

        public S unique() {
            return this.unique(true);
        }

        public S initialSortInParallel(boolean initialSortInParallel) {
            ((Builder)this.b).initialSortInParallel = initialSortInParallel;
            return (S)this;
        }

        public S initialSortInParallel() {
            return this.initialSortInParallel(true);
        }

        public S logger(Consumer<? super String> logger) {
            Preconditions.checkNotNull(logger, (String)"logger cannot be null");
            ((Builder)this.b).logger = logger;
            return (S)this;
        }

        public S loggerStdOut() {
            return this.logger((Consumer<String>)new Consumer<String>(){

                @Override
                public void accept(String msg) {
                    System.out.println(ZonedDateTime.now().truncatedTo(ChronoUnit.MILLIS).format(Builder.DATE_TIME_PATTERN) + " " + msg);
                }
            });
        }

        public S bufferSize(int bufferSize) {
            Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"bufferSize must be greater than 0");
            ((Builder)this.b).bufferSize = bufferSize;
            return (S)this;
        }

        public S tempDirectory(File directory) {
            Preconditions.checkNotNull((Object)directory, (String)"tempDirectory cannot be null");
            ((Builder)this.b).tempDirectory = directory;
            return (S)this;
        }
    }

    public static final class Builder3<T> {
        private final Builder<T> b;

        Builder3(Builder<T> b) {
            this.b = b;
        }

        public Builder3<T> filter(Predicate<? super T> predicate) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).filter(predicate));
        }

        public Builder3<T> map(Function<? super T, ? extends T> mapper) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).map(mapper));
        }

        public Builder3<T> flatMap(Function<? super T, ? extends List<? extends T>> mapper) {
            Function currentTransform = ((Builder)this.b).transform;
            return this.transform(r -> ((Reader)currentTransform.apply(r)).flatMap(mapper));
        }

        public Builder3<T> transform(Function<? super Reader<T>, ? extends Reader<? extends T>> transform) {
            Preconditions.checkNotNull(transform, (String)"transform cannot be null");
            Function currentTransform = ((Builder)this.b).transform;
            ((Builder)this.b).transform = r -> (Reader)transform.apply((Reader)currentTransform.apply(r));
            return this;
        }

        public Builder3<T> transformStream(Function<? super Stream<T>, ? extends Stream<? extends T>> transform) {
            Preconditions.checkNotNull(transform, (String)"transform cannot be null");
            Function currentTransform = ((Builder)this.b).transform;
            ((Builder)this.b).transform = r -> ((Reader)currentTransform.apply(r)).transform(transform);
            return this;
        }

        public Builder4<T> output(File output) {
            Preconditions.checkNotNull((Object)output, (String)"output cannot be null");
            ((Builder)this.b).output = output;
            return new Builder4<T>(this.b);
        }

        public Builder5<T> outputAsStream() {
            return new Builder5<T>(this.b);
        }
    }

    public static final class Builder2<T> {
        private final Builder<T> b;

        Builder2(Builder<T> b) {
            this.b = b;
        }

        public Builder3<T> input(Charset charset, String ... strings) {
            Preconditions.checkNotNull((Object)strings, (String)"string cannot be null");
            Preconditions.checkNotNull((Object)charset, (String)"charset cannot be null");
            List list = Arrays.asList(strings).stream().map(string -> new ByteArrayInputStream(string.getBytes(charset))).map(bis -> () -> bis).collect(Collectors.toList());
            return this.inputStreams(list);
        }

        public Builder3<T> input(String ... strings) {
            Preconditions.checkNotNull((Object)strings);
            return this.input(StandardCharsets.UTF_8, strings);
        }

        public Builder3<T> input(InputStream ... inputs) {
            java.util.ArrayList list = Lists.newArrayList();
            for (InputStream in : inputs) {
                list.add(() -> new NonClosingInputStream(in));
            }
            return this.inputStreams(list);
        }

        public Builder3<T> input(Supplier<? extends InputStream> input) {
            Preconditions.checkNotNull(input, (String)"input cannot be null");
            return this.inputStreams(Collections.singletonList(input));
        }

        public Builder3<T> input(File ... files) {
            return this.input(Arrays.asList(files));
        }

        public Builder3<T> input(List<File> files) {
            Preconditions.checkNotNull(files, (String)"files cannot be null");
            return this.inputStreams(files.stream().map(file -> this.supplier((File)file)).collect(Collectors.toList()));
        }

        public Builder3<T> inputStreams(List<? extends Supplier<? extends InputStream>> inputs) {
            Preconditions.checkNotNull(inputs);
            for (Supplier<? extends InputStream> supplier : inputs) {
                ((Builder)this.b).inputs.add(new Source(SourceType.SUPPLIER_INPUT_STREAM, supplier));
            }
            return new Builder3<T>(this.b);
        }

        public Builder3<T> readers(List<? extends Supplier<? extends Reader<? extends T>>> readers) {
            Preconditions.checkNotNull(readers);
            for (Supplier<Reader<T>> supplier : readers) {
                ((Builder)this.b).inputs.add(new Source(SourceType.SUPPLIER_READER, supplier));
            }
            return new Builder3<T>(this.b);
        }

        public Builder3<T> inputItems(T ... items) {
            return this.inputItems((Iterable<? extends T>)Arrays.asList(items));
        }

        public Builder3<T> inputItems(Iterable<? extends T> iterable) {
            Supplier<Reader> supplier = () -> new ReaderFromIterator(iterable.iterator());
            return this.readers(Collections.singletonList(supplier));
        }

        public Builder3<T> inputItems(Iterator<? extends T> iterator) {
            Supplier<Reader> supplier = () -> new ReaderFromIterator(iterator);
            return this.readers(Collections.singletonList(supplier));
        }

        private Supplier<InputStream> supplier(File file) {
            return () -> {
                try {
                    return Sorter.openFile(file, ((Builder)this.b).bufferSize);
                }
                catch (FileNotFoundException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }
    }

    public static final class Builder<T> {
        private static final DateTimeFormatter DATE_TIME_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.Sxxxx");
        private List<Source> inputs = Lists.newArrayList();
        private Optional<InputStreamReaderFactory<T>> inputReaderFactory = Optional.empty();
        private final Serializer<T> serializer;
        private File output;
        private Comparator<? super T> comparator;
        private int maxFilesPerMerge = 100;
        private int maxItemsPerFile = 100000;
        private Consumer<? super String> logger = null;
        private int bufferSize = 8192;
        private File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        private Function<? super Reader<T>, ? extends Reader<? extends T>> transform = r -> r;
        private boolean unique;
        private boolean initialSortInParallel;
        private Optional<OutputStreamWriterFactory<T>> outputWriterFactory = Optional.empty();

        Builder(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        public <S> Builder<T> inputMapper(InputStreamReaderFactory<? extends S> readerFactory, Function<? super S, ? extends T> mapper) {
            Preconditions.checkArgument((!this.inputReaderFactory.isPresent() ? 1 : 0) != 0);
            InputStreamReaderFactory factory = in -> readerFactory.createReader(in).map(mapper);
            this.inputReaderFactory = Optional.of(factory);
            return this;
        }

        public Builder2<T> comparator(Comparator<? super T> comparator) {
            Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
            this.comparator = comparator;
            return new Builder2(this);
        }

        public Builder2<T> naturalOrder() {
            return this.comparator(Comparator.naturalOrder());
        }
    }

    private static final class Source {
        final SourceType type;
        final Object source;

        Source(SourceType type, Object source) {
            this.type = type;
            this.source = source;
        }
    }

    private static enum SourceType {
        SUPPLIER_INPUT_STREAM,
        SUPPLIER_READER;

    }
}

