/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.davidmoten.bigsorter.BiConsumer;
import com.github.davidmoten.bigsorter.CsvSerializer;
import com.github.davidmoten.bigsorter.DataSerializer;
import com.github.davidmoten.bigsorter.FixedSizeRecordSerializer;
import com.github.davidmoten.bigsorter.Function;
import com.github.davidmoten.bigsorter.InputStreamReaderFactory;
import com.github.davidmoten.bigsorter.JavaSerializer;
import com.github.davidmoten.bigsorter.JsonArraySerializer;
import com.github.davidmoten.bigsorter.LineDelimiter;
import com.github.davidmoten.bigsorter.LinesSerializer;
import com.github.davidmoten.bigsorter.OutputStreamWriterFactory;
import com.github.davidmoten.guavamini.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public interface Serializer<T>
extends InputStreamReaderFactory<T>,
OutputStreamWriterFactory<T> {
    public static Serializer<String> linesUtf8() {
        return Serializer.linesUtf8(LineDelimiter.LINE_FEED);
    }

    public static Serializer<String> linesUtf8(LineDelimiter delimiter) {
        Preconditions.checkNotNull((Object)((Object)delimiter));
        if (delimiter == LineDelimiter.LINE_FEED) {
            return LinesSerializer.LINES_UTF8_LF;
        }
        return LinesSerializer.LINES_UTF8_CR_LF;
    }

    public static Serializer<String> lines(Charset charset) {
        Preconditions.checkNotNull((Object)charset);
        return new LinesSerializer(charset, LineDelimiter.LINE_FEED);
    }

    public static Serializer<String> lines(Charset charset, LineDelimiter delimiter) {
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull((Object)((Object)delimiter));
        return new LinesSerializer(charset, delimiter);
    }

    public static <T extends Serializable> Serializer<T> java() {
        return JavaSerializer.instance();
    }

    public static Serializer<byte[]> fixedSizeRecord(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        return new FixedSizeRecordSerializer(size);
    }

    public static Serializer<CSVRecord> csv(CSVFormat format, Charset charset) {
        Preconditions.checkNotNull((Object)format, (String)"format cannot be null");
        Preconditions.checkNotNull((Object)charset, (String)"charset cannot be null");
        return new CsvSerializer(format, charset);
    }

    public static Serializer<ObjectNode> jsonArray() {
        return JsonArraySerializer.INSTANCE;
    }

    public static <T> Serializer<T> dataSerializer(final Function<? super DataInputStream, ? extends T> reader, final BiConsumer<? super DataOutputStream, ? super T> writer) {
        return new DataSerializer<T>(){

            @Override
            public T read(DataInputStream dis) throws IOException {
                try {
                    return reader.apply(dis);
                }
                catch (EOFException e) {
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void write(DataOutputStream dos, T value) throws IOException {
                try {
                    writer.accept(dos, value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

